﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.Facade.Data;
using BMS.Utils;

namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// Interface responsbile for creating and returning specialized entity writers.
    /// </summary>
    public interface IWriterManager
    {
        BmsLogger Logger { get; }

        VistaSite VistASite { get; }

        /// <summary>
        /// Initiates the underlying writer with its entity writers.
        /// </summary>
        void Open();

        /// <summary>
        /// Closes the underlying writer.
        /// </summary>
        void Close();

        /// <summary>
        /// Inserts the specified entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void Insert(IEntity entity);

        /// <summary>
        /// Updates the specified entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void Update(IEntity entity);

        /// <summary>
        /// Deletes the specified entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        void Delete(IEntity entity);
    }
}