﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The room bed log.
    /// </summary>
    public class RoomBedLog : BaseEisEvsLogData<RoomBed>
    {


        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public override CrudAction CrudAction { get; set; }



        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return Convert.ToInt32(entity.IEN); } set { entity.IEN = value + ""; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get { return entity.Name; } set { entity.Name = value; } }
        /// <summary>
        /// Gets or sets a value indicating whether [currently out of service].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [currently out of service]; otherwise, <c>false</c>.
        /// </value>
        public bool CurrentlyOutOfService { get { return entity.CurrentlyOutOfService; } set { entity.CurrentlyOutOfService = value; } }
        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get { return entity.WardLocationId; } set { entity.WardLocationId = value; } }
        /// <summary>
        /// Gets or sets the out of service date.
        /// </summary>
        /// <value>
        /// The out of service date.
        /// </value>
        public DateTime? OutOfServiceDate { get { return entity.OutOfServiceDate; } set { entity.OutOfServiceDate = value; } }

        public IList<WardsWhichCanAssign> WardsWhichCanAssign { get { return entity.WardsWhichCanAssign; } set { entity.WardsWhichCanAssign = value; } }



    }
}
