﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class PatientMovementMap : FileMap<PatientMovement>
    {
        private static readonly PatientMovementMap instance = new PatientMovementMap();
        public static PatientMovementMap Instance { get { return instance; } }

        private PatientMovementMap()
        {

        }

        public override string FileNumber
        {
            get { return "405"; }
        }

        protected override void Map()
        {

                MapIen((m, s) => m.IEN = s);
                Map((m, s) => m.DateTime = s.VistAToDateTime(), ".01");
                Map((m, s) => m.EnteredOnDateTime = s.VistAToDateTime(), "101");
                Map((m, s) => m.EnteredById = s, "100");
                Map((m, s) => m.TransactionTypeId = s, ".02");
                Map((m, s) => m.PatientId = s, ".03");
                Map((m, s) => m.TypeOfMovementId = s, ".04");
                Map((m, s) => m.WardLocationId = s, ".06");
                Map((m, s) => m.RoomBedId = s, ".07");
                MapReference((m, s) => m.Patient = s, PatientMap.Instance, ".03");
        }
    }
}
