﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class PatientAppointmentMap : SubFileMap<Patient, PatientAppointment>
    {
        private static readonly PatientAppointmentMap instance = new PatientAppointmentMap();
        public static PatientAppointmentMap Instance { get { return instance; } }

        private PatientAppointmentMap()
            : base(PatientMap.Instance)
        {
        }

        public override string SubFileNumber
        {
            get { return "2.98"; }
        }

        public override string FieldIenForSubFile
        {
            get { return "1900"; }
        }

        public override string FirstFieldIenForSubFile
        {
            get { return ".001"; }
        }

        public override PatientAppointment MakeSubFile(Patient file)
        {
            return new PatientAppointment()
            {
                PatientId = file.IEN,
                Patient = file
            };
        }

        protected override void Map()
        {
            Map((m, s) => m.AppointmentDateTime = s.VistAToDateTime(), ".001");
            Map((m, s) => m.HospitalLocationId = s, ".01");
            Map((m, s) => m.TelephoneOfClinic = s, ".02");
            Map((m, s) => m.Status = s, "3");
            Map((m, s) => m.DataEntryClerkId = s, "19");
            Map((m, s) => m.DateAppointmentMade = s.VistAToDateTime(), "20");
            Map((m, s) => m.CurrentStatus = s, "100");
        }
    }
}
