﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Mdws2.Entities;


namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class ClinicPatientAppointmentCommand : BasePeriodCommand<PatientApp>
    {
        public string ClinicIen { get; private set; }

        public ClinicPatientAppointmentCommand(string clinicIen)
            : base(PatientAppointmentClinicMap.Instance)
        {
            ClinicIen = clinicIen;
        }

        protected override string Ien
        {
            get
            {
                return ',' + ClinicIen;
            }
        }

        protected override string FieldLocation
        {
            get { return "0;1"; }
        }
    }
}
