﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data.WF;
using BMS.VistaIntegration.Mdws2.Maps.WF;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    class BedSwitchCommand : BaseCommand<BedSwitch>
    {
        public BedSwitchCommand()
            : base(BedSwitchMap.Instance) { }

        public IEnumerable<string> PatientMovementsIEn { get; set; }

        private string[] orderedIens;
        private string screen;
        protected override string GetScreenParam()
        {
            return screen;
        }



        private struct ScreenPart
        {
            public ScreenPart(string screen, string minIen, int count)
            {
                Screen = screen;
                MinIen = minIen;
                Count = count;
            }

            public readonly string Screen;
            public readonly string MinIen;
            public readonly int Count;
        }

        private IEnumerable<ScreenPart> GetScreens()
        {

            StringBuilder sb = new StringBuilder("I ");
            int count = 0;
            string minIen = orderedIens[0];

            for (int i = 0; i < orderedIens.Length; i++)
            {
                string ien = orderedIens[i];
                string s = string.Format("(Y={0})!", ien);
                if (sb.Length + s.Length >= 250)
                {
                    sb.Remove(sb.Length - 1, 1);
                    yield return new ScreenPart(sb.ToString(), minIen, count);
                    count = 0;
                    minIen = orderedIens[i ];
                    sb = new StringBuilder("I ");
                }
                count++;
                sb.Append(s);
            }
            if (sb.Length != 2)
            {
                sb.Remove(sb.Length - 1, 1);
                yield return new ScreenPart(sb.ToString(), minIen, count);
            }
        }



        public override IList<BedSwitch> Execute(QuerySvcService.QuerySvcSoap client)
        {
            orderedIens = PatientMovementsIEn.OrderBy(s => int.Parse(s)).ToArray();
            if (orderedIens.Length == 0) throw new InvalidOperationException();

            List<BedSwitch> result = new List<BedSwitch>();
            foreach (ScreenPart part in GetScreens())
            {
                FromIenParam = (int.Parse(part.MinIen) - 1).ToString();
                MaxCount = part.Count;
                screen = part.Screen;
                result.AddRange(base.Execute(client));
            }
  
            return result;
        }







    }
}
