﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public class SubFileFetch<T, S> : IVistAQuery<S>
        where T : class , new()
        where S : class ,new()
    {
        public SubFileMap<T, S> SubFileMap { get; private set; }

        public SubFileFetch(SubFileMap<T, S> fileMap)
        {
            this.SubFileMap = fileMap;
        }

        public Predicate<S> FilterPredicate { get; set; }

        private class ResultMaker : IResultMaker
        {
            public List<S> Result { get; private set; }
            private T lastEntry;
            private S lastSubfileEntry;
            private readonly SubFileMap<T, S> subFileMap;
            private readonly Predicate<S> filterPredicate;
            private readonly QuerySvcSoap client;

            public ResultMaker(SubFileFetch<T, S> fileFetch)
            {
                this.subFileMap = fileFetch.SubFileMap;
                this.filterPredicate = fileFetch.FilterPredicate;
                this.client = fileFetch.Client;
            }

            public void InitEntries(int capacity)
            {
                Result = new List<S>(capacity);
            }


            public void AddNewEntry(string ien)
            {
                lastEntry = subFileMap.FileMap.Make();
                subFileMap.FileMap.SetIen(lastEntry, ien);
            }

            public void SetFieldForLastEntry(string fieldIen, string value)
            {
                subFileMap.FileMap.SetField(lastEntry, fieldIen, value);
                var reference = subFileMap.FileMap.GetReference(fieldIen);
                if (reference != null)
                {
                    reference.SetFields(client, lastEntry, value);
                }
            }


            public void SetMultipleFieldForLastEntry(string subFileNumber, string fieldIen, string value)
            {
                if (subFileNumber == subFileMap.SubFileNumber)
                {
                    if (fieldIen == subFileMap.FirstFieldIenForSubFile)
                    {
                        AddLastEntryToResult();
                        lastSubfileEntry = subFileMap.MakeSubFile(lastEntry);
                    }
                    subFileMap.SetSubFileField(lastSubfileEntry, fieldIen, value);
                    var reference = subFileMap.GetReference(fieldIen);
                    if (reference != null)
                    {
                        reference.SetFields(client, lastSubfileEntry, value);
                    }
                }
                else
                {
                    subFileMap.FileMap.SetMultipleField(lastEntry, subFileNumber, fieldIen, value);
                }
            }


            public void AddLastEntryToResult()
            {
                if (lastSubfileEntry != null)
                {
                    if (filterPredicate == null || filterPredicate(lastSubfileEntry))
                        Result.Add(lastSubfileEntry);
                    lastSubfileEntry = null;
                }
            }
        }


        public string ScreenParam { get; set; }
        public int? BulkCount { get; set; }
        public string FromParam { get; set; }
        public string IndexParam { get; set; }
        public QuerySvcSoap Client { get; set; }
        public string LastIen { get; private set; }
        public bool HasMore { get; private set; }
        public string Iens { get; set; }

        public IList<S> GetResult()
        {
                ListFetchCommand command = new ListFetchCommand(Client);
                command.FileParam = SubFileMap.FileNumber;
                command.FieldParam = SubFileMap.FieldsParam;
                command.FieldsCount = SubFileMap.FileMap.FieldsCount;
                command.FlagsParam = SubFileMap.FlagsParam;
                command.MultipleFieldsParam = SubFileMap.MultipleFieldsParam;
                command.ScreenParam = ScreenParam;
                if (BulkCount.HasValue)
                    command.NumberParam = BulkCount.ToString();
                if (IndexParam != null)
                    command.IndexParam = IndexParam;
                if (FromParam != null)
                    command.FromParam = FromParam;
                if (Iens != null)
                    command.IensParam = Iens;
                ResultMaker maker = new ResultMaker(this);
                command.Execute(maker);
                LastIen = command.LastIen;
                HasMore = BulkCount.HasValue ? command.EntriesCount >= BulkCount.Value : false;
                return maker.Result;
        }


    }
}
