﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public class SingleSubFileFetch<T, S>
        where T : class , new()
        where S : class , new()
    {

        public SubFileMap<T, S> SubFileMap { get; private set; }
        public QuerySvcSoap Client { get; set; }
        public string Ien { get; set; }
     
        public SingleSubFileFetch(SubFileMap<T, S> fileMap)
        {
            SubFileMap = fileMap;
        }

        public Predicate<S> FilterPredicate { get; set; }

        private class ResultMaker : ISingleResultMaker
        {
            public List<S> Result { get; private set; }
            private T lastEntry;
            private S lastSubfileEntry;
            private readonly SubFileMap<T, S> subFileMap;
            private readonly Predicate<S> filterPredicate;
            private readonly QuerySvcSoap client;

            public ResultMaker(SingleSubFileFetch<T, S> fileFetch)
            {
                this.subFileMap = fileFetch.SubFileMap;
                this.filterPredicate = fileFetch.FilterPredicate;
                this.client = fileFetch.Client;       
            }


            public void SetIen(string value)
            {
                Result = new List<S>();
                lastEntry = subFileMap.FileMap.Make();
                subFileMap.FileMap.SetIen(lastEntry, value);
            }

            public void SetField(string fieldIen, string value)
            {
                subFileMap.FileMap.SetField(lastEntry, fieldIen, value);
                var reference = subFileMap.FileMap.GetReference(fieldIen);
                if (reference != null)
                {
                    reference.SetFields(client, lastEntry, value);
                }
            }

            public void SetMultipleField(string subFileNumber, string fieldIen, string value)
            {
                if (subFileNumber == subFileMap.SubFileNumber)
                {
                    if (fieldIen == subFileMap.FirstFieldIenForSubFile)
                    {
                        AddLastEntryToResult();
                        lastSubfileEntry = subFileMap.MakeSubFile(lastEntry);
                    }
                    subFileMap.SetSubFileField(lastSubfileEntry, fieldIen, value);
                    var reference = subFileMap.GetReference(fieldIen);
                    if (reference != null)
                        reference.SetFields(client, lastSubfileEntry, value);
                }
                else
                {
                    subFileMap.FileMap.SetMultipleField(lastEntry, subFileNumber, fieldIen, value);
                }
            }
  

            public void AddLastEntryToResult()
            {
                if (lastSubfileEntry != null)
                {
                    if (filterPredicate == null || filterPredicate(lastSubfileEntry))
                        Result.Add(lastSubfileEntry);
                    lastSubfileEntry = null;
                }
            }

        }

        private string GetFieldsParam()
        {
            return SubFileMap.FieldsParam + SubFileMap.MultipleFieldsParam;
        }

        public IList<S> GetResult()
        {

            GetFetchCommand command = new GetFetchCommand(Client);
            command.FileParam = SubFileMap.FileNumber;
            command.FieldParam = GetFieldsParam();
            command.IenParam = Ien;
            ResultMaker maker = new ResultMaker(this);
            command.Execute(maker);
            maker.AddLastEntryToResult();
            return maker.Result;
        }
    }
}
