﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA ward location contract.
    /// </summary>
    [Serializable]
    public class WardLocation : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>        
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>        
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is currently out of service.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is currently out of service; otherwise, <c>false</c>.
        /// </value>        
        public bool IsCurrentlyOutOfService { get; set; }        

        /// <summary>
        /// Gets or sets the specialty id.
        /// </summary>
        /// <value>
        /// The specialty id.
        /// </value>
        public string SpecialtyId { get; set; }

        public Specialty Specialty { get; set; }

        public override string ToString()
        {
            return "WardLocation:" + Name;
        }
    }
}
