﻿using System.ServiceModel;
using BMS.DataContracts;
using BMS.FaultContracts;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;
using System;
using BMS.Utils;

namespace BMS.ServiceContracts
{
    /// <summary>
    /// BMS Cache related operations.
    /// </summary>
    [ServiceContract()]
    public interface IBedManagerCache
    {
        /// <summary>
        /// Inserts the web client address.
        /// </summary>
        /// <param name="url">The URL.</param>
        [OperationContract]
        [FaultContract(typeof(NullParameterException))]
        [FaultContract(typeof(CustomSQLException))]
        [FaultContract(typeof(OtherException))]
        void InsertWebClientAddress(string url);

        /// <summary>
        /// Gets the web client addresses.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        [FaultContract(typeof(CustomSQLException))]
        [FaultContract(typeof(OtherException))]
        List<string> GetWebClientAddresses();

        /// <summary>
        /// Updates the EIS cache.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="entityType">Type of the entity.</param>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void UpdateEISCache(II id, string entityType);

        /// <summary>
        /// Removes the EIS cache.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="entityType">Type of the entity.</param>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void RemoveEISCache(II id, string entityType);

        /// <summary>
        /// Updates the EVS cache.
        /// </summary>
        /// <param name="code">The code.</param>
        /// <param name="vocabularyDomain">The vocabulary domain.</param>
        [OperationContract]        
        [FaultContract(typeof(OtherException))]
        void UpdateEVSCache(string code, string vocabularyDomain);

        /// <summary>
        /// Removes the EVS cache.
        /// </summary>
        /// <param name="code">The code.</param>
        /// <param name="vocabularyDomain">The vocabulary domain.</param>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void RemoveEVSCache(string code, string vocabularyDomain);

        /// <summary>
        /// Clears the user permission cache.
        /// </summary>
        /// <param name="userName">Name of the user.</param>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void ClearUserPermissionCache(string userName);

        /// <summary>
        /// Updates the policies for organizations cache.
        /// </summary>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void UpdatePoliciesForOrganizationsCache();

        /// <summary>
        /// Updates the user roles cache.
        /// </summary>
        /// <param name="user">The user.</param>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void UpdateUserRolesCache(InfoWorld.Security.Authorization.PolicyAdministrationPoint.User user);

        /// <summary>
        /// Refreshes the cache.
        /// </summary>
        [OperationContract]
        [FaultContract(typeof(OtherException))]
        void RefreshCache();
    }
}
