﻿using System.Runtime.Serialization;
using System;
namespace BMS.FaultContracts
{
    /// <summary>
    /// Generic BMS Service fault.
    /// </summary>
    [DataContract]
    public class OtherException
    {
        /// <summary>
        /// Gets or sets the error message.
        /// </summary>
        /// <value>
        /// The error message.
        /// </value>
        [DataMember]
        public string ErrorMessage { get; set; }

        /// <summary>
        /// Gets or sets the stack trace.
        /// </summary>
        /// <value>
        /// The stack trace.
        /// </value>
        [DataMember]
        public string StackTrace { get; set; }
        /// <summary>
        /// Override ToString().
        /// </summary>
        /// <returns>Friendly print of the exception.</returns>
        public override string ToString()
        {
            return ErrorMessage
                + (String.IsNullOrEmpty(StackTrace) ? String.Empty : "  StackTrace = " + StackTrace)
                ;
        }
    }
}