﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Class used for the Bed Status Report on the facility waiting list items.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "WaitingListReport")]
    [DataContract(Name = "WaitingListReport")]
    [KnownType(typeof(II))]
    public class WaitingListReport
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 1)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the room bed assigned id.
        /// </summary>
        /// <value>
        /// The room bed assigned id.
        /// </value>
        [XmlElementAttribute("RoomBedAssignedId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "RoomBedAssignedId", Order = 2)]
        public II RoomBedAssignedId { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 3)]
        public DateTime? EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 4)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the removed date.
        /// </summary>
        /// <value>
        /// The removed date.
        /// </value>
        [XmlElementAttribute("RemovedDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "RemovedDate", Order = 5)]
        public DateTime? RemovedDate { get; set; }

        /// <summary>
        /// Gets or sets the waiting area.
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        [XmlElementAttribute("WaitingArea", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingArea", Order = 6)]
        public string WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the last edited by.
        /// </summary>
        /// <value>
        /// The last edited by.
        /// </value>
        [XmlElementAttribute("LastEditedBy", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditedBy", Order = 7)]
        public string LastEditedBy { get; set; }

        /// <summary>
        /// Gets or sets the community services.
        /// </summary>
        /// <value>
        /// The community services.
        /// </value>
        [XmlElementAttribute("CommunityServices", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "CommunityServices", Order = 8)]
        public string CommunityServices { get; set; }

        /// <summary>
        /// Gets or sets the contract fee.
        /// </summary>
        /// <value>
        /// The contract fee.
        /// </value>
        [XmlElementAttribute("ContractFee", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "ContractFee", Order = 9)]
        public string ContractFee { get; set; }

        /// <summary>
        /// Gets or sets the reason using fee.
        /// </summary>
        /// <value>
        /// The reason using fee.
        /// </value>
        [XmlElementAttribute("ReasonUsingFee", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "ReasonUsingFee", Order = 10)]
        public string ReasonUsingFee { get; set; }

        /// <summary>
        /// Gets or sets the disposition fee.
        /// </summary>
        /// <value>
        /// The disposition fee.
        /// </value>
        [XmlElementAttribute("DispositionFee", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "DispositionFee", Order = 11)]
        public string DispositionFee { get; set; }

        /// <summary>
        /// Gets or sets the authorized fee.
        /// </summary>
        /// <value>
        /// The authorized fee.
        /// </value>
        [XmlElementAttribute("AuthorizedFee", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "AuthorizedFee", Order = 12)]
        public string AuthorizedFee { get; set; }

        /// <summary>
        /// Gets or sets the in house transfer.
        /// </summary>
        /// <value>
        /// The in house transfer.
        /// </value>
        [XmlElementAttribute("InHouseTransfer", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "InHouseTransfer", Order = 13)]
        public bool? InHouseTransfer { get; set; }

        /// <summary>
        /// Gets or sets the bed requested date.
        /// </summary>
        /// <value>
        /// The bed requested date.
        /// </value>
        [XmlElementAttribute("BedRequestedDate", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "BedRequestedDate", Order = 14)]
        public DateTime? BedRequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the bed assigned date.
        /// </summary>
        /// <value>
        /// The bed assigned date.
        /// </value>
        [XmlElementAttribute("BedAssignedDate", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "BedAssignedDate", Order = 15)]
        public DateTime? BedAssignedDate { get; set; }

        /// <summary>
        /// Gets or sets the fee comments.
        /// </summary>
        /// <value>
        /// The fee comments.
        /// </value>
        [XmlElementAttribute("FeeComments", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "FeeComments", Order = 16)]
        public string FeeComments { get; set; }

        /// <summary>
        /// Gets or sets the type of bed ward.
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [XmlElementAttribute("TypeOfBedWard", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfBedWard", Order = 17)]
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the presenting problem.
        /// </summary>
        /// <value>
        /// The presenting problem.
        /// </value>
        [XmlElementAttribute("PresentingProblem", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "PresentingProblem", Order = 18)]
        public string PresentingProblem { get; set; }

        /// <summary>
        /// Gets or sets the act id.
        /// </summary>
        /// <value>
        /// The act id.
        /// </value>
        [XmlElementAttribute("ActId", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "ActId", Order = 19)]
        public int ActId { get; set; }
    }
}
