﻿using System;
using BMS.Utils;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "JobLogInfo")]
    [DataContract(Name = "JobLogInfo")]
    public class JobLogInfo
    {
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public int Id { get; set; }

        [XmlElementAttribute("VistaName", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "VistaName", Order = 2)]
        public string VistaName { get; set; }
        
        [XmlElementAttribute("VistaId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "VistaId", Order = 3)]
        public string VistaId { get; set; }
        
        [XmlElementAttribute("RetrievalMethod", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "RetrievalMethod", Order = 4)]
        public DataRetrievalMethod RetrievalMethod { get; set; }
        
        [XmlElementAttribute("RetrievedDataType", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "RetrievedDataType", Order = 5)]
        public VistaDataType RetrievedDataType { get; set; }
        
        [XmlElementAttribute("RetrievedEntriesNumber", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "RetrievedEntriesNumber", Order = 6)]
        public int RetrievedEntriesNumber { get; set; }
        
        [XmlElementAttribute("StartDate", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "StartDate", Order = 7)]
        public DateTime StartDate { get; set; }
        
        [XmlElementAttribute("EndDate", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "EndDate", Order = 8)]
        public DateTime? EndDate { get; set; }
        
        [XmlElementAttribute("LaunchType", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "LaunchType", Order = 9)]
        public JobLaunchType LaunchType { get; set; }
        
        [XmlElementAttribute("QueryStartDate", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "QueryStartDate", Order = 10)]
        public DateTime? QueryStartDate { get; set; }
        
        [XmlElementAttribute("QueryEndDate", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "QueryEndDate", Order = 11)]
        public DateTime? QueryEndDate { get; set; }
        
        [XmlElementAttribute("Status", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "Status", Order = 12)]
        public JobStatus Status { get; set; }
        
        [XmlElementAttribute("ErrorMessage", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "ErrorMessage", Order = 13)]
        public string ErrorMessage { get; set; }
        
        [XmlElementAttribute("Details", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "Details", Order = 14)]
        public string Details { get; set; }
        
        [XmlElementAttribute("Index", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "Index", Order = 15)]
        public int Index { get; set; }
        
        [XmlElementAttribute("TotalCount", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "TotalCount", Order = 16)]
        public int TotalCount { get; set; }
    }
}
