﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about an unavailable event that is raised with BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedUnavailable")]
    [DataContract(Name = "BedUnavailable")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class BedUnavailable : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the ward of the out of service event(EIS place reference).
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [XmlElementAttribute("DivisionId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "DivisionId", Order = 1)]
        public II DivisionId { get; set; }

        /// <summary>
        /// Gets or sets the bed associated with the out of service event(EIs place reference).
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [XmlElementAttribute("BedId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 2)]
        public II BedId { get; set; }                
        
        /// <summary>
        /// Gets or sets the type of the out of service event(EVS concept).
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        [XmlElementAttribute("Type", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Type", Order = 3)]
        public CD Type { get; set; }

        /// <summary>
        /// Gets or sets the reason for the out of service event(EVS concept).
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        [XmlElementAttribute("Reason", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "Reason", Order = 4)]
        public CD Reason { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [XmlElementAttribute("CreatedBy", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "CreatedBy", Order = 5)]
        public string CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the edited date.
        /// </summary>
        /// <value>
        /// The edited date.
        /// </value>
        [XmlElementAttribute("EditedDate", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "EditedDate", Order = 6)]
        public DateTime? EditedDate { get; set; }

        /// <summary>
        /// Gets or sets the edited by.
        /// </summary>
        /// <value>
        /// The edited by.
        /// </value>
        [XmlElementAttribute("EditedBy", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "EditedBy", Order = 7)]
        public string EditedBy { get; set; }

        /// <summary>
        /// Gets or sets the canceled by.
        /// </summary>
        /// <value>
        /// The canceled by.
        /// </value>
        [XmlElementAttribute("CanceledBy", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "CanceledBy", Order = 8)]
        public string CanceledBy { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 9)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is unavailable from vist A.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is unavailable from vist A; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsUnavailableFromVistA", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "IsUnavailableFromVistA", Order = 10)]
        public bool IsUnavailableFromVistA { get; set; }

        /// <summary>
        /// Gets or sets the ward list.
        /// </summary>
        /// <value>
        /// The ward list.
        /// </value>
        [XmlElementAttribute("WardList", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "WardList", Order = 11)]
        public List<II> WardList { get; set; }

        /// <summary>
        /// Gets or sets the expected completed date (OOS ends for the bed).
        /// </summary>
        /// <value>
        /// The expected completed date.
        /// </value>
        [XmlElementAttribute("ExpectedCompletedDate", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "ExpectedCompletedDate", Order = 12)]
        public DateTime? ExpectedCompletedDate { get; set; }

        #endregion
    }
}