﻿using System;
using InfoWorld.HL7.ITS;
using System.Xml.Serialization;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Main entity for all documents (HL7 ACT).
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Act")]
    [DataContract(Name = "Act")]
    [KnownType(typeof(II))]
    public class Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the creation date of the act.
        /// </summary>
        /// <value>
        /// The creation date.
        /// </value>
        [XmlElementAttribute("CreationDate", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "CreationDate", Order = 3)]
        public DateTime? CreationDate { get; set; }

        /// <summary>
        /// Gets or sets the canceled date of the act.
        /// </summary>
        /// <value>
        /// The canceled date.
        /// </value>
        [XmlElementAttribute("CanceledDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "CanceledDate", Order = 4)]
        public DateTime? CanceledDate { get; set; }

        /// <summary>
        /// Gets or sets the act on which the present act depends.
        /// </summary>
        /// <value>
        /// The parent.
        /// </value>
        [XmlElementAttribute("Parent", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "Parent", Order = 5)]
        public Act Parent { get; set; }

        /// <summary>
        /// Gets or sets the activity flow Id.
        /// </summary>
        /// <value>
        /// The flow Id.
        /// </value>
        [XmlElementAttribute("FlowId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "FlowId", Order = 6)]
        public Guid FlowId { get; set; }

        /// <summary>
        /// Gets or sets the VistA IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        [XmlElementAttribute("IEN", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "IEN", Order = 7)]
        public string IEN { get; set; }

        #endregion
    }
}
