﻿using System;
using BMS.DataContracts;
using BMS.MT;

namespace BMS.Translators
{
    public static class TranslatorWaitingListReport
    {
        public static void CopyTo(this WaitingListReportBO waitingListReportBO, DataContracts.WaitingListReport waitingListReport)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                waitingListReport.ActId = waitingListReportBO.ACT_ID.Value.Value;
                waitingListReport.AuthorizedFee = waitingListReportBO.AUTHORIZED_FEE.Value;
                waitingListReport.BedAssignedDate = waitingListReportBO.BED_ASSIGNED_DATE.Value;
                waitingListReport.BedRequestedDate = waitingListReportBO.BED_REQUESTED_DATE.Value;
                waitingListReport.CommunityServices = waitingListReportBO.SERVICE_RECEIVING_FEE.Value;
                waitingListReport.ContractFee = waitingListReportBO.CONTRACT_FEE.Value;
                waitingListReport.DispositionFee = waitingListReportBO.FEE_DISPOSITION.Value;
                waitingListReport.EnteredDate = waitingListReportBO.ENTERED_DATE.Value;
                waitingListReport.FeeComments = waitingListReportBO.FEE_COMMENTS.Value;
                waitingListReport.InHouseTransfer = waitingListReportBO.IN_HOUSE.Value;
                waitingListReport.LastEditedBy = waitingListReportBO.LAST_EDIT_BY.Value;
                waitingListReport.PatientId = TranslatorUtils.BuildIdentifier(waitingListReportBO.DOMAIN_ID, waitingListReportBO.PATIENT_UID);
                waitingListReport.PresentingProblem = waitingListReportBO.PRESENTING_PROBLEM.Value;
                waitingListReport.ReasonUsingFee = waitingListReportBO.REASON_USING_FEE.Value;
                waitingListReport.RemovedDate = waitingListReportBO.REMOVED_DATE.Value;
                waitingListReport.RequestedDate = waitingListReportBO.REQUESTED_DATE.Value;
                waitingListReport.RoomBedAssignedId = TranslatorUtils.BuildIdentifier(waitingListReportBO.DOMAIN_ID, waitingListReportBO.BED_ASSIGNED_UID);
                waitingListReport.TypeOfBedWard = waitingListReportBO.TYPE_OF_BED_WARD.Value;
                waitingListReport.WaitingArea = waitingListReportBO.WAITING_AREA.Value;                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
