﻿using BMS.MT;
using System;
using BMS.Utils;

namespace BMS.Translators
{
    public static class TranslatorTransfer
    {
        public static void CopyTo(this TransferBO transferBO, DataContracts.Transfer transfer)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                transfer.CanceledDate = transferBO.CANCELED_DATE.Value;
                transfer.CreationDate = transferBO.CREATION_DATE.Value;
                transfer.FlowId = transferBO.FLOW_ID.Value;
                transfer.Id = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.ACT_ID);
                transfer.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.PARENT_ACT_ID));
                transfer.PatientId = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.PATIENT_UID);                
                transfer.IEN = transferBO.IEN.Value;
                transfer.Disposition = TranslatorUtils.BuildConcept(transferBO.EVN_DISPOSITION_CODE, transferBO.EVN_DISPOSITION_CODE_SYSTEM, transferBO.EVN_DISPOSITION_CODE_SYSTEM_NAME, transferBO.EVN_DISPOSITION_DISPLAY_NAME);
                transfer.DispositionDate = transferBO.EVN_DISPOSITION_DATE.Value;
                transfer.AdmissionFacilityId = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.EVN_ADMISSION_FACILITY_UID);
                transfer.Comment = transferBO.REQ_COMMENTS.Value;
                transfer.Era = TranslatorUtils.BuildConcept(transferBO.REQ_ERA_CODE, transferBO.REQ_ERA_CODE_SYSTEM, transferBO.REQ_ERA_CODE_SYSTEM_NAME, transferBO.REQ_ERA_DISPLAY_NAME);
                transfer.FacilityId = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.REQ_FACILITY_UID);
                transfer.FacilityRegion = transferBO.REQ_FACILITY_REGION.Value;
                transfer.FacilityVISN = transferBO.REQ_FACILITY_VISN.Value;
                transfer.Contract = TranslatorUtils.BuildConcept(transferBO.REQ_CONTRACT_CODE, transferBO.REQ_CONTRACT_CODE_SYSTEM, transferBO.REQ_CONTRACT_CODE_SYSTEM_NAME, transferBO.REQ_CONTRACT_DISPLAY_NAME);
                transfer.Diagnosis = transferBO.REQ_DIAGNOSIS.Value;
                transfer.CurrentLocation = transferBO.REQ_CURRENT_LOCATION.Value;
                transfer.DischargeComment = transferBO.EVN_COMMENT.Value;
                transfer.Speciality = TranslatorUtils.BuildConcept(transferBO.REQ_SPECIALITY_CODE, transferBO.REQ_SPECIALITY_CODE_SYSTEM, transferBO.REQ_SPECIALITY_CODE_SYSTEM_NAME, transferBO.REQ_SPECIALITY_DISPLAY_NAME);
                transfer.AdmissionDate = transferBO.REQ_LOCATION_ADMISSION_DATE.Value;
                transfer.EnteredBy = transferBO.REQ_ENTERED_BY.Value;
                transfer.LastEditBy = transferBO.REQ_LAST_EDIT_BY.Value;
                transfer.Edited = transferBO.REQ_EDITED.Value;
                transfer.RequestedDate = transferBO.REQ_REQUESTED_DATE.Value;
                transfer.VistaSiteId = TranslatorUtils.BuildIdentifier(transferBO.DOMAIN_ID, transferBO.REQ_VISTA_SITE_UID);
                transfer.IsNationalWaitList = transferBO.IS_NATIONAL_WAIT_LIST.Value == true ? true : false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.Transfer transfer, TransferBO transferBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                transferBO.CANCELED_DATE.Value = transfer.CanceledDate;
                transferBO.CREATION_DATE.Value = transfer.CreationDate;
                if (transfer.Id != null)
                {
                    transferBO.DOMAIN_ID.Value = transfer.Id.root;
                    int? actId = transfer.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        transferBO.ACT_ID.Value = actId.Value;
                }
                transferBO.FLOW_ID.Value = transfer.FlowId;
                if (transfer.Parent != null && transfer.Parent.Id != null)
                    transferBO.PARENT_ACT_ID.Value = transfer.Parent.Id.extension.ParseAsInt();
                if (transfer.PatientId != null)                
                    transferBO.PATIENT_UID.Value = System.Guid.Parse(transfer.PatientId.extension);
                    
                transferBO.IEN.Value = transfer.IEN;
                if (transfer.Disposition != null)
                {
                    transferBO.EVN_DISPOSITION_CODE.Value = transfer.Disposition.code;
                    transferBO.EVN_DISPOSITION_CODE_SYSTEM.Value = transfer.Disposition.codeSystem;
                    transferBO.EVN_DISPOSITION_CODE_SYSTEM_NAME.Value = transfer.Disposition.codeSystemName;
                    transferBO.EVN_DISPOSITION_DISPLAY_NAME.Value = transfer.Disposition.displayName;
                }
                if (transfer.AdmissionFacilityId != null)
                    transferBO.EVN_ADMISSION_FACILITY_UID.Value = System.Guid.Parse(transfer.AdmissionFacilityId.extension);
                transferBO.REQ_COMMENTS.Value = transfer.Comment;
                if (transfer.Era != null)
                {
                    transferBO.REQ_ERA_CODE.Value = transfer.Era.code;
                    transferBO.REQ_ERA_CODE_SYSTEM.Value = transfer.Era.codeSystem;
                    transferBO.REQ_ERA_CODE_SYSTEM_NAME.Value = transfer.Era.codeSystemName;
                    transferBO.REQ_ERA_DISPLAY_NAME.Value = transfer.Era.displayName;
                }
                if (transfer.Speciality != null)
                {
                    transferBO.REQ_SPECIALITY_CODE.Value = transfer.Speciality.code;
                    transferBO.REQ_SPECIALITY_CODE_SYSTEM.Value = transfer.Speciality.codeSystem;
                    transferBO.REQ_SPECIALITY_CODE_SYSTEM_NAME.Value = transfer.Speciality.codeSystemName;
                    transferBO.REQ_SPECIALITY_DISPLAY_NAME.Value = transfer.Speciality.displayName;
                }
                if (transfer.FacilityId != null)    
                    transferBO.REQ_FACILITY_UID.Value = System.Guid.Parse(transfer.FacilityId.extension);
                transferBO.REQ_FACILITY_REGION.Value = transfer.FacilityRegion;
                transferBO.REQ_FACILITY_VISN.Value = transfer.FacilityVISN;

                if (transfer.Contract != null)
                {
                    transferBO.REQ_CONTRACT_CODE.Value = transfer.Contract.code;
                    transferBO.REQ_CONTRACT_CODE_SYSTEM.Value = transfer.Contract.codeSystem;
                    transferBO.REQ_CONTRACT_CODE_SYSTEM_NAME.Value = transfer.Contract.codeSystemName;
                    transferBO.REQ_CONTRACT_DISPLAY_NAME.Value = transfer.Contract.displayName;
                }
                transferBO.REQ_DIAGNOSIS.Value = transfer.Diagnosis;
                transferBO.REQ_CURRENT_LOCATION.Value = transfer.CurrentLocation;
                transferBO.REQ_LOCATION_ADMISSION_DATE.Value = transfer.AdmissionDate;
                transferBO.EVN_COMMENT.Value = transfer.DischargeComment;
                transferBO.OPERATION_TYPE.Value = transfer.OperationType;
                transferBO.EVN_DISPOSITION_DATE.Value = transfer.DispositionDate;

                transferBO.REQ_ENTERED_BY.Value = transfer.EnteredBy;
                transferBO.REQ_LAST_EDIT_BY.Value = transfer.LastEditBy;
                transferBO.REQ_EDITED.Value = transfer.Edited;
                transferBO.REQ_REQUESTED_DATE.Value = transfer.RequestedDate;
                if (transfer.VistaSiteId != null)
                    transferBO.REQ_VISTA_SITE_UID.Value = System.Guid.Parse(transfer.VistaSiteId.extension);
                transferBO.IS_NATIONAL_WAIT_LIST.Value = transfer.IsNationalWaitList;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
