﻿using BMS.MT;
using System;
using System.Collections.Generic;
using BMS.DataContracts;
using System.Linq;
using System.ServiceModel;

namespace BMS.Translators
{
    public static class TranslatorPatientLocation
    {
        public static void CopyTo(this PatientLocationBO patientLocationBO, DataContracts.PatientLocation patientLocation)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                patientLocation.CurrentAdmissionWardId = TranslatorUtils.BuildIdentifier(patientLocationBO.DOMAIN_ID, patientLocationBO.CURRENT_ADMISSION_WARD_UID);
                patientLocation.CurrentAdmissionBedId = TranslatorUtils.BuildIdentifier(patientLocationBO.DOMAIN_ID, patientLocationBO.CURRENT_ADMISSION_BED_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
