﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorMovementOrder
    {
        public static void CopyTo(this MovementReqBO movementOrderBO, DataContracts.MovementOrder movementOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(movementOrderBO.FACILITY_LIST.Value))
                {
                    if (movementOrderBO.FACILITY_LIST.Value.EndsWith(","))
                        movementOrderBO.FACILITY_LIST.Value = movementOrderBO.FACILITY_LIST.Value.Substring(0, movementOrderBO.FACILITY_LIST.Value.Length - 1);
                    string[] facilityList = movementOrderBO.FACILITY_LIST.Value.Split(',');
                    movementOrder.FacilityList = new List<II>();
                    for (int i = 0; i < facilityList.Length; i++)
                        movementOrder.FacilityList.Add(TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID.Value, facilityList[i]));
                }
                movementOrder.HospitalLocationId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.HOSPITAL_LOCATION_UID);
                movementOrder.Id = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.ID);
                movementOrder.Ien = movementOrderBO.IEN.Value;
                movementOrder.IsActive = movementOrderBO.IS_ACTIVE.Value;
                movementOrder.OrderedDate = movementOrderBO.ORDERED_DATE.Value;
                movementOrder.OrderText = movementOrderBO.ORDER_TEXT.Value;
                movementOrder.PatientId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.PATIENT_UID);
                movementOrder.ProviderId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.PROVIDER_UID);
                movementOrder.ReleasedDate = movementOrderBO.RELEASED_DATE.Value;
                movementOrder.SchedulerId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.SCHEDULER_UID);
                movementOrder.SignedById = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.SIGNED_BY_UID);
                movementOrder.SignedDate = movementOrderBO.SIGNED_DATE.Value;
                movementOrder.VistaSiteId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.VISTA_SITE_UID);
                movementOrder.WardId = TranslatorUtils.BuildIdentifier(movementOrderBO.DOMAIN_ID, movementOrderBO.WARD_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.MovementOrder movementOrder, MovementReqBO movementOrderBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                movementOrderBO.FACILITY_LIST.Value = string.Empty;
                if (movementOrder.FacilityList != null && movementOrder.FacilityList.Count > 0)
                {
                    foreach (II id in movementOrder.FacilityList)
                        movementOrderBO.FACILITY_LIST.Value += id.extension + ",";
                }
                if (movementOrder.HospitalLocationId != null)
                    movementOrderBO.HOSPITAL_LOCATION_UID.Value = Guid.Parse(movementOrder.HospitalLocationId.extension);
                if (movementOrder.Id != null)
                {
                    movementOrderBO.DOMAIN_ID.Value = movementOrder.Id.root;
                    int? actId = movementOrder.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        movementOrderBO.ID.Value = actId.Value;
                }
                movementOrderBO.IEN.Value = movementOrder.Ien;
                movementOrderBO.IS_ACTIVE.Value = movementOrder.IsActive;
                movementOrderBO.ORDERED_DATE.Value = movementOrder.OrderedDate;
                movementOrderBO.ORDER_TEXT.Value = movementOrder.OrderText;
                if (movementOrder.PatientId != null)
                    movementOrderBO.PATIENT_UID.Value = Guid.Parse(movementOrder.PatientId.extension);
                if (movementOrder.ProviderId != null)
                    movementOrderBO.PROVIDER_UID.Value = Guid.Parse(movementOrder.ProviderId.extension);
                movementOrderBO.RELEASED_DATE.Value = movementOrder.ReleasedDate;
                if (movementOrder.SchedulerId != null)
                    movementOrderBO.SCHEDULER_UID.Value = System.Guid.Parse(movementOrder.SchedulerId.extension);
                if (movementOrder.SignedById != null)
                    movementOrderBO.SIGNED_BY_UID.Value = System.Guid.Parse(movementOrder.SignedById.extension);
                movementOrderBO.SIGNED_DATE.Value = movementOrder.SignedDate;
                if (movementOrder.VistaSiteId != null)
                    movementOrderBO.VISTA_SITE_UID.Value = Guid.Parse(movementOrder.VistaSiteId.extension);
                if (movementOrder.WardId != null)
                    movementOrderBO.WARD_UID.Value = Guid.Parse(movementOrder.WardId.extension);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
