﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorMovementEvent
    {
        public static void CopyTo(this MovementEvnBO movementEventBO, DataContracts.MovementEvent movementEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                movementEvent.BedId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.BED_UID);                                
                movementEvent.EnteredById = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.ENTERED_BY_UID);
                movementEvent.EnteredDate = movementEventBO.ENTERED_DATE.Value;                
                movementEvent.Id = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.ID);
                movementEvent.Ien = movementEventBO.IEN.Value;
                movementEvent.MovementDate = movementEventBO.MOVEMENT_DATE.Value;
                movementEvent.MovementType = TranslatorUtils.BuildConcept(movementEventBO.TYPE_OF_MOVEMENT_CODE, movementEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM, movementEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, movementEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME);
                movementEvent.OldBedId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.OLD_BED_UID);
                movementEvent.OldWardId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.OLD_WARD_UID);                
                movementEvent.PatientId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.PATIENT_UID);
                movementEvent.VistaSiteId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.VISTA_SITE_UID);
                movementEvent.WardId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.WARD_UID);
                movementEvent.AdmissionId = TranslatorUtils.BuildIdentifier(movementEventBO.DOMAIN_ID, movementEventBO.ADMISSION_ID);
                movementEvent.AdmissionIen = movementEventBO.ADMISSION_IEN.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.MovementEvent movementEvent, MovementEvnBO movementEventBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (movementEvent.BedId != null)
                    movementEventBO.BED_UID.Value = Guid.Parse(movementEvent.BedId.extension);
                else
                    movementEventBO.BED_UID.Value = null;
                if (movementEvent.EnteredById != null)
                    movementEventBO.ENTERED_BY_UID.Value = Guid.Parse(movementEvent.EnteredById.extension);
                movementEventBO.ENTERED_DATE.Value = movementEvent.EnteredDate;                
                if (movementEvent.Id != null)
                {
                    movementEventBO.DOMAIN_ID.Value = movementEvent.Id.root;
                    int? id = movementEvent.Id.extension.ParseAsInt();
                    if (id.HasValue)
                        movementEventBO.ID.Value = id.Value;
                }
                movementEventBO.IEN.Value = movementEvent.Ien;
                movementEventBO.MOVEMENT_DATE.Value = movementEvent.MovementDate;
                if (movementEvent.MovementType != null)
                {
                    movementEventBO.TYPE_OF_MOVEMENT_CODE.Value = movementEvent.MovementType.code;
                    movementEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM.Value = movementEvent.MovementType.codeSystem;
                    movementEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME.Value = movementEvent.MovementType.codeSystemName;
                    movementEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME.Value = movementEvent.MovementType.displayName;
                }
                if (movementEvent.OldBedId != null)
                    movementEventBO.OLD_BED_UID.Value = Guid.Parse(movementEvent.OldBedId.extension);
                else
                    movementEventBO.OLD_BED_UID.Value = null;
                if (movementEvent.OldWardId != null)
                    movementEventBO.OLD_WARD_UID.Value = Guid.Parse(movementEvent.OldWardId.extension);
                else
                    movementEventBO.OLD_WARD_UID.Value = null;
                if (movementEvent.PatientId != null)
                    movementEventBO.PATIENT_UID.Value = Guid.Parse(movementEvent.PatientId.extension);
                if (movementEvent.VistaSiteId != null)
                    movementEventBO.VISTA_SITE_UID.Value = Guid.Parse(movementEvent.VistaSiteId.extension);
                if (movementEvent.WardId != null)
                    movementEventBO.WARD_UID.Value = Guid.Parse(movementEvent.WardId.extension);
                else
                    movementEventBO.WARD_UID.Value = null;
                movementEventBO.ADMISSION_IEN.Value = movementEvent.AdmissionIen;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
