﻿using BMS.MT;
using System;
using BMS.Utils;

namespace BMS.Translators
{
    public static class TranslatorLoggedUser
    {
        public static void CopyTo(this LoggedUserBO loggedUserBO, DataContracts.LoggedUser loggedUser)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                loggedUser.SessionId = loggedUserBO.SESSION_ID.Value;
                loggedUser.UserName = loggedUserBO.USER_NAME.Value;
                loggedUser.FacilityId = TranslatorUtils.BuildIdentifier(loggedUserBO.DOMAIN_ID, loggedUserBO.FACILITY_UID);
                loggedUser.VisnId = TranslatorUtils.BuildIdentifier(loggedUserBO.DOMAIN_ID, loggedUserBO.VISN_UID);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.LoggedUser loggedUser, LoggedUserBO loggedUserBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                loggedUserBO.USER_NAME.Value = loggedUser.UserName;
                loggedUserBO.SESSION_ID.Value = loggedUser.SessionId;                
                if (loggedUser.FacilityId != null)
                    loggedUserBO.FACILITY_UID.Value = Guid.Parse(loggedUser.FacilityId.extension);                
                if (loggedUser.VisnId != null)
                    loggedUserBO.VISN_UID.Value = Guid.Parse(loggedUser.VisnId.extension);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
