﻿using BMS.MT;
using System;
using BMS.Utils;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorBedCleaning
    {
        public static void CopyTo(this BedCleanBO bedCleaningBO, DataContracts.BedCleaningOperation bedCleaning)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedCleaning.BedId = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.BED_UID);                
                bedCleaning.Id = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.ID);                
                bedCleaning.EventIen = bedCleaningBO.EVENT_IEN.Value;
                bedCleaning.TypeOfClean = TranslatorUtils.BuildConcept(bedCleaningBO.TYPE_OF_CLEAN_CODE, bedCleaningBO.TYPE_OF_CLEAN_CODE_SYSTEM, bedCleaningBO.TYPE_OF_CLEAN_CODE_SYSTEM_NAME, bedCleaningBO.TYPE_OF_CLEAN_DISPLAY_NAME);
                bedCleaning.AcceptedBy = bedCleaningBO.ACCEPTED_BY.Value;
                bedCleaning.AcceptedDate = bedCleaningBO.ACCEPTED_DATE.Value;
                bedCleaning.CompletedBy = bedCleaningBO.COMPLETED_BY.Value;
                bedCleaning.CompletedDate = bedCleaningBO.COMPLETED_DATE.Value;
                bedCleaning.ManualRequest = TranslatorUtils.BuildConcept(bedCleaningBO.MANUAL_REQUEST_CODE, bedCleaningBO.MANUAL_REQUEST_CODE_SYSTEM, bedCleaningBO.MANUAL_REQUEST_CODE_SYSTEM_NAME, bedCleaningBO.MANUAL_REQUEST_DISPLAY_NAME);
                bedCleaning.RequestedDate = bedCleaningBO.REQUESTED_DATE.Value;
                bedCleaning.LastEditedBy = bedCleaningBO.LAST_EDITED_BY.Value;
                bedCleaning.LastEditDate = bedCleaningBO.LAST_EDIT_DATE.Value;
                bedCleaning.VistaSiteId = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.VISTA_SITE_UID);
                bedCleaning.DivisionId = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.DIVISION_UID);
                bedCleaning.WardId = TranslatorUtils.BuildIdentifier(bedCleaningBO.DOMAIN_ID, bedCleaningBO.WARD_UID);
                bedCleaning.EMSNotify = bedCleaningBO.EMS_NOTIFY.Value;
                bedCleaning.SpecialInstructions = bedCleaningBO.SPECIAL_INSTRUCTIONS.Value;
                bedCleaning.Comment = bedCleaningBO.COMMENT.Value;
                bedCleaning.CommentedBy = bedCleaningBO.COMMENTED_BY.Value;
                bedCleaning.CommentedDate = bedCleaningBO.COMMENTED_DATE.Value;
                bedCleaning.VacatedDate = bedCleaningBO.VACATED_DATE.Value;
                bedCleaning.EventType = bedCleaningBO.EVENT_TYPE.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.BedCleaningOperation bedCleaning, BedCleanBO bedCleaningBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {                
                if (bedCleaning.Id != null)
                {
                    bedCleaningBO.DOMAIN_ID.Value = bedCleaning.Id.root;
                    int? actId = bedCleaning.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        bedCleaningBO.ID.Value = actId.Value;
                }                
                bedCleaningBO.EVENT_IEN.Value = bedCleaning.EventIen;
                if (bedCleaning.TypeOfClean != null)
                {
                    bedCleaningBO.TYPE_OF_CLEAN_CODE.Value = bedCleaning.TypeOfClean.code;
                    bedCleaningBO.TYPE_OF_CLEAN_CODE_SYSTEM.Value = bedCleaning.TypeOfClean.codeSystem;
                    bedCleaningBO.TYPE_OF_CLEAN_CODE_SYSTEM_NAME.Value = bedCleaning.TypeOfClean.codeSystemName;
                    bedCleaningBO.TYPE_OF_CLEAN_DISPLAY_NAME.Value = bedCleaning.TypeOfClean.displayName;
                }
                if (bedCleaning.BedId != null)
                        bedCleaningBO.BED_UID.Value = System.Guid.Parse(bedCleaning.BedId.extension);                
                bedCleaningBO.ACCEPTED_DATE.Value = bedCleaning.AcceptedDate;
                bedCleaningBO.COMPLETED_DATE.Value = bedCleaning.CompletedDate;
                bedCleaningBO.ACCEPTED_BY.Value = bedCleaning.AcceptedBy;
                bedCleaningBO.COMPLETED_BY.Value = bedCleaning.CompletedBy;
                if (bedCleaning.ManualRequest != null)
                {
                    bedCleaningBO.MANUAL_REQUEST_CODE.Value = bedCleaning.ManualRequest.code;
                    bedCleaningBO.MANUAL_REQUEST_CODE_SYSTEM.Value = bedCleaning.ManualRequest.codeSystem;
                    bedCleaningBO.MANUAL_REQUEST_CODE_SYSTEM_NAME.Value = bedCleaning.ManualRequest.codeSystemName;
                    bedCleaningBO.MANUAL_REQUEST_DISPLAY_NAME.Value = bedCleaning.ManualRequest.displayName;
                }
                bedCleaningBO.REQUESTED_DATE.Value = bedCleaning.RequestedDate;
                bedCleaningBO.LAST_EDITED_BY.Value = bedCleaning.LastEditedBy;
                bedCleaningBO.LAST_EDIT_DATE.Value = bedCleaning.LastEditDate;
                if (bedCleaning.VistaSiteId != null)
                    bedCleaningBO.VISTA_SITE_UID.Value = Guid.Parse(bedCleaning.VistaSiteId.extension);                
                if (bedCleaning.DivisionId != null)
                    bedCleaningBO.DIVISION_UID.Value = Guid.Parse(bedCleaning.DivisionId.extension);                
                if (bedCleaning.WardId != null)
                    bedCleaningBO.WARD_UID.Value = Guid.Parse(bedCleaning.WardId.extension);                
                bedCleaningBO.EMS_NOTIFY.Value = bedCleaning.EMSNotify;
                bedCleaningBO.SPECIAL_INSTRUCTIONS.Value = bedCleaning.SpecialInstructions;
                bedCleaningBO.COMMENT.Value = bedCleaning.Comment;
                bedCleaningBO.COMMENTED_BY.Value = bedCleaning.CommentedBy;
                bedCleaningBO.COMMENTED_DATE.Value = bedCleaning.CommentedDate;
                bedCleaningBO.VACATED_DATE.Value = bedCleaning.VacatedDate;
                bedCleaningBO.EVENT_TYPE.Value = bedCleaning.EventType;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}