﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorBedCleanMobileInfo
    {
        public static void CopyTo(this BedCleanMobileInfoBO bedCleanMobileInfoBO, DataContracts.BedCleanInfo bedCleanInfo)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bedCleanInfo.Id = TranslatorUtils.BuildIdentifier(bedCleanMobileInfoBO.DOMAIN_ID, bedCleanMobileInfoBO.ID);                
                bedCleanInfo.BedId = TranslatorUtils.BuildIdentifier(bedCleanMobileInfoBO.DOMAIN_ID, bedCleanMobileInfoBO.BED_UID);
                bedCleanInfo.WardId = TranslatorUtils.BuildIdentifier(bedCleanMobileInfoBO.DOMAIN_ID, bedCleanMobileInfoBO.WARD_UID);
                bedCleanInfo.RequestedDate = bedCleanMobileInfoBO.REQUESTED_DATE.Value;
                bedCleanInfo.AcceptedBy = bedCleanMobileInfoBO.ACCEPTED_BY.Value;
                bedCleanInfo.AcceptedDate = bedCleanMobileInfoBO.ACCEPTED_DATE.Value;
                bedCleanInfo.UnavailableType = TranslatorUtils.BuildConcept(bedCleanMobileInfoBO.UNAVAILABLE_TYPE_CODE, bedCleanMobileInfoBO.UNAVAILABLE_TYPE_CODE_SYSTEM, bedCleanMobileInfoBO.UNAVAILABLE_TYPE_CODE_SYSTEM_NAME, bedCleanMobileInfoBO.UNAVAILABLE_TYPE_DISPLAY_NAME);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
