﻿using System;
using BMS.DataContracts;
using BMS.MT;
using BMS.Utils;

namespace BMS.Translators
{
    public static class TranslatorAuditInfo
    {
        public static void CopyTo(this JobAuditInfoBO auditInfoBO, JobLogInfo audit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                audit.EndDate = auditInfoBO.END_DATE.Value;
                audit.ErrorMessage = auditInfoBO.ERROR_MESSAGE.Value;
                audit.Id = auditInfoBO.ID.Value;
                audit.LaunchType = (JobLaunchType)auditInfoBO.LAUNCH_TYPE.Value;
                audit.RetrievalMethod = (DataRetrievalMethod)auditInfoBO.RETRIEVAL_METHOD.Value;
                audit.RetrievedDataType = (VistaDataType)auditInfoBO.RETRIEVED_DATA_TYPE.Value;
                audit.RetrievedEntriesNumber = auditInfoBO.RETRIEVED_ENTRIES_NUMBER.Value;
                audit.StartDate = auditInfoBO.START_DATE.Value;
                audit.Status = (JobStatus)auditInfoBO.STATUS.Value;
                audit.VistaId = auditInfoBO.VISTA_ID.Value;
                audit.VistaName = auditInfoBO.VISTA_NAME.Value;
                audit.Index = auditInfoBO.INDEX.Value;
                audit.TotalCount = auditInfoBO.TOTAL_COUNT.Value;
                audit.Details = auditInfoBO.DETAILS.Value;

                if (auditInfoBO.JOB_AUDIT_PARAMS != null)
                {
                    foreach (JobAuditInfoParamBO parameter in auditInfoBO.JOB_AUDIT_PARAMS)
                    {
                        if (parameter.NAME.Value != null && parameter.NAME.Value.Equals(Constants.JOB_AUDIT_QUERY_START_DATE))
                            audit.QueryStartDate = DateTime.Parse(parameter.VALUE.Value);
                        if (parameter.NAME.Value != null && parameter.NAME.Value.Equals(Constants.JOB_AUDIT_QUERY_END_DATE))
                            audit.QueryEndDate = DateTime.Parse(parameter.VALUE.Value);
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
