﻿using System;
using System.Linq;
using System.ServiceModel;
using BMS.MT;
using BMS.Utils;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;

namespace BMS.Translators
{
    public static class TranslatorAdmissionOrder
    {
        public static void CopyTo(this AdmissionOrderBO admissionOrderBO, DataContracts.AdmissionOrder admissionOrder)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!string.IsNullOrEmpty(admissionOrderBO.FACILITY_LIST.Value))
                {
                    if (admissionOrderBO.FACILITY_LIST.Value.EndsWith(","))
                        admissionOrderBO.FACILITY_LIST.Value = admissionOrderBO.FACILITY_LIST.Value.Substring(0, admissionOrderBO.FACILITY_LIST.Value.Length - 1);
                    string[] facilityList = admissionOrderBO.FACILITY_LIST.Value.Split(',');
                    admissionOrder.FacilityList = new List<II>();
                    for (int i = 0; i < facilityList.Length; i++)
                        admissionOrder.FacilityList.Add(TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID.Value, facilityList[i]));
                }
                admissionOrder.HospitalLocationId = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.HOSPITAL_LOCATION_UID);                
                admissionOrder.Id = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.ID);
                admissionOrder.Ien = admissionOrderBO.IEN.Value;
                admissionOrder.IsActive = admissionOrderBO.IS_ACTIVE.Value;
                admissionOrder.OrderedDate = admissionOrderBO.ORDERED_DATE.Value;
                admissionOrder.OrderText = admissionOrderBO.ORDER_TEXT.Value;
                admissionOrder.PatientId = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.PATIENT_UID);
                admissionOrder.ProviderId = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.PROVIDER_UID);
                admissionOrder.ReleasedDate = admissionOrderBO.RELEASED_DATE.Value;
                admissionOrder.SignedById = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.SIGNED_BY_UID);
                admissionOrder.SignedDate = admissionOrderBO.SIGNED_DATE.Value;
                admissionOrder.VistaSiteId = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.VISTA_SITE_UID);
                admissionOrder.WardId = TranslatorUtils.BuildIdentifier(admissionOrderBO.DOMAIN_ID, admissionOrderBO.WARD_UID);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.AdmissionOrder admissionOrder, AdmissionOrderBO admissionOrderBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                admissionOrderBO.FACILITY_LIST.Value = string.Empty;
                if (admissionOrder.FacilityList != null && admissionOrder.FacilityList.Count > 0)
                {
                    foreach (II id in admissionOrder.FacilityList)
                        admissionOrderBO.FACILITY_LIST.Value += id.extension + ",";
                }
                if (admissionOrder.HospitalLocationId != null)
                    admissionOrderBO.HOSPITAL_LOCATION_UID.Value = Guid.Parse(admissionOrder.HospitalLocationId.extension);
                if (admissionOrder.Id != null)
                {
                    admissionOrderBO.DOMAIN_ID.Value = admissionOrder.Id.root;
                    int? actId = admissionOrder.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        admissionOrderBO.ID.Value = actId.Value;
                }
                admissionOrderBO.IEN.Value = admissionOrder.Ien;
                admissionOrderBO.IS_ACTIVE.Value = admissionOrder.IsActive;
                admissionOrderBO.ORDERED_DATE.Value = admissionOrder.OrderedDate;
                admissionOrderBO.ORDER_TEXT.Value = admissionOrder.OrderText;
                if (admissionOrder.PatientId != null)
                    admissionOrderBO.PATIENT_UID.Value = Guid.Parse(admissionOrder.PatientId.extension);
                if (admissionOrder.ProviderId != null)
                    admissionOrderBO.PROVIDER_UID.Value = Guid.Parse(admissionOrder.ProviderId.extension);
                admissionOrderBO.RELEASED_DATE.Value = admissionOrder.ReleasedDate;
                if (admissionOrder.SignedById != null)                                    
                    admissionOrderBO.SIGNED_BY_UID.Value = System.Guid.Parse(admissionOrder.SignedById.extension);                        
                admissionOrderBO.SIGNED_DATE.Value = admissionOrder.SignedDate;
                if (admissionOrder.VistaSiteId != null)
                    admissionOrderBO.VISTA_SITE_UID.Value = Guid.Parse(admissionOrder.VistaSiteId.extension);
                if (admissionOrder.WardId != null)
                    admissionOrderBO.WARD_UID.Value = Guid.Parse(admissionOrder.WardId.extension);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
