﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Service;
using System.Reflection;
using System.Configuration;
using BMS.Facade.Implementation;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.BMService;


namespace BMS.Facade
{
    /// <summary>
    /// The 'Facade' class
    /// </summary>
    public static class FacadeManager
    {
        private static readonly IEntityOperations _entityInterface = null;
        private static readonly IVocabularyOperations _vocabularyInterface = null;
        private static readonly INewEventOperations _newEventInterface = null;
        private static readonly IADTOperations _adtInterface = null;
        private static readonly IUserOperations _userInterface = null;
        private static readonly IBedOperations _bedInterface = null;
        private static readonly IReportsOperations _reportsInterface = null;
        private static readonly IDiversionOperations _diversionInterface = null;
        private static readonly IConfigurationOperations _configurationInterface = null;
        private static readonly IWorkflowOperations _workflowInterface = null;
        private static readonly IVistAIntegrationOperations _vistAIntegrationOperations = null;
        private static readonly IIconOperations _iconInterface = null;

        public static IUserOperations UserInterface
        {
            get { return FacadeManager._userInterface; }
        }
        public static IEntityOperations EntityInterface
        {
            get { return FacadeManager._entityInterface; }
        }
        public static IVocabularyOperations VocabularyInterface
        {
            get { return FacadeManager._vocabularyInterface; }
        }
        public static IADTOperations ADTInterface
        {
            get { return FacadeManager._adtInterface; }
        }
        public static INewEventOperations NewEventInterface
        {
            get { return FacadeManager._newEventInterface; }
        }
        public static IBedOperations BedInterface
        {
            get { return FacadeManager._bedInterface; }
        }
        public static IReportsOperations ReportsInterface
        {
            get { return FacadeManager._reportsInterface; }
        }
        public static IDiversionOperations DiversionInterface
        {
            get { return FacadeManager._diversionInterface; }
        }
        public static IConfigurationOperations ConfigurationInterface
        {
            get { return FacadeManager._configurationInterface; }
        }
        public static IWorkflowOperations WorkflowInterface
        {
            get { return FacadeManager._workflowInterface; }
        }

        public static IVistAIntegrationOperations VistAIntegrationInterface
        {
            get { return FacadeManager._vistAIntegrationOperations; }
        }

        public static IIconOperations IconInterface
        {
            get { return FacadeManager._iconInterface; }
        }

        static FacadeManager()
        {
            _entityInterface = new EntityOperationsImplementation();
            _vocabularyInterface = new VocabularyOperationsImplementation();
            _adtInterface = new ADTOperationsImplementation();
            _newEventInterface = new NewEventOperationsImplementation();
            _userInterface = new UserOperationsImplementation();
            _bedInterface = new BedOperationsImplementation();
            _reportsInterface = new ReportsOperationsImplementation();
            _diversionInterface = new DiversionOperationsImplementation();
            _configurationInterface = new ConfigurationImplementation();
            _workflowInterface = new WorkflowOperationsImplementation();
            _vistAIntegrationOperations = new VistAIntegrationOperationsImplementation();
            _iconInterface = new IconOperationsImplementation();
        }
    }
}
