﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;

namespace BMS.Facade.Service
{
    /// <summary>
    /// Interface used to manipulate event operations.
    /// </summary>
    public interface INewEventOperations
    {
        /// <summary>
        /// Gets the new events.
        /// </summary>
        /// <returns></returns>
        List<NewEventInfo> GetNewEvents(string wardUidList, Guid facilityIdentifier, int timeZoneMinutesOffset);

        /// <summary>
        /// Gets the count of new events.
        /// </summary>
        /// <returns></returns>
        int GetCountNewEvents(string wardUidList, Guid facilityIdentifier, List<Module> flags, int timeZoneMinutesOffset);
    }
}
