﻿using System;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Contains data about waiting list items (patients waiting).
    /// </summary>
    [DataContract]
    public class WaitingListItem : Act
    {
        /// <summary>
        /// Gets or sets the date of the removal from the waiting list.
        /// </summary>
        /// <value>
        /// The removal date.
        /// </value>
        [DataMember]
        public DateTime? RemovedDate { get;set; }        

        /// <summary>
        /// Gets or sets the date of the admission request.
        /// </summary>
        /// <value>
        /// The date of the request.
        /// </value>
        [DataMember]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the illness is acute (fee disposition).
        /// </summary>
        /// <value>
        /// The fee disposition.
        /// </value>
        [DataMember]
        public CD FeeDisposition { get; set; }

        /// <summary>
        /// Gets or sets the comment for the fee.
        /// </summary>
        /// <value>
        /// The comment for the fee.
        /// </value>
        [DataMember]
        public string CommentFee { get; set; }

        /// <summary>
        /// Gets or sets the reason for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The reason for the fee.
        /// </value>
        [DataMember]
        public CD ReasonFee { get; set; }

        /// <summary>
        /// Gets or sets the received service for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The service received.
        /// </value>
        [DataMember]
        public CD ServiceReceive { get; set; }

        /// <summary>
        /// Gets or sets the value indicating if the fee was authorized or not(EVS concept).
        /// </summary>
        /// <value>
        /// The authorization.
        /// </value>
        [DataMember]
        public CD Authorization { get; set; }

        /// <summary>
        /// Gets or sets whether there is a contract concerning the fee.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [DataMember]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the problem. Name of the presented problem or diagnostic of  the patient.
        /// </summary>
        /// <value>
        /// The problem.
        /// </value>
        [DataMember]
        public string Problem { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient(EVS patient).
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [DataMember]
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the area where the patient waits for admission(EVS concept).
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        [DataMember]
        public CD WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the facility where the patient will be admitted.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [DataMember]
        public Facility Facility { get; set; }

        /// <summary>
        /// Gets or sets the requested bed.
        /// </summary>
        /// <value>
        /// The requested bed.
        /// </value>
        [DataMember]
        public Place RequestedBed { get; set; }

        /// <summary>
        /// Gets or sets the requested bed date.
        /// </summary>
        /// <value>
        /// The requested bed date.
        /// </value>
        [DataMember]
        public DateTime? RequestedBedDate { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this patient already admitted to current facility.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is in house; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsInHouse { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [DataMember]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [DataMember]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this item overlaps a previously removed item, operation which should be undone.
        /// </summary>
        /// <value>
        ///   <c>true</c> if a remove operation should be undone; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool UndoRemovalOfPreviousItem { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether bed is in isolation or not.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if bed is in isolation; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsBedInIsolation { get; set; }

        /// <summary>
        /// Gets or sets the wait time alert date.
        /// </summary>
        /// <value>
        /// The wait time alert date.
        /// </value>
        [DataMember]
        public DateTime? WaitTimeAlertDate{get;set;}

        /// <summary>
        /// Gets or sets the community living center.
        /// </summary>
        /// <value>
        /// The community living center.
        /// </value>
        [DataMember]
        public bool IsCommunityLivingCenter { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation patient.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is evacuation patient; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsEvacuationPatient { get; set; }

        /// <summary>
        /// Gets or sets the evacuation disposition status.
        /// </summary>
        /// <value>
        /// The evacuation disposition status.
        /// </value>
        [DataMember]
        public CD EvacuationDispositionStatus { get; set; }

        /// <summary>
        /// Gets or sets the evacuation expected date.
        /// </summary>
        /// <value>
        /// The evacuation expected date.
        /// </value>
        [DataMember]
        public DateTime? EvacuationExpectedDate { get; set; }

        /// <summary>
        /// Gets or sets the evacuation actual date.
        /// </summary>
        /// <value>
        /// The evacuation actual date.
        /// </value>
        [DataMember]
        public DateTime? EvacuationActualDate { get; set; }

        /// <summary>
        /// Gets or sets the evacuation reason for delay.
        /// </summary>
        /// <value>
        /// The evacuation reason for delay.
        /// </value>
        [DataMember]
        public string EvacuationReasonForDelay { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transfer evacuate to.
        /// </summary>
        /// <value>
        /// The evacuation transfer evacuate to.
        /// </value>
        [DataMember]
        public string EvacuationTransferEvacuateTo { get; set; }

        /// <summary>
        /// Gets or sets the evacuation equip supply requirements.
        /// </summary>
        /// <value>
        /// The evacuation equip supply requirements.
        /// </value>
        [DataMember]
        public string EvacuationEquipSupplyRequirements { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation care level.
        /// </summary>
        /// <value>
        /// The evacuation transportation care level.
        /// </value>
        [DataMember]
        public string EvacuationTransportationCareLevel { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute medical attendant.
        /// </summary>
        /// <value>
        /// The evacuation enroute medical attendant.
        /// </value>
        [DataMember]
        public string EvacuationEnrouteMedicalAttendant { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute non medical attendant.
        /// </summary>
        /// <value>
        /// The evacuation enroute non medical attendant.
        /// </value>
        [DataMember]
        public string EvacuationEnrouteNonMedicalAttendant { get; set; }

        /// <summary>
        /// Gets or sets the type of the evacuation transportation.
        /// </summary>
        /// <value>
        /// The type of the evacuation transportation.
        /// </value>
        [DataMember]
        public CD EvacuationTransportationType { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation provider.
        /// </summary>
        /// <value>
        /// The evacuation transportation provider.
        /// </value>
        [DataMember]
        public CD EvacuationTransportationProvider { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation comments.
        /// </summary>
        /// <value>
        /// The evacuation transportation comments.
        /// </value>
        [DataMember]
        public string EvacuationTransportationComments { get; set; }

        /// <summary>
        /// Gets or sets the evacuation destination address.
        /// </summary>
        /// <value>
        /// The evacuation destination address.
        /// </value>
        [DataMember]
        public string EvacuationDestinationAddress { get; set; }

        /// <summary>
        /// Gets or sets the state of the evacuation destination city.
        /// </summary>
        /// <value>
        /// The state of the evacuation destination city.
        /// </value>
        [DataMember]
        public string EvacuationDestinationCityState { get; set; }

        /// <summary>
        /// Gets or sets the evacuation destination POC telephone.
        /// </summary>
        /// <value>
        /// The evacuation destination POC telephone.
        /// </value>
        [DataMember]
        public string EvacuationDestinationPOCTelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation originator POC telephone.
        /// </summary>
        /// <value>
        /// The evacuation originator POC telephone.
        /// </value>
        [DataMember]
        public string EvacuationOriginatorPOCTelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation comments.
        /// </summary>
        /// <value>
        /// The evacuation comments.
        /// </value>
        [DataMember]
        public string EvacuationComments { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute medical attendant number.
        /// </summary>
        /// <value>
        /// The evacuation enroute medical attendant number.
        /// </value>
        [DataMember]
        public int? EvacuationEnrouteMedicalAttendantNumber { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute non medical attendant number.
        /// </summary>
        /// <value>
        /// The evacuation enroute non medical attendant number.
        /// </value>
        [DataMember]
        public int? EvacuationEnrouteNonMedicalAttendantNumber { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        [DataMember]
        public string AdmittingDiagnosis { get; set; }
    }
}
