﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.Facade.Data
{
    /// <summary>
    /// User class. Stores information about user.
    /// </summary>
    public class User
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the current facility.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [ConvertDateTime]
        public Facility Facility { get; set; }

        /// <summary>
        /// Gets or sets the vistasite.
        /// </summary>
        /// <value>
        /// The vistasite.
        /// </value>
        [ConvertDateTime]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the visn.
        /// </summary>
        /// <value>
        /// The visn.
        /// </value>
        [ConvertDateTime]
        public Visn Visn { get; set; }

        /// <summary>
        /// Gets or sets the region.
        /// </summary>
        /// <value>
        /// The region.
        /// </value>
         [ConvertDateTime]
        public Region Region { get; set; }

        /// <summary>
        /// Gets or sets the user name.
        /// </summary>
        /// <value>
        /// The user name.
        /// </value>
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the read access.
        /// </summary>
        /// <value>
        /// The read access.
        /// </value>
        public CD ReadAccess { get; set; }

        /// <summary>
        /// Gets or sets the write access.
        /// </summary>
        /// <value>
        /// The write access.
        /// </value>
        public CD WriteAccess { get; set; }

        /// <summary>
        /// Gets or sets the support user.
        /// </summary>
        /// <value>
        /// The support user.
        /// </value>
        public CD SupportUser { get; set; }

        /// <summary>
        /// Gets or sets the national user.
        /// </summary>
        /// <value>
        /// The national user.
        /// </value>
        public CD NationalUser { get; set; }

        /// <summary>
        /// Gets or sets the regional user.
        /// </summary>
        /// <value>
        /// The regional user.
        /// </value>
        public CD RegionalUser { get; set; }

        /// <summary>
        /// Gets or sets the visn user.
        /// </summary>
        /// <value>
        /// The visn user.
        /// </value>
        public CD VisnUser { get; set; }

        /// <summary>
        /// Gets or sets the site user.
        /// </summary>
        /// <value>
        /// The site user.
        /// </value>
        public CD SiteUser { get; set; }

        /// <summary>
        /// Gets or sets the EMS user.
        /// </summary>
        /// <value>
        /// The EMS user.
        /// </value>
        public CD EMSUser { get; set; }

        /// <summary>
        /// Gets or sets the guest user.
        /// </summary>
        /// <value>
        /// The guest user.
        /// </value>
        public CD GuestUser { get; set; }

        /// <summary>
        /// Gets or sets the admin user.
        /// </summary>
        /// <value>
        /// The admin user.
        /// </value>
        public CD AdminUser { get; set; }

        /// <summary>
        /// Gets or sets the audit log user.
        /// </summary>
        /// <value>
        /// The audit log user.
        /// </value>
        public CD AuditLogUser { get; set; }

        /// <summary>
        /// Gets or sets the EMS supervisor user.
        /// </summary>
        /// <value>
        /// The EMS supervisor user.
        /// </value>
        public CD EMSSupervisorUser { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is super user.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is super user; otherwise, <c>false</c>.
        /// </value>
        public bool IsSuperUser { get; set; }

        /// <summary>
        /// Gets or sets the domain.
        /// </summary>
        /// <value>
        /// The domain.
        /// </value>
        public string Domain { get; set; }

        /// <summary>
        /// Gets or sets the available domains.
        /// </summary>
        public IList<string> AvailableDomains { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the default facility.
        /// </summary>
        public Facility DefaultFacility { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is group.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is group; otherwise, <c>false</c>.
        /// </value>
        public bool IsGroup { get; set; }

        /// <summary>
        /// Gets or sets the salt used for parameters encryption and decryption.
        /// </summary>
        /// <value>
        /// The salt.
        /// </value>
        public string Salt { get; set; }

        #endregion

    }
}
