﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Bed Clean class. Stores information about bed cleaning.
    /// </summary>
    [DataContract]
    public class BedClean
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [DataMember]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the type of clean.
        /// </summary>
        /// <value>
        /// The type of clean.
        /// </value>
        [DataMember]
        public CD TypeOfClean { get; set; }

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [DataMember]
        public Ward Ward { get; set; }

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public Place Bed { get; set; }

        /// <summary>
        /// Gets or sets the manual request.
        /// </summary>
        /// <value>
        /// The manual request.
        /// </value>
        [DataMember]
        public CD ManualRequest { get; set; }

        /// <summary>
        /// Gets or sets the accepted date.
        /// </summary>
        /// <value>
        /// The accepted date.
        /// </value>
        [DataMember]
        public DateTime? AcceptedDate { get; set; }

        /// <summary>
        /// Gets or sets the accepted by.
        /// </summary>
        /// <value>
        /// The accepted by.
        /// </value>
        [DataMember]
        public string AcceptedBy { get; set; }

        /// <summary>
        /// Gets or sets the completed date.
        /// </summary>
        /// <value>
        /// The completed date.
        /// </value>
        [DataMember]
        public DateTime? CompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the completed by.
        /// </summary>
        /// <value>
        /// The completed by.
        /// </value>
        [DataMember]
        public string CompletedBy { get; set; }

        /// <summary>
        /// Gets or sets the last edited by.
        /// </summary>
        /// <value>
        /// The last edited by.
        /// </value>
        [DataMember]
        public string LastEditedBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [DataMember]
        public DateTime? LastEditDate { get; set; }

        /// <summary>
        /// Gets or sets the requested date.
        /// </summary>
        /// <value>
        /// The requested date.
        /// </value>
        [DataMember]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets the division.
        /// </summary>
        /// <value>
        /// The division.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public Division Division { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the EMSNotify flag.
        /// </summary>
        /// <value>
        /// The EMSNotify flag.
        /// </value>
        [DataMember]
        public string EMSNotify { get; set; }

        /// <summary>
        /// Gets or sets the special instructions.
        /// </summary>
        /// <value>
        /// The special instructions.
        /// </value>
        [DataMember]
        public string SpecialInstructions { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [DataMember]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the user who added,modified a comment.
        /// </summary>
        /// <value>
        /// The user who added, modified a comment.
        /// </value>
        [DataMember]
        public string CommentedBy { get; set; }

        /// <summary>
        /// Gets or sets the date when a comment was added,modified.
        /// </summary>
        /// <value>
        /// The date when a comment was added,modified.
        /// </value>
        [DataMember]
        public DateTime? CommentedDate { get; set; }

        /// <summary>
        /// Gets or sets the vacated date.
        /// </summary>
        /// <value>
        /// The vacated date.
        /// </value>
        [DataMember]
        public DateTime? VacatedDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the event(ADM, TRA, DIS, BSW).
        /// </summary>
        /// <value>
        /// The type of the event.
        /// </value>
        [DataMember]
        public string EventType { get; set; }

        /// <summary>
        /// Gets or sets the event ien.
        /// </summary>
        /// <value>
        /// The event ien.
        /// </value>
        [DataMember]
        public string EventIen { get; set; }

        #endregion
    }
}
