-- MySQL dump 10.13  Distrib 5.6.28, for Linux (x86_64)
--
-- Host: localhost    Database: raptor500
-- ------------------------------------------------------
-- Server version	5.6.28

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `actions`
--

DROP TABLE IF EXISTS `actions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `actions` (
  `aid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Primary Key: Unique actions ID.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The object that that action acts on (node, user, comment, system or custom types.)',
  `callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback function that executes when the action runs.',
  `parameters` longblob NOT NULL COMMENT 'Parameters to be passed to the callback function.',
  `label` varchar(255) NOT NULL DEFAULT '0' COMMENT 'Label of the action.',
  PRIMARY KEY (`aid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores action information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `actions`
--

LOCK TABLES `actions` WRITE;
/*!40000 ALTER TABLE `actions` DISABLE KEYS */;
INSERT INTO `actions` VALUES ('comment_publish_action','comment','comment_publish_action','','Publish comment'),('comment_save_action','comment','comment_save_action','','Save comment'),('comment_unpublish_action','comment','comment_unpublish_action','','Unpublish comment'),('node_make_sticky_action','node','node_make_sticky_action','','Make content sticky'),('node_make_unsticky_action','node','node_make_unsticky_action','','Make content unsticky'),('node_promote_action','node','node_promote_action','','Promote content to front page'),('node_publish_action','node','node_publish_action','','Publish content'),('node_save_action','node','node_save_action','','Save content'),('node_unpromote_action','node','node_unpromote_action','','Remove content from front page'),('node_unpublish_action','node','node_unpublish_action','','Unpublish content'),('pathauto_node_update_action','node','pathauto_node_update_action','','Update node alias'),('pathauto_taxonomy_term_update_action','taxonomy_term','pathauto_taxonomy_term_update_action','','Update taxonomy term alias'),('pathauto_user_update_action','user','pathauto_user_update_action','','Update user alias'),('system_block_ip_action','user','system_block_ip_action','','Ban IP address of current user'),('user_block_user_action','user','user_block_user_action','','Block current user');
/*!40000 ALTER TABLE `actions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ajax_example_node_form_alter`
--

DROP TABLE IF EXISTS `ajax_example_node_form_alter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ajax_example_node_form_alter` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid to store settings.',
  `example_1` int(11) NOT NULL DEFAULT '0' COMMENT 'Node Form Example 1 checkbox',
  `example_2` varchar(256) DEFAULT '' COMMENT 'Node Form Example 2 textfield',
  PRIMARY KEY (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores example settings for nodes.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ajax_example_node_form_alter`
--

LOCK TABLES `ajax_example_node_form_alter` WRITE;
/*!40000 ALTER TABLE `ajax_example_node_form_alter` DISABLE KEYS */;
/*!40000 ALTER TABLE `ajax_example_node_form_alter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authmap`
--

DROP TABLE IF EXISTS `authmap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authmap` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique authmap ID.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'User’s users.uid.',
  `authname` varchar(128) NOT NULL DEFAULT '' COMMENT 'Unique authentication name.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'Module which is controlling the authentication.',
  PRIMARY KEY (`aid`),
  UNIQUE KEY `authname` (`authname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores distributed authentication mapping.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authmap`
--

LOCK TABLES `authmap` WRITE;
/*!40000 ALTER TABLE `authmap` DISABLE KEYS */;
/*!40000 ALTER TABLE `authmap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `batch`
--

DROP TABLE IF EXISTS `batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `batch` (
  `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) NOT NULL COMMENT 'A string token generated against the current user’s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores details about batches (processes that run in...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batch`
--

LOCK TABLES `batch` WRITE;
/*!40000 ALTER TABLE `batch` DISABLE KEYS */;
/*!40000 ALTER TABLE `batch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block`
--

DROP TABLE IF EXISTS `block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block` (
  `bid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique block ID.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The module from which the block originates; for example, ’user’ for the Who’s Online block, and ’block’ for any custom blocks.',
  `delta` varchar(32) NOT NULL DEFAULT '0' COMMENT 'Unique ID for block within a module.',
  `theme` varchar(64) NOT NULL DEFAULT '' COMMENT 'The theme under which the block settings apply.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Block enabled status. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Block weight within region.',
  `region` varchar(64) NOT NULL DEFAULT '' COMMENT 'Theme region within which the block is set.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how users may control visibility of the block. (0 = Users cannot control, 1 = On by default, but can be hidden, 2 = Hidden by default, but can be shown)',
  `visibility` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate how to show blocks on pages. (0 = Show on all pages except listed pages, 1 = Show only on listed pages, 2 = Use custom PHP code to determine visibility)',
  `pages` text NOT NULL COMMENT 'Contents of the "Pages" block; contains either a list of paths on which to include/exclude the block or PHP code, depending on "visibility" setting.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Custom title for the block. (Empty string will use block default title, <none> will remove the title, text will cause block to use specified title.)',
  `cache` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Binary flag to indicate block cache mode. (-2: Custom cache, -1: Do not cache, 1: Cache per role, 2: Cache per user, 4: Cache per page, 8: Block cache global) See DRUPAL_CACHE_* constants in ../includes/common.inc for more detailed information.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `tmd` (`theme`,`module`,`delta`),
  KEY `list` (`theme`,`status`,`region`,`weight`,`module`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COMMENT='Stores block settings, such as region and visibility...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block`
--

LOCK TABLES `block` WRITE;
/*!40000 ALTER TABLE `block` DISABLE KEYS */;
INSERT INTO `block` VALUES (1,'system','main','bartik',1,0,'content',0,0,'','',-1),(2,'search','form','bartik',1,-1,'sidebar_first',0,0,'','',-1),(3,'node','recent','seven',1,10,'dashboard_main',0,0,'','',-1),(4,'user','login','bartik',1,0,'sidebar_first',0,0,'','',-1),(5,'system','navigation','bartik',1,0,'sidebar_first',0,0,'','',-1),(6,'system','powered-by','bartik',1,10,'footer',0,0,'','',-1),(7,'system','help','bartik',1,0,'help',0,0,'','',-1),(8,'system','main','seven',1,0,'content',0,0,'','',-1),(9,'system','help','seven',1,0,'help',0,0,'','',-1),(10,'user','login','seven',1,10,'content',0,0,'','',-1),(11,'user','new','seven',1,0,'dashboard_sidebar',0,0,'','',-1),(12,'search','form','seven',1,-10,'dashboard_sidebar',0,0,'','',-1),(13,'comment','recent','bartik',0,0,'-1',0,0,'','',1),(14,'node','syndicate','bartik',0,0,'-1',0,0,'','',-1),(15,'node','recent','bartik',0,0,'-1',0,0,'','',1),(16,'shortcut','shortcuts','bartik',0,0,'-1',0,0,'','',-1),(17,'system','management','bartik',0,0,'-1',0,0,'','',-1),(18,'system','user-menu','bartik',0,0,'-1',0,0,'','',-1),(19,'system','main-menu','bartik',0,0,'-1',0,0,'','',-1),(20,'user','new','bartik',0,0,'-1',0,0,'','',1),(21,'user','online','bartik',0,0,'-1',0,0,'','',-1),(22,'comment','recent','seven',1,0,'dashboard_inactive',0,0,'','',1),(23,'node','syndicate','seven',0,0,'-1',0,0,'','',-1),(24,'shortcut','shortcuts','seven',0,0,'-1',0,0,'','',-1),(25,'system','powered-by','seven',0,10,'-1',0,0,'','',-1),(26,'system','navigation','seven',0,0,'-1',0,0,'','',-1),(27,'system','management','seven',0,0,'-1',0,0,'','',-1),(28,'system','user-menu','seven',0,0,'-1',0,0,'','',-1),(29,'system','main-menu','seven',0,0,'-1',0,0,'','',-1),(30,'user','online','seven',1,0,'dashboard_inactive',0,0,'','',-1),(31,'comment','recent','omega',0,0,'-1',0,0,'','',1),(32,'node','recent','omega',0,0,'-1',0,0,'','',1),(33,'node','syndicate','omega',0,0,'-1',0,0,'','',-1),(34,'search','form','omega',1,-1,'sidebar_first',0,0,'','',-1),(35,'shortcut','shortcuts','omega',0,0,'-1',0,0,'','',-1),(36,'system','help','omega',1,0,'help',0,0,'','',-1),(37,'system','main','omega',1,0,'content',0,0,'','',-1),(38,'system','main-menu','omega',0,0,'-1',0,0,'','',-1),(39,'system','management','omega',0,0,'-1',0,0,'','',-1),(40,'system','navigation','omega',1,0,'sidebar_first',0,0,'','',-1),(41,'system','powered-by','omega',1,10,'footer',0,0,'','',-1),(42,'system','user-menu','omega',0,0,'-1',0,0,'','',-1),(43,'user','login','omega',1,0,'sidebar_first',0,0,'','',-1),(44,'user','new','omega',0,0,'-1',0,0,'','',1),(45,'user','online','omega',0,0,'-1',0,0,'','',-1),(46,'comment','recent','raptor_omega',0,0,'-1',0,0,'','',1),(47,'node','recent','raptor_omega',0,0,'-1',0,0,'','',1),(48,'node','syndicate','raptor_omega',0,0,'-1',0,0,'','',-1),(49,'search','form','raptor_omega',1,-1,'sidebar_first',0,0,'','',-1),(50,'shortcut','shortcuts','raptor_omega',0,0,'-1',0,0,'','',-1),(51,'system','help','raptor_omega',1,0,'help',0,0,'','',-1),(52,'system','main','raptor_omega',1,0,'content',0,0,'','',-1),(53,'system','main-menu','raptor_omega',0,0,'-1',0,0,'','',-1),(54,'system','management','raptor_omega',0,0,'-1',0,0,'','',-1),(55,'system','navigation','raptor_omega',1,0,'sidebar_first',0,0,'','',-1),(56,'system','powered-by','raptor_omega',1,10,'footer',0,0,'','',-1),(57,'system','user-menu','raptor_omega',0,0,'-1',0,0,'','',-1),(58,'user','login','raptor_omega',1,0,'sidebar_first',0,0,'','',-1),(59,'user','new','raptor_omega',0,0,'-1',0,0,'','',1),(60,'user','online','raptor_omega',0,0,'-1',0,0,'','',-1);
/*!40000 ALTER TABLE `block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_custom`
--

DROP TABLE IF EXISTS `block_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_custom` (
  `bid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The block’s block.bid.',
  `body` longtext COMMENT 'Block contents.',
  `info` varchar(128) NOT NULL DEFAULT '' COMMENT 'Block description.',
  `format` varchar(255) DEFAULT NULL COMMENT 'The filter_format.format of the block body.',
  PRIMARY KEY (`bid`),
  UNIQUE KEY `info` (`info`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores contents of custom-made blocks.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_custom`
--

LOCK TABLES `block_custom` WRITE;
/*!40000 ALTER TABLE `block_custom` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_custom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_node_type`
--

DROP TABLE IF EXISTS `block_node_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_node_type` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type from node_type.type.',
  PRIMARY KEY (`module`,`delta`,`type`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up display criteria for blocks based on content types';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_node_type`
--

LOCK TABLES `block_node_type` WRITE;
/*!40000 ALTER TABLE `block_node_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_node_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `block_role`
--

DROP TABLE IF EXISTS `block_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `block_role` (
  `module` varchar(64) NOT NULL COMMENT 'The block’s origin module, from block.module.',
  `delta` varchar(32) NOT NULL COMMENT 'The block’s unique delta within module, from block.delta.',
  `rid` int(10) unsigned NOT NULL COMMENT 'The user’s role ID from users_roles.rid.',
  PRIMARY KEY (`module`,`delta`,`rid`),
  KEY `rid` (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Sets up access permissions for blocks based on user roles';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_role`
--

LOCK TABLES `block_role` WRITE;
/*!40000 ALTER TABLE `block_role` DISABLE KEYS */;
/*!40000 ALTER TABLE `block_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `blocked_ips`
--

DROP TABLE IF EXISTS `blocked_ips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `blocked_ips` (
  `iid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: unique ID for IP addresses.',
  `ip` varchar(40) NOT NULL DEFAULT '' COMMENT 'IP address',
  PRIMARY KEY (`iid`),
  KEY `blocked_ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores blocked IP addresses.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `blocked_ips`
--

LOCK TABLES `blocked_ips` WRITE;
/*!40000 ALTER TABLE `blocked_ips` DISABLE KEYS */;
/*!40000 ALTER TABLE `blocked_ips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` VALUES ('entity_info:en','a:6:{s:7:\"comment\";a:14:{s:5:\"label\";s:7:\"Comment\";s:10:\"base table\";s:7:\"comment\";s:12:\"uri callback\";s:11:\"comment_uri\";s:9:\"fieldable\";b:1;s:16:\"controller class\";s:17:\"CommentController\";s:11:\"entity keys\";a:5:{s:2:\"id\";s:3:\"cid\";s:6:\"bundle\";s:9:\"node_type\";s:5:\"label\";s:7:\"subject\";s:8:\"language\";s:8:\"language\";s:8:\"revision\";s:0:\"\";}s:7:\"bundles\";a:2:{s:20:\"comment_node_article\";a:4:{s:5:\"label\";s:15:\"Article comment\";s:11:\"node bundle\";s:7:\"article\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:44:\"admin/structure/types/manage/article/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}s:17:\"comment_node_page\";a:4:{s:5:\"label\";s:18:\"Basic page comment\";s:11:\"node bundle\";s:4:\"page\";s:5:\"admin\";a:4:{s:4:\"path\";s:55:\"admin/structure/types/manage/%comment_node_type/comment\";s:15:\"bundle argument\";i:4;s:9:\"real path\";s:41:\"admin/structure/types/manage/page/comment\";s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:8:{s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Post\";i:1;s:13:\"sioct:Comment\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:12:\"comment_body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"pid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"sioc:reply_of\";}s:4:\"type\";s:3:\"rel\";}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}}}}s:10:\"view modes\";a:1:{s:4:\"full\";a:2:{s:5:\"label\";s:12:\"Full comment\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:0;s:11:\"field cache\";b:1;s:9:\"load hook\";s:12:\"comment_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:14:{s:3:\"cid\";s:6:\"serial\";s:3:\"pid\";s:3:\"int\";s:3:\"nid\";s:3:\"int\";s:3:\"uid\";s:3:\"int\";s:7:\"subject\";s:7:\"varchar\";s:8:\"hostname\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:6:\"thread\";s:7:\"varchar\";s:4:\"name\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:8:\"homepage\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:14:{i:0;s:3:\"cid\";i:1;s:3:\"pid\";i:2;s:3:\"nid\";i:3;s:3:\"uid\";i:4;s:7:\"subject\";i:5;s:8:\"hostname\";i:6;s:7:\"created\";i:7;s:7:\"changed\";i:8;s:6:\"status\";i:9;s:6:\"thread\";i:10;s:4:\"name\";i:11;s:4:\"mail\";i:12;s:8:\"homepage\";i:13;s:8:\"language\";}}}s:4:\"node\";a:16:{s:5:\"label\";s:4:\"Node\";s:16:\"controller class\";s:14:\"NodeController\";s:10:\"base table\";s:4:\"node\";s:14:\"revision table\";s:13:\"node_revision\";s:12:\"uri callback\";s:8:\"node_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:5:{s:2:\"id\";s:3:\"nid\";s:8:\"revision\";s:3:\"vid\";s:6:\"bundle\";s:4:\"type\";s:5:\"label\";s:5:\"title\";s:8:\"language\";s:8:\"language\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:4:\"type\";}s:7:\"bundles\";a:2:{s:7:\"article\";a:3:{s:5:\"label\";s:7:\"Article\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:36:\"admin/structure/types/manage/article\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:11:{s:11:\"field_image\";a:2:{s:10:\"predicates\";a:2:{i:0;s:8:\"og:image\";i:1;s:12:\"rdfs:seeAlso\";}s:4:\"type\";s:3:\"rel\";}s:10:\"field_tags\";a:2:{s:10:\"predicates\";a:1:{i:0;s:10:\"dc:subject\";}s:4:\"type\";s:3:\"rel\";}s:7:\"rdftype\";a:2:{i:0;s:9:\"sioc:Item\";i:1;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}s:4:\"page\";a:3:{s:5:\"label\";s:10:\"Basic page\";s:5:\"admin\";a:4:{s:4:\"path\";s:39:\"admin/structure/types/manage/%node_type\";s:9:\"real path\";s:33:\"admin/structure/types/manage/page\";s:15:\"bundle argument\";i:4;s:16:\"access arguments\";a:1:{i:0;s:24:\"administer content types\";}}s:11:\"rdf_mapping\";a:9:{s:7:\"rdftype\";a:1:{i:0;s:13:\"foaf:Document\";}s:5:\"title\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:7:\"created\";a:3:{s:10:\"predicates\";a:2:{i:0;s:7:\"dc:date\";i:1;s:10:\"dc:created\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:7:\"changed\";a:3:{s:10:\"predicates\";a:1:{i:0;s:11:\"dc:modified\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}s:4:\"body\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"content:encoded\";}}s:3:\"uid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:has_creator\";}s:4:\"type\";s:3:\"rel\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:13:\"comment_count\";a:2:{s:10:\"predicates\";a:1:{i:0;s:16:\"sioc:num_replies\";}s:8:\"datatype\";s:11:\"xsd:integer\";}s:13:\"last_activity\";a:3:{s:10:\"predicates\";a:1:{i:0;s:23:\"sioc:last_activity_date\";}s:8:\"datatype\";s:12:\"xsd:dateTime\";s:8:\"callback\";s:12:\"date_iso8601\";}}}}s:10:\"view modes\";a:5:{s:4:\"full\";a:2:{s:5:\"label\";s:12:\"Full content\";s:15:\"custom settings\";b:0;}s:6:\"teaser\";a:2:{s:5:\"label\";s:6:\"Teaser\";s:15:\"custom settings\";b:1;}s:3:\"rss\";a:2:{s:5:\"label\";s:3:\"RSS\";s:15:\"custom settings\";b:0;}s:12:\"search_index\";a:2:{s:5:\"label\";s:12:\"Search index\";s:15:\"custom settings\";b:0;}s:13:\"search_result\";a:2:{s:5:\"label\";s:32:\"Search result highlighting input\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"node_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:14:{s:3:\"nid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"type\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:5:\"title\";s:7:\"varchar\";s:3:\"uid\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:7:\"created\";s:3:\"int\";s:7:\"changed\";s:3:\"int\";s:7:\"comment\";s:3:\"int\";s:7:\"promote\";s:3:\"int\";s:6:\"sticky\";s:3:\"int\";s:4:\"tnid\";s:3:\"int\";s:9:\"translate\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:2:{s:10:\"base table\";a:14:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:4:\"type\";i:3;s:8:\"language\";i:4;s:5:\"title\";i:5;s:3:\"uid\";i:6;s:6:\"status\";i:7;s:7:\"created\";i:8;s:7:\"changed\";i:9;s:7:\"comment\";i:10;s:7:\"promote\";i:11;s:6:\"sticky\";i:12;s:4:\"tnid\";i:13;s:9:\"translate\";}s:14:\"revision table\";a:10:{i:0;s:3:\"nid\";i:1;s:3:\"vid\";i:2;s:3:\"uid\";i:3;s:5:\"title\";i:4;s:3:\"log\";i:5;s:9:\"timestamp\";i:6;s:6:\"status\";i:7;s:7:\"comment\";i:8;s:7:\"promote\";i:9;s:6:\"sticky\";}}}s:4:\"file\";a:13:{s:5:\"label\";s:4:\"File\";s:10:\"base table\";s:12:\"file_managed\";s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"fid\";s:5:\"label\";s:8:\"filename\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:12:\"static cache\";b:0;s:9:\"fieldable\";b:0;s:16:\"controller class\";s:29:\"DrupalDefaultEntityController\";s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"file_load\";s:7:\"bundles\";a:1:{s:4:\"file\";a:2:{s:5:\"label\";s:4:\"File\";s:11:\"rdf_mapping\";a:0:{}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:8:{s:3:\"fid\";s:6:\"serial\";s:3:\"uid\";s:3:\"int\";s:8:\"filename\";s:7:\"varchar\";s:3:\"uri\";s:7:\"varchar\";s:8:\"filemime\";s:7:\"varchar\";s:8:\"filesize\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:9:\"timestamp\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:8:{i:0;s:3:\"fid\";i:1;s:3:\"uid\";i:2;s:8:\"filename\";i:3;s:3:\"uri\";i:4;s:8:\"filemime\";i:5;s:8:\"filesize\";i:6;s:6:\"status\";i:7;s:9:\"timestamp\";}}}s:13:\"taxonomy_term\";a:15:{s:5:\"label\";s:13:\"Taxonomy term\";s:16:\"controller class\";s:22:\"TaxonomyTermController\";s:10:\"base table\";s:18:\"taxonomy_term_data\";s:12:\"uri callback\";s:17:\"taxonomy_term_uri\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"tid\";s:6:\"bundle\";s:23:\"vocabulary_machine_name\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";}s:11:\"bundle keys\";a:1:{s:6:\"bundle\";s:12:\"machine_name\";}s:7:\"bundles\";a:1:{s:4:\"tags\";a:3:{s:5:\"label\";s:4:\"Tags\";s:5:\"admin\";a:4:{s:4:\"path\";s:58:\"admin/structure/taxonomy/%taxonomy_vocabulary_machine_name\";s:9:\"real path\";s:29:\"admin/structure/taxonomy/tags\";s:15:\"bundle argument\";i:3;s:16:\"access arguments\";a:1:{i:0;s:19:\"administer taxonomy\";}}s:11:\"rdf_mapping\";a:5:{s:7:\"rdftype\";a:1:{i:0;s:12:\"skos:Concept\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:2:{i:0;s:10:\"rdfs:label\";i:1;s:14:\"skos:prefLabel\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:15:\"skos:definition\";}}s:3:\"vid\";a:2:{s:10:\"predicates\";a:1:{i:0;s:13:\"skos:inScheme\";}s:4:\"type\";s:3:\"rel\";}s:6:\"parent\";a:2:{s:10:\"predicates\";a:1:{i:0;s:12:\"skos:broader\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:1:{s:4:\"full\";a:2:{s:5:\"label\";s:18:\"Taxonomy term page\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:18:\"taxonomy_term_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:6:{s:3:\"tid\";s:6:\"serial\";s:3:\"vid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:6:\"format\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:6:{i:0;s:3:\"tid\";i:1;s:3:\"vid\";i:2;s:4:\"name\";i:3;s:11:\"description\";i:4;s:6:\"format\";i:5;s:6:\"weight\";}}}s:19:\"taxonomy_vocabulary\";a:13:{s:5:\"label\";s:19:\"Taxonomy vocabulary\";s:16:\"controller class\";s:28:\"TaxonomyVocabularyController\";s:10:\"base table\";s:19:\"taxonomy_vocabulary\";s:11:\"entity keys\";a:4:{s:2:\"id\";s:3:\"vid\";s:5:\"label\";s:4:\"name\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:9:\"fieldable\";b:0;s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:24:\"taxonomy_vocabulary_load\";s:7:\"bundles\";a:1:{s:19:\"taxonomy_vocabulary\";a:2:{s:5:\"label\";s:19:\"Taxonomy vocabulary\";s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:18:\"skos:ConceptScheme\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:8:\"dc:title\";}}s:11:\"description\";a:1:{s:10:\"predicates\";a:1:{i:0;s:12:\"rdfs:comment\";}}}}}s:10:\"view modes\";a:0:{}s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:7:{s:3:\"vid\";s:6:\"serial\";s:4:\"name\";s:7:\"varchar\";s:12:\"machine_name\";s:7:\"varchar\";s:11:\"description\";s:4:\"text\";s:9:\"hierarchy\";s:3:\"int\";s:6:\"module\";s:7:\"varchar\";s:6:\"weight\";s:3:\"int\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:7:{i:0;s:3:\"vid\";i:1;s:4:\"name\";i:2;s:12:\"machine_name\";i:3;s:11:\"description\";i:4;s:9:\"hierarchy\";i:5;s:6:\"module\";i:6;s:6:\"weight\";}}}s:4:\"user\";a:15:{s:5:\"label\";s:4:\"User\";s:16:\"controller class\";s:14:\"UserController\";s:10:\"base table\";s:5:\"users\";s:12:\"uri callback\";s:8:\"user_uri\";s:14:\"label callback\";s:15:\"format_username\";s:9:\"fieldable\";b:1;s:11:\"entity keys\";a:3:{s:2:\"id\";s:3:\"uid\";s:8:\"revision\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:7:\"bundles\";a:1:{s:4:\"user\";a:3:{s:5:\"label\";s:4:\"User\";s:5:\"admin\";a:2:{s:4:\"path\";s:28:\"admin/config/people/accounts\";s:16:\"access arguments\";a:1:{i:0;s:16:\"administer users\";}}s:11:\"rdf_mapping\";a:3:{s:7:\"rdftype\";a:1:{i:0;s:16:\"sioc:UserAccount\";}s:4:\"name\";a:1:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:name\";}}s:8:\"homepage\";a:2:{s:10:\"predicates\";a:1:{i:0;s:9:\"foaf:page\";}s:4:\"type\";s:3:\"rel\";}}}}s:10:\"view modes\";a:1:{s:4:\"full\";a:2:{s:5:\"label\";s:12:\"User account\";s:15:\"custom settings\";b:0;}}s:12:\"static cache\";b:1;s:11:\"field cache\";b:1;s:9:\"load hook\";s:9:\"user_load\";s:11:\"translation\";a:0:{}s:22:\"base table field types\";a:16:{s:3:\"uid\";s:3:\"int\";s:4:\"name\";s:7:\"varchar\";s:4:\"pass\";s:7:\"varchar\";s:4:\"mail\";s:7:\"varchar\";s:5:\"theme\";s:7:\"varchar\";s:9:\"signature\";s:7:\"varchar\";s:16:\"signature_format\";s:7:\"varchar\";s:7:\"created\";s:3:\"int\";s:6:\"access\";s:3:\"int\";s:5:\"login\";s:3:\"int\";s:6:\"status\";s:3:\"int\";s:8:\"timezone\";s:7:\"varchar\";s:8:\"language\";s:7:\"varchar\";s:7:\"picture\";s:3:\"int\";s:4:\"init\";s:7:\"varchar\";s:4:\"data\";s:4:\"blob\";}s:17:\"schema_fields_sql\";a:1:{s:10:\"base table\";a:16:{i:0;s:3:\"uid\";i:1;s:4:\"name\";i:2;s:4:\"pass\";i:3;s:4:\"mail\";i:4;s:5:\"theme\";i:5;s:9:\"signature\";i:6;s:16:\"signature_format\";i:7;s:7:\"created\";i:8;s:6:\"access\";i:9;s:5:\"login\";i:10;s:6:\"status\";i:11;s:8:\"timezone\";i:12;s:8:\"language\";i:13;s:7:\"picture\";i:14;s:4:\"init\";i:15;s:4:\"data\";}}}}',0,1454110967,1),('filter_formats:en','a:3:{s:13:\"filtered_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:13:\"filtered_html\";s:4:\"name\";s:13:\"Filtered HTML\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"0\";}s:9:\"full_html\";O:8:\"stdClass\":5:{s:6:\"format\";s:9:\"full_html\";s:4:\"name\";s:9:\"Full HTML\";s:5:\"cache\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:1:\"1\";}s:10:\"plain_text\";O:8:\"stdClass\":5:{s:6:\"format\";s:10:\"plain_text\";s:4:\"name\";s:10:\"Plain text\";s:5:\"cache\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:6:\"weight\";s:2:\"10\";}}',0,1454111016,1),('filter_list_format','a:3:{s:9:\"full_html\";a:6:{s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:168:\"a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}\";}s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:40:\"a:1:{s:17:\"filter_url_length\";s:2:\"72\";}\";}s:13:\"forena_report\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"forena\";s:4:\"name\";s:13:\"forena_report\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:9:\"full_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}}s:10:\"plain_text\";a:5:{s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:168:\"a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}\";}s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:36:\"a:1:{s:17:\"filter_url_length\";i:72;}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"2\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:10:\"plain_text\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}}s:13:\"filtered_html\";a:5:{s:18:\"filter_html_escape\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:18:\"filter_html_escape\";s:6:\"weight\";s:3:\"-10\";s:6:\"status\";s:1:\"0\";s:8:\"settings\";s:6:\"a:0:{}\";}s:10:\"filter_url\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:10:\"filter_url\";s:6:\"weight\";s:1:\"0\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:36:\"a:1:{s:17:\"filter_url_length\";i:72;}\";}s:11:\"filter_html\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:11:\"filter_html\";s:6:\"weight\";s:1:\"1\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:168:\"a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}\";}s:12:\"filter_autop\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"filter_autop\";s:6:\"weight\";s:1:\"2\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}s:20:\"filter_htmlcorrector\";O:8:\"stdClass\":6:{s:6:\"format\";s:13:\"filtered_html\";s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:20:\"filter_htmlcorrector\";s:6:\"weight\";s:2:\"10\";s:6:\"status\";s:1:\"1\";s:8:\"settings\";s:6:\"a:0:{}\";}}}',0,1454111016,1),('node_types:en','O:8:\"stdClass\":2:{s:5:\"types\";a:2:{s:7:\"article\";O:8:\"stdClass\":14:{s:4:\"type\";s:7:\"article\";s:4:\"name\";s:7:\"Article\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:89:\"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:7:\"article\";s:16:\"disabled_changed\";b:0;}s:4:\"page\";O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:10:\"Basic page\";s:4:\"base\";s:12:\"node_content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:77:\"Use <em>basic pages</em> for your static content, such as an \'About us\' page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:8:\"disabled\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";s:16:\"disabled_changed\";b:0;}}s:5:\"names\";a:2:{s:7:\"article\";s:7:\"Article\";s:4:\"page\";s:10:\"Basic page\";}}',0,1443811944,1),('omega:layouts','a:9:{s:4:\"hero\";a:7:{s:4:\"name\";s:4:\"hero\";s:4:\"path\";s:39:\"sites/all/themes/omega/ohm/layouts/hero\";s:4:\"file\";s:55:\"sites/all/themes/omega/ohm/layouts/hero/hero.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:4:\"Hero\";s:11:\"description\";s:47:\"A 3 column layout with a prominent hero region.\";s:7:\"preview\";s:11:\"preview.png\";s:8:\"template\";s:11:\"hero-layout\";s:7:\"regions\";a:10:{s:8:\"branding\";s:8:\"Branding\";s:10:\"navigation\";s:14:\"Navigation bar\";s:6:\"header\";s:6:\"Header\";s:4:\"hero\";s:4:\"Hero\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:2:{i:0;s:32:\"css/layouts/hero/hero.layout.css\";i:1;s:41:\"css/layouts/hero/hero.layout.no-query.css\";}}}s:5:\"theme\";s:3:\"ohm\";s:8:\"attached\";a:1:{s:3:\"css\";a:2:{s:5:\"all:0\";a:4:{s:4:\"data\";s:59:\"sites/all/themes/omega/ohm/css/layouts/hero/hero.layout.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}s:5:\"all:1\";a:4:{s:4:\"data\";s:68:\"sites/all/themes/omega/ohm/css/layouts/hero/hero.layout.no-query.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:11:\"hero-layout\";}s:10:\"off-canvas\";a:7:{s:4:\"name\";s:10:\"off-canvas\";s:4:\"path\";s:47:\"sites/all/themes/omega/omega/layouts/off-canvas\";s:4:\"file\";s:69:\"sites/all/themes/omega/omega/layouts/off-canvas/off-canvas.layout.inc\";s:4:\"info\";a:7:{s:4:\"name\";s:10:\"Off Canvas\";s:11:\"description\";s:68:\"A layout demonstrating the off canvas responsive navigation pattern.\";s:7:\"preview\";s:11:\"preview.png\";s:8:\"template\";s:17:\"off-canvas-layout\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:44:\"css/layouts/off-canvas/off-canvas.layout.css\";}}s:7:\"scripts\";a:1:{i:0;s:39:\"layouts/off-canvas/assets/off-canvas.js\";}}s:5:\"theme\";s:5:\"omega\";s:8:\"attached\";a:2:{s:3:\"css\";a:1:{s:5:\"all:0\";a:4:{s:4:\"data\";s:73:\"sites/all/themes/omega/omega/css/layouts/off-canvas/off-canvas.layout.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}s:2:\"js\";a:1:{i:0;a:3:{s:4:\"data\";s:68:\"sites/all/themes/omega/omega/layouts/off-canvas/assets/off-canvas.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:17:\"off-canvas-layout\";}s:6:\"simple\";a:7:{s:4:\"name\";s:6:\"simple\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/layouts/simple\";s:4:\"file\";s:61:\"sites/all/themes/omega/omega/layouts/simple/simple.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"Simple\";s:11:\"description\";s:61:\"A simple 3 column layout demonstrating mobile first and Susy.\";s:7:\"preview\";s:11:\"preview.png\";s:8:\"template\";s:13:\"simple-layout\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:36:\"css/layouts/simple/simple.layout.css\";}}}s:5:\"theme\";s:5:\"omega\";s:8:\"attached\";a:1:{s:3:\"css\";a:1:{s:5:\"all:0\";a:4:{s:4:\"data\";s:65:\"sites/all/themes/omega/omega/css/layouts/simple/simple.layout.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:13:\"simple-layout\";}s:6:\"divine\";a:7:{s:4:\"name\";s:6:\"divine\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/layouts/divine\";s:4:\"file\";s:61:\"sites/all/themes/omega/omega/layouts/divine/divine.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:6:\"Divine\";s:11:\"description\";s:59:\"A layout utilising the golden ratio (or divine proportion).\";s:7:\"preview\";s:11:\"preview.png\";s:8:\"template\";s:13:\"divine-layout\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:2:{i:0;s:36:\"css/layouts/divine/divine.layout.css\";i:1;s:45:\"css/layouts/divine/divine.layout.no-query.css\";}}}s:5:\"theme\";s:5:\"omega\";s:8:\"attached\";a:1:{s:3:\"css\";a:2:{s:5:\"all:0\";a:4:{s:4:\"data\";s:65:\"sites/all/themes/omega/omega/css/layouts/divine/divine.layout.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}s:5:\"all:1\";a:4:{s:4:\"data\";s:74:\"sites/all/themes/omega/omega/css/layouts/divine/divine.layout.no-query.css\";s:5:\"media\";s:3:\"all\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:13:\"divine-layout\";}s:8:\"protocol\";a:7:{s:4:\"name\";s:8:\"protocol\";s:4:\"path\";s:46:\"sites/all/themes/raptor_omega/layouts/protocol\";s:4:\"file\";s:66:\"sites/all/themes/raptor_omega/layouts/protocol/protocol.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"RAPTOR Protocol\";s:11:\"description\";s:25:\"The RAPTOR protcol layout\";s:8:\"template\";s:15:\"protocol-layout\";s:7:\"preview\";s:11:\"preview.png\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:7:\"scripts\";a:7:{i:0;s:26:\"js/jquery-ui-1.10.3.min.js\";i:1;s:25:\"js/modernizr-2.5.3.min.js\";i:2;s:14:\"js/protocol.js\";i:3;s:25:\"js/jquery.scrollTo.min.js\";i:4;s:23:\"js/jquery.dataTables.js\";i:5;s:12:\"js/global.js\";i:6;s:19:\"js/jquery.sticky.js\";}}s:5:\"theme\";s:12:\"raptor_omega\";s:8:\"attached\";a:1:{s:2:\"js\";a:7:{i:0;a:3:{s:4:\"data\";s:56:\"sites/all/themes/raptor_omega/js/jquery-ui-1.10.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:1;a:3:{s:4:\"data\";s:55:\"sites/all/themes/raptor_omega/js/modernizr-2.5.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:2;a:3:{s:4:\"data\";s:44:\"sites/all/themes/raptor_omega/js/protocol.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:3;a:3:{s:4:\"data\";s:55:\"sites/all/themes/raptor_omega/js/jquery.scrollTo.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:4;a:3:{s:4:\"data\";s:53:\"sites/all/themes/raptor_omega/js/jquery.dataTables.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:5;a:3:{s:4:\"data\";s:42:\"sites/all/themes/raptor_omega/js/global.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:6;a:3:{s:4:\"data\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:15:\"protocol-layout\";}s:7:\"supinfo\";a:7:{s:4:\"name\";s:7:\"supinfo\";s:4:\"path\";s:45:\"sites/all/themes/raptor_omega/layouts/supinfo\";s:4:\"file\";s:64:\"sites/all/themes/raptor_omega/layouts/supinfo/supinfo.layout.inc\";s:4:\"info\";a:5:{s:4:\"name\";s:31:\"RAPTOR Supplemental Information\";s:11:\"description\";s:42:\"The RAPTOR supplemental information layout\";s:8:\"template\";s:14:\"supinfo-layout\";s:7:\"preview\";s:11:\"preview.png\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}}s:5:\"theme\";s:12:\"raptor_omega\";s:8:\"attached\";a:0:{}s:8:\"template\";s:14:\"supinfo-layout\";}s:8:\"worklist\";a:7:{s:4:\"name\";s:8:\"worklist\";s:4:\"path\";s:46:\"sites/all/themes/raptor_omega/layouts/worklist\";s:4:\"file\";s:66:\"sites/all/themes/raptor_omega/layouts/worklist/worklist.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:15:\"RAPTOR Worklist\";s:11:\"description\";s:26:\"The RAPTOR worklist layout\";s:8:\"template\";s:15:\"worklist-layout\";s:7:\"preview\";s:11:\"preview.png\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:7:\"scripts\";a:6:{i:0;s:26:\"js/jquery-ui-1.10.3.min.js\";i:1;s:25:\"js/modernizr-2.5.3.min.js\";i:2;s:23:\"js/jquery.dataTables.js\";i:3;s:14:\"js/worklist.js\";i:4;s:12:\"js/global.js\";i:5;s:19:\"js/jquery.sticky.js\";}}s:5:\"theme\";s:12:\"raptor_omega\";s:8:\"attached\";a:1:{s:2:\"js\";a:6:{i:0;a:3:{s:4:\"data\";s:56:\"sites/all/themes/raptor_omega/js/jquery-ui-1.10.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:1;a:3:{s:4:\"data\";s:55:\"sites/all/themes/raptor_omega/js/modernizr-2.5.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:2;a:3:{s:4:\"data\";s:53:\"sites/all/themes/raptor_omega/js/jquery.dataTables.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:3;a:3:{s:4:\"data\";s:44:\"sites/all/themes/raptor_omega/js/worklist.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:4;a:3:{s:4:\"data\";s:42:\"sites/all/themes/raptor_omega/js/global.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:5;a:3:{s:4:\"data\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:15:\"worklist-layout\";}s:5:\"login\";a:7:{s:4:\"name\";s:5:\"login\";s:4:\"path\";s:43:\"sites/all/themes/raptor_omega/layouts/login\";s:4:\"file\";s:60:\"sites/all/themes/raptor_omega/layouts/login/login.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:20:\"RAPTOR Administrator\";s:11:\"description\";s:28:\"The RAPTOR login page layout\";s:8:\"template\";s:12:\"login-layout\";s:7:\"preview\";s:11:\"preview.png\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:7:\"scripts\";a:4:{i:0;s:26:\"js/jquery-ui-1.10.3.min.js\";i:1;s:25:\"js/modernizr-2.5.3.min.js\";i:2;s:23:\"js/jquery.dataTables.js\";i:3;s:14:\"js/userform.js\";}}s:5:\"theme\";s:12:\"raptor_omega\";s:8:\"attached\";a:1:{s:2:\"js\";a:4:{i:0;a:3:{s:4:\"data\";s:56:\"sites/all/themes/raptor_omega/js/jquery-ui-1.10.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:1;a:3:{s:4:\"data\";s:55:\"sites/all/themes/raptor_omega/js/modernizr-2.5.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:2;a:3:{s:4:\"data\";s:53:\"sites/all/themes/raptor_omega/js/jquery.dataTables.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:3;a:3:{s:4:\"data\";s:44:\"sites/all/themes/raptor_omega/js/userform.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:12:\"login-layout\";}s:5:\"admin\";a:7:{s:4:\"name\";s:5:\"admin\";s:4:\"path\";s:43:\"sites/all/themes/raptor_omega/layouts/admin\";s:4:\"file\";s:60:\"sites/all/themes/raptor_omega/layouts/admin/admin.layout.inc\";s:4:\"info\";a:6:{s:4:\"name\";s:20:\"RAPTOR Administrator\";s:11:\"description\";s:36:\"The RAPTOR administrator page layout\";s:8:\"template\";s:12:\"admin-layout\";s:7:\"preview\";s:11:\"preview.png\";s:7:\"regions\";a:9:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:14:\"Navigation bar\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";}s:7:\"scripts\";a:6:{i:0;s:26:\"js/jquery-ui-1.10.3.min.js\";i:1;s:25:\"js/modernizr-2.5.3.min.js\";i:2;s:23:\"js/jquery.dataTables.js\";i:3;s:14:\"js/userform.js\";i:4;s:12:\"js/global.js\";i:5;s:19:\"js/jquery.sticky.js\";}}s:5:\"theme\";s:12:\"raptor_omega\";s:8:\"attached\";a:1:{s:2:\"js\";a:6:{i:0;a:3:{s:4:\"data\";s:56:\"sites/all/themes/raptor_omega/js/jquery-ui-1.10.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:1;a:3:{s:4:\"data\";s:55:\"sites/all/themes/raptor_omega/js/modernizr-2.5.3.min.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:2;a:3:{s:4:\"data\";s:53:\"sites/all/themes/raptor_omega/js/jquery.dataTables.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:3;a:3:{s:4:\"data\";s:44:\"sites/all/themes/raptor_omega/js/userform.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:4;a:3:{s:4:\"data\";s:42:\"sites/all/themes/raptor_omega/js/global.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}i:5;a:3:{s:4:\"data\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";s:5:\"group\";i:100;s:6:\"weight\";i:-10;}}}s:8:\"template\";s:12:\"admin-layout\";}}',0,1454111015,1),('omega:raptor_omega:extensions','a:4:{s:13:\"compatibility\";a:7:{s:4:\"name\";s:13:\"compatibility\";s:4:\"path\";s:51:\"sites/all/themes/omega/omega/includes/compatibility\";s:4:\"file\";s:79:\"sites/all/themes/omega/omega/includes/compatibility/compatibility.extension.inc\";s:4:\"info\";a:3:{s:4:\"name\";s:13:\"Compatibility\";s:11:\"description\";s:129:\"Manage cross browser and device compatibility enhancements such as apple touch icons, conditional classes and view port settings.\";s:7:\"enabled\";b:1;}s:5:\"theme\";s:5:\"omega\";s:7:\"enabled\";i:1;s:6:\"errors\";b:0;}s:11:\"development\";a:7:{s:4:\"name\";s:11:\"development\";s:4:\"path\";s:49:\"sites/all/themes/omega/omega/includes/development\";s:4:\"file\";s:75:\"sites/all/themes/omega/omega/includes/development/development.extension.inc\";s:4:\"info\";a:3:{s:4:\"name\";s:11:\"Development\";s:11:\"description\";s:119:\"Enable development tools such as Livereload, the browser width indicator and control caching to ease subtheme creation.\";s:7:\"enabled\";b:1;}s:5:\"theme\";s:5:\"omega\";s:7:\"enabled\";i:1;s:6:\"errors\";b:0;}s:6:\"assets\";a:7:{s:4:\"name\";s:6:\"assets\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/includes/assets\";s:4:\"file\";s:65:\"sites/all/themes/omega/omega/includes/assets/assets.extension.inc\";s:4:\"info\";a:3:{s:4:\"name\";s:6:\"Assets\";s:11:\"description\";s:99:\"Manage the inclusion of Javascript and CSS in your theme as well as enabling third-party polyfills.\";s:7:\"enabled\";b:1;}s:5:\"theme\";s:5:\"omega\";s:7:\"enabled\";i:1;s:6:\"errors\";b:0;}s:7:\"layouts\";a:7:{s:4:\"name\";s:7:\"layouts\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/includes/layouts\";s:4:\"file\";s:67:\"sites/all/themes/omega/omega/includes/layouts/layouts.extension.inc\";s:4:\"info\";a:3:{s:4:\"name\";s:7:\"Layouts\";s:11:\"description\";s:81:\"Choose a default layout from those provided by Omega and any installed subthemes.\";s:7:\"enabled\";b:0;}s:5:\"theme\";s:5:\"omega\";s:7:\"enabled\";i:1;s:6:\"errors\";b:0;}}',0,1454110967,1),('omega:raptor_omega:libraries','a:4:{s:11:\"selectivizr\";a:9:{s:4:\"name\";s:11:\"Selectivizr\";s:11:\"description\";s:193:\"Selectivizr is a JavaScript utility that emulates CSS3 pseudo-classes and attribute selectors in Internet Explorer 6-8. Simply include the script in your pages and selectivizr will do the rest.\";s:6:\"vendor\";s:11:\"Keith Clark\";s:10:\"vendor url\";s:23:\"http://selectivizr.com/\";s:7:\"package\";s:9:\"Polyfills\";s:5:\"files\";a:1:{s:2:\"js\";a:1:{s:18:\"selectivizr.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:110;s:10:\"every_page\";b:1;}}}s:8:\"variants\";a:1:{s:6:\"source\";a:3:{s:4:\"name\";s:6:\"Source\";s:11:\"description\";s:98:\"During development it might be useful to include the source files instead of the minified version.\";s:5:\"files\";a:1:{s:2:\"js\";a:1:{s:14:\"selectivizr.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:110;s:10:\"every_page\";b:1;}}}}}s:5:\"theme\";s:5:\"omega\";s:4:\"path\";N;}s:7:\"respond\";a:10:{s:4:\"name\";s:7:\"Respond\";s:11:\"description\";s:245:\"Respond is a fast & lightweight polyfill for min/max-width CSS3 Media Queries (for IE 6-8, and more). Note: This library requires <a href=\"/RSite500/admin/config/development/performance\">CSS aggregation</a> to be enabled for it to work properly.\";s:6:\"vendor\";s:10:\"Scott Jehl\";s:10:\"vendor url\";s:21:\"http://scottjehl.com/\";s:7:\"package\";s:9:\"Polyfills\";s:9:\"callbacks\";a:1:{i:0;s:51:\"omega_extension_assets_requirements_css_aggregation\";}s:5:\"files\";a:1:{s:2:\"js\";a:1:{s:14:\"respond.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:120;s:10:\"every_page\";b:1;}}}s:8:\"variants\";a:1:{s:6:\"source\";a:3:{s:4:\"name\";s:6:\"Source\";s:11:\"description\";s:98:\"During development it might be useful to include the source files instead of the minified version.\";s:5:\"files\";a:1:{s:2:\"js\";a:1:{s:10:\"respond.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:120;s:10:\"every_page\";b:1;}}}}}s:5:\"theme\";s:5:\"omega\";s:4:\"path\";N;}s:3:\"pie\";a:11:{s:4:\"name\";s:8:\"CSS3 PIE\";s:11:\"description\";s:105:\"PIE makes Internet Explorer 6-9 capable of rendering several of the most useful CSS3 decoration features.\";s:6:\"vendor\";s:11:\"Keith Clark\";s:10:\"vendor url\";s:19:\"http://css3pie.com/\";s:12:\"options form\";s:30:\"omega_library_pie_options_form\";s:7:\"package\";s:9:\"Polyfills\";s:9:\"callbacks\";a:1:{i:0;s:41:\"omega_extension_assets_load_pie_selectors\";}s:5:\"files\";a:0:{}s:8:\"variants\";a:1:{s:2:\"js\";a:3:{s:4:\"name\";s:10:\"JavaScript\";s:11:\"description\";s:149:\"While the .htc behavior is still the recommended approach for most users, the JS version has some advantages that may be a better fit for some users.\";s:5:\"files\";a:1:{s:2:\"js\";a:1:{s:6:\"PIE.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}}}}}s:5:\"theme\";s:5:\"omega\";s:4:\"path\";N;}s:9:\"html5shiv\";a:8:{s:4:\"name\";s:10:\"HTML5 Shiv\";s:11:\"description\";s:209:\"This script is the defacto way to enable use of HTML5 sectioning elements in legacy Internet Explorer, as well as default HTML5 styling in Internet Explorer 6 - 9, Safari 4.x (and iPhone 3.x), and Firefox 3.x.\";s:6:\"vendor\";s:16:\"Alexander Farkas\";s:7:\"package\";s:9:\"Polyfills\";s:5:\"files\";a:1:{s:2:\"js\";a:2:{s:16:\"html5shiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}s:26:\"html5shiv-printshiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}}}s:8:\"variants\";a:1:{s:6:\"source\";a:3:{s:4:\"name\";s:6:\"Source\";s:11:\"description\";s:98:\"During development it might be useful to include the source files instead of the minified version.\";s:5:\"files\";a:1:{s:2:\"js\";a:2:{s:12:\"html5shiv.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}s:22:\"html5shiv-printshiv.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}}}}}s:5:\"theme\";s:5:\"omega\";s:4:\"path\";N;}}',0,1454111015,1),('schema','a:171:{s:5:\"block\";a:6:{s:6:\"fields\";a:12:{s:3:\"bid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:5:\"theme\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"region\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"custom\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:10:\"visibility\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:5:\"pages\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:5:\"title\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:5:\"cache\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"bid\";}s:11:\"unique keys\";a:1:{s:3:\"tmd\";a:3:{i:0;s:5:\"theme\";i:1;s:6:\"module\";i:2;s:5:\"delta\";}}s:7:\"indexes\";a:1:{s:4:\"list\";a:5:{i:0;s:5:\"theme\";i:1;s:6:\"status\";i:2;s:6:\"region\";i:3;s:6:\"weight\";i:4;s:6:\"module\";}}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:5:\"block\";}s:10:\"block_role\";a:5:{s:6:\"fields\";a:3:{s:6:\"module\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"delta\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:3:\"rid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:6:\"module\";i:1;s:5:\"delta\";i:2;s:3:\"rid\";}s:7:\"indexes\";a:1:{s:3:\"rid\";a:1:{i:0;s:3:\"rid\";}}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:10:\"block_role\";}s:12:\"block_custom\";a:5:{s:6:\"fields\";a:4:{s:3:\"bid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"body\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:4:\"info\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"unique keys\";a:1:{s:4:\"info\";a:1:{i:0;s:4:\"info\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"bid\";}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:12:\"block_custom\";}s:11:\"cache_block\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:5:\"block\";s:4:\"name\";s:11:\"cache_block\";}s:7:\"comment\";a:6:{s:6:\"fields\";a:14:{s:3:\"cid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:3:\"pid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"nid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"subject\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"changed\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}s:6:\"thread\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:0;}s:4:\"mail\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:0;}s:8:\"homepage\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:7:\"indexes\";a:5:{s:18:\"comment_status_pid\";a:2:{i:0;s:3:\"pid\";i:1;s:6:\"status\";}s:15:\"comment_num_new\";a:5:{i:0;s:3:\"nid\";i:1;s:6:\"status\";i:2;s:7:\"created\";i:3;s:3:\"cid\";i:4;s:6:\"thread\";}s:11:\"comment_uid\";a:1:{i:0;s:3:\"uid\";}s:20:\"comment_nid_language\";a:2:{i:0;s:3:\"nid\";i:1;s:8:\"language\";}s:15:\"comment_created\";a:1:{i:0;s:7:\"created\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:12:\"foreign keys\";a:2:{s:12:\"comment_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:14:\"comment_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:7:\"comment\";s:4:\"name\";s:7:\"comment\";}s:23:\"node_comment_statistics\";a:6:{s:6:\"fields\";a:6:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"cid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:22:\"last_comment_timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"last_comment_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:0;}s:16:\"last_comment_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"comment_count\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"nid\";}s:7:\"indexes\";a:3:{s:22:\"node_comment_timestamp\";a:1:{i:0;s:22:\"last_comment_timestamp\";}s:13:\"comment_count\";a:1:{i:0;s:13:\"comment_count\";}s:16:\"last_comment_uid\";a:1:{i:0;s:16:\"last_comment_uid\";}}s:12:\"foreign keys\";a:2:{s:15:\"statistics_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:19:\"last_comment_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:16:\"last_comment_uid\";s:3:\"uid\";}}}s:6:\"module\";s:7:\"comment\";s:4:\"name\";s:23:\"node_comment_statistics\";}s:8:\"watchdog\";a:5:{s:6:\"fields\";a:11:{s:3:\"wid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"message\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:9:\"variables\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:8:\"severity\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:4:\"link\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:8:\"location\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:7:\"referer\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"wid\";}s:7:\"indexes\";a:3:{s:4:\"type\";a:1:{i:0;s:4:\"type\";}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:8:\"severity\";a:1:{i:0;s:8:\"severity\";}}s:6:\"module\";s:5:\"dblog\";s:4:\"name\";s:8:\"watchdog\";}s:12:\"field_config\";a:5:{s:6:\"fields\";a:13:{s:2:\"id\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:10:\"field_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"active\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:12:\"storage_type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:14:\"storage_module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:14:\"storage_active\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:1;s:9:\"serialize\";b:1;}s:11:\"cardinality\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:12:\"translatable\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:2:\"id\";}s:7:\"indexes\";a:8:{s:10:\"field_name\";a:1:{i:0;s:10:\"field_name\";}s:6:\"active\";a:1:{i:0;s:6:\"active\";}s:14:\"storage_active\";a:1:{i:0;s:14:\"storage_active\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:6:\"module\";a:1:{i:0;s:6:\"module\";}s:14:\"storage_module\";a:1:{i:0;s:14:\"storage_module\";}s:4:\"type\";a:1:{i:0;s:4:\"type\";}s:12:\"storage_type\";a:1:{i:0;s:12:\"storage_type\";}}s:6:\"module\";s:5:\"field\";s:4:\"name\";s:12:\"field_config\";}s:21:\"field_config_instance\";a:5:{s:6:\"fields\";a:7:{s:2:\"id\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:8:\"field_id\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;}s:10:\"field_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:1;s:9:\"serialize\";b:1;}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:2:\"id\";}s:7:\"indexes\";a:2:{s:17:\"field_name_bundle\";a:3:{i:0;s:10:\"field_name\";i:1;s:11:\"entity_type\";i:2;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}}s:6:\"module\";s:5:\"field\";s:4:\"name\";s:21:\"field_config_instance\";}s:11:\"cache_field\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:5:\"field\";s:4:\"name\";s:11:\"cache_field\";}s:23:\"field_data_comment_body\";a:6:{s:6:\"fields\";a:9:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:18:\"comment_body_value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:19:\"comment_body_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:5:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:7:\"deleted\";i:3;s:5:\"delta\";i:4;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:19:\"comment_body_format\";a:1:{i:0;s:19:\"comment_body_format\";}}s:12:\"foreign keys\";a:1:{s:19:\"comment_body_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:19:\"comment_body_format\";s:6:\"format\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:23:\"field_data_comment_body\";}s:27:\"field_revision_comment_body\";a:6:{s:6:\"fields\";a:9:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:18:\"comment_body_value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:19:\"comment_body_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:6:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:11:\"revision_id\";i:3;s:7:\"deleted\";i:4;s:5:\"delta\";i:5;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:19:\"comment_body_format\";a:1:{i:0;s:19:\"comment_body_format\";}}s:12:\"foreign keys\";a:1:{s:19:\"comment_body_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:19:\"comment_body_format\";s:6:\"format\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:27:\"field_revision_comment_body\";}s:15:\"field_data_body\";a:6:{s:6:\"fields\";a:10:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"body_value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:12:\"body_summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:11:\"body_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:5:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:7:\"deleted\";i:3;s:5:\"delta\";i:4;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:11:\"body_format\";a:1:{i:0;s:11:\"body_format\";}}s:12:\"foreign keys\";a:1:{s:11:\"body_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:11:\"body_format\";s:6:\"format\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:15:\"field_data_body\";}s:19:\"field_revision_body\";a:6:{s:6:\"fields\";a:10:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"body_value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:12:\"body_summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:11:\"body_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:6:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:11:\"revision_id\";i:3;s:7:\"deleted\";i:4;s:5:\"delta\";i:5;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:11:\"body_format\";a:1:{i:0;s:11:\"body_format\";}}s:12:\"foreign keys\";a:1:{s:11:\"body_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:11:\"body_format\";s:6:\"format\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:19:\"field_revision_body\";}s:21:\"field_data_field_tags\";a:6:{s:6:\"fields\";a:8:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:14:\"field_tags_tid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:5:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:7:\"deleted\";i:3;s:5:\"delta\";i:4;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:14:\"field_tags_tid\";a:1:{i:0;s:14:\"field_tags_tid\";}}s:12:\"foreign keys\";a:1:{s:14:\"field_tags_tid\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:14:\"field_tags_tid\";s:3:\"tid\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:21:\"field_data_field_tags\";}s:25:\"field_revision_field_tags\";a:6:{s:6:\"fields\";a:8:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:14:\"field_tags_tid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:6:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:11:\"revision_id\";i:3;s:7:\"deleted\";i:4;s:5:\"delta\";i:5;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:14:\"field_tags_tid\";a:1:{i:0;s:14:\"field_tags_tid\";}}s:12:\"foreign keys\";a:1:{s:14:\"field_tags_tid\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:14:\"field_tags_tid\";s:3:\"tid\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:25:\"field_revision_field_tags\";}s:22:\"field_data_field_image\";a:6:{s:6:\"fields\";a:12:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:15:\"field_image_fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:15:\"field_image_alt\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:17:\"field_image_title\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:17:\"field_image_width\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:18:\"field_image_height\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:11:\"primary key\";a:5:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:7:\"deleted\";i:3;s:5:\"delta\";i:4;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:15:\"field_image_fid\";a:1:{i:0;s:15:\"field_image_fid\";}}s:12:\"foreign keys\";a:1:{s:15:\"field_image_fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:15:\"field_image_fid\";s:3:\"fid\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:22:\"field_data_field_image\";}s:26:\"field_revision_field_image\";a:6:{s:6:\"fields\";a:12:{s:11:\"entity_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"bundle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"deleted\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"entity_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"revision_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"delta\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:15:\"field_image_fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:8:\"unsigned\";b:1;}s:15:\"field_image_alt\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:17:\"field_image_title\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:17:\"field_image_width\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}s:18:\"field_image_height\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;}}s:11:\"primary key\";a:6:{i:0;s:11:\"entity_type\";i:1;s:9:\"entity_id\";i:2;s:11:\"revision_id\";i:3;s:7:\"deleted\";i:4;s:5:\"delta\";i:5;s:8:\"language\";}s:7:\"indexes\";a:7:{s:11:\"entity_type\";a:1:{i:0;s:11:\"entity_type\";}s:6:\"bundle\";a:1:{i:0;s:6:\"bundle\";}s:7:\"deleted\";a:1:{i:0;s:7:\"deleted\";}s:9:\"entity_id\";a:1:{i:0;s:9:\"entity_id\";}s:11:\"revision_id\";a:1:{i:0;s:11:\"revision_id\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}s:15:\"field_image_fid\";a:1:{i:0;s:15:\"field_image_fid\";}}s:12:\"foreign keys\";a:1:{s:15:\"field_image_fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:15:\"field_image_fid\";s:3:\"fid\";}}}s:6:\"module\";s:17:\"field_sql_storage\";s:4:\"name\";s:26:\"field_revision_field_image\";}s:6:\"filter\";a:5:{s:6:\"fields\";a:6:{s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"settings\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:6:\"format\";i:1;s:4:\"name\";}s:7:\"indexes\";a:1:{s:4:\"list\";a:3:{i:0;s:6:\"weight\";i:1;s:6:\"module\";i:2;s:4:\"name\";}}s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:6:\"filter\";}s:13:\"filter_format\";a:6:{s:6:\"fields\";a:5:{s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:5:\"cache\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"status\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:6:\"format\";}s:11:\"unique keys\";a:1:{s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:7:\"indexes\";a:1:{s:13:\"status_weight\";a:2:{i:0;s:6:\"status\";i:1;s:6:\"weight\";}}s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:13:\"filter_format\";}s:12:\"cache_filter\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"filter\";s:4:\"name\";s:12:\"cache_filter\";}s:11:\"cache_image\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:5:\"image\";s:4:\"name\";s:11:\"cache_image\";}s:12:\"image_styles\";a:5:{s:6:\"fields\";a:3:{s:4:\"isid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:5:\"label\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:4:\"isid\";}s:11:\"unique keys\";a:1:{s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:6:\"module\";s:5:\"image\";s:4:\"name\";s:12:\"image_styles\";}s:13:\"image_effects\";a:6:{s:6:\"fields\";a:5:{s:4:\"ieid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"isid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"weight\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:0;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"ieid\";}s:7:\"indexes\";a:2:{s:4:\"isid\";a:1:{i:0;s:4:\"isid\";}s:6:\"weight\";a:1:{i:0;s:6:\"weight\";}}s:12:\"foreign keys\";a:1:{s:11:\"image_style\";a:2:{s:5:\"table\";s:12:\"image_styles\";s:7:\"columns\";a:1:{s:4:\"isid\";s:4:\"isid\";}}}s:6:\"module\";s:5:\"image\";s:4:\"name\";s:13:\"image_effects\";}s:11:\"menu_custom\";a:4:{s:6:\"fields\";a:3:{s:9:\"menu_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"title\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:11:\"description\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:12:\"translatable\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:9:\"menu_name\";}s:6:\"module\";s:4:\"menu\";s:4:\"name\";s:11:\"menu_custom\";}s:4:\"node\";a:7:{s:6:\"fields\";a:14:{s:3:\"nid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"vid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;s:7:\"default\";N;}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"changed\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"comment\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"promote\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"sticky\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"tnid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"translate\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:10:{s:12:\"node_changed\";a:1:{i:0;s:7:\"changed\";}s:12:\"node_created\";a:1:{i:0;s:7:\"created\";}s:14:\"node_frontpage\";a:4:{i:0;s:7:\"promote\";i:1;s:6:\"status\";i:2;s:6:\"sticky\";i:3;s:7:\"created\";}s:16:\"node_status_type\";a:3:{i:0;s:6:\"status\";i:1;s:4:\"type\";i:2;s:3:\"nid\";}s:15:\"node_title_type\";a:2:{i:0;s:5:\"title\";i:1;a:2:{i:0;s:4:\"type\";i:1;i:4;}}s:9:\"node_type\";a:1:{i:0;a:2:{i:0;s:4:\"type\";i:1;i:4;}}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:4:\"tnid\";a:1:{i:0;s:4:\"tnid\";}s:9:\"translate\";a:1:{i:0;s:9:\"translate\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}}s:11:\"unique keys\";a:1:{s:3:\"vid\";a:1:{i:0;s:3:\"vid\";}}s:12:\"foreign keys\";a:2:{s:13:\"node_revision\";a:2:{s:5:\"table\";s:13:\"node_revision\";s:7:\"columns\";a:1:{s:3:\"vid\";s:3:\"vid\";}}s:11:\"node_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:11:\"primary key\";a:1:{i:0;s:3:\"nid\";}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:4:\"node\";}s:11:\"node_access\";a:5:{s:6:\"fields\";a:6:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"gid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"realm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"grant_view\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:12:\"grant_update\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:12:\"grant_delete\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}}s:11:\"primary key\";a:3:{i:0;s:3:\"nid\";i:1;s:3:\"gid\";i:2;s:5:\"realm\";}s:12:\"foreign keys\";a:1:{s:13:\"affected_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:11:\"node_access\";}s:13:\"node_revision\";a:6:{s:6:\"fields\";a:10:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"vid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"log\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"comment\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"promote\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"sticky\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:2:{s:3:\"nid\";a:1:{i:0;s:3:\"nid\";}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"vid\";}s:12:\"foreign keys\";a:2:{s:14:\"versioned_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:14:\"version_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:13:\"node_revision\";}s:9:\"node_type\";a:4:{s:6:\"fields\";a:13:{s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:4:\"base\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"module\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:6:\"medium\";s:12:\"translatable\";b:1;}s:4:\"help\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:6:\"medium\";s:12:\"translatable\";b:1;}s:9:\"has_title\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:4:\"size\";s:4:\"tiny\";}s:11:\"title_label\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:6:\"custom\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:8:\"modified\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:8:\"disabled\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:9:\"orig_type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:4:\"type\";}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:9:\"node_type\";}s:15:\"block_node_type\";a:5:{s:6:\"fields\";a:3:{s:6:\"module\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"delta\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:6:\"module\";i:1;s:5:\"delta\";i:2;s:4:\"type\";}s:7:\"indexes\";a:1:{s:4:\"type\";a:1:{i:0;s:4:\"type\";}}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:15:\"block_node_type\";}s:7:\"history\";a:5:{s:6:\"fields\";a:3:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"nid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:2:{i:0;s:3:\"uid\";i:1;s:3:\"nid\";}s:7:\"indexes\";a:1:{s:3:\"nid\";a:1:{i:0;s:3:\"nid\";}}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:7:\"history\";}s:28:\"raptor_contraindication_rule\";a:4:{s:6:\"fields\";a:12:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"rule_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"summary_msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:80;s:8:\"not null\";b:1;}s:6:\"msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:11:\"explanation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;}s:10:\"req_ack_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"trigger_crit\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:1;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:7:\"rule_nm\";}s:6:\"module\";s:24:\"raptor_contraindications\";s:4:\"name\";s:28:\"raptor_contraindication_rule\";}s:37:\"raptor_contraindication_rule_replaced\";a:5:{s:6:\"fields\";a:12:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"rule_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"summary_msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:80;s:8:\"not null\";b:1;}s:6:\"msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:11:\"explanation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;}s:10:\"req_ack_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"trigger_crit\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:1;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:7:\"rule_nm\";}s:11:\"replaced_dt\";a:4:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;s:11:\"description\";s:29:\"When this record was replaced\";}s:6:\"module\";s:24:\"raptor_contraindications\";s:4:\"name\";s:37:\"raptor_contraindication_rule_replaced\";}s:31:\"raptor_contraindication_measure\";a:4:{s:6:\"fields\";a:10:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"return_type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"purpose_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;}s:11:\"criteria_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:0;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:6:\"module\";s:24:\"raptor_contraindications\";s:4:\"name\";s:31:\"raptor_contraindication_measure\";}s:40:\"raptor_contraindication_measure_replaced\";a:5:{s:6:\"fields\";a:10:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"return_type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"purpose_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;}s:11:\"criteria_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:0;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:11:\"replaced_dt\";a:4:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;s:11:\"description\";s:29:\"When this record was replaced\";}s:6:\"module\";s:24:\"raptor_contraindications\";s:4:\"name\";s:40:\"raptor_contraindication_measure_replaced\";}s:19:\"raptor_user_profile\";a:4:{s:6:\"fields\";a:40:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"username\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"role_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:11:\"RADIOLOGIST\";}s:13:\"worklist_cols\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:0;}s:13:\"usernametitle\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:9:\"firstname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:8:\"lastname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:6:\"suffix\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:9:\"prefemail\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:9:\"prefphone\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:16:\"accountactive_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"CEUA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"LACE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"SWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"PWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"APWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"SUWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"CE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"QA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"SP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"VREP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"VREP2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"EBO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"UNP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"REP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"DRA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELCO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELHO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELRO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELSO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"ELSVO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EECC1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ECIR1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EERL1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EARM1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"CUT1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"QA2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:7:\"default\";i:0;}s:3:\"QA3\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:7:\"default\";i:0;}s:13:\"special_privs\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:3:\"uid\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_user_profile\";}s:19:\"raptor_user_anatomy\";a:4:{s:6:\"fields\";a:5:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"weightgroup\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"keyword\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:13:\"specialist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:4:{i:0;s:3:\"uid\";i:1;s:11:\"weightgroup\";i:2;s:7:\"keyword\";i:3;s:13:\"specialist_yn\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_user_anatomy\";}s:20:\"raptor_user_modality\";a:4:{s:6:\"fields\";a:4:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:13:\"specialist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:3:\"uid\";i:1;s:13:\"modality_abbr\";i:2;s:13:\"specialist_yn\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:20:\"raptor_user_modality\";}s:19:\"raptor_user_service\";a:4:{s:6:\"fields\";a:4:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:13:\"specialist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:3:\"uid\";i:1;s:10:\"service_nm\";i:2;s:13:\"specialist_yn\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_user_service\";}s:28:\"raptor_user_group_membership\";a:4:{s:6:\"fields\";a:3:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"group_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:3:\"uid\";i:1;s:8:\"group_nm\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_user_group_membership\";}s:28:\"raptor_user_anatomy_override\";a:4:{s:6:\"fields\";a:4:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"weightgroup\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"keyword\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:3:\"uid\";i:1;s:11:\"weightgroup\";i:2;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_user_anatomy_override\";}s:29:\"raptor_user_modality_override\";a:4:{s:6:\"fields\";a:3:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:3:\"uid\";i:1;s:13:\"modality_abbr\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_user_modality_override\";}s:28:\"raptor_user_service_override\";a:4:{s:6:\"fields\";a:3:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:3:\"uid\";i:1;s:10:\"service_nm\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_user_service_override\";}s:29:\"raptor_user_activity_tracking\";a:4:{s:6:\"fields\";a:5:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"action_cd\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"ipaddress\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:0;}s:9:\"sessionid\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:200;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:7:\"indexes\";a:1:{s:4:\"main\";a:2:{i:0;s:10:\"updated_dt\";i:1;s:3:\"uid\";}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_user_activity_tracking\";}s:36:\"raptor_user_recent_activity_tracking\";a:4:{s:6:\"fields\";a:9:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"ipaddress\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:0;}s:9:\"sessionid\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:200;s:8:\"not null\";b:0;}s:20:\"most_recent_login_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:21:\"most_recent_logout_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:21:\"most_recent_action_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:21:\"most_recent_action_cd\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:20:\"most_recent_error_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:20:\"most_recent_error_cd\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"uid\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:36:\"raptor_user_recent_activity_tracking\";}s:12:\"raptor_group\";a:4:{s:6:\"fields\";a:3:{s:7:\"name_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"desc_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"name_tx\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:12:\"raptor_group\";}s:28:\"raptor_group_anatomy_keyword\";a:4:{s:6:\"fields\";a:4:{s:7:\"name_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"weightgroup\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"keyword\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:7:\"name_tx\";i:1;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_group_anatomy_keyword\";}s:21:\"raptor_group_modality\";a:4:{s:6:\"fields\";a:3:{s:8:\"group_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:8:\"group_nm\";i:1;s:13:\"modality_abbr\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:21:\"raptor_group_modality\";}s:20:\"raptor_group_service\";a:4:{s:6:\"fields\";a:3:{s:8:\"group_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:8:\"group_nm\";i:1;s:10:\"service_nm\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:20:\"raptor_group_service\";}s:21:\"raptor_list_hydration\";a:3:{s:6:\"fields\";a:7:{s:7:\"type_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:1;}s:9:\"option_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:5:\"ct_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"mr_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"nm_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"fl_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"us_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:21:\"raptor_list_hydration\";}s:20:\"raptor_list_sedation\";a:3:{s:6:\"fields\";a:7:{s:7:\"type_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:1;}s:9:\"option_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:5:\"ct_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"mr_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"nm_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"fl_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"us_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:20:\"raptor_list_sedation\";}s:24:\"raptor_list_radioisotope\";a:3:{s:6:\"fields\";a:7:{s:7:\"type_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:1;}s:9:\"option_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:5:\"ct_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"mr_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"nm_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"fl_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"us_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_list_radioisotope\";}s:20:\"raptor_list_contrast\";a:3:{s:6:\"fields\";a:7:{s:7:\"type_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:1;}s:9:\"option_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:5:\"ct_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"mr_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"nm_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"fl_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:5:\"us_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:20:\"raptor_list_contrast\";}s:20:\"raptor_list_modality\";a:4:{s:6:\"fields\";a:5:{s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:13:\"modality_desc\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:8:\"prefixes\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:8:\"keywords\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:35:\"TIMESTAMP DEFAULT CURRENT_TIMESTAMP\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:13:\"modality_abbr\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:20:\"raptor_list_modality\";}s:19:\"raptor_list_service\";a:4:{s:6:\"fields\";a:3:{s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:12:\"service_desc\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:35:\"TIMESTAMP DEFAULT CURRENT_TIMESTAMP\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"service_nm\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_list_service\";}s:33:\"raptor_list_radiation_dose_target\";a:3:{s:6:\"fields\";a:4:{s:2:\"id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:7:\"area_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:9:\"area_desc\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:35:\"TIMESTAMP DEFAULT CURRENT_TIMESTAMP\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:33:\"raptor_list_radiation_dose_target\";}s:11:\"raptor_role\";a:4:{s:6:\"fields\";a:58:{s:6:\"roleid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"enabled_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"CEUA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockCEUA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"LACE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockLACE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"SWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockSWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"PWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockPWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"APWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockAPWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"SUWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockSUWI1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"CE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"lockCE1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"QA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"lockQA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"SP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"lockSP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"VREP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockVREP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"VREP2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockVREP2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"EBO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockEBO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"UNP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockUNP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"REP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockREP1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"DRA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockDRA1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELCO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockELCO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELHO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockELHO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELSO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockELSO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ELRO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockELRO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"ELSVO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"lockELSVO1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EECC1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockEECC1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"ECIR1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockECIR1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EERL1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockEERL1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"EARM1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"lockEARM1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"CUT1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"lockCUT1\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"QA2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"lockQA2\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"QA3\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:7:\"default\";i:0;}s:7:\"lockQA3\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:35:\"TIMESTAMP DEFAULT CURRENT_TIMESTAMP\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"name\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:11:\"raptor_role\";}s:22:\"raptor_ticket_tracking\";a:4:{s:6:\"fields\";a:11:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"workflow_state\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:2:\"AC\";}s:12:\"suspended_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:11:\"approved_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:15:\"acknowledged_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:17:\"exam_completed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:22:\"interpret_completed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:15:\"qa_completed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:25:\"exam_details_committed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:22:\"raptor_ticket_tracking\";}s:29:\"raptor_ticket_commit_tracking\";a:4:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"workflow_state\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"commit_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";i:2;s:9:\"commit_dt\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_ticket_commit_tracking\";}s:32:\"raptor_ticket_id_change_tracking\";a:4:{s:6:\"fields\";a:7:{s:15:\"original_siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:12:\"original_IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"new_siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"new_IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:24:\"workflow_state_at_change\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:15:\"original_siteid\";i:1;s:12:\"original_IEN\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:32:\"raptor_ticket_id_change_tracking\";}s:27:\"raptor_ticket_lock_tracking\";a:4:{s:6:\"fields\";a:6:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:13:\"locked_by_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:14:\"locked_type_cd\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"E\";}s:15:\"lock_started_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:17:\"lock_refreshed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:2:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_ticket_lock_tracking\";}s:27:\"raptor_ticket_collaboration\";a:4:{s:6:\"fields\";a:9:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:13:\"requester_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:12:\"requested_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:18:\"requester_notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:16:\"collaborator_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"viewed_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"workflow_state\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}}s:7:\"indexes\";a:1:{s:8:\"main_idx\";a:4:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";i:2;s:16:\"collaborator_uid\";i:3;s:9:\"active_yn\";}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_ticket_collaboration\";}s:30:\"raptor_ticket_workflow_history\";a:3:{s:6:\"fields\";a:7:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"initiating_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:18:\"old_workflow_state\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:18:\"new_workflow_state\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:15:\"collaborate_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:30:\"raptor_ticket_workflow_history\";}s:31:\"raptor_ticket_protocol_settings\";a:4:{s:6:\"fields\";a:22:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:26:\"primary_protocol_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:28:\"secondary_protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:25:\"current_workflow_state_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:10:\"allergy_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:17:\"claustrophobic_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:14:\"consent_req_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:31:\"raptor_ticket_protocol_settings\";}s:40:\"raptor_ticket_protocol_settings_replaced\";a:3:{s:6:\"fields\";a:23:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:26:\"primary_protocol_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:28:\"secondary_protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:25:\"current_workflow_state_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:10:\"allergy_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:17:\"claustrophobic_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:14:\"consent_req_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"original_created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:40:\"raptor_ticket_protocol_settings_replaced\";}s:28:\"raptor_ticket_protocol_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_ticket_protocol_notes\";}s:27:\"raptor_ticket_exam_settings\";a:3:{s:6:\"fields\";a:18:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:25:\"current_workflow_state_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:19:\"consent_received_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_ticket_exam_settings\";}s:33:\"raptor_ticket_exam_settings_sofar\";a:3:{s:6:\"fields\";a:18:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:25:\"current_workflow_state_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:19:\"consent_received_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:33:\"raptor_ticket_exam_settings_sofar\";}s:36:\"raptor_ticket_exam_settings_replaced\";a:3:{s:6:\"fields\";a:19:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:25:\"current_workflow_state_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:19:\"consent_received_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"original_created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:36:\"raptor_ticket_exam_settings_replaced\";}s:33:\"raptor_ticket_exam_radiation_dose\";a:4:{s:6:\"fields\";a:13:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"patientid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:17:\"sequence_position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:4:\"dose\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:19:\"dose_target_area_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:7:\"dose_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:13:\"data_provider\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:4:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";i:2;s:14:\"dose_source_cd\";i:3;s:17:\"sequence_position\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:33:\"raptor_ticket_exam_radiation_dose\";}s:39:\"raptor_ticket_exam_radiation_dose_sofar\";a:3:{s:6:\"fields\";a:13:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"patientid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:17:\"sequence_position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:4:\"dose\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:19:\"dose_target_area_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:7:\"dose_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:13:\"data_provider\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:39:\"raptor_ticket_exam_radiation_dose_sofar\";}s:42:\"raptor_ticket_exam_radiation_dose_replaced\";a:3:{s:6:\"fields\";a:14:{s:6:\"siteid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"IEN\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"patientid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:17:\"sequence_position\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"dose\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:19:\"dose_target_area_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:7:\"dose_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:13:\"data_provider\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;}s:10:\"author_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:19:\"original_created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:42:\"raptor_ticket_exam_radiation_dose_replaced\";}s:24:\"raptor_ticket_exam_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_ticket_exam_notes\";}s:30:\"raptor_ticket_exam_notes_sofar\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:30:\"raptor_ticket_exam_notes_sofar\";}s:29:\"raptor_ticket_interpret_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_ticket_interpret_notes\";}s:18:\"raptor_qa_criteria\";a:4:{s:6:\"fields\";a:7:{s:10:\"context_cd\";a:4:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"T\";}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"question\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:256;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"explanation\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:10:\"context_cd\";i:1;s:9:\"shortname\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:18:\"raptor_qa_criteria\";}s:27:\"raptor_qa_criteria_replaced\";a:3:{s:6:\"fields\";a:8:{s:10:\"context_cd\";a:4:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"T\";}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"question\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:256;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"explanation\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:14:\"replacement_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_qa_criteria_replaced\";}s:27:\"raptor_ticket_qa_evaluation\";a:4:{s:6:\"fields\";a:9:{s:6:\"siteid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"IEN\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:14:\"workflow_state\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:18:\"criteria_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:16:\"criteria_version\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:14:\"criteria_score\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:7:\"comment\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:13:\"evaluation_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:5:{i:0;s:6:\"siteid\";i:1;s:3:\"IEN\";i:2;s:10:\"author_uid\";i:3;s:18:\"criteria_shortname\";i:4;s:13:\"evaluation_dt\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_ticket_qa_evaluation\";}s:22:\"raptor_ticket_qa_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:22:\"raptor_ticket_qa_notes\";}s:27:\"raptor_ticket_suspend_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_ticket_suspend_notes\";}s:29:\"raptor_ticket_unsuspend_notes\";a:3:{s:6:\"fields\";a:5:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_ticket_unsuspend_notes\";}s:23:\"raptor_ticket_checklist\";a:3:{s:6:\"fields\";a:9:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:18:\"question_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:11:\"question_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:9:\"answer_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:0;}s:17:\"comment_prompt_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;}s:10:\"comment_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:23:\"raptor_ticket_checklist\";}s:32:\"raptor_ticket_checklist_replaced\";a:3:{s:6:\"fields\";a:10:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:18:\"question_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:11:\"question_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:9:\"answer_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:0;}s:17:\"comment_prompt_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;}s:10:\"comment_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:32:\"raptor_ticket_checklist_replaced\";}s:30:\"raptor_ticket_contraindication\";a:3:{s:6:\"fields\";a:6:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"rule_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:15:\"acknowledged_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:30:\"raptor_ticket_contraindication\";}s:29:\"raptor_patient_radiation_dose\";a:4:{s:6:\"fields\";a:11:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"patientid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"dose\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:19:\"dose_target_area_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:7:\"dose_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:13:\"data_provider\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:4:{i:0;s:9:\"patientid\";i:1;s:14:\"dose_source_cd\";i:2;s:7:\"dose_dt\";i:3;s:19:\"dose_target_area_id\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:29:\"raptor_patient_radiation_dose\";}s:38:\"raptor_patient_radiation_dose_replaced\";a:3:{s:6:\"fields\";a:12:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"patientid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"dose\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:19:\"dose_target_area_id\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:7:\"dose_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:13:\"data_provider\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"original_created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:38:\"raptor_patient_radiation_dose_replaced\";}s:19:\"raptor_protocol_lib\";a:4:{s:6:\"fields\";a:18:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:13:\"modality_abbr\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"service_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:17:\"lowerbound_weight\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"upperbound_weight\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"image_guided_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"contrast_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"radioisotope_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"sedation_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"multievent_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:17:\"original_filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:23:\"original_file_upload_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:27:\"original_file_upload_by_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:18:\"protocol_shortname\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_protocol_lib\";}s:24:\"raptor_protocol_template\";a:4:{s:6:\"fields\";a:18:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"consent_req_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:16:\"protocolnotes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:12:\"examnotes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:18:\"protocol_shortname\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_protocol_template\";}s:24:\"raptor_protocol_keywords\";a:4:{s:6:\"fields\";a:4:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"weightgroup\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"keyword\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:18:\"protocol_shortname\";i:1;s:11:\"weightgroup\";i:2;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_protocol_keywords\";}s:28:\"raptor_protocol_lib_replaced\";a:3:{s:6:\"fields\";a:19:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:13:\"modality_abbr\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"service_nm\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:17:\"lowerbound_weight\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"upperbound_weight\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"image_guided_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"contrast_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"radioisotope_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"sedation_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:13:\"multievent_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:17:\"original_filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:23:\"original_file_upload_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:27:\"original_file_upload_by_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:28:\"raptor_protocol_lib_replaced\";}s:33:\"raptor_protocol_template_replaced\";a:3:{s:6:\"fields\";a:19:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"hydration_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:15:\"hydration_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"sedation_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:16:\"sedation_oral_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"sedation_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:16:\"contrast_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"contrast_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"contrast_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:20:\"radioisotope_none_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:23:\"radioisotope_enteric_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:18:\"radioisotope_iv_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:14:\"consent_req_kw\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:16:\"protocolnotes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:12:\"examnotes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:33:\"raptor_protocol_template_replaced\";}s:33:\"raptor_protocol_keywords_replaced\";a:3:{s:6:\"fields\";a:5:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"weightgroup\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"keyword\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:33:\"raptor_protocol_keywords_replaced\";}s:12:\"raptor_about\";a:3:{s:6:\"fields\";a:5:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"info_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:0;}s:8:\"major_ct\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;s:7:\"default\";i:1;}s:8:\"minor_ct\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;s:7:\"default\";i:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:12:\"raptor_about\";}s:17:\"raptor_cprs_codes\";a:3:{s:6:\"fields\";a:6:{s:7:\"cprs_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:6;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:17:\"raptor_cprs_codes\";}s:19:\"raptor_radlex_codes\";a:3:{s:6:\"fields\";a:6:{s:9:\"radlex_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_radlex_codes\";}s:16:\"raptor_cpt_codes\";a:3:{s:6:\"fields\";a:6:{s:6:\"cpt_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:5;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:16:\"raptor_cpt_codes\";}s:16:\"raptor_icd_codes\";a:3:{s:6:\"fields\";a:6:{s:6:\"icd_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:16:\"raptor_icd_codes\";}s:19:\"raptor_snomed_codes\";a:3:{s:6:\"fields\";a:6:{s:9:\"snomed_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:19:\"raptor_snomed_codes\";}s:18:\"raptor_loinc_codes\";a:3:{s:6:\"fields\";a:6:{s:8:\"loinc_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:1;}s:24:\"exclude_from_worklist_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"contrast_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:13:\"modality_abbr\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:0;}s:10:\"service_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:18:\"raptor_loinc_codes\";}s:25:\"raptor_protocol_code_maps\";a:3:{s:6:\"fields\";a:8:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"cprs_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:6;s:8:\"not null\";b:0;}s:9:\"radlex_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:0;}s:6:\"cpt_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:5;s:8:\"not null\";b:0;}s:9:\"snomed_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:0;}s:6:\"icd_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:8:\"loinc_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:10;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:25:\"raptor_protocol_code_maps\";}s:18:\"raptor_atrisk_meds\";a:4:{s:6:\"fields\";a:1:{s:7:\"keyword\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:18:\"raptor_atrisk_meds\";}s:30:\"raptor_atrisk_allergy_contrast\";a:4:{s:6:\"fields\";a:1:{s:7:\"keyword\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:30:\"raptor_atrisk_allergy_contrast\";}s:26:\"raptor_atrisk_bloodthinner\";a:4:{s:6:\"fields\";a:1:{s:7:\"keyword\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:26:\"raptor_atrisk_bloodthinner\";}s:27:\"raptor_atrisk_rare_contrast\";a:4:{s:6:\"fields\";a:1:{s:7:\"keyword\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_atrisk_rare_contrast\";}s:31:\"raptor_atrisk_rare_radioisotope\";a:4:{s:6:\"fields\";a:1:{s:7:\"keyword\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"keyword\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:31:\"raptor_atrisk_rare_radioisotope\";}s:25:\"raptor_checklist_question\";a:4:{s:6:\"fields\";a:23:{s:7:\"type_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"relative_position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:500;}s:13:\"modality_abbr\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:18:\"question_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"question_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:10:\"ask_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:9:\"ask_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"ask_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:20:\"ask_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:25:\"always_require_comment_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:25:\"trigger_comment_on_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:24:\"trigger_comment_on_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:29:\"trigger_comment_on_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:35:\"trigger_comment_on_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:17:\"comment_prompt_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:11:\"Explanation\";}s:16:\"failed_on_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"failed_on_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:20:\"failed_on_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:26:\"failed_on_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:18:\"the_okay_answer_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:0;s:7:\"default\";s:3:\"yes\";}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:18:\"question_shortname\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:25:\"raptor_checklist_question\";}s:34:\"raptor_checklist_question_replaced\";a:3:{s:6:\"fields\";a:24:{s:7:\"type_cd\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:17:\"relative_position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:500;}s:13:\"modality_abbr\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:18:\"question_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"question_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:10:\"ask_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:9:\"ask_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"ask_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:20:\"ask_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:25:\"always_require_comment_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:25:\"trigger_comment_on_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:24:\"trigger_comment_on_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:29:\"trigger_comment_on_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:35:\"trigger_comment_on_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:17:\"comment_prompt_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;s:7:\"default\";s:11:\"Explanation\";}s:16:\"failed_on_yes_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:15:\"failed_on_no_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:20:\"failed_on_notsure_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:26:\"failed_on_notapplicable_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:18:\"the_okay_answer_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:0;s:7:\"default\";s:3:\"yes\";}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:34:\"raptor_checklist_question_replaced\";}s:24:\"raptor_schedule_location\";a:4:{s:6:\"fields\";a:2:{s:11:\"location_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:14:\"description_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:11:\"location_tx\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_schedule_location\";}s:27:\"raptor_boilerplate_protocol\";a:4:{s:6:\"fields\";a:3:{s:11:\"category_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"title_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"content_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:250;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:2:{i:0;s:11:\"category_tx\";i:1;s:8:\"title_tx\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:27:\"raptor_boilerplate_protocol\";}s:23:\"raptor_boilerplate_exam\";a:4:{s:6:\"fields\";a:3:{s:11:\"category_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"title_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"content_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:250;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:2:{i:0;s:11:\"category_tx\";i:1;s:8:\"title_tx\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:23:\"raptor_boilerplate_exam\";}s:24:\"raptor_schedule_duration\";a:4:{s:6:\"fields\";a:1:{s:7:\"minutes\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:7:\"minutes\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:24:\"raptor_schedule_duration\";}s:17:\"raptor_cache_data\";a:4:{s:6:\"fields\";a:7:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"retry_delay\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:7:\"max_age\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"group_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}s:9:\"item_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}s:9:\"item_data\";a:3:{s:4:\"type\";s:4:\"blob\";s:10:\"mysql_type\";s:10:\"mediumblob\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:3:{i:0;s:3:\"uid\";i:1;s:10:\"group_name\";i:2;s:9:\"item_name\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:17:\"raptor_cache_data\";}s:17:\"raptor_cache_flag\";a:4:{s:6:\"fields\";a:8:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"retry_delay\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:7:\"max_age\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"group_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}s:9:\"item_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}s:9:\"flag_name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"flag_value\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:4:{i:0;s:3:\"uid\";i:1;s:10:\"group_name\";i:2;s:9:\"item_name\";i:3;s:9:\"flag_name\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:17:\"raptor_cache_flag\";}s:39:\"raptor_protocol_radiation_dose_tracking\";a:4:{s:6:\"fields\";a:13:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:18:\"protocol_shortname\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:14:\"dose_source_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:3:\"uom\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;}s:12:\"dose_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:1;s:8:\"not null\";b:1;}s:8:\"dose_avg\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:9:\"sample_ct\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:17:\"baseline_dose_avg\";a:4:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:18:\"baseline_sample_ct\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:17:\"lowest_dose_value\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:18:\"highest_dose_value\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:5:{i:0;s:6:\"siteid\";i:1;s:18:\"protocol_shortname\";i:2;s:14:\"dose_source_cd\";i:3;s:3:\"uom\";i:4;s:12:\"dose_type_cd\";}s:6:\"module\";s:16:\"raptor_datalayer\";s:4:\"name\";s:39:\"raptor_protocol_radiation_dose_tracking\";}s:28:\"raptor_list_kw_with_contrast\";a:3:{s:6:\"fields\";a:1:{s:9:\"phrase_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:6:\"module\";s:15:\"raptor_formulas\";s:4:\"name\";s:28:\"raptor_list_kw_with_contrast\";}s:31:\"raptor_list_kw_without_contrast\";a:3:{s:6:\"fields\";a:1:{s:9:\"phrase_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:6:\"module\";s:15:\"raptor_formulas\";s:4:\"name\";s:31:\"raptor_list_kw_without_contrast\";}s:38:\"raptor_list_kw_withandwithout_contrast\";a:3:{s:6:\"fields\";a:1:{s:9:\"phrase_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;}}s:6:\"module\";s:15:\"raptor_formulas\";s:4:\"name\";s:38:\"raptor_list_kw_withandwithout_contrast\";}s:27:\"raptor_protocol_lib_uploads\";a:4:{s:6:\"fields\";a:10:{s:18:\"protocol_shortname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:17:\"original_filename\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:0;}s:8:\"filetype\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:8;s:8:\"not null\";b:1;}s:9:\"file_blob\";a:3:{s:4:\"type\";s:4:\"blob\";s:10:\"mysql_type\";s:10:\"mediumblob\";s:8:\"not null\";b:1;}s:8:\"filesize\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:15:\"uploaded_by_uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:10:\"comment_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:11:\"uploaded_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:18:\"protocol_shortname\";i:1;s:7:\"version\";}s:6:\"module\";s:18:\"raptor_protocollib\";s:4:\"name\";s:27:\"raptor_protocol_lib_uploads\";}s:24:\"raptor_rep_example_table\";a:3:{s:6:\"fields\";a:4:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"some_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}}s:6:\"module\";s:14:\"raptor_reports\";s:4:\"name\";s:24:\"raptor_rep_example_table\";}s:21:\"raptor_schedule_track\";a:3:{s:6:\"fields\";a:12:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"scheduled_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:11:\"duration_am\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:17:\"notes_critical_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"location_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:23:\"confirmed_by_patient_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:18:\"canceled_reason_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:11:\"canceled_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:17:\"raptor_scheduling\";s:4:\"name\";s:21:\"raptor_schedule_track\";}s:30:\"raptor_schedule_track_replaced\";a:3:{s:6:\"fields\";a:13:{s:6:\"siteid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"IEN\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"scheduled_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:11:\"duration_am\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:8:\"notes_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:17:\"notes_critical_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:11:\"location_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:23:\"confirmed_by_patient_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:18:\"canceled_reason_tx\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:11:\"canceled_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}s:10:\"author_uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:19:\"original_created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:11:\"replaced_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:6:\"module\";s:17:\"raptor_scheduling\";s:4:\"name\";s:30:\"raptor_schedule_track_replaced\";}s:21:\"raptor_workflow_state\";a:4:{s:6:\"fields\";a:3:{s:4:\"abbr\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"description\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:4:\"abbr\";}s:6:\"module\";s:15:\"raptor_workflow\";s:4:\"name\";s:21:\"raptor_workflow_state\";}s:11:\"rdf_mapping\";a:4:{s:6:\"fields\";a:3:{s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:6:\"bundle\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:7:\"mapping\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:4:\"type\";i:1;s:6:\"bundle\";}s:6:\"module\";s:3:\"rdf\";s:4:\"name\";s:11:\"rdf_mapping\";}s:14:\"search_dataset\";a:4:{s:6:\"fields\";a:4:{s:3:\"sid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:1;}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:7:\"reindex\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:2:{i:0;s:3:\"sid\";i:1;s:4:\"type\";}s:6:\"module\";s:6:\"search\";s:4:\"name\";s:14:\"search_dataset\";}s:12:\"search_index\";a:6:{s:6:\"fields\";a:4:{s:4:\"word\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"sid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:1;}s:5:\"score\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:7:\"indexes\";a:1:{s:8:\"sid_type\";a:2:{i:0;s:3:\"sid\";i:1;s:4:\"type\";}}s:12:\"foreign keys\";a:1:{s:14:\"search_dataset\";a:2:{s:5:\"table\";s:14:\"search_dataset\";s:7:\"columns\";a:2:{s:3:\"sid\";s:3:\"sid\";s:4:\"type\";s:4:\"type\";}}}s:11:\"primary key\";a:3:{i:0;s:4:\"word\";i:1;s:3:\"sid\";i:2;s:4:\"type\";}s:6:\"module\";s:6:\"search\";s:4:\"name\";s:12:\"search_index\";}s:12:\"search_total\";a:4:{s:6:\"fields\";a:2:{s:4:\"word\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:50;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"count\";a:2:{s:4:\"type\";s:5:\"float\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:4:\"word\";}s:6:\"module\";s:6:\"search\";s:4:\"name\";s:12:\"search_total\";}s:17:\"search_node_links\";a:5:{s:6:\"fields\";a:4:{s:3:\"sid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:16;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"caption\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:3:{i:0;s:3:\"sid\";i:1;s:4:\"type\";i:2;s:3:\"nid\";}s:7:\"indexes\";a:1:{s:3:\"nid\";a:1:{i:0;s:3:\"nid\";}}s:6:\"module\";s:6:\"search\";s:4:\"name\";s:17:\"search_node_links\";}s:12:\"shortcut_set\";a:5:{s:6:\"fields\";a:2:{s:8:\"set_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:8:\"set_name\";}s:12:\"foreign keys\";a:1:{s:9:\"menu_name\";a:2:{s:5:\"table\";s:10:\"menu_links\";s:7:\"columns\";a:1:{s:8:\"set_name\";s:9:\"menu_name\";}}}s:6:\"module\";s:8:\"shortcut\";s:4:\"name\";s:12:\"shortcut_set\";}s:18:\"shortcut_set_users\";a:6:{s:6:\"fields\";a:2:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"set_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"uid\";}s:7:\"indexes\";a:1:{s:8:\"set_name\";a:1:{i:0;s:8:\"set_name\";}}s:12:\"foreign keys\";a:2:{s:8:\"set_user\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}s:8:\"set_name\";a:2:{s:5:\"table\";s:12:\"shortcut_set\";s:7:\"columns\";a:1:{s:8:\"set_name\";s:8:\"set_name\";}}}s:6:\"module\";s:8:\"shortcut\";s:4:\"name\";s:18:\"shortcut_set_users\";}s:22:\"simplerulesengine_rule\";a:4:{s:6:\"fields\";a:12:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"rule_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"summary_msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:80;s:8:\"not null\";b:1;}s:6:\"msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:11:\"explanation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;}s:10:\"req_ack_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"trigger_crit\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:1;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:7:\"rule_nm\";}s:6:\"module\";s:22:\"simplerulesengine_core\";s:4:\"name\";s:22:\"simplerulesengine_rule\";}s:25:\"simplerulesengine_measure\";a:4:{s:6:\"fields\";a:10:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"return_type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"purpose_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;}s:11:\"criteria_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:0;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:6:\"module\";s:22:\"simplerulesengine_core\";s:4:\"name\";s:25:\"simplerulesengine_measure\";}s:42:\"simplerulesengine_measure_question_choices\";a:4:{s:6:\"fields\";a:4:{s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:8:\"position\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"show_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:256;s:8:\"not null\";b:0;}s:9:\"choice_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:10:\"measure_nm\";i:1;s:8:\"position\";}s:6:\"module\";s:22:\"simplerulesengine_core\";s:4:\"name\";s:42:\"simplerulesengine_measure_question_choices\";}s:45:\"simplerulesengine_measure_question_validation\";a:4:{s:6:\"fields\";a:6:{s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:5:\"regex\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:0;}s:8:\"maxfloat\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:0;s:8:\"not null\";b:0;}s:8:\"minfloat\";a:3:{s:4:\"type\";s:5:\"float\";s:8:\"unsigned\";b:0;s:8:\"not null\";b:0;}s:6:\"maxint\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:0;s:8:\"not null\";b:0;}s:6:\"minint\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:0;s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:6:\"module\";s:22:\"simplerulesengine_core\";s:4:\"name\";s:45:\"simplerulesengine_measure_question_validation\";}s:34:\"simplerulesengine_measure_question\";a:4:{s:6:\"fields\";a:7:{s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:21:\"question_significance\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:50;}s:16:\"question_type_cd\";a:3:{s:4:\"type\";s:4:\"char\";s:6:\"length\";i:2;s:8:\"not null\";b:1;}s:12:\"answer_limit\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;}s:11:\"question_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:256;s:8:\"not null\";b:1;}s:14:\"explanation_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:6:\"module\";s:22:\"simplerulesengine_core\";s:4:\"name\";s:34:\"simplerulesengine_measure_question\";}s:27:\"simplerulesengine_demo_rule\";a:4:{s:6:\"fields\";a:12:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:7:\"rule_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:14:\"summary_msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:80;s:8:\"not null\";b:1;}s:6:\"msg_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:512;s:8:\"not null\";b:1;}s:11:\"explanation\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:2048;s:8:\"not null\";b:1;}s:10:\"req_ack_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:12:\"trigger_crit\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:1;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:7:\"rule_nm\";}s:6:\"module\";s:22:\"simplerulesengine_demo\";s:4:\"name\";s:27:\"simplerulesengine_demo_rule\";}s:30:\"simplerulesengine_demo_measure\";a:4:{s:6:\"fields\";a:10:{s:11:\"category_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"measure_nm\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;}s:7:\"version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:11:\"return_type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:20;s:8:\"not null\";b:1;}s:10:\"purpose_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:1024;s:8:\"not null\";b:1;}s:11:\"criteria_tx\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:4000;s:8:\"not null\";b:0;}s:11:\"readonly_yn\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"active_yn\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:10:\"updated_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}s:10:\"created_dt\";a:3:{s:4:\"type\";s:8:\"datetime\";s:10:\"mysql_type\";s:8:\"datetime\";s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:10:\"measure_nm\";}s:6:\"module\";s:22:\"simplerulesengine_demo\";s:4:\"name\";s:30:\"simplerulesengine_demo_measure\";}s:8:\"variable\";a:4:{s:6:\"fields\";a:2:{s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"value\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"name\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:8:\"variable\";}s:7:\"actions\";a:4:{s:6:\"fields\";a:5:{s:3:\"aid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"parameters\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:5:\"label\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:1:\"0\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"aid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:7:\"actions\";}s:5:\"batch\";a:5:{s:6:\"fields\";a:4:{s:3:\"bid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:5:\"token\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:9:\"timestamp\";a:2:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;}s:5:\"batch\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"bid\";}s:7:\"indexes\";a:1:{s:5:\"token\";a:1:{i:0;s:5:\"token\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:5:\"batch\";}s:11:\"blocked_ips\";a:5:{s:6:\"fields\";a:2:{s:3:\"iid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:2:\"ip\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:40;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:7:\"indexes\";a:1:{s:10:\"blocked_ip\";a:1:{i:0;s:2:\"ip\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"iid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:11:\"blocked_ips\";}s:5:\"cache\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:5:\"cache\";}s:15:\"cache_bootstrap\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:15:\"cache_bootstrap\";}s:10:\"cache_form\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"cache_form\";}s:10:\"cache_page\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"cache_page\";}s:10:\"cache_menu\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"cache_menu\";}s:10:\"cache_path\";a:5:{s:6:\"fields\";a:5:{s:3:\"cid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"serialized\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:5:\"small\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"cache_path\";}s:16:\"date_format_type\";a:5:{s:6:\"fields\";a:3:{s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"title\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"type\";}s:7:\"indexes\";a:1:{s:5:\"title\";a:1:{i:0;s:5:\"title\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:16:\"date_format_type\";}s:12:\"date_formats\";a:5:{s:6:\"fields\";a:4:{s:4:\"dfid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;s:8:\"unsigned\";b:1;}s:6:\"format\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;s:6:\"binary\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"dfid\";}s:11:\"unique keys\";a:1:{s:7:\"formats\";a:2:{i:0;s:6:\"format\";i:1;s:4:\"type\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:12:\"date_formats\";}s:18:\"date_format_locale\";a:4:{s:6:\"fields\";a:3:{s:6:\"format\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;s:6:\"binary\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:8:\"language\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:2:{i:0;s:4:\"type\";i:1;s:8:\"language\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:18:\"date_format_locale\";}s:12:\"file_managed\";a:7:{s:6:\"fields\";a:8:{s:3:\"fid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"uri\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:6:\"binary\";b:1;}s:8:\"filemime\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"filesize\";a:5:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:3:\"big\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:9:\"timestamp\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:3:{s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:6:\"status\";a:1:{i:0;s:6:\"status\";}s:9:\"timestamp\";a:1:{i:0;s:9:\"timestamp\";}}s:11:\"unique keys\";a:1:{s:3:\"uri\";a:1:{i:0;s:3:\"uri\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"fid\";}s:12:\"foreign keys\";a:1:{s:10:\"file_owner\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:12:\"file_managed\";}s:10:\"file_usage\";a:5:{s:6:\"fields\";a:5:{s:3:\"fid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:2:\"id\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"count\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:4:{i:0;s:3:\"fid\";i:1;s:4:\"type\";i:2;s:2:\"id\";i:3;s:6:\"module\";}s:7:\"indexes\";a:3:{s:7:\"type_id\";a:2:{i:0;s:4:\"type\";i:1;s:2:\"id\";}s:9:\"fid_count\";a:2:{i:0;s:3:\"fid\";i:1;s:5:\"count\";}s:10:\"fid_module\";a:2:{i:0;s:3:\"fid\";i:1;s:6:\"module\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"file_usage\";}s:5:\"flood\";a:5:{s:6:\"fields\";a:5:{s:3:\"fid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:5:\"event\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"identifier\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"expiration\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"fid\";}s:7:\"indexes\";a:2:{s:5:\"allow\";a:3:{i:0;s:5:\"event\";i:1;s:10:\"identifier\";i:2;s:9:\"timestamp\";}s:5:\"purge\";a:1:{i:0;s:10:\"expiration\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:5:\"flood\";}s:11:\"menu_router\";a:5:{s:6:\"fields\";a:23:{s:4:\"path\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:14:\"load_functions\";a:2:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;}s:16:\"to_arg_functions\";a:2:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:1;}s:15:\"access_callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:16:\"access_arguments\";a:2:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;}s:13:\"page_callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:14:\"page_arguments\";a:2:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;}s:17:\"delivery_callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"fit\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:12:\"number_parts\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:7:\"context\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:10:\"tab_parent\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"tab_root\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:14:\"title_callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:15:\"title_arguments\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:14:\"theme_callback\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:15:\"theme_arguments\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"type\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:11:\"description\";a:2:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;}s:8:\"position\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:12:\"include_file\";a:2:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:6:\"medium\";}}s:7:\"indexes\";a:3:{s:3:\"fit\";a:1:{i:0;s:3:\"fit\";}s:10:\"tab_parent\";a:3:{i:0;a:2:{i:0;s:10:\"tab_parent\";i:1;i:64;}i:1;s:6:\"weight\";i:2;s:5:\"title\";}s:21:\"tab_root_weight_title\";a:3:{i:0;a:2:{i:0;s:8:\"tab_root\";i:1;i:64;}i:1;s:6:\"weight\";i:2;s:5:\"title\";}}s:11:\"primary key\";a:1:{i:0;s:4:\"path\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:11:\"menu_router\";}s:10:\"menu_links\";a:5:{s:6:\"fields\";a:25:{s:9:\"menu_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"mlid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"plid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"link_path\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"router_path\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:10:\"link_title\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:7:\"options\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:12:\"translatable\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:6:\"system\";}s:6:\"hidden\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:8:\"external\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:12:\"has_children\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:8:\"expanded\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"depth\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:10:\"customized\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}s:2:\"p1\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p2\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p3\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p4\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p5\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p6\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p7\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p8\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:2:\"p9\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"updated\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:5:\"small\";}}s:7:\"indexes\";a:4:{s:9:\"path_menu\";a:2:{i:0;a:2:{i:0;s:9:\"link_path\";i:1;i:128;}i:1;s:9:\"menu_name\";}s:22:\"menu_plid_expand_child\";a:4:{i:0;s:9:\"menu_name\";i:1;s:4:\"plid\";i:2;s:8:\"expanded\";i:3;s:12:\"has_children\";}s:12:\"menu_parents\";a:10:{i:0;s:9:\"menu_name\";i:1;s:2:\"p1\";i:2;s:2:\"p2\";i:3;s:2:\"p3\";i:4;s:2:\"p4\";i:5;s:2:\"p5\";i:6;s:2:\"p6\";i:7;s:2:\"p7\";i:8;s:2:\"p8\";i:9;s:2:\"p9\";}s:11:\"router_path\";a:1:{i:0;a:2:{i:0;s:11:\"router_path\";i:1;i:128;}}}s:11:\"primary key\";a:1:{i:0;s:4:\"mlid\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:10:\"menu_links\";}s:5:\"queue\";a:5:{s:6:\"fields\";a:5:{s:7:\"item_id\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}s:6:\"expire\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:7:\"item_id\";}s:7:\"indexes\";a:2:{s:12:\"name_created\";a:2:{i:0;s:4:\"name\";i:1;s:7:\"created\";}s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:5:\"queue\";}s:8:\"registry\";a:5:{s:6:\"fields\";a:5:{s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:9;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"filename\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:2:{i:0;s:4:\"name\";i:1;s:4:\"type\";}s:7:\"indexes\";a:1:{s:4:\"hook\";a:3:{i:0;s:4:\"type\";i:1;s:6:\"weight\";i:2;s:6:\"module\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:8:\"registry\";}s:13:\"registry_file\";a:4:{s:6:\"fields\";a:2:{s:8:\"filename\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"hash\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:8:\"filename\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:13:\"registry_file\";}s:9:\"semaphore\";a:5:{s:6:\"fields\";a:3:{s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"value\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"expire\";a:3:{s:4:\"type\";s:5:\"float\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:1;}}s:7:\"indexes\";a:2:{s:5:\"value\";a:1:{i:0;s:5:\"value\";}s:6:\"expire\";a:1:{i:0;s:6:\"expire\";}}s:11:\"primary key\";a:1:{i:0;s:4:\"name\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:9:\"semaphore\";}s:9:\"sequences\";a:4:{s:6:\"fields\";a:1:{s:5:\"value\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:5:\"value\";}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:9:\"sequences\";}s:8:\"sessions\";a:6:{s:6:\"fields\";a:7:{s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"sid\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;}s:4:\"ssid\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"cache\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"session\";a:3:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";}}s:11:\"primary key\";a:2:{i:0;s:3:\"sid\";i:1;s:4:\"ssid\";}s:7:\"indexes\";a:3:{s:9:\"timestamp\";a:1:{i:0;s:9:\"timestamp\";}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:4:\"ssid\";a:1:{i:0;s:4:\"ssid\";}}s:12:\"foreign keys\";a:1:{s:12:\"session_user\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:8:\"sessions\";}s:6:\"system\";a:5:{s:6:\"fields\";a:9:{s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"owner\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"bootstrap\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:14:\"schema_version\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:-1;s:4:\"size\";s:5:\"small\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"info\";a:2:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;}}s:11:\"primary key\";a:1:{i:0;s:8:\"filename\";}s:7:\"indexes\";a:2:{s:11:\"system_list\";a:5:{i:0;s:6:\"status\";i:1;s:9:\"bootstrap\";i:2;s:4:\"type\";i:3;s:6:\"weight\";i:4;s:4:\"name\";}s:9:\"type_name\";a:2:{i:0;s:4:\"type\";i:1;s:4:\"name\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:6:\"system\";}s:9:\"url_alias\";a:5:{s:6:\"fields\";a:4:{s:3:\"pid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:6:\"source\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"alias\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"pid\";}s:7:\"indexes\";a:2:{s:18:\"alias_language_pid\";a:3:{i:0;s:5:\"alias\";i:1;s:8:\"language\";i:2;s:3:\"pid\";}s:19:\"source_language_pid\";a:3:{i:0;s:6:\"source\";i:1;s:8:\"language\";i:2;s:3:\"pid\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:9:\"url_alias\";}s:18:\"taxonomy_term_data\";a:6:{s:6:\"fields\";a:6:{s:3:\"tid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"vid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"tid\";}s:12:\"foreign keys\";a:1:{s:10:\"vocabulary\";a:2:{s:5:\"table\";s:19:\"taxonomy_vocabulary\";s:7:\"columns\";a:1:{s:3:\"vid\";s:3:\"vid\";}}}s:7:\"indexes\";a:3:{s:13:\"taxonomy_tree\";a:3:{i:0;s:3:\"vid\";i:1;s:6:\"weight\";i:2;s:4:\"name\";}s:8:\"vid_name\";a:2:{i:0;s:3:\"vid\";i:1;s:4:\"name\";}s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:18:\"taxonomy_term_data\";}s:23:\"taxonomy_term_hierarchy\";a:6:{s:6:\"fields\";a:2:{s:3:\"tid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"parent\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:1:{s:6:\"parent\";a:1:{i:0;s:6:\"parent\";}}s:12:\"foreign keys\";a:1:{s:18:\"taxonomy_term_data\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:3:\"tid\";s:3:\"tid\";}}}s:11:\"primary key\";a:2:{i:0;s:3:\"tid\";i:1;s:6:\"parent\";}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:23:\"taxonomy_term_hierarchy\";}s:19:\"taxonomy_vocabulary\";a:6:{s:6:\"fields\";a:7:{s:3:\"vid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:9:\"hierarchy\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"vid\";}s:7:\"indexes\";a:1:{s:4:\"list\";a:2:{i:0;s:6:\"weight\";i:1;s:4:\"name\";}}s:11:\"unique keys\";a:1:{s:12:\"machine_name\";a:1:{i:0;s:12:\"machine_name\";}}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:19:\"taxonomy_vocabulary\";}s:14:\"taxonomy_index\";a:5:{s:6:\"fields\";a:4:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"tid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"sticky\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:0;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:2:{s:9:\"term_node\";a:3:{i:0;s:3:\"tid\";i:1;s:6:\"sticky\";i:2;s:7:\"created\";}s:3:\"nid\";a:1:{i:0;s:3:\"nid\";}}s:12:\"foreign keys\";a:2:{s:12:\"tracked_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:4:\"term\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:3:\"tid\";s:3:\"tid\";}}}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:14:\"taxonomy_index\";}s:7:\"authmap\";a:6:{s:6:\"fields\";a:4:{s:3:\"aid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"authname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"unique keys\";a:1:{s:8:\"authname\";a:1:{i:0;s:8:\"authname\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"aid\";}s:12:\"foreign keys\";a:1:{s:4:\"user\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:7:\"authmap\";}s:15:\"role_permission\";a:6:{s:6:\"fields\";a:3:{s:3:\"rid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:10:\"permission\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:11:\"primary key\";a:2:{i:0;s:3:\"rid\";i:1;s:10:\"permission\";}s:7:\"indexes\";a:1:{s:10:\"permission\";a:1:{i:0;s:10:\"permission\";}}s:12:\"foreign keys\";a:1:{s:4:\"role\";a:2:{s:5:\"table\";s:4:\"role\";s:7:\"columns\";a:1:{s:3:\"rid\";s:3:\"rid\";}}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:15:\"role_permission\";}s:4:\"role\";a:6:{s:6:\"fields\";a:3:{s:3:\"rid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"unique keys\";a:1:{s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"rid\";}s:7:\"indexes\";a:1:{s:11:\"name_weight\";a:2:{i:0;s:4:\"name\";i:1;s:6:\"weight\";}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:4:\"role\";}s:5:\"users\";a:7:{s:6:\"fields\";a:16:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"pass\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"mail\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:5:\"theme\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"signature\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:16:\"signature_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"access\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"login\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:8:\"timezone\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"picture\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"init\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:7:\"indexes\";a:4:{s:6:\"access\";a:1:{i:0;s:6:\"access\";}s:7:\"created\";a:1:{i:0;s:7:\"created\";}s:4:\"mail\";a:1:{i:0;s:4:\"mail\";}s:7:\"picture\";a:1:{i:0;s:7:\"picture\";}}s:11:\"unique keys\";a:1:{s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"uid\";}s:12:\"foreign keys\";a:1:{s:16:\"signature_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:16:\"signature_format\";s:6:\"format\";}}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:5:\"users\";}s:11:\"users_roles\";a:6:{s:6:\"fields\";a:2:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"rid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:2:{i:0;s:3:\"uid\";i:1;s:3:\"rid\";}s:7:\"indexes\";a:1:{s:3:\"rid\";a:1:{i:0;s:3:\"rid\";}}s:12:\"foreign keys\";a:2:{s:4:\"user\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}s:4:\"role\";a:2:{s:5:\"table\";s:4:\"role\";s:7:\"columns\";a:1:{s:3:\"rid\";s:3:\"rid\";}}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:11:\"users_roles\";}}',0,1454110967,1),('schema:runtime:','a:7:{s:7:\"comment\";a:6:{s:6:\"fields\";a:14:{s:3:\"cid\";a:2:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;}s:3:\"pid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"nid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"subject\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"hostname\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"changed\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:1;s:4:\"size\";s:4:\"tiny\";}s:6:\"thread\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:4:\"name\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:0;}s:4:\"mail\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:0;}s:8:\"homepage\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}}s:7:\"indexes\";a:5:{s:18:\"comment_status_pid\";a:2:{i:0;s:3:\"pid\";i:1;s:6:\"status\";}s:15:\"comment_num_new\";a:5:{i:0;s:3:\"nid\";i:1;s:6:\"status\";i:2;s:7:\"created\";i:3;s:3:\"cid\";i:4;s:6:\"thread\";}s:11:\"comment_uid\";a:1:{i:0;s:3:\"uid\";}s:20:\"comment_nid_language\";a:2:{i:0;s:3:\"nid\";i:1;s:8:\"language\";}s:15:\"comment_created\";a:1:{i:0;s:7:\"created\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"cid\";}s:12:\"foreign keys\";a:2:{s:12:\"comment_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:14:\"comment_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:7:\"comment\";s:4:\"name\";s:7:\"comment\";}s:4:\"node\";a:7:{s:6:\"fields\";a:14:{s:3:\"nid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"vid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:0;s:7:\"default\";N;}s:4:\"type\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"changed\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"comment\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"promote\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"sticky\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"tnid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:9:\"translate\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:10:{s:12:\"node_changed\";a:1:{i:0;s:7:\"changed\";}s:12:\"node_created\";a:1:{i:0;s:7:\"created\";}s:14:\"node_frontpage\";a:4:{i:0;s:7:\"promote\";i:1;s:6:\"status\";i:2;s:6:\"sticky\";i:3;s:7:\"created\";}s:16:\"node_status_type\";a:3:{i:0;s:6:\"status\";i:1;s:4:\"type\";i:2;s:3:\"nid\";}s:15:\"node_title_type\";a:2:{i:0;s:5:\"title\";i:1;a:2:{i:0;s:4:\"type\";i:1;i:4;}}s:9:\"node_type\";a:1:{i:0;a:2:{i:0;s:4:\"type\";i:1;i:4;}}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:4:\"tnid\";a:1:{i:0;s:4:\"tnid\";}s:9:\"translate\";a:1:{i:0;s:9:\"translate\";}s:8:\"language\";a:1:{i:0;s:8:\"language\";}}s:11:\"unique keys\";a:1:{s:3:\"vid\";a:1:{i:0;s:3:\"vid\";}}s:12:\"foreign keys\";a:2:{s:13:\"node_revision\";a:2:{s:5:\"table\";s:13:\"node_revision\";s:7:\"columns\";a:1:{s:3:\"vid\";s:3:\"vid\";}}s:11:\"node_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:11:\"primary key\";a:1:{i:0;s:3:\"nid\";}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:4:\"node\";}s:13:\"node_revision\";a:6:{s:6:\"fields\";a:10:{s:3:\"nid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:3:\"vid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uid\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"title\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"log\";a:3:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:1;s:4:\"size\";s:3:\"big\";}s:9:\"timestamp\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:1;}s:7:\"comment\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:7:\"promote\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"sticky\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:2:{s:3:\"nid\";a:1:{i:0;s:3:\"nid\";}s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"vid\";}s:12:\"foreign keys\";a:2:{s:14:\"versioned_node\";a:2:{s:5:\"table\";s:4:\"node\";s:7:\"columns\";a:1:{s:3:\"nid\";s:3:\"nid\";}}s:14:\"version_author\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:4:\"node\";s:4:\"name\";s:13:\"node_revision\";}s:12:\"file_managed\";a:7:{s:6:\"fields\";a:8:{s:3:\"fid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:8:\"filename\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:3:\"uri\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:6:\"binary\";b:1;}s:8:\"filemime\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:8:\"filesize\";a:5:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:3:\"big\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:9:\"timestamp\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:7:\"indexes\";a:3:{s:3:\"uid\";a:1:{i:0;s:3:\"uid\";}s:6:\"status\";a:1:{i:0;s:6:\"status\";}s:9:\"timestamp\";a:1:{i:0;s:9:\"timestamp\";}}s:11:\"unique keys\";a:1:{s:3:\"uri\";a:1:{i:0;s:3:\"uri\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"fid\";}s:12:\"foreign keys\";a:1:{s:10:\"file_owner\";a:2:{s:5:\"table\";s:5:\"users\";s:7:\"columns\";a:1:{s:3:\"uid\";s:3:\"uid\";}}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:12:\"file_managed\";}s:18:\"taxonomy_term_data\";a:6:{s:6:\"fields\";a:6:{s:3:\"tid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:3:\"vid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"tid\";}s:12:\"foreign keys\";a:1:{s:10:\"vocabulary\";a:2:{s:5:\"table\";s:19:\"taxonomy_vocabulary\";s:7:\"columns\";a:1:{s:3:\"vid\";s:3:\"vid\";}}}s:7:\"indexes\";a:3:{s:13:\"taxonomy_tree\";a:3:{i:0;s:3:\"vid\";i:1;s:6:\"weight\";i:2;s:4:\"name\";}s:8:\"vid_name\";a:2:{i:0;s:3:\"vid\";i:1;s:4:\"name\";}s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:18:\"taxonomy_term_data\";}s:19:\"taxonomy_vocabulary\";a:6:{s:6:\"fields\";a:7:{s:3:\"vid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;}s:4:\"name\";a:5:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";s:12:\"translatable\";b:1;}s:12:\"machine_name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:11:\"description\";a:4:{s:4:\"type\";s:4:\"text\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:12:\"translatable\";b:1;}s:9:\"hierarchy\";a:5:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:6:\"module\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:6:\"weight\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}}s:11:\"primary key\";a:1:{i:0;s:3:\"vid\";}s:7:\"indexes\";a:1:{s:4:\"list\";a:2:{i:0;s:6:\"weight\";i:1;s:4:\"name\";}}s:11:\"unique keys\";a:1:{s:12:\"machine_name\";a:1:{i:0;s:12:\"machine_name\";}}s:6:\"module\";s:8:\"taxonomy\";s:4:\"name\";s:19:\"taxonomy_vocabulary\";}s:5:\"users\";a:7:{s:6:\"fields\";a:16:{s:3:\"uid\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"unsigned\";b:1;s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"name\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:60;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"pass\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:128;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:4:\"mail\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:5:\"theme\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:9:\"signature\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:16:\"signature_format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}s:7:\"created\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"access\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:5:\"login\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:6:\"status\";a:4:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;s:4:\"size\";s:4:\"tiny\";}s:8:\"timezone\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:32;s:8:\"not null\";b:0;}s:8:\"language\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:12;s:8:\"not null\";b:1;s:7:\"default\";s:0:\"\";}s:7:\"picture\";a:3:{s:4:\"type\";s:3:\"int\";s:8:\"not null\";b:1;s:7:\"default\";i:0;}s:4:\"init\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:254;s:8:\"not null\";b:0;s:7:\"default\";s:0:\"\";}s:4:\"data\";a:4:{s:4:\"type\";s:4:\"blob\";s:8:\"not null\";b:0;s:4:\"size\";s:3:\"big\";s:9:\"serialize\";b:1;}}s:7:\"indexes\";a:4:{s:6:\"access\";a:1:{i:0;s:6:\"access\";}s:7:\"created\";a:1:{i:0;s:7:\"created\";}s:4:\"mail\";a:1:{i:0;s:4:\"mail\";}s:7:\"picture\";a:1:{i:0;s:7:\"picture\";}}s:11:\"unique keys\";a:1:{s:4:\"name\";a:1:{i:0;s:4:\"name\";}}s:11:\"primary key\";a:1:{i:0;s:3:\"uid\";}s:12:\"foreign keys\";a:1:{s:16:\"signature_format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:16:\"signature_format\";s:6:\"format\";}}}s:6:\"module\";s:4:\"user\";s:4:\"name\";s:5:\"users\";}}',0,1454110967,1),('schema:runtime:1','a:2:{s:16:\"date_format_type\";a:5:{s:6:\"fields\";a:3:{s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:5:\"title\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"type\";}s:7:\"indexes\";a:1:{s:5:\"title\";a:1:{i:0;s:5:\"title\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:16:\"date_format_type\";}s:12:\"date_formats\";a:5:{s:6:\"fields\";a:4:{s:4:\"dfid\";a:3:{s:4:\"type\";s:6:\"serial\";s:8:\"not null\";b:1;s:8:\"unsigned\";b:1;}s:6:\"format\";a:4:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:100;s:8:\"not null\";b:1;s:6:\"binary\";b:1;}s:4:\"type\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:64;s:8:\"not null\";b:1;}s:6:\"locked\";a:4:{s:4:\"type\";s:3:\"int\";s:4:\"size\";s:4:\"tiny\";s:7:\"default\";i:0;s:8:\"not null\";b:1;}}s:11:\"primary key\";a:1:{i:0;s:4:\"dfid\";}s:11:\"unique keys\";a:1:{s:7:\"formats\";a:2:{i:0;s:6:\"format\";i:1;s:4:\"type\";}}s:6:\"module\";s:6:\"system\";s:4:\"name\";s:12:\"date_formats\";}}',0,1454111015,1),('theme_registry:build:modules','a:145:{s:12:\"user_picture\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:8:\"template\";s:25:\"modules/user/user-picture\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_user_picture\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:12:\"user_profile\";a:8:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:25:\"modules/user/user-profile\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_user_profile\";i:2;s:21:\"contextual_preprocess\";i:3;s:27:\"rdf_preprocess_user_profile\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:21:\"user_profile_category\";a:8:{s:14:\"render element\";s:7:\"element\";s:8:\"template\";s:34:\"modules/user/user-profile-category\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:41:\"template_preprocess_user_profile_category\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"user_profile_item\";a:8:{s:14:\"render element\";s:7:\"element\";s:8:\"template\";s:30:\"modules/user/user-profile-item\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_user_profile_item\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:9:\"user_list\";a:6:{s:9:\"variables\";a:2:{s:5:\"users\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:15:\"theme_user_list\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:22:\"user_admin_permissions\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:28:\"theme_user_admin_permissions\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"user_admin_roles\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:22:\"theme_user_admin_roles\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:27:\"user_permission_description\";a:8:{s:9:\"variables\";a:2:{s:15:\"permission_item\";N;s:4:\"hide\";N;}s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:33:\"theme_user_permission_description\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:14:\"user_signature\";a:6:{s:9:\"variables\";a:1:{s:9:\"signature\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:20:\"theme_user_signature\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:7:\"toolbar\";a:7:{s:14:\"render element\";s:7:\"toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:15:\"modules/toolbar\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:26:\"toolbar_preprocess_toolbar\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:14:\"toolbar_toggle\";a:6:{s:9:\"variables\";a:2:{s:9:\"collapsed\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:8:\"function\";s:20:\"theme_toolbar_toggle\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:30:\"taxonomy_overview_vocabularies\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:36:\"theme_taxonomy_overview_vocabularies\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:23:\"taxonomy_overview_terms\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:29:\"theme_taxonomy_overview_terms\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:13:\"taxonomy_term\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:30:\"modules/taxonomy/taxonomy-term\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_taxonomy_term\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"rdf_preprocess_taxonomy_term\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"page\";s:8:\"template\";s:19:\"modules/system/html\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"toolbar_preprocess_html\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_html\";i:2;s:11:\"rdf_process\";}}s:4:\"page\";a:6:{s:14:\"render element\";s:4:\"page\";s:8:\"template\";s:19:\"modules/system/page\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:3;s:24:\"shortcut_preprocess_page\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_page\";i:2;s:11:\"rdf_process\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:21:\"modules/system/region\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:15:\"status_messages\";a:6:{s:9:\"variables\";a:1:{s:7:\"display\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_status_messages\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"link\";a:6:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:4:\"path\";N;s:7:\"options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"links\";a:6:{s:9:\"variables\";a:3:{s:5:\"links\";N;s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_links\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"image\";a:6:{s:9:\"variables\";a:6:{s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_image\";s:20:\"preprocess functions\";a:1:{i:0;s:20:\"rdf_preprocess_image\";}s:17:\"process functions\";a:0:{}}s:10:\"breadcrumb\";a:6:{s:9:\"variables\";a:1:{s:10:\"breadcrumb\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_breadcrumb\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"help\";a:6:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_help\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"table\";a:6:{s:9:\"variables\";a:7:{s:6:\"header\";N;s:4:\"rows\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_table\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"tablesort_indicator\";a:6:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_tablesort_indicator\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"mark\";a:6:{s:9:\"variables\";a:1:{s:4:\"type\";i:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_mark\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"item_list\";a:6:{s:9:\"variables\";a:4:{s:5:\"items\";a:0:{}s:5:\"title\";N;s:4:\"type\";s:2:\"ul\";s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_item_list\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:14:\"more_help_link\";a:6:{s:9:\"variables\";a:1:{s:3:\"url\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:20:\"theme_more_help_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"feed_icon\";a:6:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_feed_icon\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"more_link\";a:6:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_more_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"username\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_username\";s:20:\"preprocess functions\";a:2:{i:0;s:28:\"template_preprocess_username\";i:1;s:23:\"rdf_preprocess_username\";}s:17:\"process functions\";a:1:{i:0;s:25:\"template_process_username\";}}s:12:\"progress_bar\";a:6:{s:9:\"variables\";a:2:{s:7:\"percent\";N;s:7:\"message\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_progress_bar\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"indentation\";a:6:{s:9:\"variables\";a:1:{s:4:\"size\";i:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_indentation\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"html_tag\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_html_tag\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"maintenance_page\";a:6:{s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:8:\"template\";s:31:\"modules/system/maintenance-page\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_maintenance_page\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:33:\"template_process_maintenance_page\";i:2;s:11:\"rdf_process\";}}s:11:\"update_page\";a:6:{s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_update_page\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"install_page\";a:6:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_install_page\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"task_list\";a:6:{s:9:\"variables\";a:2:{s:5:\"items\";N;s:6:\"active\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_task_list\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"authorize_message\";a:6:{s:9:\"variables\";a:2:{s:7:\"message\";N;s:7:\"success\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_authorize_message\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"authorize_report\";a:6:{s:9:\"variables\";a:1:{s:8:\"messages\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_authorize_report\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"pager\";a:6:{s:9:\"variables\";a:4:{s:4:\"tags\";a:0:{}s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}s:8:\"quantity\";i:9;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_pager\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"pager_first\";a:6:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_pager_first\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:14:\"pager_previous\";a:6:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:20:\"theme_pager_previous\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:10:\"pager_next\";a:6:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_next\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:10:\"pager_last\";a:6:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_last\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:10:\"pager_link\";a:6:{s:9:\"variables\";a:5:{s:4:\"text\";N;s:8:\"page_new\";N;s:7:\"element\";N;s:10:\"parameters\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"menu_link\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"menu_tree\";a:6:{s:14:\"render element\";s:4:\"tree\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_tree\";s:20:\"preprocess functions\";a:1:{i:0;s:29:\"template_preprocess_menu_tree\";}s:17:\"process functions\";a:0:{}}s:15:\"menu_local_task\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_menu_local_task\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"menu_local_action\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_menu_local_action\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"menu_local_tasks\";a:6:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_menu_local_tasks\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:6:\"select\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_select\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"fieldset\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_fieldset\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"radio\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_radio\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:6:\"radios\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_radios\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"date\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_date\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:15:\"exposed_filters\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_exposed_filters\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"checkbox\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_checkbox\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:10:\"checkboxes\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_checkboxes\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:6:\"button\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_button\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"image_button\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_image_button\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:6:\"hidden\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_hidden\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"textfield\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_textfield\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_form\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"textarea\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_textarea\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:8:\"password\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_password\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"file\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_file\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"tableselect\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_tableselect\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"form_element\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_form_element\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"form_required_marker\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_form_required_marker\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:18:\"form_element_label\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_form_element_label\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:13:\"vertical_tabs\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_vertical_tabs\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_container\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:18:\"system_themes_page\";a:8:{s:9:\"variables\";a:1:{s:12:\"theme_groups\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_system_themes_page\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"system_settings_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_system_settings_form\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"confirm_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_confirm_form\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:23:\"system_modules_fieldset\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:29:\"theme_system_modules_fieldset\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:27:\"system_modules_incompatible\";a:8:{s:9:\"variables\";a:1:{s:7:\"message\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:33:\"theme_system_modules_incompatible\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:24:\"system_modules_uninstall\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:30:\"theme_system_modules_uninstall\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:13:\"status_report\";a:8:{s:14:\"render element\";s:12:\"requirements\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_status_report\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:10:\"admin_page\";a:8:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_admin_page\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"admin_block\";a:8:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_admin_block\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"admin_block_content\";a:8:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_admin_block_content\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:18:\"system_admin_index\";a:8:{s:9:\"variables\";a:1:{s:10:\"menu_items\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_system_admin_index\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"system_powered_by\";a:6:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_system_powered_by\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"system_compact_link\";a:6:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_system_compact_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:25:\"system_date_time_settings\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:31:\"theme_system_date_time_settings\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:22:\"shortcut_set_customize\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:18:\"shortcut.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/shortcut\";s:8:\"function\";s:28:\"theme_shortcut_set_customize\";s:8:\"includes\";a:1:{i:0;s:35:\"modules/shortcut/shortcut.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"search_block_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:8:\"template\";s:32:\"modules/search/search-block-form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_search_block_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:13:\"search_result\";a:8:{s:9:\"variables\";a:2:{s:6:\"result\";N;s:6:\"module\";N;}s:4:\"file\";s:16:\"search.pages.inc\";s:8:\"template\";s:28:\"modules/search/search-result\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_search_result\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:14:\"search_results\";a:8:{s:9:\"variables\";a:2:{s:7:\"results\";N;s:6:\"module\";N;}s:4:\"file\";s:16:\"search.pages.inc\";s:8:\"template\";s:29:\"modules/search/search-results\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:34:\"template_preprocess_search_results\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:29:\"rdf_template_variable_wrapper\";a:6:{s:9:\"variables\";a:4:{s:7:\"content\";N;s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:6:\"inline\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:35:\"theme_rdf_template_variable_wrapper\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"rdf_metadata\";a:6:{s:9:\"variables\";a:1:{s:8:\"metadata\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:18:\"theme_rdf_metadata\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"options_none\";a:6:{s:9:\"variables\";a:2:{s:8:\"instance\";N;s:6:\"option\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:29:\"modules/field/modules/options\";s:8:\"function\";s:18:\"theme_options_none\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:4:\"node\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:17:\"modules/node/node\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:19:\"rdf_preprocess_node\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"node_search_admin\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_search_admin\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:13:\"node_add_list\";a:8:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"file\";s:14:\"node.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:19:\"theme_node_add_list\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"node_preview\";a:8:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"file\";s:14:\"node.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:18:\"theme_node_preview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"node_admin_overview\";a:8:{s:9:\"variables\";a:2:{s:4:\"name\";N;s:4:\"type\";N;}s:4:\"file\";s:17:\"content_types.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_admin_overview\";s:8:\"includes\";a:1:{i:0;s:30:\"modules/node/content_types.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"node_recent_block\";a:6:{s:9:\"variables\";a:1:{s:5:\"nodes\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_recent_block\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"node_recent_content\";a:6:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_recent_content\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:18:\"menu_overview_form\";a:8:{s:4:\"file\";s:14:\"menu.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:24:\"theme_menu_overview_form\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"menu_admin_overview\";a:8:{s:4:\"file\";s:14:\"menu.admin.inc\";s:9:\"variables\";a:3:{s:5:\"title\";N;s:4:\"name\";N;s:11:\"description\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:25:\"theme_menu_admin_overview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"image_style\";a:6:{s:9:\"variables\";a:7:{s:10:\"style_name\";N;s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:17:\"theme_image_style\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"image_style_list\";a:6:{s:9:\"variables\";a:1:{s:6:\"styles\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:22:\"theme_image_style_list\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"image_style_effects\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_style_effects\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"image_style_preview\";a:6:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_style_preview\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"image_anchor\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_anchor\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"image_resize_summary\";a:6:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_resize_summary\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"image_scale_summary\";a:6:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_scale_summary\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:18:\"image_crop_summary\";a:6:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:24:\"theme_image_crop_summary\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"image_rotate_summary\";a:6:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_rotate_summary\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:12:\"image_widget\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_widget\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:15:\"image_formatter\";a:6:{s:9:\"variables\";a:3:{s:4:\"item\";N;s:4:\"path\";N;s:11:\"image_style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:21:\"theme_image_formatter\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:21:\"filter_admin_overview\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_admin_overview\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:32:\"filter_admin_format_filter_order\";a:8:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:38:\"theme_filter_admin_format_filter_order\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"filter_tips\";a:8:{s:9:\"variables\";a:2:{s:4:\"tips\";N;s:4:\"long\";b:0;}s:4:\"file\";s:16:\"filter.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:17:\"theme_filter_tips\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.pages.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:19:\"text_format_wrapper\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:25:\"theme_text_format_wrapper\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:21:\"filter_tips_more_info\";a:6:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_tips_more_info\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"filter_guidelines\";a:6:{s:9:\"variables\";a:1:{s:6:\"format\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:23:\"theme_filter_guidelines\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"file_link\";a:6:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_link\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"file_icon\";a:6:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_icon\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:17:\"file_managed_file\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:23:\"theme_file_managed_file\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:11:\"file_widget\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:17:\"theme_file_widget\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"file_widget_multiple\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_widget_multiple\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:20:\"file_formatter_table\";a:6:{s:9:\"variables\";a:1:{s:5:\"items\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_formatter_table\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"file_upload_help\";a:6:{s:9:\"variables\";a:2:{s:11:\"description\";N;s:17:\"upload_validators\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:22:\"theme_file_upload_help\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:14:\"field_ui_table\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/field_ui\";s:8:\"function\";s:20:\"theme_field_ui_table\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"field\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/field\";s:8:\"function\";s:11:\"theme_field\";s:20:\"preprocess functions\";a:2:{i:0;s:25:\"template_preprocess_field\";i:1;s:20:\"rdf_preprocess_field\";}s:17:\"process functions\";a:1:{i:0;s:22:\"template_process_field\";}}s:25:\"field_multiple_value_form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/field\";s:8:\"function\";s:31:\"theme_field_multiple_value_form\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:13:\"dblog_message\";a:8:{s:9:\"variables\";a:2:{s:5:\"event\";N;s:4:\"link\";b:0;}s:4:\"file\";s:15:\"dblog.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/dblog\";s:8:\"function\";s:19:\"theme_dblog_message\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/dblog/dblog.admin.inc\";}s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:9:\"dashboard\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:15:\"theme_dashboard\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:15:\"dashboard_admin\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:21:\"theme_dashboard_admin\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:16:\"dashboard_region\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:22:\"theme_dashboard_region\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:25:\"dashboard_disabled_blocks\";a:6:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:31:\"theme_dashboard_disabled_blocks\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:24:\"dashboard_disabled_block\";a:6:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:30:\"theme_dashboard_disabled_block\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:28:\"dashboard_admin_display_form\";a:9:{s:8:\"template\";s:24:\"block-admin-display-form\";s:4:\"path\";s:13:\"modules/block\";s:4:\"file\";s:15:\"block.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/block/block.admin.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:48:\"template_preprocess_dashboard_admin_display_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:13:\"comment_block\";a:6:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:19:\"theme_comment_block\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:15:\"comment_preview\";a:6:{s:9:\"variables\";a:1:{s:7:\"comment\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:21:\"theme_comment_preview\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:7:\"comment\";a:6:{s:8:\"template\";s:23:\"modules/comment/comment\";s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_comment\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"rdf_preprocess_comment\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:22:\"comment_post_forbidden\";a:6:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:28:\"theme_comment_post_forbidden\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:15:\"comment_wrapper\";a:6:{s:8:\"template\";s:31:\"modules/comment/comment-wrapper\";s:14:\"render element\";s:7:\"content\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_comment_wrapper\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"color_scheme_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/color\";s:8:\"function\";s:23:\"theme_color_scheme_form\";s:20:\"preprocess functions\";a:0:{}s:17:\"process functions\";a:0:{}}s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:19:\"modules/block/block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/block\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"system_preprocess_block\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:24:\"block_admin_display_form\";a:8:{s:8:\"template\";s:38:\"modules/block/block-admin-display-form\";s:4:\"file\";s:15:\"block.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/block\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/block/block.admin.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:44:\"template_preprocess_block_admin_display_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}}',0,1443811944,1),('theme_registry:raptor_omega','a:160:{s:15:\"protocol_layout\";a:6:{s:8:\"template\";s:15:\"protocol-layout\";s:4:\"path\";s:46:\"sites/all/themes/raptor_omega/layouts/protocol\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:14:\"supinfo_layout\";a:6:{s:8:\"template\";s:14:\"supinfo-layout\";s:4:\"path\";s:45:\"sites/all/themes/raptor_omega/layouts/supinfo\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:15:\"worklist_layout\";a:6:{s:8:\"template\";s:15:\"worklist-layout\";s:4:\"path\";s:46:\"sites/all/themes/raptor_omega/layouts/worklist\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:12:\"login_layout\";a:6:{s:8:\"template\";s:12:\"login-layout\";s:4:\"path\";s:43:\"sites/all/themes/raptor_omega/layouts/login\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:12:\"admin_layout\";a:6:{s:8:\"template\";s:12:\"admin-layout\";s:4:\"path\";s:43:\"sites/all/themes/raptor_omega/layouts/admin\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:12:\"omega_chrome\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:18:\"theme_omega_chrome\";}s:17:\"omega_page_layout\";a:4:{s:9:\"base hook\";s:4:\"page\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:23:\"theme_omega_page_layout\";}s:11:\"hero_layout\";a:6:{s:8:\"template\";s:11:\"hero-layout\";s:4:\"path\";s:39:\"sites/all/themes/omega/ohm/layouts/hero\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:17:\"off_canvas_layout\";a:6:{s:8:\"template\";s:17:\"off-canvas-layout\";s:4:\"path\";s:47:\"sites/all/themes/omega/omega/layouts/off-canvas\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:13:\"simple_layout\";a:6:{s:8:\"template\";s:13:\"simple-layout\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/layouts/simple\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:13:\"divine_layout\";a:6:{s:8:\"template\";s:13:\"divine-layout\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/layouts/divine\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:24:\"block_admin_display_form\";a:8:{s:8:\"template\";s:24:\"block-admin-display-form\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:2:{i:0;s:29:\"modules/block/block.admin.inc\";i:1;s:79:\"sites/all/themes/omega/omega/preprocess/block-admin-display-form.preprocess.inc\";}s:14:\"render element\";s:4:\"form\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:44:\"template_preprocess_block_admin_display_form\";i:3;s:21:\"contextual_preprocess\";i:4;s:41:\"omega_preprocess_block_admin_display_form\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:5:\"block\";a:8:{s:8:\"template\";s:5:\"block\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:25:\"template_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"system_preprocess_block\";i:5;s:22:\"omega_preprocess_block\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";i:3;s:19:\"omega_process_block\";}s:8:\"includes\";a:2:{i:0;s:54:\"sites/all/themes/omega/omega/process/block.process.inc\";i:1;s:60:\"sites/all/themes/omega/omega/preprocess/block.preprocess.inc\";}}s:13:\"taxonomy_term\";a:8:{s:8:\"template\";s:13:\"taxonomy-term\";s:4:\"path\";s:47:\"sites/all/themes/omega/omega/templates/taxonomy\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:33:\"template_preprocess_taxonomy_term\";i:3;s:21:\"contextual_preprocess\";i:4;s:28:\"rdf_preprocess_taxonomy_term\";i:5;s:30:\"omega_preprocess_taxonomy_term\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:68:\"sites/all/themes/omega/omega/preprocess/taxonomy-term.preprocess.inc\";}}s:4:\"node\";a:8:{s:8:\"template\";s:4:\"node\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/templates/node\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:24:\"template_preprocess_node\";i:3;s:21:\"contextual_preprocess\";i:4;s:19:\"rdf_preprocess_node\";i:5;s:21:\"omega_preprocess_node\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:59:\"sites/all/themes/omega/omega/preprocess/node.preprocess.inc\";}}s:6:\"region\";a:8:{s:8:\"template\";s:6:\"region\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:26:\"template_preprocess_region\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"omega_preprocess_region\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:61:\"sites/all/themes/omega/omega/preprocess/region.preprocess.inc\";}}s:17:\"user_profile_item\";a:8:{s:8:\"template\";s:17:\"user-profile-item\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/templates/user\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:14:\"render element\";s:7:\"element\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:37:\"template_preprocess_user_profile_item\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:12:\"user_profile\";a:8:{s:8:\"template\";s:12:\"user-profile\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/templates/user\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:32:\"template_preprocess_user_profile\";i:3;s:21:\"contextual_preprocess\";i:4;s:27:\"rdf_preprocess_user_profile\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:21:\"user_profile_category\";a:8:{s:8:\"template\";s:21:\"user-profile-category\";s:4:\"path\";s:43:\"sites/all/themes/omega/omega/templates/user\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:2:{i:0;s:27:\"modules/user/user.pages.inc\";i:1;s:76:\"sites/all/themes/omega/omega/preprocess/user-profile-category.preprocess.inc\";}s:14:\"render element\";s:7:\"element\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:41:\"template_preprocess_user_profile_category\";i:3;s:21:\"contextual_preprocess\";i:4;s:38:\"omega_preprocess_user_profile_category\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:13:\"search_result\";a:8:{s:8:\"template\";s:13:\"search-result\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/search\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:9:\"variables\";a:2:{s:6:\"result\";N;s:6:\"module\";N;}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:33:\"template_preprocess_search_result\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:14:\"search_results\";a:8:{s:8:\"template\";s:14:\"search-results\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/search\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:9:\"variables\";a:2:{s:7:\"results\";N;s:6:\"module\";N;}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:34:\"template_preprocess_search_results\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:4:\"page\";a:8:{s:8:\"template\";s:4:\"page\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/system\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:7:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:24:\"template_preprocess_page\";i:3;s:21:\"contextual_preprocess\";i:4;s:24:\"shortcut_preprocess_page\";i:5;s:21:\"omega_preprocess_page\";i:6;s:28:\"raptor_omega_preprocess_page\";}s:17:\"process functions\";a:6:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:21:\"template_process_page\";i:3;s:11:\"rdf_process\";i:4;s:18:\"omega_process_page\";i:5;s:25:\"raptor_omega_process_page\";}s:8:\"includes\";a:4:{i:0;s:53:\"sites/all/themes/omega/omega/process/page.process.inc\";i:1;s:59:\"sites/all/themes/omega/omega/preprocess/page.preprocess.inc\";i:2;s:54:\"sites/all/themes/raptor_omega/process/page.process.inc\";i:3;s:60:\"sites/all/themes/raptor_omega/preprocess/page.preprocess.inc\";}}s:16:\"maintenance_page\";a:7:{s:8:\"template\";s:16:\"maintenance-page\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/system\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:36:\"template_preprocess_maintenance_page\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:33:\"template_process_maintenance_page\";i:3;s:11:\"rdf_process\";}}s:4:\"html\";a:10:{s:8:\"template\";s:4:\"html\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/system\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:24:\"template_preprocess_html\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"toolbar_preprocess_html\";i:5;s:21:\"omega_preprocess_html\";i:6;s:45:\"omega_extension_compatibility_preprocess_html\";i:7;s:39:\"omega_extension_assets_attach_libraries\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:36:\"omega_template_process_html_override\";i:3;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:59:\"sites/all/themes/omega/omega/preprocess/html.preprocess.inc\";}s:16:\"apple-touch-icon\";a:4:{s:61:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed.png\";a:3:{s:3:\"uri\";s:61:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";b:0;}s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-114x114.png\";a:3:{s:3:\"uri\";s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-114x114.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:7:\"114x114\";}s:67:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-72x72.png\";a:3:{s:3:\"uri\";s:67:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-72x72.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:5:\"72x72\";}s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-144x144.png\";a:3:{s:3:\"uri\";s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-144x144.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:7:\"144x144\";}}s:9:\"libraries\";a:4:{s:11:\"selectivizr\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:1:{s:19:\"/selectivizr.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:110;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";b:0;s:4:\"path\";N;}s:7:\"respond\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:1:{s:15:\"/respond.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:120;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";a:1:{i:0;s:51:\"omega_extension_assets_requirements_css_aggregation\";}s:4:\"path\";N;}s:3:\"pie\";a:4:{s:8:\"attached\";a:0:{}s:8:\"settings\";a:2:{s:6:\"status\";i:1;s:9:\"selectors\";a:0:{}}s:9:\"callbacks\";a:1:{i:0;s:41:\"omega_extension_assets_load_pie_selectors\";}s:4:\"path\";N;}s:9:\"html5shiv\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:2:{s:17:\"/html5shiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}s:27:\"/html5shiv-printshiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";b:0;s:4:\"path\";N;}}}s:7:\"comment\";a:8:{s:8:\"template\";s:7:\"comment\";s:4:\"path\";s:46:\"sites/all/themes/omega/omega/templates/comment\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:27:\"template_preprocess_comment\";i:3;s:21:\"contextual_preprocess\";i:4;s:22:\"rdf_preprocess_comment\";i:5;s:24:\"omega_preprocess_comment\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:62:\"sites/all/themes/omega/omega/preprocess/comment.preprocess.inc\";}}s:15:\"comment_wrapper\";a:8:{s:8:\"template\";s:15:\"comment-wrapper\";s:4:\"path\";s:46:\"sites/all/themes/omega/omega/templates/comment\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:7:\"content\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:35:\"template_preprocess_comment_wrapper\";i:3;s:21:\"contextual_preprocess\";i:4;s:32:\"omega_preprocess_comment_wrapper\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";i:3;s:29:\"omega_process_comment_wrapper\";}s:8:\"includes\";a:2:{i:0;s:64:\"sites/all/themes/omega/omega/process/comment-wrapper.process.inc\";i:1;s:70:\"sites/all/themes/omega/omega/preprocess/comment-wrapper.preprocess.inc\";}}s:15:\"region__minimal\";a:6:{s:8:\"template\";s:15:\"region--minimal\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/region\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:6:\"region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:15:\"region__sidebar\";a:6:{s:8:\"template\";s:15:\"region--sidebar\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/region\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:6:\"region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:10:\"block__nav\";a:6:{s:8:\"template\";s:10:\"block--nav\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:14:\"block__minimal\";a:6:{s:8:\"template\";s:14:\"block--minimal\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:12:\"user_picture\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:8:\"template\";s:25:\"modules/user/user-picture\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:32:\"template_preprocess_user_picture\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:9:\"user_list\";a:4:{s:9:\"variables\";a:2:{s:5:\"users\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:15:\"theme_user_list\";}s:22:\"user_admin_permissions\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:28:\"theme_user_admin_permissions\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:16:\"user_admin_roles\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:22:\"theme_user_admin_roles\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:27:\"user_permission_description\";a:6:{s:9:\"variables\";a:2:{s:15:\"permission_item\";N;s:4:\"hide\";N;}s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:33:\"theme_user_permission_description\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:14:\"user_signature\";a:4:{s:9:\"variables\";a:1:{s:9:\"signature\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:20:\"theme_user_signature\";}s:7:\"toolbar\";a:7:{s:14:\"render element\";s:7:\"toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:15:\"modules/toolbar\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";i:3;s:26:\"toolbar_preprocess_toolbar\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:14:\"toolbar_toggle\";a:4:{s:9:\"variables\";a:2:{s:9:\"collapsed\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:8:\"function\";s:20:\"theme_toolbar_toggle\";}s:30:\"taxonomy_overview_vocabularies\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:36:\"theme_taxonomy_overview_vocabularies\";}s:23:\"taxonomy_overview_terms\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:29:\"theme_taxonomy_overview_terms\";}s:15:\"status_messages\";a:5:{s:9:\"variables\";a:1:{s:7:\"display\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:21:\"omega_status_messages\";s:8:\"includes\";a:1:{i:0;s:60:\"sites/all/themes/omega/omega/theme/status-messages.theme.inc\";}}s:4:\"link\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:4:\"path\";N;s:7:\"options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_link\";}s:5:\"links\";a:6:{s:9:\"variables\";a:3:{s:5:\"links\";N;s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_links\";s:20:\"preprocess functions\";a:1:{i:0;s:22:\"omega_preprocess_links\";}s:8:\"includes\";a:1:{i:0;s:60:\"sites/all/themes/omega/omega/preprocess/links.preprocess.inc\";}}s:5:\"image\";a:5:{s:9:\"variables\";a:6:{s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_image\";s:20:\"preprocess functions\";a:1:{i:0;s:20:\"rdf_preprocess_image\";}}s:10:\"breadcrumb\";a:5:{s:9:\"variables\";a:1:{s:10:\"breadcrumb\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:16:\"omega_breadcrumb\";s:8:\"includes\";a:1:{i:0;s:55:\"sites/all/themes/omega/omega/theme/breadcrumb.theme.inc\";}}s:4:\"help\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_help\";}s:5:\"table\";a:4:{s:9:\"variables\";a:7:{s:6:\"header\";N;s:4:\"rows\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_table\";}s:19:\"tablesort_indicator\";a:4:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_tablesort_indicator\";}s:4:\"mark\";a:5:{s:9:\"variables\";a:1:{s:4:\"type\";i:1;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:10:\"omega_mark\";s:8:\"includes\";a:1:{i:0;s:49:\"sites/all/themes/omega/omega/theme/mark.theme.inc\";}}s:9:\"item_list\";a:5:{s:9:\"variables\";a:4:{s:5:\"items\";a:0:{}s:5:\"title\";N;s:4:\"type\";s:2:\"ul\";s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:15:\"omega_item_list\";s:8:\"includes\";a:1:{i:0;s:54:\"sites/all/themes/omega/omega/theme/item-list.theme.inc\";}}s:14:\"more_help_link\";a:5:{s:9:\"variables\";a:1:{s:3:\"url\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:20:\"omega_more_help_link\";s:8:\"includes\";a:1:{i:0;s:59:\"sites/all/themes/omega/omega/theme/more-help-link.theme.inc\";}}s:9:\"feed_icon\";a:4:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_feed_icon\";}s:9:\"more_link\";a:4:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_more_link\";}s:8:\"username\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_username\";s:20:\"preprocess functions\";a:2:{i:0;s:28:\"template_preprocess_username\";i:1;s:23:\"rdf_preprocess_username\";}s:17:\"process functions\";a:1:{i:0;s:25:\"template_process_username\";}}s:12:\"progress_bar\";a:4:{s:9:\"variables\";a:2:{s:7:\"percent\";N;s:7:\"message\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_progress_bar\";}s:11:\"indentation\";a:4:{s:9:\"variables\";a:1:{s:4:\"size\";i:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_indentation\";}s:8:\"html_tag\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_html_tag\";s:17:\"process functions\";a:1:{i:0;s:22:\"omega_process_html_tag\";}s:8:\"includes\";a:1:{i:0;s:57:\"sites/all/themes/omega/omega/process/html-tag.process.inc\";}}s:11:\"update_page\";a:4:{s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_update_page\";}s:12:\"install_page\";a:4:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_install_page\";}s:9:\"task_list\";a:4:{s:9:\"variables\";a:2:{s:5:\"items\";N;s:6:\"active\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_task_list\";}s:17:\"authorize_message\";a:4:{s:9:\"variables\";a:2:{s:7:\"message\";N;s:7:\"success\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_authorize_message\";}s:16:\"authorize_report\";a:4:{s:9:\"variables\";a:1:{s:8:\"messages\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_authorize_report\";}s:5:\"pager\";a:5:{s:9:\"variables\";a:4:{s:4:\"tags\";a:0:{}s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}s:8:\"quantity\";i:9;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:11:\"omega_pager\";s:8:\"includes\";a:1:{i:0;s:50:\"sites/all/themes/omega/omega/theme/pager.theme.inc\";}}s:11:\"pager_first\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_pager_first\";}s:14:\"pager_previous\";a:4:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:20:\"theme_pager_previous\";}s:10:\"pager_next\";a:4:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_next\";}s:10:\"pager_last\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_last\";}s:10:\"pager_link\";a:4:{s:9:\"variables\";a:5:{s:4:\"text\";N;s:8:\"page_new\";N;s:7:\"element\";N;s:10:\"parameters\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_link\";}s:9:\"menu_link\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_link\";}s:9:\"menu_tree\";a:5:{s:14:\"render element\";s:4:\"tree\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_tree\";s:20:\"preprocess functions\";a:1:{i:0;s:29:\"template_preprocess_menu_tree\";}}s:15:\"menu_local_task\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_menu_local_task\";}s:17:\"menu_local_action\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_menu_local_action\";}s:16:\"menu_local_tasks\";a:5:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:22:\"omega_menu_local_tasks\";s:8:\"includes\";a:1:{i:0;s:61:\"sites/all/themes/omega/omega/theme/menu-local-tasks.theme.inc\";}}s:6:\"select\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_select\";}s:8:\"fieldset\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_fieldset\";}s:5:\"radio\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_radio\";}s:6:\"radios\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_radios\";}s:4:\"date\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_date\";}s:15:\"exposed_filters\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_exposed_filters\";}s:8:\"checkbox\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_checkbox\";}s:10:\"checkboxes\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_checkboxes\";}s:6:\"button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_button\";}s:12:\"image_button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_image_button\";}s:6:\"hidden\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_hidden\";}s:9:\"textfield\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_textfield\";}s:4:\"form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_form\";}s:8:\"textarea\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_textarea\";}s:8:\"password\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_password\";}s:4:\"file\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_file\";}s:11:\"tableselect\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_tableselect\";}s:12:\"form_element\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_form_element\";}s:20:\"form_required_marker\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_form_required_marker\";}s:18:\"form_element_label\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_form_element_label\";}s:13:\"vertical_tabs\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_vertical_tabs\";}s:9:\"container\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_container\";}s:18:\"system_themes_page\";a:6:{s:9:\"variables\";a:1:{s:12:\"theme_groups\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:24:\"omega_system_themes_page\";s:8:\"includes\";a:2:{i:0;s:31:\"modules/system/system.admin.inc\";i:1;s:63:\"sites/all/themes/omega/omega/theme/system-themes-page.theme.inc\";}}s:20:\"system_settings_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_system_settings_form\";}s:12:\"confirm_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_confirm_form\";}s:23:\"system_modules_fieldset\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:29:\"theme_system_modules_fieldset\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:27:\"system_modules_incompatible\";a:6:{s:9:\"variables\";a:1:{s:7:\"message\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:33:\"theme_system_modules_incompatible\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:24:\"system_modules_uninstall\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:30:\"theme_system_modules_uninstall\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:13:\"status_report\";a:6:{s:14:\"render element\";s:12:\"requirements\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_status_report\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:10:\"admin_page\";a:6:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_admin_page\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:11:\"admin_block\";a:6:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:17:\"omega_admin_block\";s:8:\"includes\";a:2:{i:0;s:31:\"modules/system/system.admin.inc\";i:1;s:56:\"sites/all/themes/omega/omega/theme/admin-block.theme.inc\";}}s:19:\"admin_block_content\";a:6:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_admin_block_content\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:18:\"system_admin_index\";a:6:{s:9:\"variables\";a:1:{s:10:\"menu_items\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_system_admin_index\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:17:\"system_powered_by\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_system_powered_by\";}s:19:\"system_compact_link\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_system_compact_link\";}s:25:\"system_date_time_settings\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:31:\"theme_system_date_time_settings\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:22:\"shortcut_set_customize\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:18:\"shortcut.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/shortcut\";s:8:\"function\";s:28:\"theme_shortcut_set_customize\";s:8:\"includes\";a:1:{i:0;s:35:\"modules/shortcut/shortcut.admin.inc\";}}s:17:\"search_block_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:8:\"template\";s:32:\"modules/search/search-block-form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:37:\"template_preprocess_search_block_form\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:29:\"rdf_template_variable_wrapper\";a:4:{s:9:\"variables\";a:4:{s:7:\"content\";N;s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:6:\"inline\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:35:\"theme_rdf_template_variable_wrapper\";}s:12:\"rdf_metadata\";a:4:{s:9:\"variables\";a:1:{s:8:\"metadata\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:18:\"theme_rdf_metadata\";}s:12:\"options_none\";a:4:{s:9:\"variables\";a:2:{s:8:\"instance\";N;s:6:\"option\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:29:\"modules/field/modules/options\";s:8:\"function\";s:18:\"theme_options_none\";}s:17:\"node_search_admin\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_search_admin\";}s:13:\"node_add_list\";a:6:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"file\";s:14:\"node.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:19:\"theme_node_add_list\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}}s:12:\"node_preview\";a:6:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"file\";s:14:\"node.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:18:\"theme_node_preview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}}s:19:\"node_admin_overview\";a:6:{s:9:\"variables\";a:2:{s:4:\"name\";N;s:4:\"type\";N;}s:4:\"file\";s:17:\"content_types.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_admin_overview\";s:8:\"includes\";a:1:{i:0;s:30:\"modules/node/content_types.inc\";}}s:17:\"node_recent_block\";a:4:{s:9:\"variables\";a:1:{s:5:\"nodes\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_recent_block\";}s:19:\"node_recent_content\";a:4:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_recent_content\";}s:18:\"menu_overview_form\";a:6:{s:4:\"file\";s:14:\"menu.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:24:\"theme_menu_overview_form\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}}s:19:\"menu_admin_overview\";a:6:{s:4:\"file\";s:14:\"menu.admin.inc\";s:9:\"variables\";a:3:{s:5:\"title\";N;s:4:\"name\";N;s:11:\"description\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:25:\"theme_menu_admin_overview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}}s:11:\"image_style\";a:4:{s:9:\"variables\";a:7:{s:10:\"style_name\";N;s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:17:\"theme_image_style\";}s:16:\"image_style_list\";a:4:{s:9:\"variables\";a:1:{s:6:\"styles\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:22:\"theme_image_style_list\";}s:19:\"image_style_effects\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_style_effects\";}s:19:\"image_style_preview\";a:5:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:25:\"omega_image_style_preview\";s:8:\"includes\";a:1:{i:0;s:64:\"sites/all/themes/omega/omega/theme/image-style-preview.theme.inc\";}}s:12:\"image_anchor\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_anchor\";}s:20:\"image_resize_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_resize_summary\";}s:19:\"image_scale_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_scale_summary\";}s:18:\"image_crop_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:24:\"theme_image_crop_summary\";}s:20:\"image_rotate_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_rotate_summary\";}s:12:\"image_widget\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_widget\";}s:15:\"image_formatter\";a:4:{s:9:\"variables\";a:3:{s:4:\"item\";N;s:4:\"path\";N;s:11:\"image_style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:21:\"theme_image_formatter\";}s:21:\"filter_admin_overview\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_admin_overview\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}}s:32:\"filter_admin_format_filter_order\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:38:\"theme_filter_admin_format_filter_order\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}}s:11:\"filter_tips\";a:6:{s:9:\"variables\";a:2:{s:4:\"tips\";N;s:4:\"long\";b:0;}s:4:\"file\";s:16:\"filter.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:17:\"theme_filter_tips\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.pages.inc\";}}s:19:\"text_format_wrapper\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:25:\"theme_text_format_wrapper\";}s:21:\"filter_tips_more_info\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_tips_more_info\";}s:17:\"filter_guidelines\";a:4:{s:9:\"variables\";a:1:{s:6:\"format\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:23:\"theme_filter_guidelines\";}s:9:\"file_link\";a:4:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_link\";}s:9:\"file_icon\";a:4:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_icon\";}s:17:\"file_managed_file\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:23:\"theme_file_managed_file\";}s:11:\"file_widget\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:17:\"theme_file_widget\";}s:20:\"file_widget_multiple\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_widget_multiple\";}s:20:\"file_formatter_table\";a:4:{s:9:\"variables\";a:1:{s:5:\"items\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_formatter_table\";}s:16:\"file_upload_help\";a:4:{s:9:\"variables\";a:2:{s:11:\"description\";N;s:17:\"upload_validators\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:22:\"theme_file_upload_help\";}s:14:\"field_ui_table\";a:4:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/field_ui\";s:8:\"function\";s:20:\"theme_field_ui_table\";}s:5:\"field\";a:7:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:11:\"omega_field\";s:20:\"preprocess functions\";a:3:{i:0;s:25:\"template_preprocess_field\";i:1;s:20:\"rdf_preprocess_field\";i:2;s:22:\"omega_preprocess_field\";}s:17:\"process functions\";a:1:{i:0;s:22:\"template_process_field\";}s:8:\"includes\";a:2:{i:0;s:60:\"sites/all/themes/omega/omega/preprocess/field.preprocess.inc\";i:1;s:50:\"sites/all/themes/omega/omega/theme/field.theme.inc\";}}s:25:\"field_multiple_value_form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/field\";s:8:\"function\";s:31:\"theme_field_multiple_value_form\";}s:13:\"dblog_message\";a:6:{s:9:\"variables\";a:2:{s:5:\"event\";N;s:4:\"link\";b:0;}s:4:\"file\";s:15:\"dblog.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/dblog\";s:8:\"function\";s:19:\"theme_dblog_message\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/dblog/dblog.admin.inc\";}}s:9:\"dashboard\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:15:\"theme_dashboard\";}s:15:\"dashboard_admin\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:21:\"theme_dashboard_admin\";}s:16:\"dashboard_region\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:22:\"theme_dashboard_region\";}s:25:\"dashboard_disabled_blocks\";a:4:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:31:\"theme_dashboard_disabled_blocks\";}s:24:\"dashboard_disabled_block\";a:4:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:30:\"theme_dashboard_disabled_block\";}s:28:\"dashboard_admin_display_form\";a:9:{s:8:\"template\";s:24:\"block-admin-display-form\";s:4:\"path\";s:13:\"modules/block\";s:4:\"file\";s:15:\"block.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/block/block.admin.inc\";}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:48:\"template_preprocess_dashboard_admin_display_form\";i:3;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:13:\"comment_block\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:19:\"theme_comment_block\";}s:15:\"comment_preview\";a:4:{s:9:\"variables\";a:1:{s:7:\"comment\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:21:\"theme_comment_preview\";}s:22:\"comment_post_forbidden\";a:4:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:28:\"theme_comment_post_forbidden\";}s:17:\"color_scheme_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/color\";s:8:\"function\";s:23:\"theme_color_scheme_form\";}}',0,1454111015,1),('theme_registry:runtime:raptor_omega','a:160:{s:15:\"protocol_layout\";N;s:14:\"supinfo_layout\";N;s:15:\"worklist_layout\";a:6:{s:8:\"template\";s:15:\"worklist-layout\";s:4:\"path\";s:46:\"sites/all/themes/raptor_omega/layouts/worklist\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:12:\"login_layout\";a:6:{s:8:\"template\";s:12:\"login-layout\";s:4:\"path\";s:43:\"sites/all/themes/raptor_omega/layouts/login\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:29:\"sites/all/themes/raptor_omega\";s:20:\"preprocess functions\";a:2:{i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:4:{i:0;s:42:\"_omega_preprocess_default_layout_variables\";i:1;s:24:\"omega_cleanup_attributes\";i:2;s:16:\"template_process\";i:3;s:11:\"rdf_process\";}}s:12:\"admin_layout\";N;s:12:\"omega_chrome\";N;s:17:\"omega_page_layout\";a:4:{s:9:\"base hook\";s:4:\"page\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:23:\"theme_omega_page_layout\";}s:11:\"hero_layout\";N;s:17:\"off_canvas_layout\";N;s:13:\"simple_layout\";N;s:13:\"divine_layout\";N;s:24:\"block_admin_display_form\";N;s:5:\"block\";a:8:{s:8:\"template\";s:5:\"block\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:25:\"template_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"system_preprocess_block\";i:5;s:22:\"omega_preprocess_block\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";i:3;s:19:\"omega_process_block\";}s:8:\"includes\";a:2:{i:0;s:54:\"sites/all/themes/omega/omega/process/block.process.inc\";i:1;s:60:\"sites/all/themes/omega/omega/preprocess/block.preprocess.inc\";}}s:13:\"taxonomy_term\";N;s:4:\"node\";N;s:6:\"region\";a:8:{s:8:\"template\";s:6:\"region\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:8:\"elements\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:26:\"template_preprocess_region\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"omega_preprocess_region\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:61:\"sites/all/themes/omega/omega/preprocess/region.preprocess.inc\";}}s:17:\"user_profile_item\";N;s:12:\"user_profile\";N;s:21:\"user_profile_category\";N;s:13:\"search_result\";N;s:14:\"search_results\";N;s:4:\"page\";a:8:{s:8:\"template\";s:4:\"page\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/system\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:7:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:24:\"template_preprocess_page\";i:3;s:21:\"contextual_preprocess\";i:4;s:24:\"shortcut_preprocess_page\";i:5;s:21:\"omega_preprocess_page\";i:6;s:28:\"raptor_omega_preprocess_page\";}s:17:\"process functions\";a:6:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:21:\"template_process_page\";i:3;s:11:\"rdf_process\";i:4;s:18:\"omega_process_page\";i:5;s:25:\"raptor_omega_process_page\";}s:8:\"includes\";a:4:{i:0;s:53:\"sites/all/themes/omega/omega/process/page.process.inc\";i:1;s:59:\"sites/all/themes/omega/omega/preprocess/page.preprocess.inc\";i:2;s:54:\"sites/all/themes/raptor_omega/process/page.process.inc\";i:3;s:60:\"sites/all/themes/raptor_omega/preprocess/page.preprocess.inc\";}}s:16:\"maintenance_page\";N;s:4:\"html\";a:10:{s:8:\"template\";s:4:\"html\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/system\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:24:\"template_preprocess_html\";i:3;s:21:\"contextual_preprocess\";i:4;s:23:\"toolbar_preprocess_html\";i:5;s:21:\"omega_preprocess_html\";i:6;s:45:\"omega_extension_compatibility_preprocess_html\";i:7;s:39:\"omega_extension_assets_attach_libraries\";}s:17:\"process functions\";a:4:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:36:\"omega_template_process_html_override\";i:3;s:11:\"rdf_process\";}s:8:\"includes\";a:1:{i:0;s:59:\"sites/all/themes/omega/omega/preprocess/html.preprocess.inc\";}s:16:\"apple-touch-icon\";a:4:{s:61:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed.png\";a:3:{s:3:\"uri\";s:61:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";b:0;}s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-114x114.png\";a:3:{s:3:\"uri\";s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-114x114.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:7:\"114x114\";}s:67:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-72x72.png\";a:3:{s:3:\"uri\";s:67:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-72x72.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:5:\"72x72\";}s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-144x144.png\";a:3:{s:3:\"uri\";s:69:\"sites/all/themes/omega/omega/apple-touch-icon-precomposed-144x144.png\";s:11:\"precomposed\";b:1;s:5:\"sizes\";s:7:\"144x144\";}}s:9:\"libraries\";a:4:{s:11:\"selectivizr\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:1:{s:19:\"/selectivizr.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:110;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";b:0;s:4:\"path\";N;}s:7:\"respond\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:1:{s:15:\"/respond.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:120;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";a:1:{i:0;s:51:\"omega_extension_assets_requirements_css_aggregation\";}s:4:\"path\";N;}s:3:\"pie\";a:4:{s:8:\"attached\";a:0:{}s:8:\"settings\";a:2:{s:6:\"status\";i:1;s:9:\"selectors\";a:0:{}}s:9:\"callbacks\";a:1:{i:0;s:41:\"omega_extension_assets_load_pie_selectors\";}s:4:\"path\";N;}s:9:\"html5shiv\";a:4:{s:8:\"attached\";a:1:{s:2:\"js\";a:2:{s:17:\"/html5shiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}s:27:\"/html5shiv-printshiv.min.js\";a:3:{s:8:\"browsers\";a:2:{s:2:\"IE\";s:21:\"(gte IE 6)&(lte IE 8)\";s:3:\"!IE\";b:0;}s:6:\"weight\";i:100;s:10:\"every_page\";b:1;}}}s:8:\"settings\";a:1:{s:6:\"status\";i:1;}s:9:\"callbacks\";b:0;s:4:\"path\";N;}}}s:7:\"comment\";N;s:15:\"comment_wrapper\";N;s:15:\"region__minimal\";a:6:{s:8:\"template\";s:15:\"region--minimal\";s:4:\"path\";s:45:\"sites/all/themes/omega/omega/templates/region\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:6:\"region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:15:\"region__sidebar\";N;s:10:\"block__nav\";N;s:14:\"block__minimal\";a:6:{s:8:\"template\";s:14:\"block--minimal\";s:4:\"path\";s:44:\"sites/all/themes/omega/omega/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";}s:12:\"user_picture\";N;s:9:\"user_list\";N;s:22:\"user_admin_permissions\";N;s:16:\"user_admin_roles\";N;s:27:\"user_permission_description\";N;s:14:\"user_signature\";N;s:7:\"toolbar\";a:7:{s:14:\"render element\";s:7:\"toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:15:\"modules/toolbar\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"omega_initialize_attributes\";i:2;s:21:\"contextual_preprocess\";i:3;s:26:\"toolbar_preprocess_toolbar\";}s:17:\"process functions\";a:3:{i:0;s:24:\"omega_cleanup_attributes\";i:1;s:16:\"template_process\";i:2;s:11:\"rdf_process\";}}s:14:\"toolbar_toggle\";a:4:{s:9:\"variables\";a:2:{s:9:\"collapsed\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:8:\"function\";s:20:\"theme_toolbar_toggle\";}s:30:\"taxonomy_overview_vocabularies\";N;s:23:\"taxonomy_overview_terms\";N;s:15:\"status_messages\";a:5:{s:9:\"variables\";a:1:{s:7:\"display\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:21:\"omega_status_messages\";s:8:\"includes\";a:1:{i:0;s:60:\"sites/all/themes/omega/omega/theme/status-messages.theme.inc\";}}s:4:\"link\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:4:\"path\";N;s:7:\"options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_link\";}s:5:\"links\";a:6:{s:9:\"variables\";a:3:{s:5:\"links\";N;s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_links\";s:20:\"preprocess functions\";a:1:{i:0;s:22:\"omega_preprocess_links\";}s:8:\"includes\";a:1:{i:0;s:60:\"sites/all/themes/omega/omega/preprocess/links.preprocess.inc\";}}s:5:\"image\";a:5:{s:9:\"variables\";a:6:{s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_image\";s:20:\"preprocess functions\";a:1:{i:0;s:20:\"rdf_preprocess_image\";}}s:10:\"breadcrumb\";a:5:{s:9:\"variables\";a:1:{s:10:\"breadcrumb\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:16:\"omega_breadcrumb\";s:8:\"includes\";a:1:{i:0;s:55:\"sites/all/themes/omega/omega/theme/breadcrumb.theme.inc\";}}s:4:\"help\";N;s:5:\"table\";N;s:19:\"tablesort_indicator\";N;s:4:\"mark\";N;s:9:\"item_list\";a:5:{s:9:\"variables\";a:4:{s:5:\"items\";a:0:{}s:5:\"title\";N;s:4:\"type\";s:2:\"ul\";s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:15:\"omega_item_list\";s:8:\"includes\";a:1:{i:0;s:54:\"sites/all/themes/omega/omega/theme/item-list.theme.inc\";}}s:14:\"more_help_link\";N;s:9:\"feed_icon\";a:4:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_feed_icon\";}s:9:\"more_link\";N;s:8:\"username\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";N;s:8:\"html_tag\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_html_tag\";s:17:\"process functions\";a:1:{i:0;s:22:\"omega_process_html_tag\";}s:8:\"includes\";a:1:{i:0;s:57:\"sites/all/themes/omega/omega/process/html-tag.process.inc\";}}s:11:\"update_page\";N;s:12:\"install_page\";N;s:9:\"task_list\";N;s:17:\"authorize_message\";N;s:16:\"authorize_report\";N;s:5:\"pager\";N;s:11:\"pager_first\";N;s:14:\"pager_previous\";N;s:10:\"pager_next\";N;s:10:\"pager_last\";N;s:10:\"pager_link\";N;s:9:\"menu_link\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_link\";}s:9:\"menu_tree\";a:5:{s:14:\"render element\";s:4:\"tree\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_tree\";s:20:\"preprocess functions\";a:1:{i:0;s:29:\"template_preprocess_menu_tree\";}}s:15:\"menu_local_task\";N;s:17:\"menu_local_action\";N;s:16:\"menu_local_tasks\";a:5:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:28:\"sites/all/themes/omega/omega\";s:8:\"function\";s:22:\"omega_menu_local_tasks\";s:8:\"includes\";a:1:{i:0;s:61:\"sites/all/themes/omega/omega/theme/menu-local-tasks.theme.inc\";}}s:6:\"select\";N;s:8:\"fieldset\";N;s:5:\"radio\";N;s:6:\"radios\";N;s:4:\"date\";N;s:15:\"exposed_filters\";N;s:8:\"checkbox\";N;s:10:\"checkboxes\";N;s:6:\"button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_button\";}s:12:\"image_button\";N;s:6:\"hidden\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_hidden\";}s:9:\"textfield\";N;s:4:\"form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_form\";}s:8:\"textarea\";N;s:8:\"password\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_password\";}s:4:\"file\";N;s:11:\"tableselect\";N;s:12:\"form_element\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_form_element\";}s:20:\"form_required_marker\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_form_required_marker\";}s:18:\"form_element_label\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_form_element_label\";}s:13:\"vertical_tabs\";N;s:9:\"container\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_container\";}s:18:\"system_themes_page\";N;s:20:\"system_settings_form\";N;s:12:\"confirm_form\";N;s:23:\"system_modules_fieldset\";N;s:27:\"system_modules_incompatible\";N;s:24:\"system_modules_uninstall\";N;s:13:\"status_report\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:18:\"system_admin_index\";N;s:17:\"system_powered_by\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_system_powered_by\";}s:19:\"system_compact_link\";N;s:25:\"system_date_time_settings\";N;s:22:\"shortcut_set_customize\";N;s:17:\"search_block_form\";N;s:29:\"rdf_template_variable_wrapper\";N;s:12:\"rdf_metadata\";N;s:12:\"options_none\";N;s:17:\"node_search_admin\";N;s:13:\"node_add_list\";N;s:12:\"node_preview\";N;s:19:\"node_admin_overview\";N;s:17:\"node_recent_block\";N;s:19:\"node_recent_content\";N;s:18:\"menu_overview_form\";N;s:19:\"menu_admin_overview\";N;s:11:\"image_style\";N;s:16:\"image_style_list\";N;s:19:\"image_style_effects\";N;s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";N;s:15:\"image_formatter\";N;s:21:\"filter_admin_overview\";N;s:32:\"filter_admin_format_filter_order\";N;s:11:\"filter_tips\";N;s:19:\"text_format_wrapper\";N;s:21:\"filter_tips_more_info\";N;s:17:\"filter_guidelines\";N;s:9:\"file_link\";N;s:9:\"file_icon\";N;s:17:\"file_managed_file\";N;s:11:\"file_widget\";N;s:20:\"file_widget_multiple\";N;s:20:\"file_formatter_table\";N;s:16:\"file_upload_help\";N;s:14:\"field_ui_table\";N;s:5:\"field\";N;s:25:\"field_multiple_value_form\";N;s:13:\"dblog_message\";N;s:9:\"dashboard\";N;s:15:\"dashboard_admin\";N;s:16:\"dashboard_region\";N;s:25:\"dashboard_disabled_blocks\";N;s:24:\"dashboard_disabled_block\";N;s:28:\"dashboard_admin_display_form\";N;s:13:\"comment_block\";N;s:15:\"comment_preview\";N;s:22:\"comment_post_forbidden\";N;s:17:\"color_scheme_form\";N;}',0,1454341313,1),('theme_registry:runtime:seven','a:145:{s:19:\"tablesort_indicator\";N;s:19:\"admin_block_content\";N;s:13:\"node_add_list\";N;s:16:\"maintenance_page\";N;s:4:\"page\";a:7:{s:8:\"template\";s:4:\"page\";s:4:\"path\";s:12:\"themes/seven\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:3;s:24:\"shortcut_preprocess_page\";i:4;s:21:\"seven_preprocess_page\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_page\";i:2;s:11:\"rdf_process\";}}s:12:\"user_picture\";N;s:12:\"user_profile\";N;s:21:\"user_profile_category\";N;s:17:\"user_profile_item\";N;s:9:\"user_list\";N;s:22:\"user_admin_permissions\";N;s:16:\"user_admin_roles\";N;s:27:\"user_permission_description\";N;s:14:\"user_signature\";N;s:7:\"toolbar\";a:7:{s:14:\"render element\";s:7:\"toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:15:\"modules/toolbar\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:26:\"toolbar_preprocess_toolbar\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:14:\"toolbar_toggle\";a:4:{s:9:\"variables\";a:2:{s:9:\"collapsed\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:8:\"function\";s:20:\"theme_toolbar_toggle\";}s:30:\"taxonomy_overview_vocabularies\";N;s:23:\"taxonomy_overview_terms\";N;s:13:\"taxonomy_term\";N;s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"page\";s:8:\"template\";s:19:\"modules/system/html\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"themes/seven\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"toolbar_preprocess_html\";i:4;s:21:\"seven_preprocess_html\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_html\";i:2;s:11:\"rdf_process\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:21:\"modules/system/region\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:15:\"status_messages\";a:4:{s:9:\"variables\";a:1:{s:7:\"display\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_status_messages\";}s:4:\"link\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:4:\"path\";N;s:7:\"options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_link\";}s:5:\"links\";a:4:{s:9:\"variables\";a:3:{s:5:\"links\";N;s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_links\";}s:5:\"image\";N;s:10:\"breadcrumb\";a:4:{s:9:\"variables\";a:1:{s:10:\"breadcrumb\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_breadcrumb\";}s:4:\"help\";N;s:5:\"table\";a:4:{s:9:\"variables\";a:7:{s:6:\"header\";N;s:4:\"rows\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_table\";}s:4:\"mark\";N;s:9:\"item_list\";a:4:{s:9:\"variables\";a:4:{s:5:\"items\";a:0:{}s:5:\"title\";N;s:4:\"type\";s:2:\"ul\";s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_item_list\";}s:14:\"more_help_link\";N;s:9:\"feed_icon\";N;s:9:\"more_link\";N;s:8:\"username\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";N;s:8:\"html_tag\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_html_tag\";}s:11:\"update_page\";N;s:12:\"install_page\";N;s:9:\"task_list\";N;s:17:\"authorize_message\";N;s:16:\"authorize_report\";N;s:5:\"pager\";N;s:11:\"pager_first\";N;s:14:\"pager_previous\";N;s:10:\"pager_next\";N;s:10:\"pager_last\";N;s:10:\"pager_link\";N;s:9:\"menu_link\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_link\";}s:9:\"menu_tree\";a:5:{s:14:\"render element\";s:4:\"tree\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_tree\";s:20:\"preprocess functions\";a:1:{i:0;s:29:\"template_preprocess_menu_tree\";}}s:15:\"menu_local_task\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_menu_local_task\";}s:17:\"menu_local_action\";N;s:16:\"menu_local_tasks\";a:4:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_menu_local_tasks\";}s:6:\"select\";N;s:8:\"fieldset\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_fieldset\";}s:5:\"radio\";N;s:6:\"radios\";N;s:4:\"date\";N;s:15:\"exposed_filters\";N;s:8:\"checkbox\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_checkbox\";}s:10:\"checkboxes\";N;s:6:\"button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_button\";}s:12:\"image_button\";N;s:6:\"hidden\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_hidden\";}s:9:\"textfield\";N;s:4:\"form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_form\";}s:8:\"textarea\";N;s:8:\"password\";N;s:4:\"file\";N;s:11:\"tableselect\";N;s:12:\"form_element\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_form_element\";}s:20:\"form_required_marker\";N;s:18:\"form_element_label\";N;s:13:\"vertical_tabs\";N;s:9:\"container\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_container\";}s:18:\"system_themes_page\";N;s:20:\"system_settings_form\";N;s:12:\"confirm_form\";N;s:23:\"system_modules_fieldset\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:29:\"theme_system_modules_fieldset\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:27:\"system_modules_incompatible\";N;s:24:\"system_modules_uninstall\";N;s:13:\"status_report\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:18:\"system_admin_index\";N;s:17:\"system_powered_by\";N;s:19:\"system_compact_link\";N;s:25:\"system_date_time_settings\";N;s:22:\"shortcut_set_customize\";N;s:17:\"search_block_form\";N;s:13:\"search_result\";N;s:14:\"search_results\";N;s:29:\"rdf_template_variable_wrapper\";N;s:12:\"rdf_metadata\";N;s:12:\"options_none\";N;s:4:\"node\";N;s:17:\"node_search_admin\";N;s:12:\"node_preview\";N;s:19:\"node_admin_overview\";N;s:17:\"node_recent_block\";N;s:19:\"node_recent_content\";N;s:18:\"menu_overview_form\";N;s:19:\"menu_admin_overview\";N;s:11:\"image_style\";N;s:16:\"image_style_list\";N;s:19:\"image_style_effects\";N;s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";N;s:15:\"image_formatter\";N;s:21:\"filter_admin_overview\";N;s:32:\"filter_admin_format_filter_order\";N;s:11:\"filter_tips\";N;s:19:\"text_format_wrapper\";N;s:21:\"filter_tips_more_info\";N;s:17:\"filter_guidelines\";N;s:9:\"file_link\";N;s:9:\"file_icon\";N;s:17:\"file_managed_file\";N;s:11:\"file_widget\";N;s:20:\"file_widget_multiple\";N;s:20:\"file_formatter_table\";N;s:16:\"file_upload_help\";N;s:14:\"field_ui_table\";N;s:5:\"field\";N;s:25:\"field_multiple_value_form\";N;s:13:\"dblog_message\";N;s:9:\"dashboard\";N;s:15:\"dashboard_admin\";N;s:16:\"dashboard_region\";N;s:25:\"dashboard_disabled_blocks\";N;s:24:\"dashboard_disabled_block\";N;s:28:\"dashboard_admin_display_form\";N;s:13:\"comment_block\";N;s:15:\"comment_preview\";N;s:7:\"comment\";N;s:22:\"comment_post_forbidden\";N;s:15:\"comment_wrapper\";N;s:17:\"color_scheme_form\";N;s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:19:\"modules/block/block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/block\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"system_preprocess_block\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:24:\"block_admin_display_form\";N;}',0,1443811944,1),('theme_registry:seven','a:145:{s:19:\"tablesort_indicator\";a:4:{s:8:\"function\";s:25:\"seven_tablesort_indicator\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:9:\"variables\";a:1:{s:5:\"style\";N;}}s:19:\"admin_block_content\";a:5:{s:8:\"function\";s:25:\"seven_admin_block_content\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}s:9:\"variables\";a:1:{s:7:\"content\";N;}}s:13:\"node_add_list\";a:5:{s:8:\"function\";s:19:\"seven_node_add_list\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}s:9:\"variables\";a:1:{s:7:\"content\";N;}}s:16:\"maintenance_page\";a:7:{s:8:\"template\";s:16:\"maintenance-page\";s:4:\"path\";s:12:\"themes/seven\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_maintenance_page\";i:2;s:21:\"contextual_preprocess\";i:3;s:33:\"seven_preprocess_maintenance_page\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:33:\"template_process_maintenance_page\";i:2;s:11:\"rdf_process\";}}s:4:\"page\";a:7:{s:8:\"template\";s:4:\"page\";s:4:\"path\";s:12:\"themes/seven\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:12:\"themes/seven\";s:14:\"render element\";s:4:\"page\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:3;s:24:\"shortcut_preprocess_page\";i:4;s:21:\"seven_preprocess_page\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_page\";i:2;s:11:\"rdf_process\";}}s:12:\"user_picture\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:8:\"template\";s:25:\"modules/user/user-picture\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_user_picture\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:12:\"user_profile\";a:8:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:25:\"modules/user/user-profile\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_user_profile\";i:2;s:21:\"contextual_preprocess\";i:3;s:27:\"rdf_preprocess_user_profile\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:21:\"user_profile_category\";a:8:{s:14:\"render element\";s:7:\"element\";s:8:\"template\";s:34:\"modules/user/user-profile-category\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:41:\"template_preprocess_user_profile_category\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"user_profile_item\";a:8:{s:14:\"render element\";s:7:\"element\";s:8:\"template\";s:30:\"modules/user/user-profile-item\";s:4:\"file\";s:14:\"user.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_user_profile_item\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:9:\"user_list\";a:4:{s:9:\"variables\";a:2:{s:5:\"users\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:15:\"theme_user_list\";}s:22:\"user_admin_permissions\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:28:\"theme_user_admin_permissions\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:16:\"user_admin_roles\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:22:\"theme_user_admin_roles\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:27:\"user_permission_description\";a:6:{s:9:\"variables\";a:2:{s:15:\"permission_item\";N;s:4:\"hide\";N;}s:4:\"file\";s:14:\"user.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:33:\"theme_user_permission_description\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/user/user.admin.inc\";}}s:14:\"user_signature\";a:4:{s:9:\"variables\";a:1:{s:9:\"signature\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/user\";s:8:\"function\";s:20:\"theme_user_signature\";}s:7:\"toolbar\";a:7:{s:14:\"render element\";s:7:\"toolbar\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:15:\"modules/toolbar\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:26:\"toolbar_preprocess_toolbar\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:14:\"toolbar_toggle\";a:4:{s:9:\"variables\";a:2:{s:9:\"collapsed\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/toolbar\";s:8:\"function\";s:20:\"theme_toolbar_toggle\";}s:30:\"taxonomy_overview_vocabularies\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:36:\"theme_taxonomy_overview_vocabularies\";}s:23:\"taxonomy_overview_terms\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:8:\"function\";s:29:\"theme_taxonomy_overview_terms\";}s:13:\"taxonomy_term\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:30:\"modules/taxonomy/taxonomy-term\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/taxonomy\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_taxonomy_term\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"rdf_preprocess_taxonomy_term\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"page\";s:8:\"template\";s:19:\"modules/system/html\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"themes/seven\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"toolbar_preprocess_html\";i:4;s:21:\"seven_preprocess_html\";}s:17:\"process functions\";a:3:{i:0;s:16:\"template_process\";i:1;s:21:\"template_process_html\";i:2;s:11:\"rdf_process\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:21:\"modules/system/region\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:15:\"status_messages\";a:4:{s:9:\"variables\";a:1:{s:7:\"display\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_status_messages\";}s:4:\"link\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:4:\"path\";N;s:7:\"options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_link\";}s:5:\"links\";a:4:{s:9:\"variables\";a:3:{s:5:\"links\";N;s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_links\";}s:5:\"image\";a:5:{s:9:\"variables\";a:6:{s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_image\";s:20:\"preprocess functions\";a:1:{i:0;s:20:\"rdf_preprocess_image\";}}s:10:\"breadcrumb\";a:4:{s:9:\"variables\";a:1:{s:10:\"breadcrumb\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_breadcrumb\";}s:4:\"help\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_help\";}s:5:\"table\";a:4:{s:9:\"variables\";a:7:{s:6:\"header\";N;s:4:\"rows\";N;s:10:\"attributes\";a:0:{}s:7:\"caption\";N;s:9:\"colgroups\";a:0:{}s:6:\"sticky\";b:1;s:5:\"empty\";s:0:\"\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_table\";}s:4:\"mark\";a:4:{s:9:\"variables\";a:1:{s:4:\"type\";i:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_mark\";}s:9:\"item_list\";a:4:{s:9:\"variables\";a:4:{s:5:\"items\";a:0:{}s:5:\"title\";N;s:4:\"type\";s:2:\"ul\";s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_item_list\";}s:14:\"more_help_link\";a:4:{s:9:\"variables\";a:1:{s:3:\"url\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:20:\"theme_more_help_link\";}s:9:\"feed_icon\";a:4:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_feed_icon\";}s:9:\"more_link\";a:4:{s:9:\"variables\";a:2:{s:3:\"url\";N;s:5:\"title\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_more_link\";}s:8:\"username\";a:6:{s:9:\"variables\";a:1:{s:7:\"account\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_username\";s:20:\"preprocess functions\";a:2:{i:0;s:28:\"template_preprocess_username\";i:1;s:23:\"rdf_preprocess_username\";}s:17:\"process functions\";a:1:{i:0;s:25:\"template_process_username\";}}s:12:\"progress_bar\";a:4:{s:9:\"variables\";a:2:{s:7:\"percent\";N;s:7:\"message\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_progress_bar\";}s:11:\"indentation\";a:4:{s:9:\"variables\";a:1:{s:4:\"size\";i:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_indentation\";}s:8:\"html_tag\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_html_tag\";}s:11:\"update_page\";a:4:{s:9:\"variables\";a:2:{s:7:\"content\";N;s:13:\"show_messages\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_update_page\";}s:12:\"install_page\";a:4:{s:9:\"variables\";a:1:{s:7:\"content\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_install_page\";}s:9:\"task_list\";a:4:{s:9:\"variables\";a:2:{s:5:\"items\";N;s:6:\"active\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_task_list\";}s:17:\"authorize_message\";a:4:{s:9:\"variables\";a:2:{s:7:\"message\";N;s:7:\"success\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_authorize_message\";}s:16:\"authorize_report\";a:4:{s:9:\"variables\";a:1:{s:8:\"messages\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_authorize_report\";}s:5:\"pager\";a:4:{s:9:\"variables\";a:4:{s:4:\"tags\";a:0:{}s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}s:8:\"quantity\";i:9;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_pager\";}s:11:\"pager_first\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_pager_first\";}s:14:\"pager_previous\";a:4:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:20:\"theme_pager_previous\";}s:10:\"pager_next\";a:4:{s:9:\"variables\";a:4:{s:4:\"text\";N;s:7:\"element\";i:0;s:8:\"interval\";i:1;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_next\";}s:10:\"pager_last\";a:4:{s:9:\"variables\";a:3:{s:4:\"text\";N;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_last\";}s:10:\"pager_link\";a:4:{s:9:\"variables\";a:5:{s:4:\"text\";N;s:8:\"page_new\";N;s:7:\"element\";N;s:10:\"parameters\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_pager_link\";}s:9:\"menu_link\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_link\";}s:9:\"menu_tree\";a:5:{s:14:\"render element\";s:4:\"tree\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_menu_tree\";s:20:\"preprocess functions\";a:1:{i:0;s:29:\"template_preprocess_menu_tree\";}}s:15:\"menu_local_task\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_menu_local_task\";}s:17:\"menu_local_action\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_menu_local_action\";}s:16:\"menu_local_tasks\";a:4:{s:9:\"variables\";a:2:{s:7:\"primary\";a:0:{}s:9:\"secondary\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:22:\"theme_menu_local_tasks\";}s:6:\"select\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_select\";}s:8:\"fieldset\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_fieldset\";}s:5:\"radio\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:11:\"theme_radio\";}s:6:\"radios\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_radios\";}s:4:\"date\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_date\";}s:15:\"exposed_filters\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:21:\"theme_exposed_filters\";}s:8:\"checkbox\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_checkbox\";}s:10:\"checkboxes\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_checkboxes\";}s:6:\"button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_button\";}s:12:\"image_button\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_image_button\";}s:6:\"hidden\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:12:\"theme_hidden\";}s:9:\"textfield\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_textfield\";}s:4:\"form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_form\";}s:8:\"textarea\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_textarea\";}s:8:\"password\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:14:\"theme_password\";}s:4:\"file\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:10:\"theme_file\";}s:11:\"tableselect\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_tableselect\";}s:12:\"form_element\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_form_element\";}s:20:\"form_required_marker\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_form_required_marker\";}s:18:\"form_element_label\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_form_element_label\";}s:13:\"vertical_tabs\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_vertical_tabs\";}s:9:\"container\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:15:\"theme_container\";}s:18:\"system_themes_page\";a:6:{s:9:\"variables\";a:1:{s:12:\"theme_groups\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_system_themes_page\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:20:\"system_settings_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:26:\"theme_system_settings_form\";}s:12:\"confirm_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:18:\"theme_confirm_form\";}s:23:\"system_modules_fieldset\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:29:\"theme_system_modules_fieldset\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:27:\"system_modules_incompatible\";a:6:{s:9:\"variables\";a:1:{s:7:\"message\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:33:\"theme_system_modules_incompatible\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:24:\"system_modules_uninstall\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:30:\"theme_system_modules_uninstall\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:13:\"status_report\";a:6:{s:14:\"render element\";s:12:\"requirements\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:19:\"theme_status_report\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:10:\"admin_page\";a:6:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:16:\"theme_admin_page\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:11:\"admin_block\";a:6:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:17:\"theme_admin_block\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:18:\"system_admin_index\";a:6:{s:9:\"variables\";a:1:{s:10:\"menu_items\";N;}s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:24:\"theme_system_admin_index\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:17:\"system_powered_by\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:23:\"theme_system_powered_by\";}s:19:\"system_compact_link\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:25:\"theme_system_compact_link\";}s:25:\"system_date_time_settings\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"system.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/system\";s:8:\"function\";s:31:\"theme_system_date_time_settings\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/system/system.admin.inc\";}}s:22:\"shortcut_set_customize\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:18:\"shortcut.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/shortcut\";s:8:\"function\";s:28:\"theme_shortcut_set_customize\";s:8:\"includes\";a:1:{i:0;s:35:\"modules/shortcut/shortcut.admin.inc\";}}s:17:\"search_block_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:8:\"template\";s:32:\"modules/search/search-block-form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_search_block_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:13:\"search_result\";a:8:{s:9:\"variables\";a:2:{s:6:\"result\";N;s:6:\"module\";N;}s:4:\"file\";s:16:\"search.pages.inc\";s:8:\"template\";s:28:\"modules/search/search-result\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_search_result\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:14:\"search_results\";a:8:{s:9:\"variables\";a:2:{s:7:\"results\";N;s:6:\"module\";N;}s:4:\"file\";s:16:\"search.pages.inc\";s:8:\"template\";s:29:\"modules/search/search-results\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/search\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/search/search.pages.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:34:\"template_preprocess_search_results\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:29:\"rdf_template_variable_wrapper\";a:4:{s:9:\"variables\";a:4:{s:7:\"content\";N;s:10:\"attributes\";a:0:{}s:7:\"context\";a:0:{}s:6:\"inline\";b:1;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:35:\"theme_rdf_template_variable_wrapper\";}s:12:\"rdf_metadata\";a:4:{s:9:\"variables\";a:1:{s:8:\"metadata\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:11:\"modules/rdf\";s:8:\"function\";s:18:\"theme_rdf_metadata\";}s:12:\"options_none\";a:4:{s:9:\"variables\";a:2:{s:8:\"instance\";N;s:6:\"option\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:29:\"modules/field/modules/options\";s:8:\"function\";s:18:\"theme_options_none\";}s:4:\"node\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:17:\"modules/node/node\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:19:\"rdf_preprocess_node\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"node_search_admin\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_search_admin\";}s:12:\"node_preview\";a:6:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"file\";s:14:\"node.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:18:\"theme_node_preview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/node/node.pages.inc\";}}s:19:\"node_admin_overview\";a:6:{s:9:\"variables\";a:2:{s:4:\"name\";N;s:4:\"type\";N;}s:4:\"file\";s:17:\"content_types.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_admin_overview\";s:8:\"includes\";a:1:{i:0;s:30:\"modules/node/content_types.inc\";}}s:17:\"node_recent_block\";a:4:{s:9:\"variables\";a:1:{s:5:\"nodes\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:23:\"theme_node_recent_block\";}s:19:\"node_recent_content\";a:4:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/node\";s:8:\"function\";s:25:\"theme_node_recent_content\";}s:18:\"menu_overview_form\";a:6:{s:4:\"file\";s:14:\"menu.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:24:\"theme_menu_overview_form\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}}s:19:\"menu_admin_overview\";a:6:{s:4:\"file\";s:14:\"menu.admin.inc\";s:9:\"variables\";a:3:{s:5:\"title\";N;s:4:\"name\";N;s:11:\"description\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/menu\";s:8:\"function\";s:25:\"theme_menu_admin_overview\";s:8:\"includes\";a:1:{i:0;s:27:\"modules/menu/menu.admin.inc\";}}s:11:\"image_style\";a:4:{s:9:\"variables\";a:7:{s:10:\"style_name\";N;s:4:\"path\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:17:\"theme_image_style\";}s:16:\"image_style_list\";a:4:{s:9:\"variables\";a:1:{s:6:\"styles\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:22:\"theme_image_style_list\";}s:19:\"image_style_effects\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_style_effects\";}s:19:\"image_style_preview\";a:4:{s:9:\"variables\";a:1:{s:5:\"style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_style_preview\";}s:12:\"image_anchor\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_anchor\";}s:20:\"image_resize_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_resize_summary\";}s:19:\"image_scale_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:25:\"theme_image_scale_summary\";}s:18:\"image_crop_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:24:\"theme_image_crop_summary\";}s:20:\"image_rotate_summary\";a:4:{s:9:\"variables\";a:1:{s:4:\"data\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:26:\"theme_image_rotate_summary\";}s:12:\"image_widget\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:18:\"theme_image_widget\";}s:15:\"image_formatter\";a:4:{s:9:\"variables\";a:3:{s:4:\"item\";N;s:4:\"path\";N;s:11:\"image_style\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/image\";s:8:\"function\";s:21:\"theme_image_formatter\";}s:21:\"filter_admin_overview\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_admin_overview\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}}s:32:\"filter_admin_format_filter_order\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:16:\"filter.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:38:\"theme_filter_admin_format_filter_order\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.admin.inc\";}}s:11:\"filter_tips\";a:6:{s:9:\"variables\";a:2:{s:4:\"tips\";N;s:4:\"long\";b:0;}s:4:\"file\";s:16:\"filter.pages.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:17:\"theme_filter_tips\";s:8:\"includes\";a:1:{i:0;s:31:\"modules/filter/filter.pages.inc\";}}s:19:\"text_format_wrapper\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:25:\"theme_text_format_wrapper\";}s:21:\"filter_tips_more_info\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:27:\"theme_filter_tips_more_info\";}s:17:\"filter_guidelines\";a:4:{s:9:\"variables\";a:1:{s:6:\"format\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:14:\"modules/filter\";s:8:\"function\";s:23:\"theme_filter_guidelines\";}s:9:\"file_link\";a:4:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_link\";}s:9:\"file_icon\";a:4:{s:9:\"variables\";a:2:{s:4:\"file\";N;s:14:\"icon_directory\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:15:\"theme_file_icon\";}s:17:\"file_managed_file\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:23:\"theme_file_managed_file\";}s:11:\"file_widget\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:17:\"theme_file_widget\";}s:20:\"file_widget_multiple\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_widget_multiple\";}s:20:\"file_formatter_table\";a:4:{s:9:\"variables\";a:1:{s:5:\"items\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:26:\"theme_file_formatter_table\";}s:16:\"file_upload_help\";a:4:{s:9:\"variables\";a:2:{s:11:\"description\";N;s:17:\"upload_validators\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:12:\"modules/file\";s:8:\"function\";s:22:\"theme_file_upload_help\";}s:14:\"field_ui_table\";a:4:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:16:\"modules/field_ui\";s:8:\"function\";s:20:\"theme_field_ui_table\";}s:5:\"field\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/field\";s:8:\"function\";s:11:\"theme_field\";s:20:\"preprocess functions\";a:2:{i:0;s:25:\"template_preprocess_field\";i:1;s:20:\"rdf_preprocess_field\";}s:17:\"process functions\";a:1:{i:0;s:22:\"template_process_field\";}}s:25:\"field_multiple_value_form\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/field\";s:8:\"function\";s:31:\"theme_field_multiple_value_form\";}s:13:\"dblog_message\";a:6:{s:9:\"variables\";a:2:{s:5:\"event\";N;s:4:\"link\";b:0;}s:4:\"file\";s:15:\"dblog.admin.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/dblog\";s:8:\"function\";s:19:\"theme_dblog_message\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/dblog/dblog.admin.inc\";}}s:9:\"dashboard\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:15:\"theme_dashboard\";}s:15:\"dashboard_admin\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:21:\"theme_dashboard_admin\";}s:16:\"dashboard_region\";a:4:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:22:\"theme_dashboard_region\";}s:25:\"dashboard_disabled_blocks\";a:4:{s:9:\"variables\";a:1:{s:6:\"blocks\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:31:\"theme_dashboard_disabled_blocks\";}s:24:\"dashboard_disabled_block\";a:4:{s:9:\"variables\";a:1:{s:5:\"block\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"function\";s:30:\"theme_dashboard_disabled_block\";}s:28:\"dashboard_admin_display_form\";a:9:{s:8:\"template\";s:24:\"block-admin-display-form\";s:4:\"path\";s:13:\"modules/block\";s:4:\"file\";s:15:\"block.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"modules/dashboard\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/block/block.admin.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:48:\"template_preprocess_dashboard_admin_display_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:13:\"comment_block\";a:4:{s:9:\"variables\";a:0:{}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:19:\"theme_comment_block\";}s:15:\"comment_preview\";a:4:{s:9:\"variables\";a:1:{s:7:\"comment\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:21:\"theme_comment_preview\";}s:7:\"comment\";a:6:{s:8:\"template\";s:23:\"modules/comment/comment\";s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_comment\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"rdf_preprocess_comment\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:22:\"comment_post_forbidden\";a:4:{s:9:\"variables\";a:1:{s:4:\"node\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:8:\"function\";s:28:\"theme_comment_post_forbidden\";}s:15:\"comment_wrapper\";a:6:{s:8:\"template\";s:31:\"modules/comment/comment-wrapper\";s:14:\"render element\";s:7:\"content\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:15:\"modules/comment\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_comment_wrapper\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:17:\"color_scheme_form\";a:4:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/color\";s:8:\"function\";s:23:\"theme_color_scheme_form\";}s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:8:\"template\";s:19:\"modules/block/block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/block\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:21:\"contextual_preprocess\";i:3;s:23:\"system_preprocess_block\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}s:24:\"block_admin_display_form\";a:8:{s:8:\"template\";s:38:\"modules/block/block-admin-display-form\";s:4:\"file\";s:15:\"block.admin.inc\";s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:13:\"modules/block\";s:8:\"includes\";a:1:{i:0;s:29:\"modules/block/block.admin.inc\";}s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:44:\"template_preprocess_block_admin_display_form\";i:2;s:21:\"contextual_preprocess\";}s:17:\"process functions\";a:2:{i:0;s:16:\"template_process\";i:1;s:11:\"rdf_process\";}}}',0,1443811944,1);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_block`
--

DROP TABLE IF EXISTS `cache_block`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_block` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Block module to store already built...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_block`
--

LOCK TABLES `cache_block` WRITE;
/*!40000 ALTER TABLE `cache_block` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_block` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_bootstrap`
--

DROP TABLE IF EXISTS `cache_bootstrap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_bootstrap` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for data required to bootstrap Drupal, may be...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_bootstrap`
--

LOCK TABLES `cache_bootstrap` WRITE;
/*!40000 ALTER TABLE `cache_bootstrap` DISABLE KEYS */;
INSERT INTO `cache_bootstrap` VALUES ('bootstrap_modules','a:2:{s:5:\"dblog\";O:8:\"stdClass\":2:{s:4:\"name\";s:5:\"dblog\";s:8:\"filename\";s:26:\"modules/dblog/dblog.module\";}s:11:\"raptor_glue\";O:8:\"stdClass\":2:{s:4:\"name\";s:11:\"raptor_glue\";s:8:\"filename\";s:48:\"sites/all/modules/raptor_glue/raptor_glue.module\";}}',0,1454111015,1),('hook_info','a:4:{s:10:\"token_info\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:16:\"token_info_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:6:\"tokens\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:12:\"tokens_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}}',0,1454110967,1),('lookup_cache','a:2:{s:30:\"cDrupalDefaultEntityController\";s:19:\"includes/entity.inc\";s:20:\"cSelectQueryExtender\";s:28:\"includes/database/select.inc\";}',0,1454111016,1),('module_implements','a:61:{s:15:\"stream_wrappers\";a:1:{s:6:\"system\";b:0;}s:23:\"module_implements_alter\";a:0:{}s:21:\"stream_wrappers_alter\";a:0:{}s:17:\"url_inbound_alter\";a:0:{}s:12:\"custom_theme\";a:1:{s:6:\"system\";b:0;}s:19:\"menu_get_item_alter\";a:0:{}s:18:\"url_outbound_alter\";a:0:{}s:13:\"library_alter\";a:0:{}s:4:\"init\";a:3:{s:5:\"dblog\";b:0;s:11:\"raptor_glue\";b:0;s:6:\"system\";b:0;}s:11:\"admin_paths\";a:6:{s:5:\"block\";b:0;s:4:\"node\";b:0;s:8:\"shortcut\";b:0;s:6:\"system\";b:0;s:8:\"taxonomy\";b:0;s:4:\"user\";b:0;}s:17:\"admin_paths_alter\";a:0:{}s:22:\"menu_site_status_alter\";a:1:{s:4:\"user\";b:0;}s:12:\"element_info\";a:6:{s:10:\"contextual\";b:0;s:8:\"field_ui\";b:0;s:4:\"file\";b:0;s:6:\"filter\";b:0;s:6:\"system\";b:0;s:4:\"user\";b:0;}s:18:\"element_info_alter\";a:0:{}s:10:\"form_alter\";a:1:{s:11:\"raptor_glue\";b:0;}s:21:\"form_user_login_alter\";a:1:{s:11:\"raptor_glue\";b:0;}s:28:\"page_delivery_callback_alter\";a:0:{}s:10:\"page_build\";a:3:{s:5:\"block\";b:0;s:9:\"dashboard\";b:0;s:7:\"toolbar\";b:0;}s:11:\"query_alter\";a:0:{}s:22:\"query_block_load_alter\";a:0:{}s:24:\"query_translatable_alter\";a:0:{}s:16:\"block_list_alter\";a:3:{s:5:\"block\";b:0;s:9:\"dashboard\";b:0;s:4:\"node\";b:0;}s:17:\"dashboard_regions\";a:1:{s:9:\"dashboard\";b:0;}s:23:\"dashboard_regions_alter\";a:0:{}s:14:\"file_url_alter\";a:0:{}s:18:\"omega_layout_alter\";a:0:{}s:24:\"omega_layouts_info_alter\";a:0:{}s:11:\"node_grants\";a:0:{}s:16:\"block_view_alter\";a:1:{s:4:\"menu\";b:0;}s:28:\"block_view_search_form_alter\";a:0:{}s:32:\"query_preferred_menu_links_alter\";a:0:{}s:11:\"node_access\";a:1:{s:4:\"node\";b:0;}s:34:\"block_view_system_navigation_alter\";a:0:{}s:27:\"block_view_user_login_alter\";a:0:{}s:28:\"block_view_system_main_alter\";a:0:{}s:20:\"theme_registry_alter\";a:0:{}s:32:\"omega_theme_libraries_info_alter\";a:0:{}s:34:\"block_view_system_powered_by_alter\";a:0:{}s:22:\"menu_local_tasks_alter\";a:1:{s:4:\"node\";b:0;}s:4:\"help\";a:43:{s:5:\"block\";b:0;s:5:\"color\";b:0;s:7:\"comment\";b:0;s:10:\"contextual\";b:0;s:9:\"dashboard\";b:0;s:5:\"dblog\";b:0;s:5:\"field\";b:0;s:17:\"field_sql_storage\";b:0;s:8:\"field_ui\";b:0;s:4:\"file\";b:0;s:6:\"filter\";b:0;s:4:\"help\";b:0;s:5:\"image\";b:0;s:4:\"list\";b:0;s:4:\"menu\";b:0;s:4:\"node\";b:0;s:6:\"number\";b:0;s:7:\"options\";b:0;s:4:\"path\";b:0;s:24:\"raptor_contraindications\";b:0;s:16:\"raptor_datalayer\";b:0;s:15:\"raptor_ewdvista\";b:0;s:21:\"raptor_floatingdialog\";b:0;s:15:\"raptor_formulas\";b:0;s:11:\"raptor_glue\";b:0;s:12:\"raptor_graph\";b:0;s:19:\"raptor_imageviewing\";b:0;s:16:\"raptor_mdwsvista\";b:0;s:18:\"raptor_protocollib\";b:0;s:14:\"raptor_reports\";b:0;s:17:\"raptor_scheduling\";b:0;s:15:\"raptor_workflow\";b:0;s:3:\"rdf\";b:0;s:6:\"search\";b:0;s:8:\"shortcut\";b:0;s:22:\"simplerulesengine_core\";b:0;s:22:\"simplerulesengine_demo\";b:0;s:20:\"simplerulesengine_ui\";b:0;s:6:\"system\";b:0;s:8:\"taxonomy\";b:0;s:4:\"text\";b:0;s:7:\"toolbar\";b:0;s:4:\"user\";b:0;}s:28:\"block_view_system_help_alter\";a:0:{}s:10:\"page_alter\";a:3:{s:11:\"raptor_glue\";b:0;s:8:\"shortcut\";b:0;s:6:\"system\";b:0;}s:26:\"translated_menu_link_alter\";a:1:{s:4:\"user\";b:0;}s:21:\"menu_breadcrumb_alter\";a:0:{}s:14:\"rdf_namespaces\";a:1:{s:3:\"rdf\";b:0;}s:8:\"js_alter\";a:0:{}s:15:\"html_head_alter\";a:0:{}s:9:\"css_alter\";a:0:{}s:8:\"watchdog\";a:2:{s:5:\"dblog\";b:0;s:11:\"raptor_glue\";b:0;}s:4:\"exit\";a:0:{}s:30:\"query_user_load_multiple_alter\";a:0:{}s:30:\"query_file_load_multiple_alter\";a:0:{}s:11:\"entity_load\";a:1:{s:3:\"rdf\";b:0;}s:9:\"user_load\";a:0:{}s:44:\"form_raptor_glue_worklist_form_builder_alter\";a:0:{}s:5:\"forms\";a:4:{s:7:\"comment\";b:0;s:9:\"dashboard\";b:0;s:4:\"node\";b:0;s:6:\"search\";b:0;}s:21:\"form_search_box_alter\";a:0:{}s:28:\"form_search_block_form_alter\";a:0:{}s:11:\"search_info\";a:2:{s:4:\"node\";b:0;s:4:\"user\";b:0;}s:20:\"shortcut_default_set\";a:0:{}s:14:\"username_alter\";a:0:{}}',0,1454341313,1),('system_list','a:3:{s:14:\"module_enabled\";a:43:{s:5:\"block\";O:8:\"stdClass\":9:{s:8:\"filename\";s:26:\"modules/block/block.module\";s:4:\"name\";s:5:\"block\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7009\";s:6:\"weight\";s:2:\"-5\";s:4:\"info\";a:13:{s:4:\"name\";s:5:\"Block\";s:11:\"description\";s:140:\"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:10:\"block.test\";}s:9:\"configure\";s:21:\"admin/structure/block\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:5:\"color\";O:8:\"stdClass\":9:{s:8:\"filename\";s:26:\"modules/color/color.module\";s:4:\"name\";s:5:\"color\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7001\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:5:\"Color\";s:11:\"description\";s:70:\"Allows administrators to change the color scheme of compatible themes.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:10:\"color.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:7:\"comment\";O:8:\"stdClass\":9:{s:8:\"filename\";s:30:\"modules/comment/comment.module\";s:4:\"name\";s:7:\"comment\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7009\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:7:\"Comment\";s:11:\"description\";s:57:\"Allows users to comment on and discuss published content.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:4:\"text\";}s:5:\"files\";a:2:{i:0;s:14:\"comment.module\";i:1;s:12:\"comment.test\";}s:9:\"configure\";s:21:\"admin/content/comment\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:11:\"comment.css\";s:27:\"modules/comment/comment.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:10:\"contextual\";O:8:\"stdClass\":9:{s:8:\"filename\";s:36:\"modules/contextual/contextual.module\";s:4:\"name\";s:10:\"contextual\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:16:\"Contextual links\";s:11:\"description\";s:75:\"Provides contextual links to perform actions related to elements on a page.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:15:\"contextual.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:9:\"dashboard\";O:8:\"stdClass\":9:{s:8:\"filename\";s:34:\"modules/dashboard/dashboard.module\";s:4:\"name\";s:9:\"dashboard\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:13:{s:4:\"name\";s:9:\"Dashboard\";s:11:\"description\";s:136:\"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.\";s:4:\"core\";s:3:\"7.x\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:5:\"files\";a:1:{i:0;s:14:\"dashboard.test\";}s:12:\"dependencies\";a:1:{i:0;s:5:\"block\";}s:9:\"configure\";s:25:\"admin/dashboard/customize\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:5:\"dblog\";O:8:\"stdClass\":9:{s:8:\"filename\";s:26:\"modules/dblog/dblog.module\";s:4:\"name\";s:5:\"dblog\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"1\";s:14:\"schema_version\";s:4:\"7002\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:16:\"Database logging\";s:11:\"description\";s:47:\"Logs and records system events to the database.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:10:\"dblog.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:5:\"field\";O:8:\"stdClass\":9:{s:8:\"filename\";s:26:\"modules/field/field.module\";s:4:\"name\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7003\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:5:\"Field\";s:11:\"description\";s:57:\"Field API to add fields to entities like nodes and users.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:4:{i:0;s:12:\"field.module\";i:1;s:16:\"field.attach.inc\";i:2;s:20:\"field.info.class.inc\";i:3;s:16:\"tests/field.test\";}s:12:\"dependencies\";a:1:{i:0;s:17:\"field_sql_storage\";}s:8:\"required\";b:1;s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:15:\"theme/field.css\";s:29:\"modules/field/theme/field.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:17:\"field_sql_storage\";O:8:\"stdClass\":9:{s:8:\"filename\";s:64:\"modules/field/modules/field_sql_storage/field_sql_storage.module\";s:4:\"name\";s:17:\"field_sql_storage\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7002\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:13:{s:4:\"name\";s:17:\"Field SQL storage\";s:11:\"description\";s:37:\"Stores field data in an SQL database.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:22:\"field_sql_storage.test\";}s:8:\"required\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:8:\"field_ui\";O:8:\"stdClass\":9:{s:8:\"filename\";s:32:\"modules/field_ui/field_ui.module\";s:4:\"name\";s:8:\"field_ui\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:8:\"Field UI\";s:11:\"description\";s:33:\"User interface for the Field API.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:13:\"field_ui.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:4:\"file\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/file/file.module\";s:4:\"name\";s:4:\"file\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:4:\"File\";s:11:\"description\";s:26:\"Defines a file field type.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:15:\"tests/file.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:6:\"filter\";O:8:\"stdClass\":9:{s:8:\"filename\";s:28:\"modules/filter/filter.module\";s:4:\"name\";s:6:\"filter\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7010\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:6:\"Filter\";s:11:\"description\";s:43:\"Filters content in preparation for display.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:11:\"filter.test\";}s:8:\"required\";b:1;s:9:\"configure\";s:28:\"admin/config/content/formats\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:4:\"help\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/help/help.module\";s:4:\"name\";s:4:\"help\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:4:\"Help\";s:11:\"description\";s:35:\"Manages the display of online help.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:9:\"help.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:5:\"image\";O:8:\"stdClass\":9:{s:8:\"filename\";s:26:\"modules/image/image.module\";s:4:\"name\";s:5:\"image\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7005\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Image\";s:11:\"description\";s:34:\"Provides image manipulation tools.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:4:\"file\";}s:5:\"files\";a:1:{i:0;s:10:\"image.test\";}s:9:\"configure\";s:31:\"admin/config/media/image-styles\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;s:8:\"required\";b:1;s:11:\"explanation\";s:73:\"Field type(s) in use - see <a href=\"/admin/reports/fields\">Field list</a>\";}}s:4:\"list\";O:8:\"stdClass\":9:{s:8:\"filename\";s:38:\"modules/field/modules/list/list.module\";s:4:\"name\";s:4:\"list\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7002\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:4:\"List\";s:11:\"description\";s:69:\"Defines list field types. Use with Options to create selection lists.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:2:{i:0;s:5:\"field\";i:1;s:7:\"options\";}s:5:\"files\";a:1:{i:0;s:15:\"tests/list.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:4:\"menu\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/menu/menu.module\";s:4:\"name\";s:4:\"menu\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7003\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:13:{s:4:\"name\";s:4:\"Menu\";s:11:\"description\";s:60:\"Allows administrators to customize the site navigation menu.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:9:\"menu.test\";}s:9:\"configure\";s:20:\"admin/structure/menu\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:4:\"node\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/node/node.module\";s:4:\"name\";s:4:\"node\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7015\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:4:\"Node\";s:11:\"description\";s:66:\"Allows content to be submitted to the site and displayed on pages.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:2:{i:0;s:11:\"node.module\";i:1;s:9:\"node.test\";}s:8:\"required\";b:1;s:9:\"configure\";s:21:\"admin/structure/types\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:8:\"node.css\";s:21:\"modules/node/node.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:6:\"number\";O:8:\"stdClass\":9:{s:8:\"filename\";s:42:\"modules/field/modules/number/number.module\";s:4:\"name\";s:6:\"number\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:6:\"Number\";s:11:\"description\";s:28:\"Defines numeric field types.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:11:\"number.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:7:\"options\";O:8:\"stdClass\":9:{s:8:\"filename\";s:44:\"modules/field/modules/options/options.module\";s:4:\"name\";s:7:\"options\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:7:\"Options\";s:11:\"description\";s:82:\"Defines selection, check box and radio button widgets for text and numeric fields.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:12:\"options.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:4:\"path\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/path/path.module\";s:4:\"name\";s:4:\"path\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:13:{s:4:\"name\";s:4:\"Path\";s:11:\"description\";s:28:\"Allows users to rename URLs.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:9:\"path.test\";}s:9:\"configure\";s:24:\"admin/config/search/path\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:24:\"raptor_contraindications\";O:8:\"stdClass\":9:{s:8:\"filename\";s:74:\"sites/all/modules/raptor_contraindications/raptor_contraindications.module\";s:4:\"name\";s:24:\"raptor_contraindications\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:31:\"RAPTOR Contraindications Engine\";s:11:\"description\";s:75:\"A module with the contraindications engine needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:37:\"admin/config/raptor_contraindications\";s:7:\"version\";s:8:\"7.x-0.96\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"files\";a:1:{i:0;s:35:\"tests/raptor_contraindications.test\";}s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:16:\"raptor_datalayer\";O:8:\"stdClass\":9:{s:8:\"filename\";s:58:\"sites/all/modules/raptor_datalayer/raptor_datalayer.module\";s:4:\"name\";s:16:\"raptor_datalayer\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:17:\"RAPTOR Data Layer\";s:11:\"description\";s:73:\"A module with the data layer integration needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:29:\"admin/config/raptor_datalayer\";s:7:\"version\";s:8:\"7.x-0.95\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:15:\"raptor_ewdvista\";O:8:\"stdClass\":9:{s:8:\"filename\";s:56:\"sites/all/modules/raptor_ewdvista/raptor_ewdvista.module\";s:4:\"name\";s:15:\"raptor_ewdvista\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:28:\"RAPTOR EWD Integration Layer\";s:11:\"description\";s:72:\"A module that integrates RAPTOR with VistA data sources by utilizing EWD\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:28:\"admin/config/raptor_ewdvista\";s:7:\"version\";s:8:\"7.x-0.95\";s:7:\"package\";s:6:\"RAPTOR\";s:12:\"dependencies\";a:2:{i:0;s:16:\"raptor_datalayer\";i:1;s:11:\"raptor_glue\";}s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:21:\"raptor_floatingdialog\";O:8:\"stdClass\":9:{s:8:\"filename\";s:68:\"sites/all/modules/raptor_floatingdialog/raptor_floatingdialog.module\";s:4:\"name\";s:21:\"raptor_floatingdialog\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:34:\"RAPTOR Floating Dialog Integration\";s:11:\"description\";s:46:\"A module with the floating dialog markup logic\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:11:\"7.x-0.5-dev\";s:7:\"package\";s:6:\"RAPTOR\";s:7:\"scripts\";a:1:{s:13:\"js/scripts.js\";s:53:\"sites/all/modules/raptor_floatingdialog/js/scripts.js\";}s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:15:\"raptor_formulas\";O:8:\"stdClass\":9:{s:8:\"filename\";s:56:\"sites/all/modules/raptor_formulas/raptor_formulas.module\";s:4:\"name\";s:15:\"raptor_formulas\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:15:\"RAPTOR Formulas\";s:11:\"description\";s:73:\"A module with formulas and inference logic used by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:8:\"7.x-0.85\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:11:\"raptor_glue\";O:8:\"stdClass\":9:{s:8:\"filename\";s:48:\"sites/all/modules/raptor_glue/raptor_glue.module\";s:4:\"name\";s:11:\"raptor_glue\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"1\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:11:\"RAPTOR Glue\";s:11:\"description\";s:60:\"Integrates all the other RAPTOR modules into one application\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:24:\"admin/config/raptor_glue\";s:7:\"version\";s:8:\"7.x-0.95\";s:7:\"package\";s:6:\"RAPTOR\";s:12:\"dependencies\";a:6:{i:0;s:24:\"raptor_contraindications\";i:1;s:16:\"raptor_datalayer\";i:2;s:19:\"raptor_imageviewing\";i:3;s:17:\"raptor_scheduling\";i:4;s:15:\"raptor_workflow\";i:5;s:15:\"raptor_formulas\";}s:5:\"files\";a:1:{i:0;s:22:\"tests/raptor_glue.test\";}s:7:\"scripts\";a:1:{s:16:\"js/formHelper.js\";s:46:\"sites/all/modules/raptor_glue/js/formHelper.js\";}s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:12:\"raptor_graph\";O:8:\"stdClass\":9:{s:8:\"filename\";s:50:\"sites/all/modules/raptor_graph/raptor_graph.module\";s:4:\"name\";s:12:\"raptor_graph\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:24:\"RAPTOR Graph Integration\";s:11:\"description\";s:68:\"A module with the graph integration needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:8:\"7.x-0.96\";s:7:\"package\";s:6:\"RAPTOR\";s:12:\"dependencies\";a:2:{i:0;s:16:\"raptor_datalayer\";i:1;s:15:\"raptor_formulas\";}s:7:\"scripts\";a:2:{s:12:\"js/d3.min.js\";s:43:\"sites/all/modules/raptor_graph/js/d3.min.js\";s:19:\"js/raptor-charts.js\";s:50:\"sites/all/modules/raptor_graph/js/raptor-charts.js\";}s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:19:\"raptor_imageviewing\";O:8:\"stdClass\":9:{s:8:\"filename\";s:64:\"sites/all/modules/raptor_imageviewing/raptor_imageviewing.module\";s:4:\"name\";s:19:\"raptor_imageviewing\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:31:\"RAPTOR Image Viewer Integration\";s:11:\"description\";s:75:\"A module with the image viewer integration needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:11:\"7.x-0.1-dev\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:16:\"raptor_mdwsvista\";O:8:\"stdClass\":9:{s:8:\"filename\";s:58:\"sites/all/modules/raptor_mdwsvista/raptor_mdwsvista.module\";s:4:\"name\";s:16:\"raptor_mdwsvista\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:29:\"RAPTOR MDWS Integration Layer\";s:11:\"description\";s:73:\"A module that integrates RAPTOR with VistA data sources by utilizing MDWS\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:29:\"admin/config/raptor_mdwsvista\";s:7:\"version\";s:8:\"7.x-0.96\";s:7:\"package\";s:6:\"RAPTOR\";s:12:\"dependencies\";a:3:{i:0;s:16:\"raptor_datalayer\";i:1;s:15:\"raptor_formulas\";i:2;s:11:\"raptor_glue\";}s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:18:\"raptor_protocollib\";O:8:\"stdClass\":9:{s:8:\"filename\";s:62:\"sites/all/modules/raptor_protocollib/raptor_protocollib.module\";s:4:\"name\";s:18:\"raptor_protocollib\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:35:\"RAPTOR Protocol Library Integration\";s:11:\"description\";s:53:\"A module with the support for scanned protocol images\";s:4:\"core\";s:3:\"7.x\";s:9:\"configure\";s:31:\"admin/config/raptor_protocollib\";s:7:\"version\";s:8:\"7.x-0.85\";s:7:\"package\";s:6:\"RAPTOR\";s:12:\"dependencies\";a:1:{i:0;s:16:\"raptor_datalayer\";}s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:14:\"raptor_reports\";O:8:\"stdClass\":9:{s:8:\"filename\";s:54:\"sites/all/modules/raptor_reports/raptor_reports.module\";s:4:\"name\";s:14:\"raptor_reports\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:14:\"RAPTOR Reports\";s:11:\"description\";s:44:\"The reports module of the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:8:\"7.x-0.95\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:17:\"raptor_scheduling\";O:8:\"stdClass\":9:{s:8:\"filename\";s:60:\"sites/all/modules/raptor_scheduling/raptor_scheduling.module\";s:4:\"name\";s:17:\"raptor_scheduling\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:29:\"RAPTOR Scheduling Integration\";s:11:\"description\";s:73:\"A module with the scheduling integration needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:11:\"7.x-0.5-dev\";s:7:\"package\";s:6:\"RAPTOR\";s:7:\"scripts\";a:1:{s:13:\"js/scripts.js\";s:49:\"sites/all/modules/raptor_scheduling/js/scripts.js\";}s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:15:\"raptor_workflow\";O:8:\"stdClass\":9:{s:8:\"filename\";s:56:\"sites/all/modules/raptor_workflow/raptor_workflow.module\";s:4:\"name\";s:15:\"raptor_workflow\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:15:\"RAPTOR Workflow\";s:11:\"description\";s:65:\"A module with the workflow logic needed by the RAPTOR application\";s:4:\"core\";s:3:\"7.x\";s:7:\"version\";s:8:\"7.x-0.95\";s:7:\"package\";s:6:\"RAPTOR\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:3:\"rdf\";O:8:\"stdClass\":9:{s:8:\"filename\";s:22:\"modules/rdf/rdf.module\";s:4:\"name\";s:3:\"rdf\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:3:\"RDF\";s:11:\"description\";s:148:\"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:8:\"rdf.test\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:6:\"search\";O:8:\"stdClass\":9:{s:8:\"filename\";s:28:\"modules/search/search.module\";s:4:\"name\";s:6:\"search\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7000\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:6:\"Search\";s:11:\"description\";s:36:\"Enables site-wide keyword searching.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:2:{i:0;s:19:\"search.extender.inc\";i:1;s:11:\"search.test\";}s:9:\"configure\";s:28:\"admin/config/search/settings\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"search.css\";s:25:\"modules/search/search.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:8:\"shortcut\";O:8:\"stdClass\":9:{s:8:\"filename\";s:32:\"modules/shortcut/shortcut.module\";s:4:\"name\";s:8:\"shortcut\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:13:{s:4:\"name\";s:8:\"Shortcut\";s:11:\"description\";s:60:\"Allows users to manage customizable lists of shortcut links.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:1:{i:0;s:13:\"shortcut.test\";}s:9:\"configure\";s:36:\"admin/config/user-interface/shortcut\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:22:\"simplerulesengine_core\";O:8:\"stdClass\":9:{s:8:\"filename\";s:70:\"sites/all/modules/simplerulesengine_core/simplerulesengine_core.module\";s:4:\"name\";s:22:\"simplerulesengine_core\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:24:\"Simple Rules Engine Core\";s:11:\"description\";s:70:\"A simple rules engine for use in on-line decision support applications\";s:4:\"core\";s:3:\"7.x\";s:7:\"package\";s:16:\"Decision Support\";s:5:\"files\";a:1:{i:0;s:33:\"tests/simplerulesengine_core.test\";}s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:7:\"version\";N;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:22:\"simplerulesengine_demo\";O:8:\"stdClass\":9:{s:8:\"filename\";s:70:\"sites/all/modules/simplerulesengine_demo/simplerulesengine_demo.module\";s:4:\"name\";s:22:\"simplerulesengine_demo\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7101\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:10:{s:4:\"name\";s:31:\"Simple Rules Engine Demo Module\";s:11:\"description\";s:90:\"Demonstration module for programmers to see example utilization of the simple rules engine\";s:4:\"core\";s:3:\"7.x\";s:7:\"package\";s:16:\"Decision Support\";s:12:\"dependencies\";a:2:{i:0;s:22:\"simplerulesengine_core\";i:1;s:20:\"simplerulesengine_ui\";}s:5:\"mtime\";i:1454110897;s:7:\"version\";N;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:20:\"simplerulesengine_ui\";O:8:\"stdClass\":9:{s:8:\"filename\";s:66:\"sites/all/modules/simplerulesengine_ui/simplerulesengine_ui.module\";s:4:\"name\";s:20:\"simplerulesengine_ui\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:11:{s:4:\"name\";s:22:\"Simple Rules Engine UI\";s:11:\"description\";s:51:\"User Interface elements for the simple rules engine\";s:4:\"core\";s:3:\"7.x\";s:7:\"package\";s:16:\"Decision Support\";s:12:\"dependencies\";a:1:{i:0;s:22:\"simplerulesengine_core\";}s:7:\"scripts\";a:1:{s:13:\"js/scripts.js\";s:52:\"sites/all/modules/simplerulesengine_ui/js/scripts.js\";}s:5:\"mtime\";i:1454110897;s:7:\"version\";N;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:6:\"system\";O:8:\"stdClass\":9:{s:8:\"filename\";s:28:\"modules/system/system.module\";s:4:\"name\";s:6:\"system\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7079\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:6:\"System\";s:11:\"description\";s:54:\"Handles general site configuration for administrators.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:6:{i:0;s:19:\"system.archiver.inc\";i:1;s:15:\"system.mail.inc\";i:2;s:16:\"system.queue.inc\";i:3;s:14:\"system.tar.inc\";i:4;s:18:\"system.updater.inc\";i:5;s:11:\"system.test\";}s:8:\"required\";b:1;s:9:\"configure\";s:19:\"admin/config/system\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}s:8:\"taxonomy\";O:8:\"stdClass\":9:{s:8:\"filename\";s:32:\"modules/taxonomy/taxonomy.module\";s:4:\"name\";s:8:\"taxonomy\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7011\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:8:\"Taxonomy\";s:11:\"description\";s:38:\"Enables the categorization of content.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:7:\"options\";}s:5:\"files\";a:2:{i:0;s:15:\"taxonomy.module\";i:1;s:13:\"taxonomy.test\";}s:9:\"configure\";s:24:\"admin/structure/taxonomy\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;s:8:\"required\";b:1;s:11:\"explanation\";s:73:\"Field type(s) in use - see <a href=\"/admin/reports/fields\">Field list</a>\";}}s:4:\"text\";O:8:\"stdClass\":9:{s:8:\"filename\";s:38:\"modules/field/modules/text/text.module\";s:4:\"name\";s:4:\"text\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7000\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:14:{s:4:\"name\";s:4:\"Text\";s:11:\"description\";s:32:\"Defines simple text field types.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:12:\"dependencies\";a:1:{i:0;s:5:\"field\";}s:5:\"files\";a:1:{i:0;s:9:\"text.test\";}s:8:\"required\";b:1;s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;s:11:\"explanation\";s:73:\"Field type(s) in use - see <a href=\"/admin/reports/fields\">Field list</a>\";}}s:7:\"toolbar\";O:8:\"stdClass\":9:{s:8:\"filename\";s:30:\"modules/toolbar/toolbar.module\";s:4:\"name\";s:7:\"toolbar\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:12:{s:4:\"name\";s:7:\"Toolbar\";s:11:\"description\";s:99:\"Provides a toolbar that shows the top-level administration menu items and links from other modules.\";s:4:\"core\";s:3:\"7.x\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}}s:4:\"user\";O:8:\"stdClass\":9:{s:8:\"filename\";s:24:\"modules/user/user.module\";s:4:\"name\";s:4:\"user\";s:4:\"type\";s:6:\"module\";s:5:\"owner\";s:0:\"\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:4:\"7018\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:4:\"User\";s:11:\"description\";s:47:\"Manages the user registration and login system.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:5:\"files\";a:2:{i:0;s:11:\"user.module\";i:1;s:9:\"user.test\";}s:8:\"required\";b:1;s:9:\"configure\";s:19:\"admin/config/people\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:8:\"user.css\";s:21:\"modules/user/user.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:5:\"mtime\";i:1454110897;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:9:\"bootstrap\";i:0;}}}s:5:\"theme\";a:7:{s:6:\"bartik\";O:8:\"stdClass\":10:{s:8:\"filename\";s:25:\"themes/bartik/bartik.info\";s:4:\"name\";s:6:\"bartik\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:6:\"Bartik\";s:11:\"description\";s:48:\"A flexible, recolorable theme with many regions.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:7:\"regions\";a:20:{s:6:\"header\";s:6:\"Header\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:11:\"highlighted\";s:11:\"Highlighted\";s:8:\"featured\";s:8:\"Featured\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"Sidebar first\";s:14:\"sidebar_second\";s:14:\"Sidebar second\";s:14:\"triptych_first\";s:14:\"Triptych first\";s:15:\"triptych_middle\";s:15:\"Triptych middle\";s:13:\"triptych_last\";s:13:\"Triptych last\";s:18:\"footer_firstcolumn\";s:19:\"Footer first column\";s:19:\"footer_secondcolumn\";s:20:\"Footer second column\";s:18:\"footer_thirdcolumn\";s:19:\"Footer third column\";s:19:\"footer_fourthcolumn\";s:20:\"Footer fourth column\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"0\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:28:\"themes/bartik/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";}s:7:\"garland\";O:8:\"stdClass\":10:{s:8:\"filename\";s:27:\"themes/garland/garland.info\";s:4:\"name\";s:7:\"garland\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:7:\"Garland\";s:11:\"description\";s:111:\"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:8:\"settings\";a:1:{s:13:\"garland_width\";s:5:\"fluid\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:29:\"themes/garland/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";}s:3:\"ohm\";O:8:\"stdClass\":11:{s:8:\"filename\";s:35:\"sites/all/themes/omega/ohm/ohm.info\";s:4:\"name\";s:3:\"ohm\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:20:{s:4:\"name\";s:3:\"Ohm\";s:11:\"description\";s:189:\"Omega based demonstration theme. Serves as a best-practice reference for the Omega documentation. Ohm will be constantly updated as best practice evolves so shouldn\'t be used in production.\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:41:\"sites/all/themes/omega/ohm/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:7:\"regions\";a:13:{s:8:\"branding\";s:8:\"Branding\";s:10:\"navigation\";s:14:\"Navigation bar\";s:6:\"header\";s:6:\"Header\";s:4:\"hero\";s:4:\"Hero\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:6:\"layout\";a:1:{s:4:\"hero\";a:1:{s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:36:\"css/layouts/hero/ohm-hero.layout.css\";}}}}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"1\";s:27:\"toggle_comment_user_picture\";s:1:\"1\";s:32:\"toggle_comment_user_verification\";s:1:\"1\";s:14:\"toggle_favicon\";s:1:\"1\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"1\";s:31:\"omega_toggle_front_page_content\";s:1:\"1\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:5:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"0\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"0\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"0\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}s:8:\"messages\";a:1:{s:6:\"status\";s:1:\"1\";}}s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:8:\"ohm-hero\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"1\";s:23:\"omega_livereload_script\";s:36:\"http://localhost:35729/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"1\";s:23:\"omega_demo_regions_list\";a:9:{s:10:\"navigation\";s:10:\"navigation\";s:6:\"header\";s:6:\"header\";s:4:\"hero\";s:4:\"hero\";s:11:\"highlighted\";s:11:\"highlighted\";s:4:\"help\";s:4:\"help\";s:7:\"content\";s:7:\"content\";s:13:\"sidebar_first\";s:13:\"sidebar_first\";s:14:\"sidebar_second\";s:14:\"sidebar_second\";s:6:\"footer\";s:6:\"footer\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";}s:5:\"omega\";O:8:\"stdClass\":11:{s:8:\"filename\";s:39:\"sites/all/themes/omega/omega/omega.info\";s:4:\"name\";s:5:\"omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Omega\";s:11:\"description\";s:432:\"A powerful HTML5 base theme framework utilizing tools like <a href=\"http://sass-lang.com/\" title=\"Sass\">Sass</a>, <a href=\"http://compass-style.org/\" title=\"Compass\">Compass</a>, <a href=\"http://gruntjs.com/\" title=\"Grunt\">Grunt</a>, <a href=\"http://bower.io/\" title=\"Bower\">Bower</a>, <a href=\"http://rvm.io/\" title=\"Ruby Version Manager\">Ruby Version Manager</a>, <a href=\"http://bundler.io/\" title=\"Bundler\">Bundler</a> and more.\";s:10:\"screenshot\";s:43:\"sites/all/themes/omega/omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:7:\"regions\";a:12:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First Sidebar\";s:14:\"sidebar_second\";s:14:\"Second Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:7:\"plugins\";a:1:{s:6:\"panels\";a:2:{s:7:\"layouts\";s:14:\"panels/layouts\";s:6:\"styles\";s:13:\"panels/styles\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:11:\"stylesheets\";a:0:{}s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:10:\"sub_themes\";a:2:{s:3:\"ohm\";s:3:\"Ohm\";s:12:\"raptor_omega\";s:12:\"RAPTOR Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";}s:12:\"raptor_omega\";O:8:\"stdClass\":11:{s:8:\"filename\";s:47:\"sites/all/themes/raptor_omega/raptor_omega.info\";s:4:\"name\";s:12:\"raptor_omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:12:\"RAPTOR Omega\";s:11:\"description\";s:32:\"Theme for the RAPTOR application\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:44:\"sites/all/themes/raptor_omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"0\";s:27:\"toggle_comment_user_picture\";s:1:\"0\";s:32:\"toggle_comment_user_verification\";s:1:\"0\";s:14:\"toggle_favicon\";s:1:\"0\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"0\";s:31:\"omega_toggle_front_page_content\";s:1:\"0\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:20:\"omega_enable_warning\";s:1:\"1\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:5:\"admin\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"0\";s:23:\"omega_livereload_script\";s:16:\"js/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"0\";s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:4:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"1\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"1\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"1\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}}}s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";}s:5:\"seven\";O:8:\"stdClass\":10:{s:8:\"filename\";s:23:\"themes/seven/seven.info\";s:4:\"name\";s:5:\"seven\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:5:\"Seven\";s:11:\"description\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"1\";}s:7:\"regions\";a:8:{s:7:\"content\";s:7:\"Content\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/seven/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";}s:5:\"stark\";O:8:\"stdClass\":10:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal\'s default HTML markup and CSS styles. To learn how to build your own theme and override Drupal\'s default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.41\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1445457729\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1454110897;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";}}s:9:\"filepaths\";a:47:{i:0;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:5:\"block\";s:8:\"filepath\";s:26:\"modules/block/block.module\";}i:1;a:3:{s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:6:\"bartik\";s:8:\"filepath\";s:25:\"themes/bartik/bartik.info\";}i:2;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:5:\"color\";s:8:\"filepath\";s:26:\"modules/color/color.module\";}i:3;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:7:\"comment\";s:8:\"filepath\";s:30:\"modules/comment/comment.module\";}i:4;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:10:\"contextual\";s:8:\"filepath\";s:36:\"modules/contextual/contextual.module\";}i:5;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:9:\"dashboard\";s:8:\"filepath\";s:34:\"modules/dashboard/dashboard.module\";}i:6;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:5:\"dblog\";s:8:\"filepath\";s:26:\"modules/dblog/dblog.module\";}i:7;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:5:\"field\";s:8:\"filepath\";s:26:\"modules/field/field.module\";}i:8;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:17:\"field_sql_storage\";s:8:\"filepath\";s:64:\"modules/field/modules/field_sql_storage/field_sql_storage.module\";}i:9;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:8:\"field_ui\";s:8:\"filepath\";s:32:\"modules/field_ui/field_ui.module\";}i:10;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"file\";s:8:\"filepath\";s:24:\"modules/file/file.module\";}i:11;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:6:\"filter\";s:8:\"filepath\";s:28:\"modules/filter/filter.module\";}i:12;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"help\";s:8:\"filepath\";s:24:\"modules/help/help.module\";}i:13;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:5:\"image\";s:8:\"filepath\";s:26:\"modules/image/image.module\";}i:14;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"list\";s:8:\"filepath\";s:38:\"modules/field/modules/list/list.module\";}i:15;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"menu\";s:8:\"filepath\";s:24:\"modules/menu/menu.module\";}i:16;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"node\";s:8:\"filepath\";s:24:\"modules/node/node.module\";}i:17;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:6:\"number\";s:8:\"filepath\";s:42:\"modules/field/modules/number/number.module\";}i:18;a:3:{s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:5:\"omega\";s:8:\"filepath\";s:39:\"sites/all/themes/omega/omega/omega.info\";}i:19;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:7:\"options\";s:8:\"filepath\";s:44:\"modules/field/modules/options/options.module\";}i:20;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"path\";s:8:\"filepath\";s:24:\"modules/path/path.module\";}i:21;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:24:\"raptor_contraindications\";s:8:\"filepath\";s:74:\"sites/all/modules/raptor_contraindications/raptor_contraindications.module\";}i:22;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:16:\"raptor_datalayer\";s:8:\"filepath\";s:58:\"sites/all/modules/raptor_datalayer/raptor_datalayer.module\";}i:23;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:15:\"raptor_ewdvista\";s:8:\"filepath\";s:56:\"sites/all/modules/raptor_ewdvista/raptor_ewdvista.module\";}i:24;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:21:\"raptor_floatingdialog\";s:8:\"filepath\";s:68:\"sites/all/modules/raptor_floatingdialog/raptor_floatingdialog.module\";}i:25;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:15:\"raptor_formulas\";s:8:\"filepath\";s:56:\"sites/all/modules/raptor_formulas/raptor_formulas.module\";}i:26;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:11:\"raptor_glue\";s:8:\"filepath\";s:48:\"sites/all/modules/raptor_glue/raptor_glue.module\";}i:27;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:12:\"raptor_graph\";s:8:\"filepath\";s:50:\"sites/all/modules/raptor_graph/raptor_graph.module\";}i:28;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:19:\"raptor_imageviewing\";s:8:\"filepath\";s:64:\"sites/all/modules/raptor_imageviewing/raptor_imageviewing.module\";}i:29;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:16:\"raptor_mdwsvista\";s:8:\"filepath\";s:58:\"sites/all/modules/raptor_mdwsvista/raptor_mdwsvista.module\";}i:30;a:3:{s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:12:\"raptor_omega\";s:8:\"filepath\";s:47:\"sites/all/themes/raptor_omega/raptor_omega.info\";}i:31;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:18:\"raptor_protocollib\";s:8:\"filepath\";s:62:\"sites/all/modules/raptor_protocollib/raptor_protocollib.module\";}i:32;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:14:\"raptor_reports\";s:8:\"filepath\";s:54:\"sites/all/modules/raptor_reports/raptor_reports.module\";}i:33;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:17:\"raptor_scheduling\";s:8:\"filepath\";s:60:\"sites/all/modules/raptor_scheduling/raptor_scheduling.module\";}i:34;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:15:\"raptor_workflow\";s:8:\"filepath\";s:56:\"sites/all/modules/raptor_workflow/raptor_workflow.module\";}i:35;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:3:\"rdf\";s:8:\"filepath\";s:22:\"modules/rdf/rdf.module\";}i:36;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:6:\"search\";s:8:\"filepath\";s:28:\"modules/search/search.module\";}i:37;a:3:{s:4:\"type\";s:5:\"theme\";s:4:\"name\";s:5:\"seven\";s:8:\"filepath\";s:23:\"themes/seven/seven.info\";}i:38;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:8:\"shortcut\";s:8:\"filepath\";s:32:\"modules/shortcut/shortcut.module\";}i:39;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:22:\"simplerulesengine_core\";s:8:\"filepath\";s:70:\"sites/all/modules/simplerulesengine_core/simplerulesengine_core.module\";}i:40;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:22:\"simplerulesengine_demo\";s:8:\"filepath\";s:70:\"sites/all/modules/simplerulesengine_demo/simplerulesengine_demo.module\";}i:41;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:20:\"simplerulesengine_ui\";s:8:\"filepath\";s:66:\"sites/all/modules/simplerulesengine_ui/simplerulesengine_ui.module\";}i:42;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:6:\"system\";s:8:\"filepath\";s:28:\"modules/system/system.module\";}i:43;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:8:\"taxonomy\";s:8:\"filepath\";s:32:\"modules/taxonomy/taxonomy.module\";}i:44;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"text\";s:8:\"filepath\";s:38:\"modules/field/modules/text/text.module\";}i:45;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:7:\"toolbar\";s:8:\"filepath\";s:30:\"modules/toolbar/toolbar.module\";}i:46;a:3:{s:4:\"type\";s:6:\"module\";s:4:\"name\";s:4:\"user\";s:8:\"filepath\";s:24:\"modules/user/user.module\";}}}',0,1454111015,1),('variables','a:63:{s:11:\"admin_theme\";s:5:\"seven\";s:11:\"block_cache\";i:0;s:5:\"cache\";i:1;s:14:\"cache_lifetime\";s:1:\"0\";s:9:\"clean_url\";s:1:\"1\";s:12:\"comment_page\";i:0;s:8:\"cron_key\";s:43:\"AScj_viI3ghgn0UttB5RPQd9jIVmreQF939GTHFLUOg\";s:9:\"cron_last\";i:1454337502;s:19:\"css_js_query_string\";s:6:\"nvlwf0\";s:16:\"ctools_last_cron\";i:1435416472;s:21:\"date_default_timezone\";s:16:\"America/New_York\";s:18:\"default_nodes_main\";s:2:\"10\";s:22:\"drupal_css_cache_files\";a:8:{s:64:\"823ba1006db72809515d2221cd02ec1075d7b49b0c07f49307b3a7930bfdd9e4\";s:64:\"public://css/css_4Al2K149ce-83FgX_mRRgk-YtIFAulxw8t1-4JcHeAE.css\";s:64:\"592db66916e1dd3416cbe95bcb34a5a68775eb0b7cf95e4c858671de35290cc9\";s:64:\"public://css/css_mAMwIbZCzzO3au8z3Ky3xXxkcsHf4WE7A24WoUlh5nk.css\";s:64:\"8d430bccf24c5d546e444dcd23fc6c61a49de1ed9c1e404d82c78c0f9ac0f1bc\";s:64:\"public://css/css_Vn_p7xhZmS8yWWx26P0Cc7Tm0GG2K1gLWEoVrhw5xxg.css\";s:64:\"35337ea541d4968f58917d83eaa9e495d5a38bb0aaf23bc714650d3c71fc275a\";s:64:\"public://css/css_Pmdj9ifwjm01gXl6zdJAfyzQKg8kWRvo00jTny3KRv0.css\";s:64:\"ebb3f433ad4107b1ac31e9d7de0f9a5d399040e9f82b6364211dcfaadea158c0\";s:64:\"public://css/css_xnrurbZsyY33-gWqNe8gzhEMWPZUFB4PrLX3qdSj_fY.css\";s:64:\"166c39698c0f957eb6b6650abfcd6d91b070a5b6fb0dd3d2b27a69110e8c4a87\";s:64:\"public://css/css_GHdbDbW98LtuK-Mb991Xa5vMGKyTBFPieie6dsSciM0.css\";s:64:\"6b3ad3e52813cb71d2e6a6dd86442a42bb4db90bfe41b99d977343fe9c03af42\";s:64:\"public://css/css_tEz89aVYLk72Uvkxx81aToqVay7A4SqLgwDYLdJFWck.css\";s:64:\"12774b0fa526d8bebdc3605602557ccf332a57e95fd92368562b537e75ed67d8\";s:64:\"public://css/css_QYbQgYmxXrZdDbDF3bvCjhS4BVVgznjCBsXuMk57DKY.css\";}s:25:\"drupal_http_request_fails\";b:0;s:21:\"drupal_js_cache_files\";a:12:{s:64:\"a571bc4156d0556568d7f04bc93f81c658b2e21fef9bb8229528c077ce9a0ccf\";s:61:\"public://js/js_xAPl0qIk9eowy_iS9tNkCWXLUVoat94SQT48UBCFkyQ.js\";s:64:\"9c7ad3b64966f68be435d73dfefb1ad341e46e22696cb373731d43092add0994\";s:61:\"public://js/js_I23gxiikXxx_6GGz6rJ54UoPf8kO1zLBQwc8jUznXYM.js\";s:64:\"ce0f5f2ee6e96bdb3b946cef9d31e9fc5d30b496afa4eb5305bc8fa2420a3b03\";s:61:\"public://js/js_Hz_mVNh8J0vO4m0vzL-WCyX8pJcZ_1066QvwfvZIrHM.js\";s:64:\"76fb25e6f2737904baec979ffbe4cc87c22e186f22a5f99eed11bf4587797768\";s:61:\"public://js/js_odYw4pTpJhpCLFW4ssiEY-bdMiTzhWBzwJ2pYHcn1Fw.js\";s:64:\"0e0a09af58d24101763ce218fb9690f9c61005f9751768677bc177b96126ef17\";s:61:\"public://js/js_A6-lQh-fSOxEz2MTJ-5OXi5j2RyiP7zFI-hWXcQW4F4.js\";s:64:\"ae8e24cb42eecc1787fe726127caa99aae937dab4b068e5e9b3a34c9d7c9a102\";s:61:\"public://js/js_nDf50CRV3tHdteg4Hebhp8uUrclxHmBMQe_Fk4vh14A.js\";s:64:\"3dc2a592bacebe7658f98b3ad76428f151217a35ec9d12fb150196b610520f47\";s:61:\"public://js/js_aAIlbdF4ccpzjDjvNZK8TO9ZjXNykfzDkEd7lgIXB9U.js\";s:64:\"949d4c38441cc0a42a633cda1670722670a9e4679f540efc87ab04538fb7b1c4\";s:61:\"public://js/js_GdNt6d4rCxc191dCINnRDgvthfLBXu-VXWkGwlzsy14.js\";s:64:\"1a30c351624a627553d78983ad986922fa2576d2391858497e3ca6bb022b6015\";s:61:\"public://js/js_CC-zfeuQHcDhFtVRuKW53h30TL7j_105J32Nz8b8R38.js\";s:64:\"4ae9a95afa43ece34b1efb2f7cad7f62e2eb64479f41ef7d66bc6e7147a8966a\";s:61:\"public://js/js_vNfk0E4QpZNmnRYJCe6E7LXYcNSNtAJmZCBP8gL0YD0.js\";s:64:\"e1f6a5c864b3b2254c254a40b336850796464d3a5f04d23a59cb0ed400375f18\";s:61:\"public://js/js_eztRFak5ak5uGNXesXkjOlrHEJx6fyWHV4zdrNw9gyM.js\";s:64:\"cd4cc5e34057d2bb09af9275787daf6cc5f6f99a26a5830bc9ec6721f1ae92ff\";s:61:\"public://js/js_0Xi47S3keKydmeqH6-O5Jwyf7IiRSDe9Dxbv6NU67Cw.js\";}s:18:\"drupal_private_key\";s:43:\"JDVo-L1-pyVitljyYaeSYQTznhw8x3n1ElTeLtWPN7o\";s:19:\"file_temporary_path\";s:23:\"sites/default/files/tmp\";s:22:\"filter_fallback_format\";s:10:\"plain_text\";s:25:\"forena_email_input_format\";s:13:\"filtered_html\";s:27:\"forena_input_format_enabled\";i:0;s:27:\"forena_last_query_data_path\";s:18:\"sites/default/data\";s:24:\"forena_pdf_docraptor_key\";s:0:\"\";s:25:\"forena_pdf_docraptor_test\";i:1;s:24:\"forena_pdf_docraptor_url\";s:26:\"https://docraptor.com/docs\";s:22:\"forena_pdf_prince_path\";s:21:\"/usr/local/bin/prince\";s:22:\"forena_query_data_path\";s:18:\"sites/default/data\";s:15:\"install_profile\";s:6:\"acquia\";s:12:\"install_task\";s:4:\"done\";s:12:\"install_time\";i:1417212358;s:16:\"maintenance_mode\";i:0;s:24:\"maintenance_mode_message\";s:97:\"localhost is currently under maintenance. We should be back shortly. Thank you for your patience.\";s:13:\"menu_expanded\";a:0:{}s:10:\"menu_masks\";a:34:{i:0;i:501;i:1;i:493;i:2;i:250;i:3;i:247;i:4;i:246;i:5;i:245;i:6;i:125;i:7;i:123;i:8;i:122;i:9;i:121;i:10;i:117;i:11;i:63;i:12;i:62;i:13;i:61;i:14;i:60;i:15;i:59;i:16;i:58;i:17;i:44;i:18;i:31;i:19;i:30;i:20;i:29;i:21;i:28;i:22;i:24;i:23;i:21;i:24;i:15;i:25;i:14;i:26;i:13;i:27;i:11;i:28;i:7;i:29;i:6;i:30;i:5;i:31;i:3;i:32;i:2;i:33;i:1;}s:16:\"node_admin_theme\";s:1:\"1\";s:14:\"node_cron_last\";s:10:\"1417212358\";s:17:\"node_options_page\";a:1:{i:0;s:6:\"status\";}s:19:\"node_submitted_page\";b:0;s:22:\"page_cache_maximum_age\";s:1:\"0\";s:16:\"page_compression\";i:1;s:21:\"pathauto_blog_pattern\";s:17:\"blogs/[user:name]\";s:22:\"pathauto_forum_pattern\";s:29:\"[term:vocabulary]/[term:name]\";s:21:\"pathauto_node_pattern\";s:20:\"content/[node:title]\";s:27:\"pathauto_punctuation_hyphen\";i:1;s:30:\"pathauto_taxonomy_term_pattern\";s:29:\"[term:vocabulary]/[term:name]\";s:21:\"pathauto_user_pattern\";s:17:\"users/[user:name]\";s:20:\"path_alias_whitelist\";a:2:{s:4:\"node\";b:1;s:4:\"user\";b:1;}s:14:\"preprocess_css\";i:1;s:13:\"preprocess_js\";i:1;s:8:\"site_403\";s:0:\"\";s:8:\"site_404\";s:0:\"\";s:20:\"site_default_country\";s:0:\"\";s:14:\"site_frontpage\";s:4:\"node\";s:9:\"site_mail\";s:19:\"support@room4me.com\";s:9:\"site_name\";s:16:\"Localhost RAPTOR\";s:11:\"site_slogan\";s:0:\"\";s:13:\"theme_default\";s:12:\"raptor_omega\";s:27:\"theme_raptor_omega_settings\";a:44:{s:11:\"toggle_logo\";i:1;s:11:\"toggle_name\";i:1;s:13:\"toggle_slogan\";i:1;s:24:\"toggle_node_user_picture\";i:0;s:27:\"toggle_comment_user_picture\";i:0;s:32:\"toggle_comment_user_verification\";i:0;s:14:\"toggle_favicon\";i:0;s:16:\"toggle_main_menu\";i:1;s:21:\"toggle_secondary_menu\";i:0;s:31:\"omega_toggle_front_page_content\";i:0;s:12:\"default_logo\";i:1;s:9:\"logo_path\";s:36:\"profiles/acquia/AcquiaDrupalLogo.png\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";i:1;s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:20:\"omega_enable_warning\";s:1:\"1\";s:30:\"omega_toggle_extension_layouts\";i:1;s:12:\"omega_layout\";s:5:\"admin\";s:34:\"omega_toggle_extension_development\";i:1;s:28:\"omega_rebuild_theme_registry\";i:0;s:24:\"omega_rebuild_aggregates\";i:0;s:29:\"omega_browser_width_indicator\";i:0;s:16:\"omega_livereload\";i:0;s:23:\"omega_livereload_script\";s:16:\"js/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";i:0;s:36:\"omega_toggle_extension_compatibility\";i:1;s:30:\"omega_conditional_classes_html\";i:1;s:17:\"omega_apple_touch\";i:1;s:15:\"omega_cleartype\";i:1;s:23:\"omega_handheld_friendly\";i:1;s:22:\"omega_mobile_optimized\";i:1;s:14:\"omega_viewport\";i:1;s:29:\"omega_viewport_user_scaleable\";i:1;s:17:\"omega_chrome_edge\";i:1;s:18:\"omega_chrome_popup\";i:0;s:19:\"omega_chrome_notice\";i:0;s:29:\"omega_toggle_extension_assets\";i:1;s:15:\"omega_js_footer\";a:0:{}s:17:\"omega_css_exclude\";a:0:{}s:16:\"omega_js_exclude\";a:0:{}s:15:\"omega_libraries\";a:4:{s:11:\"selectivizr\";a:1:{s:6:\"status\";i:1;}s:7:\"respond\";a:1:{s:6:\"status\";i:1;}s:3:\"pie\";a:2:{s:6:\"status\";i:1;s:9:\"selectors\";a:0:{}}s:9:\"html5shiv\";a:1:{s:6:\"status\";i:1;}}}s:15:\"user_admin_role\";s:1:\"3\";s:13:\"user_pictures\";s:1:\"1\";s:23:\"user_picture_dimensions\";s:9:\"1024x1024\";s:22:\"user_picture_file_size\";s:3:\"800\";s:18:\"user_picture_style\";s:9:\"thumbnail\";s:13:\"user_register\";i:2;}',0,1454341314,1);
/*!40000 ALTER TABLE `cache_bootstrap` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_field`
--

DROP TABLE IF EXISTS `cache_field`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_field` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_field`
--

LOCK TABLES `cache_field` WRITE;
/*!40000 ALTER TABLE `cache_field` DISABLE KEYS */;
INSERT INTO `cache_field` VALUES ('field:node:1','a:1:{s:4:\"body\";a:1:{s:3:\"und\";a:1:{i:0;a:3:{s:5:\"value\";s:3154:\"<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>\";s:7:\"summary\";s:3154:\"<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>\";s:6:\"format\";s:9:\"full_html\";}}}}',0,1454111016,1),('field:user:0','a:0:{}',0,1454110967,1),('field:user:1','a:0:{}',0,1454111033,1),('field_info:bundle:node:page','a:2:{s:9:\"instances\";a:1:{s:4:\"body\";a:13:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";i:31;s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";s:2:\"id\";s:1:\"2\";s:8:\"field_id\";s:1:\"2\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:7:\"deleted\";s:1:\"0\";s:13:\"default_value\";N;}}s:6:\"fields\";a:1:{i:0;a:16:{s:12:\"entity_types\";a:1:{i:0;s:4:\"node\";}s:12:\"translatable\";s:1:\"0\";s:8:\"settings\";a:0:{}s:7:\"storage\";a:5:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";s:1:\"1\";s:7:\"details\";a:1:{s:3:\"sql\";a:2:{s:18:\"FIELD_LOAD_CURRENT\";a:1:{s:15:\"field_data_body\";a:3:{s:5:\"value\";s:10:\"body_value\";s:7:\"summary\";s:12:\"body_summary\";s:6:\"format\";s:11:\"body_format\";}}s:19:\"FIELD_LOAD_REVISION\";a:1:{s:19:\"field_revision_body\";a:3:{s:5:\"value\";s:10:\"body_value\";s:7:\"summary\";s:12:\"body_summary\";s:6:\"format\";s:11:\"body_format\";}}}}}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}s:2:\"id\";s:1:\"2\";s:10:\"field_name\";s:4:\"body\";s:4:\"type\";s:17:\"text_with_summary\";s:6:\"module\";s:4:\"text\";s:6:\"active\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:11:\"cardinality\";s:1:\"1\";s:7:\"deleted\";s:1:\"0\";s:7:\"columns\";a:3:{s:5:\"value\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:7:\"summary\";a:3:{s:4:\"type\";s:4:\"text\";s:4:\"size\";s:3:\"big\";s:8:\"not null\";b:0;}s:6:\"format\";a:3:{s:4:\"type\";s:7:\"varchar\";s:6:\"length\";i:255;s:8:\"not null\";b:0;}}s:7:\"bundles\";a:1:{s:4:\"node\";a:2:{i:0;s:4:\"page\";i:1;s:7:\"article\";}}}}}',0,1454111016,1),('field_info:bundle:user:user','a:2:{s:9:\"instances\";a:0:{}s:6:\"fields\";a:0:{}}',0,1454110967,1),('field_info:field_map','a:4:{s:12:\"comment_body\";a:2:{s:7:\"bundles\";a:1:{s:7:\"comment\";a:2:{i:0;s:17:\"comment_node_page\";i:1;s:20:\"comment_node_article\";}}s:4:\"type\";s:9:\"text_long\";}s:4:\"body\";a:2:{s:7:\"bundles\";a:1:{s:4:\"node\";a:2:{i:0;s:4:\"page\";i:1;s:7:\"article\";}}s:4:\"type\";s:17:\"text_with_summary\";}s:10:\"field_tags\";a:2:{s:7:\"bundles\";a:1:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}}s:4:\"type\";s:23:\"taxonomy_term_reference\";}s:11:\"field_image\";a:2:{s:7:\"bundles\";a:1:{s:4:\"node\";a:1:{i:0;s:7:\"article\";}}s:4:\"type\";s:5:\"image\";}}',0,1454111016,1),('field_info_types:en','a:4:{s:11:\"field types\";a:13:{s:4:\"file\";a:7:{s:5:\"label\";s:4:\"File\";s:11:\"description\";s:55:\"This field stores the ID of a file as an integer value.\";s:8:\"settings\";a:3:{s:13:\"display_field\";i:0;s:15:\"display_default\";i:0;s:10:\"uri_scheme\";s:6:\"public\";}s:17:\"instance_settings\";a:5:{s:15:\"file_extensions\";s:3:\"txt\";s:14:\"file_directory\";s:0:\"\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";i:0;s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:12:\"file_generic\";s:17:\"default_formatter\";s:12:\"file_default\";s:6:\"module\";s:4:\"file\";}s:5:\"image\";a:7:{s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:62:\"This field stores the ID of an image file as an integer value.\";s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";i:0;}s:17:\"instance_settings\";a:9:{s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:14:\"file_directory\";s:0:\"\";s:12:\"max_filesize\";s:0:\"\";s:9:\"alt_field\";i:0;s:11:\"title_field\";i:0;s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:11:\"image_image\";s:17:\"default_formatter\";s:5:\"image\";s:6:\"module\";s:5:\"image\";}s:12:\"list_integer\";a:7:{s:5:\"label\";s:14:\"List (integer)\";s:11:\"description\";s:144:\"This field stores integer values from a list of allowed \'value => label\' pairs, i.e. \'Lifetime in days\': 1 => 1 day, 7 => 1 week, 31 => 1 month.\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:0:{}s:23:\"allowed_values_function\";s:0:\"\";}s:14:\"default_widget\";s:14:\"options_select\";s:17:\"default_formatter\";s:12:\"list_default\";s:17:\"instance_settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"module\";s:4:\"list\";}s:10:\"list_float\";a:7:{s:5:\"label\";s:12:\"List (float)\";s:11:\"description\";s:134:\"This field stores float values from a list of allowed \'value => label\' pairs, i.e. \'Fraction\': 0 => 0, .25 => 1/4, .75 => 3/4, 1 => 1.\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:0:{}s:23:\"allowed_values_function\";s:0:\"\";}s:14:\"default_widget\";s:14:\"options_select\";s:17:\"default_formatter\";s:12:\"list_default\";s:17:\"instance_settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"module\";s:4:\"list\";}s:9:\"list_text\";a:7:{s:5:\"label\";s:11:\"List (text)\";s:11:\"description\";s:137:\"This field stores text values from a list of allowed \'value => label\' pairs, i.e. \'US States\': IL => Illinois, IA => Iowa, IN => Indiana.\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:0:{}s:23:\"allowed_values_function\";s:0:\"\";}s:14:\"default_widget\";s:14:\"options_select\";s:17:\"default_formatter\";s:12:\"list_default\";s:17:\"instance_settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"module\";s:4:\"list\";}s:12:\"list_boolean\";a:7:{s:5:\"label\";s:7:\"Boolean\";s:11:\"description\";s:50:\"This field stores simple on/off or yes/no options.\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:0:{}s:23:\"allowed_values_function\";s:0:\"\";}s:14:\"default_widget\";s:15:\"options_buttons\";s:17:\"default_formatter\";s:12:\"list_default\";s:17:\"instance_settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"module\";s:4:\"list\";}s:14:\"number_integer\";a:7:{s:5:\"label\";s:7:\"Integer\";s:11:\"description\";s:57:\"This field stores a number in the database as an integer.\";s:17:\"instance_settings\";a:5:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:6:\"number\";s:17:\"default_formatter\";s:14:\"number_integer\";s:8:\"settings\";a:0:{}s:6:\"module\";s:6:\"number\";}s:14:\"number_decimal\";a:7:{s:5:\"label\";s:7:\"Decimal\";s:11:\"description\";s:69:\"This field stores a number in the database in a fixed decimal format.\";s:8:\"settings\";a:3:{s:9:\"precision\";i:10;s:5:\"scale\";i:2;s:17:\"decimal_separator\";s:1:\".\";}s:17:\"instance_settings\";a:5:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:6:\"number\";s:17:\"default_formatter\";s:14:\"number_decimal\";s:6:\"module\";s:6:\"number\";}s:12:\"number_float\";a:7:{s:5:\"label\";s:5:\"Float\";s:11:\"description\";s:70:\"This field stores a number in the database in a floating point format.\";s:8:\"settings\";a:1:{s:17:\"decimal_separator\";s:1:\".\";}s:17:\"instance_settings\";a:5:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:6:\"number\";s:17:\"default_formatter\";s:14:\"number_decimal\";s:6:\"module\";s:6:\"number\";}s:23:\"taxonomy_term_reference\";a:7:{s:5:\"label\";s:14:\"Term reference\";s:11:\"description\";s:49:\"This field stores a reference to a taxonomy term.\";s:14:\"default_widget\";s:14:\"options_select\";s:17:\"default_formatter\";s:28:\"taxonomy_term_reference_link\";s:8:\"settings\";a:1:{s:14:\"allowed_values\";a:1:{i:0;a:2:{s:10:\"vocabulary\";s:0:\"\";s:6:\"parent\";s:1:\"0\";}}}s:17:\"instance_settings\";a:1:{s:18:\"user_register_form\";b:0;}s:6:\"module\";s:8:\"taxonomy\";}s:4:\"text\";a:7:{s:5:\"label\";s:4:\"Text\";s:11:\"description\";s:47:\"This field stores varchar text in the database.\";s:8:\"settings\";a:1:{s:10:\"max_length\";i:255;}s:17:\"instance_settings\";a:2:{s:15:\"text_processing\";i:0;s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:14:\"text_textfield\";s:17:\"default_formatter\";s:12:\"text_default\";s:6:\"module\";s:4:\"text\";}s:9:\"text_long\";a:7:{s:5:\"label\";s:9:\"Long text\";s:11:\"description\";s:44:\"This field stores long text in the database.\";s:17:\"instance_settings\";a:2:{s:15:\"text_processing\";i:0;s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:13:\"text_textarea\";s:17:\"default_formatter\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:17:\"text_with_summary\";a:7:{s:5:\"label\";s:21:\"Long text and summary\";s:11:\"description\";s:77:\"This field stores long text in the database along with optional summary text.\";s:17:\"instance_settings\";a:3:{s:15:\"text_processing\";i:1;s:15:\"display_summary\";i:0;s:18:\"user_register_form\";b:0;}s:14:\"default_widget\";s:26:\"text_textarea_with_summary\";s:17:\"default_formatter\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:12:\"widget types\";a:10:{s:21:\"taxonomy_autocomplete\";a:5:{s:5:\"label\";s:34:\"Autocomplete term widget (tagging)\";s:11:\"field types\";a:1:{i:0;s:23:\"taxonomy_term_reference\";}s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:21:\"taxonomy/autocomplete\";}s:9:\"behaviors\";a:1:{s:15:\"multiple values\";i:4;}s:6:\"module\";s:8:\"taxonomy\";}s:14:\"text_textfield\";a:4:{s:5:\"label\";s:10:\"Text field\";s:11:\"field types\";a:1:{i:0;s:4:\"text\";}s:8:\"settings\";a:1:{s:4:\"size\";i:60;}s:6:\"module\";s:4:\"text\";}s:13:\"text_textarea\";a:4:{s:5:\"label\";s:25:\"Text area (multiple rows)\";s:11:\"field types\";a:1:{i:0;s:9:\"text_long\";}s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"module\";s:4:\"text\";}s:26:\"text_textarea_with_summary\";a:4:{s:5:\"label\";s:24:\"Text area with a summary\";s:11:\"field types\";a:1:{i:0;s:17:\"text_with_summary\";}s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"module\";s:4:\"text\";}s:13:\"options_onoff\";a:5:{s:5:\"label\";s:22:\"Single on/off checkbox\";s:11:\"field types\";a:1:{i:0;s:12:\"list_boolean\";}s:9:\"behaviors\";a:1:{s:15:\"multiple values\";i:4;}s:8:\"settings\";a:1:{s:13:\"display_label\";i:0;}s:6:\"module\";s:7:\"options\";}s:15:\"options_buttons\";a:5:{s:5:\"label\";s:25:\"Check boxes/radio buttons\";s:11:\"field types\";a:5:{i:0;s:12:\"list_integer\";i:1;s:10:\"list_float\";i:2;s:9:\"list_text\";i:3;s:12:\"list_boolean\";i:4;s:23:\"taxonomy_term_reference\";}s:9:\"behaviors\";a:1:{s:15:\"multiple values\";i:4;}s:8:\"settings\";a:0:{}s:6:\"module\";s:7:\"options\";}s:11:\"image_image\";a:5:{s:5:\"label\";s:5:\"Image\";s:11:\"field types\";a:1:{i:0;s:5:\"image\";}s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:9:\"behaviors\";a:2:{s:15:\"multiple values\";i:4;s:13:\"default value\";i:1;}s:6:\"module\";s:5:\"image\";}s:6:\"number\";a:4:{s:5:\"label\";s:10:\"Text field\";s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:6:\"number\";}s:14:\"options_select\";a:5:{s:5:\"label\";s:11:\"Select list\";s:11:\"field types\";a:4:{i:0;s:12:\"list_integer\";i:1;s:10:\"list_float\";i:2;s:9:\"list_text\";i:3;s:23:\"taxonomy_term_reference\";}s:9:\"behaviors\";a:1:{s:15:\"multiple values\";i:4;}s:8:\"settings\";a:0:{}s:6:\"module\";s:7:\"options\";}s:12:\"file_generic\";a:5:{s:5:\"label\";s:4:\"File\";s:11:\"field types\";a:1:{i:0;s:4:\"file\";}s:8:\"settings\";a:1:{s:18:\"progress_indicator\";s:8:\"throbber\";}s:9:\"behaviors\";a:2:{s:15:\"multiple values\";i:4;s:13:\"default value\";i:1;}s:6:\"module\";s:4:\"file\";}}s:15:\"formatter types\";a:16:{s:12:\"file_default\";a:4:{s:5:\"label\";s:12:\"Generic file\";s:11:\"field types\";a:1:{i:0;s:4:\"file\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"file\";}s:10:\"file_table\";a:4:{s:5:\"label\";s:14:\"Table of files\";s:11:\"field types\";a:1:{i:0;s:4:\"file\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"file\";}s:14:\"file_url_plain\";a:4:{s:5:\"label\";s:11:\"URL to file\";s:11:\"field types\";a:1:{i:0;s:4:\"file\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"file\";}s:5:\"image\";a:4:{s:5:\"label\";s:5:\"Image\";s:11:\"field types\";a:1:{i:0;s:5:\"image\";}s:8:\"settings\";a:2:{s:11:\"image_style\";s:0:\"\";s:10:\"image_link\";s:0:\"\";}s:6:\"module\";s:5:\"image\";}s:12:\"list_default\";a:4:{s:5:\"label\";s:7:\"Default\";s:11:\"field types\";a:4:{i:0;s:12:\"list_integer\";i:1;s:10:\"list_float\";i:2;s:9:\"list_text\";i:3;s:12:\"list_boolean\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"list\";}s:8:\"list_key\";a:4:{s:5:\"label\";s:3:\"Key\";s:11:\"field types\";a:4:{i:0;s:12:\"list_integer\";i:1;s:10:\"list_float\";i:2;s:9:\"list_text\";i:3;s:12:\"list_boolean\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"list\";}s:14:\"number_integer\";a:4:{s:5:\"label\";s:7:\"Default\";s:11:\"field types\";a:1:{i:0;s:14:\"number_integer\";}s:8:\"settings\";a:4:{s:18:\"thousand_separator\";s:0:\"\";s:17:\"decimal_separator\";s:1:\".\";s:5:\"scale\";i:0;s:13:\"prefix_suffix\";b:1;}s:6:\"module\";s:6:\"number\";}s:14:\"number_decimal\";a:4:{s:5:\"label\";s:7:\"Default\";s:11:\"field types\";a:2:{i:0;s:14:\"number_decimal\";i:1;s:12:\"number_float\";}s:8:\"settings\";a:4:{s:18:\"thousand_separator\";s:0:\"\";s:17:\"decimal_separator\";s:1:\".\";s:5:\"scale\";i:2;s:13:\"prefix_suffix\";b:1;}s:6:\"module\";s:6:\"number\";}s:18:\"number_unformatted\";a:4:{s:5:\"label\";s:11:\"Unformatted\";s:11:\"field types\";a:3:{i:0;s:14:\"number_integer\";i:1;s:14:\"number_decimal\";i:2;s:12:\"number_float\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:6:\"number\";}s:28:\"taxonomy_term_reference_link\";a:4:{s:5:\"label\";s:4:\"Link\";s:11:\"field types\";a:1:{i:0;s:23:\"taxonomy_term_reference\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}s:29:\"taxonomy_term_reference_plain\";a:4:{s:5:\"label\";s:10:\"Plain text\";s:11:\"field types\";a:1:{i:0;s:23:\"taxonomy_term_reference\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}s:36:\"taxonomy_term_reference_rss_category\";a:4:{s:5:\"label\";s:12:\"RSS category\";s:11:\"field types\";a:1:{i:0;s:23:\"taxonomy_term_reference\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}s:12:\"text_default\";a:4:{s:5:\"label\";s:7:\"Default\";s:11:\"field types\";a:3:{i:0;s:4:\"text\";i:1;s:9:\"text_long\";i:2;s:17:\"text_with_summary\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:10:\"text_plain\";a:4:{s:5:\"label\";s:10:\"Plain text\";s:11:\"field types\";a:3:{i:0;s:4:\"text\";i:1;s:9:\"text_long\";i:2;s:17:\"text_with_summary\";}s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}s:12:\"text_trimmed\";a:4:{s:5:\"label\";s:7:\"Trimmed\";s:11:\"field types\";a:3:{i:0;s:4:\"text\";i:1;s:9:\"text_long\";i:2;s:17:\"text_with_summary\";}s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";}s:23:\"text_summary_or_trimmed\";a:4:{s:5:\"label\";s:18:\"Summary or trimmed\";s:11:\"field types\";a:1:{i:0;s:17:\"text_with_summary\";}s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";}}s:13:\"storage types\";a:1:{s:17:\"field_sql_storage\";a:4:{s:5:\"label\";s:19:\"Default SQL storage\";s:11:\"description\";s:64:\"Stores fields in the local SQL database, using per-field tables.\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";}}}',0,1454111016,1);
/*!40000 ALTER TABLE `cache_field` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_filter`
--

DROP TABLE IF EXISTS `cache_filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_filter` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the Filter module to store already...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_filter`
--

LOCK TABLES `cache_filter` WRITE;
/*!40000 ALTER TABLE `cache_filter` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_form`
--

DROP TABLE IF EXISTS `cache_form`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_form` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the form system to store recently built...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_form`
--

LOCK TABLES `cache_form` WRITE;
/*!40000 ALTER TABLE `cache_form` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_form` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_image`
--

DROP TABLE IF EXISTS `cache_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_image` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store information about image...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_image`
--

LOCK TABLES `cache_image` WRITE;
/*!40000 ALTER TABLE `cache_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_menu`
--

DROP TABLE IF EXISTS `cache_menu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_menu` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for the menu system to store router...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_menu`
--

LOCK TABLES `cache_menu` WRITE;
/*!40000 ALTER TABLE `cache_menu` DISABLE KEYS */;
INSERT INTO `cache_menu` VALUES ('links:main-menu:page:admin/modules:en:1:1','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";i:1;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1443811944,1),('links:main-menu:page:user/login:en:1:1','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";i:1;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454111015,1),('links:main-menu:page:worklist:en:1:1','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";i:1;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454341313,1),('links:main-menu:tree-data:en:9ec01ec58bf82a695e4acd636af283e0585fe8cd8a6e54eb140188a3e284ab1c','a:2:{s:4:\"tree\";a:1:{i:214;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"main-menu\";s:4:\"mlid\";s:3:\"214\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:7:\"<front>\";s:11:\"router_path\";s:0:\"\";s:10:\"link_title\";s:4:\"Home\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:4:\"menu\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"1\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:3:\"214\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";N;s:16:\"to_arg_functions\";N;s:15:\"access_callback\";N;s:16:\"access_arguments\";N;s:13:\"page_callback\";N;s:14:\"page_arguments\";N;s:17:\"delivery_callback\";N;s:10:\"tab_parent\";N;s:8:\"tab_root\";N;s:5:\"title\";N;s:14:\"title_callback\";N;s:15:\"title_arguments\";N;s:14:\"theme_callback\";N;s:15:\"theme_arguments\";N;s:4:\"type\";N;s:11:\"description\";N;s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1443811944,1),('links:management:page:admin/modules:en:1:0:trail','a:5:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:17:\"only_active_trail\";b:1;s:8:\"expanded\";a:3:{i:0;i:0;i:1;s:1:\"1\";i:16;s:2:\"16\";}s:12:\"active_trail\";a:3:{i:0;i:0;i:1;s:1:\"1\";i:16;s:2:\"16\";}}',0,1443811944,1),('links:management:tree-data:en:09bc82c9ca1d7556a24149515bfb07a41d387c78c7e7b30eb983f4ae4705a30f','a:2:{s:4:\"tree\";a:1:{i:1;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"1\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:5:\"admin\";s:11:\"router_path\";s:5:\"admin\";s:10:\"link_title\";s:14:\"Administration\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"9\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:5:\"admin\";s:5:\"title\";s:14:\"Administration\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:1;}s:5:\"below\";a:11:{i:7;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"7\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:16:\"admin/appearance\";s:11:\"router_path\";s:16:\"admin/appearance\";s:10:\"link_title\";s:10:\"Appearance\";s:7:\"options\";s:83:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Select and configure your themes.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-6\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"7\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:35:\"a:1:{i:0;s:17:\"administer themes\";}\";s:13:\"page_callback\";s:18:\"system_themes_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:16:\"admin/appearance\";s:5:\"title\";s:10:\"Appearance\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:33:\"Select and configure your themes.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:8;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"8\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:12:\"admin/config\";s:11:\"router_path\";s:12:\"admin/config\";s:10:\"link_title\";s:13:\"Configuration\";s:7:\"options\";s:70:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:20:\"Administer settings.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"8\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:24:\"system_admin_config_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:12:\"admin/config\";s:5:\"title\";s:13:\"Configuration\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:20:\"Administer settings.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:9;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"9\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/content\";s:11:\"router_path\";s:13:\"admin/content\";s:10:\"link_title\";s:7:\"Content\";s:7:\"options\";s:82:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:32:\"Administer content and comments.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-10\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"9\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:41:\"a:1:{i:0;s:23:\"access content overview\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:36:\"a:1:{i:0;s:18:\"node_admin_content\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/content\";s:5:\"title\";s:7:\"Content\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:32:\"Administer content and comments.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:11;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"11\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:15:\"admin/dashboard\";s:11:\"router_path\";s:15:\"admin/dashboard\";s:10:\"link_title\";s:9:\"Dashboard\";s:7:\"options\";s:84:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View and customize your dashboard.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-15\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"11\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:34:\"a:1:{i:0;s:16:\"access dashboard\";}\";s:13:\"page_callback\";s:15:\"dashboard_admin\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"admin/dashboard\";s:5:\"title\";s:9:\"Dashboard\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:34:\"View and customize your dashboard.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:12;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"12\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:10:\"admin/help\";s:11:\"router_path\";s:10:\"admin/help\";s:10:\"link_title\";s:4:\"Help\";s:7:\"options\";s:98:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:48:\"Reference for usage, configuration, and modules.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"9\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"12\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:9:\"help_main\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:10:\"admin/help\";s:5:\"title\";s:4:\"Help\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:48:\"Reference for usage, configuration, and modules.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:13;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"13\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:11:\"admin/index\";s:11:\"router_path\";s:11:\"admin/index\";s:10:\"link_title\";s:5:\"Index\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-18\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"13\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:18:\"system_admin_index\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:5:\"admin\";s:8:\"tab_root\";s:5:\"admin\";s:5:\"title\";s:5:\"Index\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:16;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"16\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/modules\";s:11:\"router_path\";s:13:\"admin/modules\";s:10:\"link_title\";s:7:\"Modules\";s:7:\"options\";s:76:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:26:\"Extend site functionality.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-2\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"16\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:32:\"a:1:{i:0;s:14:\"system_modules\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:7:\"Modules\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:26:\"Extend site functionality.\";s:15:\"in_active_trail\";b:1;}s:5:\"below\";a:2:{i:41;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"41\";s:4:\"plid\";s:2:\"16\";s:9:\"link_path\";s:18:\"admin/modules/list\";s:11:\"router_path\";s:18:\"admin/modules/list\";s:10:\"link_title\";s:4:\"List\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"3\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"16\";s:2:\"p3\";s:2:\"41\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:32:\"a:1:{i:0;s:14:\"system_modules\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:13:\"admin/modules\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:4:\"List\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:54;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"54\";s:4:\"plid\";s:2:\"16\";s:9:\"link_path\";s:23:\"admin/modules/uninstall\";s:11:\"router_path\";s:23:\"admin/modules/uninstall\";s:10:\"link_title\";s:9:\"Uninstall\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"20\";s:5:\"depth\";s:1:\"3\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"16\";s:2:\"p3\";s:2:\"54\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:42:\"a:1:{i:0;s:24:\"system_modules_uninstall\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:13:\"admin/modules\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:9:\"Uninstall\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}}i:18;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"18\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:12:\"admin/people\";s:11:\"router_path\";s:12:\"admin/people\";s:10:\"link_title\";s:6:\"People\";s:7:\"options\";s:95:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Manage user accounts, roles, and permissions.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-4\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"18\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:34:\"a:1:{i:0;s:16:\"administer users\";}\";s:13:\"page_callback\";s:10:\"user_admin\";s:14:\"page_arguments\";s:21:\"a:1:{i:0;s:4:\"list\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:12:\"admin/people\";s:5:\"title\";s:6:\"People\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:45:\"Manage user accounts, roles, and permissions.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:19;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"19\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/reports\";s:11:\"router_path\";s:13:\"admin/reports\";s:10:\"link_title\";s:7:\"Reports\";s:7:\"options\";s:84:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View reports, updates, and errors.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"5\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"19\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:37:\"a:1:{i:0;s:19:\"access site reports\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/reports\";s:5:\"title\";s:7:\"Reports\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:34:\"View reports, updates, and errors.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:21;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"21\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:15:\"admin/structure\";s:11:\"router_path\";s:15:\"admin/structure\";s:10:\"link_title\";s:9:\"Structure\";s:7:\"options\";s:95:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Administer blocks, content types, menus, etc.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-8\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"21\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"admin/structure\";s:5:\"title\";s:9:\"Structure\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:45:\"Administer blocks, content types, menus, etc.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:22;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"22\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:11:\"admin/tasks\";s:11:\"router_path\";s:11:\"admin/tasks\";s:10:\"link_title\";s:5:\"Tasks\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-20\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"22\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:5:\"admin\";s:8:\"tab_root\";s:5:\"admin\";s:5:\"title\";s:5:\"Tasks\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}}}s:10:\"node_links\";a:0:{}}',0,1443811944,1),('links:management:tree-data:en:a9eea78b0aeaddd605894be48877502635d2ae1b2a8a8d29cc1b7d377b699477','a:2:{s:4:\"tree\";a:11:{i:7;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"7\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:16:\"admin/appearance\";s:11:\"router_path\";s:16:\"admin/appearance\";s:10:\"link_title\";s:10:\"Appearance\";s:7:\"options\";s:83:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Select and configure your themes.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-6\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"7\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:35:\"a:1:{i:0;s:17:\"administer themes\";}\";s:13:\"page_callback\";s:18:\"system_themes_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:16:\"admin/appearance\";s:5:\"title\";s:10:\"Appearance\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:33:\"Select and configure your themes.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:8;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"8\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:12:\"admin/config\";s:11:\"router_path\";s:12:\"admin/config\";s:10:\"link_title\";s:13:\"Configuration\";s:7:\"options\";s:70:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:20:\"Administer settings.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"8\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:24:\"system_admin_config_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:12:\"admin/config\";s:5:\"title\";s:13:\"Configuration\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:20:\"Administer settings.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:9;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:1:\"9\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/content\";s:11:\"router_path\";s:13:\"admin/content\";s:10:\"link_title\";s:7:\"Content\";s:7:\"options\";s:82:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:32:\"Administer content and comments.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-10\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:1:\"9\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:41:\"a:1:{i:0;s:23:\"access content overview\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:36:\"a:1:{i:0;s:18:\"node_admin_content\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/content\";s:5:\"title\";s:7:\"Content\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:32:\"Administer content and comments.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:11;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"11\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:15:\"admin/dashboard\";s:11:\"router_path\";s:15:\"admin/dashboard\";s:10:\"link_title\";s:9:\"Dashboard\";s:7:\"options\";s:84:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View and customize your dashboard.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-15\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"11\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:34:\"a:1:{i:0;s:16:\"access dashboard\";}\";s:13:\"page_callback\";s:15:\"dashboard_admin\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"admin/dashboard\";s:5:\"title\";s:9:\"Dashboard\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:34:\"View and customize your dashboard.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:12;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"12\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:10:\"admin/help\";s:11:\"router_path\";s:10:\"admin/help\";s:10:\"link_title\";s:4:\"Help\";s:7:\"options\";s:98:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:48:\"Reference for usage, configuration, and modules.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"9\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"12\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:9:\"help_main\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:10:\"admin/help\";s:5:\"title\";s:4:\"Help\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:48:\"Reference for usage, configuration, and modules.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:13;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"13\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:11:\"admin/index\";s:11:\"router_path\";s:11:\"admin/index\";s:10:\"link_title\";s:5:\"Index\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-18\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"13\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:18:\"system_admin_index\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:5:\"admin\";s:8:\"tab_root\";s:5:\"admin\";s:5:\"title\";s:5:\"Index\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:16;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"16\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/modules\";s:11:\"router_path\";s:13:\"admin/modules\";s:10:\"link_title\";s:7:\"Modules\";s:7:\"options\";s:76:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:26:\"Extend site functionality.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-2\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"16\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:32:\"a:1:{i:0;s:14:\"system_modules\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:7:\"Modules\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:26:\"Extend site functionality.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:18;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"18\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:12:\"admin/people\";s:11:\"router_path\";s:12:\"admin/people\";s:10:\"link_title\";s:6:\"People\";s:7:\"options\";s:95:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Manage user accounts, roles, and permissions.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-4\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"18\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:34:\"a:1:{i:0;s:16:\"administer users\";}\";s:13:\"page_callback\";s:10:\"user_admin\";s:14:\"page_arguments\";s:21:\"a:1:{i:0;s:4:\"list\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:12:\"admin/people\";s:5:\"title\";s:6:\"People\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:45:\"Manage user accounts, roles, and permissions.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:19;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"19\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:13:\"admin/reports\";s:11:\"router_path\";s:13:\"admin/reports\";s:10:\"link_title\";s:7:\"Reports\";s:7:\"options\";s:84:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View reports, updates, and errors.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"5\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"19\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:37:\"a:1:{i:0;s:19:\"access site reports\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/reports\";s:5:\"title\";s:7:\"Reports\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:34:\"View reports, updates, and errors.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:21;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"21\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:15:\"admin/structure\";s:11:\"router_path\";s:15:\"admin/structure\";s:10:\"link_title\";s:9:\"Structure\";s:7:\"options\";s:95:\"a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Administer blocks, content types, menus, etc.\";}}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"-8\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"21\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"admin/structure\";s:5:\"title\";s:9:\"Structure\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:45:\"Administer blocks, content types, menus, etc.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:22;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"management\";s:4:\"mlid\";s:2:\"22\";s:4:\"plid\";s:1:\"1\";s:9:\"link_path\";s:11:\"admin/tasks\";s:11:\"router_path\";s:11:\"admin/tasks\";s:10:\"link_title\";s:5:\"Tasks\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-20\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"1\";s:2:\"p2\";s:2:\"22\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:45:\"a:1:{i:0;s:27:\"access administration pages\";}\";s:13:\"page_callback\";s:28:\"system_admin_menu_block_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:5:\"admin\";s:8:\"tab_root\";s:5:\"admin\";s:5:\"title\";s:5:\"Tasks\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1443811944,1),('links:navigation:page:node:en:1:0','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454111016,1),('links:navigation:page:user/login:en:1:0','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454111015,1),('links:navigation:page:worklist:en:1:0','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454341313,1),('links:navigation:tree-data:en:9bd1605e2280833450478f9083b7f8714c2fa28f1012455e2744e5af1a13eec5','a:2:{s:4:\"tree\";a:8:{i:3;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:1:\"3\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:9:\"comment/%\";s:11:\"router_path\";s:9:\"comment/%\";s:10:\"link_title\";s:17:\"Comment permalink\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"3\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:12:\"a:1:{i:1;N;}\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:33:\"a:1:{i:0;s:15:\"access comments\";}\";s:13:\"page_callback\";s:17:\"comment_permalink\";s:14:\"page_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:9:\"comment/%\";s:5:\"title\";s:17:\"Comment permalink\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:4;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:1:\"4\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:11:\"filter/tips\";s:11:\"router_path\";s:11:\"filter/tips\";s:10:\"link_title\";s:12:\"Compose tips\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"4\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"1\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:16:\"filter_tips_long\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:11:\"filter/tips\";s:5:\"title\";s:12:\"Compose tips\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:2:\"20\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:5;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:1:\"5\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:6:\"node/%\";s:11:\"router_path\";s:6:\"node/%\";s:10:\"link_title\";s:0:\"\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"5\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:26:\"a:1:{i:1;s:9:\"node_load\";}\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"node_access\";s:16:\"access_arguments\";s:29:\"a:2:{i:0;s:4:\"view\";i:1;i:1;}\";s:13:\"page_callback\";s:14:\"node_page_view\";s:14:\"page_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:6:\"node/%\";s:5:\"title\";s:0:\"\";s:14:\"title_callback\";s:15:\"node_page_title\";s:15:\"title_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:6;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:1:\"6\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:8:\"node/add\";s:11:\"router_path\";s:8:\"node/add\";s:10:\"link_title\";s:11:\"Add content\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"6\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:16:\"_node_add_access\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:13:\"node_add_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:8:\"node/add\";s:5:\"title\";s:11:\"Add content\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:17;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:2:\"17\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:6:\"user/%\";s:11:\"router_path\";s:6:\"user/%\";s:10:\"link_title\";s:10:\"My account\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"1\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:2:\"17\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:26:\"a:1:{i:1;s:9:\"user_load\";}\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:16:\"user_view_access\";s:16:\"access_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:13:\"page_callback\";s:14:\"user_view_page\";s:14:\"page_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:6:\"user/%\";s:5:\"title\";s:10:\"My account\";s:14:\"title_callback\";s:15:\"user_page_title\";s:15:\"title_arguments\";s:14:\"a:1:{i:0;i:1;}\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:23;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:2:\"23\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:15:\"comment/reply/%\";s:11:\"router_path\";s:15:\"comment/reply/%\";s:10:\"link_title\";s:15:\"Add new comment\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:2:\"23\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:26:\"a:1:{i:2;s:9:\"node_load\";}\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"node_access\";s:16:\"access_arguments\";s:29:\"a:2:{i:0;s:4:\"view\";i:1;i:2;}\";s:13:\"page_callback\";s:13:\"comment_reply\";s:14:\"page_arguments\";s:14:\"a:1:{i:0;i:2;}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"comment/reply/%\";s:5:\"title\";s:15:\"Add new comment\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:169;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:3:\"169\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:6:\"search\";s:11:\"router_path\";s:6:\"search\";s:10:\"link_title\";s:6:\"Search\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:3:\"169\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:16:\"search_is_active\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:11:\"search_view\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:2:\"20\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:172;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:10:\"navigation\";s:4:\"mlid\";s:3:\"172\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:15:\"taxonomy/term/%\";s:11:\"router_path\";s:15:\"taxonomy/term/%\";s:10:\"link_title\";s:13:\"Taxonomy term\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:3:\"172\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:36:\"a:1:{i:2;s:18:\"taxonomy_term_load\";}\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:32:\"a:1:{i:0;s:14:\"access content\";}\";s:13:\"page_callback\";s:18:\"taxonomy_term_page\";s:14:\"page_arguments\";s:14:\"a:1:{i:0;i:2;}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:15:\"taxonomy/term/%\";s:5:\"title\";s:13:\"Taxonomy term\";s:14:\"title_callback\";s:19:\"taxonomy_term_title\";s:15:\"title_arguments\";s:14:\"a:1:{i:0;i:2;}\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1454111015,1),('links:shortcut-set-1:page:admin/modules:en:1:0','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1443811944,1),('links:shortcut-set-1:page:worklist:en:1:0','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1454341313,1),('links:shortcut-set-1:tree-data:en:9bd1605e2280833450478f9083b7f8714c2fa28f1012455e2744e5af1a13eec5','a:2:{s:4:\"tree\";a:2:{i:212;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:14:\"shortcut-set-1\";s:4:\"mlid\";s:3:\"212\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:8:\"node/add\";s:11:\"router_path\";s:8:\"node/add\";s:10:\"link_title\";s:11:\"Add content\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:4:\"menu\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-20\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:3:\"212\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:16:\"_node_add_access\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:13:\"node_add_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:8:\"node/add\";s:5:\"title\";s:11:\"Add content\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:213;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:14:\"shortcut-set-1\";s:4:\"mlid\";s:3:\"213\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:13:\"admin/content\";s:11:\"router_path\";s:13:\"admin/content\";s:10:\"link_title\";s:12:\"Find content\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:4:\"menu\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-19\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:3:\"213\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:41:\"a:1:{i:0;s:23:\"access content overview\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:36:\"a:1:{i:0;s:18:\"node_admin_content\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/content\";s:5:\"title\";s:7:\"Content\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:32:\"Administer content and comments.\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1443811944,1),('links:user-menu:page:admin/modules:en:1:1','a:4:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";i:1;s:8:\"expanded\";a:1:{i:0;i:0;}s:12:\"active_trail\";a:1:{i:0;i:0;}}',0,1443811944,1),('links:user-menu:page:user/login:en:1:0:trail','a:5:{s:9:\"min_depth\";i:1;s:9:\"max_depth\";N;s:17:\"only_active_trail\";b:1;s:8:\"expanded\";a:3:{i:0;i:0;i:2;s:1:\"2\";i:14;s:2:\"14\";}s:12:\"active_trail\";a:3:{i:0;i:0;i:2;s:1:\"2\";i:14;s:2:\"14\";}}',0,1454111015,1),('links:user-menu:tree-data:en:2dca64bda4df082ccbecd433b90151b6de60b9878dd71b4e245f1f8a504f8e53','a:2:{s:4:\"tree\";a:2:{i:2;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:1:\"2\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:4:\"user\";s:11:\"router_path\";s:4:\"user\";s:10:\"link_title\";s:12:\"User account\";s:7:\"options\";s:22:\"a:1:{s:5:\"alter\";b:1;}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-10\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"2\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"1\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:9:\"user_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:12:\"User account\";s:14:\"title_callback\";s:15:\"user_menu_title\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:1;}s:5:\"below\";a:3:{i:10;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:2:\"10\";s:4:\"plid\";s:1:\"2\";s:9:\"link_path\";s:13:\"user/register\";s:11:\"router_path\";s:13:\"user/register\";s:10:\"link_title\";s:18:\"Create new account\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"2\";s:2:\"p2\";s:2:\"10\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"0\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:36:\"a:1:{i:0;s:18:\"user_register_form\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:18:\"Create new account\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:14;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:2:\"14\";s:4:\"plid\";s:1:\"2\";s:9:\"link_path\";s:10:\"user/login\";s:11:\"router_path\";s:10:\"user/login\";s:10:\"link_title\";s:6:\"Log in\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"2\";s:2:\"p2\";s:2:\"14\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:17:\"user_is_anonymous\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:9:\"user_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:6:\"Log in\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:1;}s:5:\"below\";a:0:{}}i:20;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:2:\"20\";s:4:\"plid\";s:1:\"2\";s:9:\"link_path\";s:13:\"user/password\";s:11:\"router_path\";s:13:\"user/password\";s:10:\"link_title\";s:20:\"Request new password\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:2:\"-1\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:1:\"0\";s:5:\"depth\";s:1:\"2\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"2\";s:2:\"p2\";s:2:\"20\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"0\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:26:\"a:1:{i:0;s:9:\"user_pass\";}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:20:\"Request new password\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}}i:15;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:2:\"15\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:11:\"user/logout\";s:11:\"router_path\";s:11:\"user/logout\";s:10:\"link_title\";s:7:\"Log out\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"10\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:2:\"15\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:17:\"user_is_logged_in\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:11:\"user_logout\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:11:\"user/logout\";s:5:\"title\";s:7:\"Log out\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1454111015,1),('links:user-menu:tree-data:en:9ec01ec58bf82a695e4acd636af283e0585fe8cd8a6e54eb140188a3e284ab1c','a:2:{s:4:\"tree\";a:2:{i:2;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:1:\"2\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:4:\"user\";s:11:\"router_path\";s:4:\"user\";s:10:\"link_title\";s:12:\"User account\";s:7:\"options\";s:22:\"a:1:{s:5:\"alter\";b:1;}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:3:\"-10\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:1:\"2\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"1\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:9:\"user_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:12:\"User account\";s:14:\"title_callback\";s:15:\"user_menu_title\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}i:15;a:2:{s:4:\"link\";a:42:{s:9:\"menu_name\";s:9:\"user-menu\";s:4:\"mlid\";s:2:\"15\";s:4:\"plid\";s:1:\"0\";s:9:\"link_path\";s:11:\"user/logout\";s:11:\"router_path\";s:11:\"user/logout\";s:10:\"link_title\";s:7:\"Log out\";s:7:\"options\";s:6:\"a:0:{}\";s:6:\"module\";s:6:\"system\";s:6:\"hidden\";s:1:\"0\";s:8:\"external\";s:1:\"0\";s:12:\"has_children\";s:1:\"0\";s:8:\"expanded\";s:1:\"0\";s:6:\"weight\";s:2:\"10\";s:5:\"depth\";s:1:\"1\";s:10:\"customized\";s:1:\"0\";s:2:\"p1\";s:2:\"15\";s:2:\"p2\";s:1:\"0\";s:2:\"p3\";s:1:\"0\";s:2:\"p4\";s:1:\"0\";s:2:\"p5\";s:1:\"0\";s:2:\"p6\";s:1:\"0\";s:2:\"p7\";s:1:\"0\";s:2:\"p8\";s:1:\"0\";s:2:\"p9\";s:1:\"0\";s:7:\"updated\";s:1:\"0\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:17:\"user_is_logged_in\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:11:\"user_logout\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:11:\"user/logout\";s:5:\"title\";s:7:\"Log out\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:15:\"in_active_trail\";b:0;}s:5:\"below\";a:0:{}}}s:10:\"node_links\";a:0:{}}',0,1443811944,1),('local_tasks:admin/modules','a:3:{i:0;a:23:{s:4:\"path\";s:13:\"admin/modules\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:32:\"a:1:{i:0;s:14:\"system_modules\";}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"3\";s:12:\"number_parts\";s:1:\"2\";s:7:\"context\";s:1:\"0\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:7:\"Modules\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:26:\"Extend site functionality.\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:2:\"-2\";s:12:\"include_file\";s:31:\"modules/system/system.admin.inc\";}i:1;a:23:{s:4:\"path\";s:18:\"admin/modules/list\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:32:\"a:1:{i:0;s:14:\"system_modules\";}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"7\";s:12:\"number_parts\";s:1:\"3\";s:7:\"context\";s:1:\"1\";s:10:\"tab_parent\";s:13:\"admin/modules\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:4:\"List\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:31:\"modules/system/system.admin.inc\";}i:2;a:23:{s:4:\"path\";s:23:\"admin/modules/uninstall\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:36:\"a:1:{i:0;s:18:\"administer modules\";}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:42:\"a:1:{i:0;s:24:\"system_modules_uninstall\";}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"7\";s:12:\"number_parts\";s:1:\"3\";s:7:\"context\";s:1:\"1\";s:10:\"tab_parent\";s:13:\"admin/modules\";s:8:\"tab_root\";s:13:\"admin/modules\";s:5:\"title\";s:9:\"Uninstall\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:2:\"20\";s:12:\"include_file\";s:31:\"modules/system/system.admin.inc\";}}',0,1443811944,1),('local_tasks:node','a:1:{i:0;a:23:{s:4:\"path\";s:4:\"node\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:11:\"user_access\";s:16:\"access_arguments\";s:32:\"a:1:{i:0;s:14:\"access content\";}\";s:13:\"page_callback\";s:17:\"node_page_default\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"1\";s:12:\"number_parts\";s:1:\"1\";s:7:\"context\";s:1:\"0\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:4:\"node\";s:5:\"title\";s:0:\"\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"0\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:0:\"\";}}',0,1454111016,1),('local_tasks:user','a:4:{i:0;a:23:{s:4:\"path\";s:4:\"user\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"1\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:9:\"user_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"1\";s:12:\"number_parts\";s:1:\"1\";s:7:\"context\";s:1:\"0\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:12:\"User account\";s:14:\"title_callback\";s:15:\"user_menu_title\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"6\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:3:\"-10\";s:12:\"include_file\";s:27:\"modules/user/user.pages.inc\";}i:1;a:23:{s:4:\"path\";s:13:\"user/register\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"0\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:36:\"a:1:{i:0;s:18:\"user_register_form\";}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"3\";s:12:\"number_parts\";s:1:\"2\";s:7:\"context\";s:1:\"1\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:18:\"Create new account\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:0:\"\";}i:2;a:23:{s:4:\"path\";s:10:\"user/login\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:17:\"user_is_anonymous\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:9:\"user_page\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"3\";s:12:\"number_parts\";s:1:\"2\";s:7:\"context\";s:1:\"1\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:6:\"Log in\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"140\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:27:\"modules/user/user.pages.inc\";}i:3;a:23:{s:4:\"path\";s:13:\"user/password\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"0\";s:16:\"access_arguments\";s:6:\"a:0:{}\";s:13:\"page_callback\";s:15:\"drupal_get_form\";s:14:\"page_arguments\";s:26:\"a:1:{i:0;s:9:\"user_pass\";}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"3\";s:12:\"number_parts\";s:1:\"2\";s:7:\"context\";s:1:\"1\";s:10:\"tab_parent\";s:4:\"user\";s:8:\"tab_root\";s:4:\"user\";s:5:\"title\";s:20:\"Request new password\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:3:\"132\";s:11:\"description\";s:0:\"\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:27:\"modules/user/user.pages.inc\";}}',0,1454111015,1),('local_tasks:worklist','a:1:{i:0;a:23:{s:4:\"path\";s:8:\"worklist\";s:14:\"load_functions\";s:0:\"\";s:16:\"to_arg_functions\";s:0:\"\";s:15:\"access_callback\";s:1:\"1\";s:16:\"access_arguments\";s:32:\"a:1:{i:0;s:14:\"access content\";}\";s:13:\"page_callback\";s:25:\"raptor_glue_worklist_form\";s:14:\"page_arguments\";s:6:\"a:0:{}\";s:17:\"delivery_callback\";s:0:\"\";s:3:\"fit\";s:1:\"1\";s:12:\"number_parts\";s:1:\"1\";s:7:\"context\";s:1:\"0\";s:10:\"tab_parent\";s:0:\"\";s:8:\"tab_root\";s:8:\"worklist\";s:5:\"title\";s:8:\"Worklist\";s:14:\"title_callback\";s:1:\"t\";s:15:\"title_arguments\";s:0:\"\";s:14:\"theme_callback\";s:0:\"\";s:15:\"theme_arguments\";s:6:\"a:0:{}\";s:4:\"type\";s:1:\"0\";s:11:\"description\";s:24:\"The RAPTOR Worklist Page\";s:8:\"position\";s:0:\"\";s:6:\"weight\";s:1:\"0\";s:12:\"include_file\";s:53:\"/sites/all/modules/raptor_glue/form//WorklistPage.php\";}}',0,1454341313,1),('menu_custom','a:4:{s:9:\"main-menu\";a:3:{s:9:\"menu_name\";s:9:\"main-menu\";s:5:\"title\";s:9:\"Main menu\";s:11:\"description\";s:115:\"The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.\";}s:10:\"management\";a:3:{s:9:\"menu_name\";s:10:\"management\";s:5:\"title\";s:10:\"Management\";s:11:\"description\";s:69:\"The <em>Management</em> menu contains links for administrative tasks.\";}s:10:\"navigation\";a:3:{s:9:\"menu_name\";s:10:\"navigation\";s:5:\"title\";s:10:\"Navigation\";s:11:\"description\";s:150:\"The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.\";}s:9:\"user-menu\";a:3:{s:9:\"menu_name\";s:9:\"user-menu\";s:5:\"title\";s:9:\"User menu\";s:11:\"description\";s:99:\"The <em>User</em> menu contains links related to the user\'s account, as well as the \'Log out\' link.\";}}',0,1443811932,1);
/*!40000 ALTER TABLE `cache_menu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_page`
--

DROP TABLE IF EXISTS `cache_page`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_page` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table used to store compressed pages for anonymous...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_page`
--

LOCK TABLES `cache_page` WRITE;
/*!40000 ALTER TABLE `cache_page` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_page` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_path`
--

DROP TABLE IF EXISTS `cache_path`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_path` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for path alias lookup.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_path`
--

LOCK TABLES `cache_path` WRITE;
/*!40000 ALTER TABLE `cache_path` DISABLE KEYS */;
INSERT INTO `cache_path` VALUES ('user/login','a:1:{i:0;s:10:\"user/login\";}',1454423925,1454337525,1),('worklist','a:3:{i:0;s:4:\"user\";i:1;s:11:\"user/logout\";i:2;s:8:\"node/add\";}',1454427713,1454341313,1);
/*!40000 ALTER TABLE `cache_path` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_token`
--

DROP TABLE IF EXISTS `cache_token`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_token` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for token information.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_token`
--

LOCK TABLES `cache_token` WRITE;
/*!40000 ALTER TABLE `cache_token` DISABLE KEYS */;
INSERT INTO `cache_token` VALUES ('field:info','a:4:{s:12:\"comment_body\";a:5:{s:11:\"token types\";a:1:{i:0;s:7:\"comment\";}s:6:\"labels\";a:2:{i:0;s:7:\"Comment\";i:1;s:7:\"Comment\";}s:7:\"bundles\";a:1:{s:7:\"comment\";a:2:{s:17:\"comment_node_page\";s:18:\"Basic page comment\";s:20:\"comment_node_article\";s:15:\"Article comment\";}}s:5:\"label\";s:7:\"Comment\";s:11:\"description\";s:16:\"Long text field.\";}s:4:\"body\";a:5:{s:11:\"token types\";a:1:{i:0;s:4:\"node\";}s:6:\"labels\";a:2:{i:0;s:4:\"Body\";i:1;s:4:\"Body\";}s:7:\"bundles\";a:1:{s:4:\"node\";a:2:{s:4:\"page\";s:10:\"Basic page\";s:7:\"article\";s:7:\"Article\";}}s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:28:\"Long text and summary field.\";}s:10:\"field_tags\";a:5:{s:11:\"token types\";a:1:{i:0;s:4:\"node\";}s:6:\"labels\";a:1:{i:0;s:4:\"Tags\";}s:7:\"bundles\";a:1:{s:4:\"node\";a:1:{s:7:\"article\";s:7:\"Article\";}}s:5:\"label\";s:4:\"Tags\";s:11:\"description\";s:21:\"Term reference field.\";}s:11:\"field_image\";a:5:{s:11:\"token types\";a:1:{i:0;s:4:\"node\";}s:6:\"labels\";a:1:{i:0;s:5:\"Image\";}s:7:\"bundles\";a:1:{s:4:\"node\";a:1:{s:7:\"article\";s:7:\"Article\";}}s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:12:\"Image field.\";}}',0,1435417102,1);
/*!40000 ALTER TABLE `cache_token` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_views`
--

DROP TABLE IF EXISTS `cache_views`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_views` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Generic cache table for caching things not separated out...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_views`
--

LOCK TABLES `cache_views` WRITE;
/*!40000 ALTER TABLE `cache_views` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_views` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_views_data`
--

DROP TABLE IF EXISTS `cache_views_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache_views_data` (
  `cid` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or 0 for never.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry was created.',
  `serialized` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cache table for views to store pre-rendered queries,...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_views_data`
--

LOCK TABLES `cache_views_data` WRITE;
/*!40000 ALTER TABLE `cache_views_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_views_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `comment`
--

DROP TABLE IF EXISTS `comment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `comment` (
  `cid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique comment ID.',
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid to which this comment is a reply. If set to 0, this comment is not a reply to an existing comment.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid to which this comment is a reply.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid who authored the comment. If set to 0, this comment was created by an anonymous user.',
  `subject` varchar(64) NOT NULL DEFAULT '' COMMENT 'The comment title.',
  `hostname` varchar(128) NOT NULL DEFAULT '' COMMENT 'The author’s host name.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was created, as a Unix timestamp.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The time that the comment was last edited, as a Unix timestamp.',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The published status of a comment. (0 = Not Published, 1 = Published)',
  `thread` varchar(255) NOT NULL COMMENT 'The vancode representation of the comment’s place in a thread.',
  `name` varchar(60) DEFAULT NULL COMMENT 'The comment author’s name. Uses users.name if the user is logged in, otherwise uses the value typed into the comment form.',
  `mail` varchar(64) DEFAULT NULL COMMENT 'The comment author’s e-mail address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `homepage` varchar(255) DEFAULT NULL COMMENT 'The comment author’s home page address from the comment form, if user is anonymous, and the ’Anonymous users may/must leave their contact information’ setting is turned on.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this comment.',
  PRIMARY KEY (`cid`),
  KEY `comment_status_pid` (`pid`,`status`),
  KEY `comment_num_new` (`nid`,`status`,`created`,`cid`,`thread`),
  KEY `comment_uid` (`uid`),
  KEY `comment_nid_language` (`nid`,`language`),
  KEY `comment_created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores comments and associated data.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `comment`
--

LOCK TABLES `comment` WRITE;
/*!40000 ALTER TABLE `comment` DISABLE KEYS */;
/*!40000 ALTER TABLE `comment` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctools_css_cache`
--

DROP TABLE IF EXISTS `ctools_css_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctools_css_cache` (
  `cid` varchar(128) NOT NULL COMMENT 'The CSS ID this cache object belongs to.',
  `filename` varchar(255) DEFAULT NULL COMMENT 'The filename this CSS is stored in.',
  `css` longtext COMMENT 'CSS being stored.',
  `filter` tinyint(4) DEFAULT NULL COMMENT 'Whether or not this CSS needs to be filtered.',
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store CSS that must be non-volatile.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctools_css_cache`
--

LOCK TABLES `ctools_css_cache` WRITE;
/*!40000 ALTER TABLE `ctools_css_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctools_css_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ctools_object_cache`
--

DROP TABLE IF EXISTS `ctools_object_cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ctools_object_cache` (
  `sid` varchar(64) NOT NULL COMMENT 'The session ID this cache object belongs to.',
  `name` varchar(128) NOT NULL COMMENT 'The name of the object this cache is attached to.',
  `obj` varchar(32) NOT NULL COMMENT 'The type of the object this cache is attached to; this essentially represents the owner so that several sub-systems can use this cache.',
  `updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The time this cache was created or updated.',
  `data` longblob COMMENT 'Serialized data being stored.',
  PRIMARY KEY (`sid`,`obj`,`name`),
  KEY `updated` (`updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A special cache used to store objects that are being...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ctools_object_cache`
--

LOCK TABLES `ctools_object_cache` WRITE;
/*!40000 ALTER TABLE `ctools_object_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `ctools_object_cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `date_format_locale`
--

DROP TABLE IF EXISTS `date_format_locale`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_format_locale` (
  `format` varchar(100) NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `language` varchar(12) NOT NULL COMMENT 'A languages.language for this format to be used with.',
  PRIMARY KEY (`type`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats for each locale.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_format_locale`
--

LOCK TABLES `date_format_locale` WRITE;
/*!40000 ALTER TABLE `date_format_locale` DISABLE KEYS */;
/*!40000 ALTER TABLE `date_format_locale` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `date_format_type`
--

DROP TABLE IF EXISTS `date_format_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_format_type` (
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `title` varchar(255) NOT NULL COMMENT 'The human readable name of the format type.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this is a system provided format.',
  PRIMARY KEY (`type`),
  KEY `title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configured date format types.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_format_type`
--

LOCK TABLES `date_format_type` WRITE;
/*!40000 ALTER TABLE `date_format_type` DISABLE KEYS */;
INSERT INTO `date_format_type` VALUES ('long','Long',1),('medium','Medium',1),('short','Short',1);
/*!40000 ALTER TABLE `date_format_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `date_formats`
--

DROP TABLE IF EXISTS `date_formats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `date_formats` (
  `dfid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The date format identifier.',
  `format` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The date format string.',
  `type` varchar(64) NOT NULL COMMENT 'The date format type, e.g. medium.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Whether or not this format can be modified.',
  PRIMARY KEY (`dfid`),
  UNIQUE KEY `formats` (`format`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 COMMENT='Stores configured date formats.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `date_formats`
--

LOCK TABLES `date_formats` WRITE;
/*!40000 ALTER TABLE `date_formats` DISABLE KEYS */;
INSERT INTO `date_formats` VALUES (1,'Y-m-d H:i','short',1),(2,'m/d/Y - H:i','short',1),(3,'d/m/Y - H:i','short',1),(4,'Y/m/d - H:i','short',1),(5,'d.m.Y - H:i','short',1),(6,'m/d/Y - g:ia','short',1),(7,'d/m/Y - g:ia','short',1),(8,'Y/m/d - g:ia','short',1),(9,'M j Y - H:i','short',1),(10,'j M Y - H:i','short',1),(11,'Y M j - H:i','short',1),(12,'M j Y - g:ia','short',1),(13,'j M Y - g:ia','short',1),(14,'Y M j - g:ia','short',1),(15,'D, Y-m-d H:i','medium',1),(16,'D, m/d/Y - H:i','medium',1),(17,'D, d/m/Y - H:i','medium',1),(18,'D, Y/m/d - H:i','medium',1),(19,'F j, Y - H:i','medium',1),(20,'j F, Y - H:i','medium',1),(21,'Y, F j - H:i','medium',1),(22,'D, m/d/Y - g:ia','medium',1),(23,'D, d/m/Y - g:ia','medium',1),(24,'D, Y/m/d - g:ia','medium',1),(25,'F j, Y - g:ia','medium',1),(26,'j F Y - g:ia','medium',1),(27,'Y, F j - g:ia','medium',1),(28,'j. F Y - G:i','medium',1),(29,'l, F j, Y - H:i','long',1),(30,'l, j F, Y - H:i','long',1),(31,'l, Y,  F j - H:i','long',1),(32,'l, F j, Y - g:ia','long',1),(33,'l, j F Y - g:ia','long',1),(34,'l, Y,  F j - g:ia','long',1),(35,'l, j. F Y - G:i','long',1);
/*!40000 ALTER TABLE `date_formats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_config`
--

DROP TABLE IF EXISTS `field_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field',
  `field_name` varchar(32) NOT NULL COMMENT 'The name of this field. Non-deleted field names are unique, but multiple deleted fields can have the same name.',
  `type` varchar(128) NOT NULL COMMENT 'The type of this field.',
  `module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the field type.',
  `active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the field type is enabled.',
  `storage_type` varchar(128) NOT NULL COMMENT 'The storage backend for the field.',
  `storage_module` varchar(128) NOT NULL DEFAULT '' COMMENT 'The module that implements the storage backend.',
  `storage_active` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the module that implements the storage backend is enabled.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT '@TODO',
  `data` longblob NOT NULL COMMENT 'Serialized data containing the field properties that do not warrant a dedicated column.',
  `cardinality` tinyint(4) NOT NULL DEFAULT '0',
  `translatable` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name` (`field_name`),
  KEY `active` (`active`),
  KEY `storage_active` (`storage_active`),
  KEY `deleted` (`deleted`),
  KEY `module` (`module`),
  KEY `storage_module` (`storage_module`),
  KEY `type` (`type`),
  KEY `storage_type` (`storage_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_config`
--

LOCK TABLES `field_config` WRITE;
/*!40000 ALTER TABLE `field_config` DISABLE KEYS */;
INSERT INTO `field_config` VALUES (1,'comment_body','text_long','text',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:7:\"comment\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}}',1,0,0),(2,'body','text_with_summary','text',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:12:\"entity_types\";a:1:{i:0;s:4:\"node\";}s:12:\"translatable\";b:0;s:8:\"settings\";a:0:{}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:6:\"format\";a:2:{s:5:\"table\";s:13:\"filter_format\";s:7:\"columns\";a:1:{s:6:\"format\";s:6:\"format\";}}}s:7:\"indexes\";a:1:{s:6:\"format\";a:1:{i:0;s:6:\"format\";}}}',1,0,0),(3,'field_tags','taxonomy_term_reference','taxonomy',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:8:\"settings\";a:1:{s:14:\"allowed_values\";a:1:{i:0;a:2:{s:10:\"vocabulary\";s:4:\"tags\";s:6:\"parent\";i:0;}}}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"foreign keys\";a:1:{s:3:\"tid\";a:2:{s:5:\"table\";s:18:\"taxonomy_term_data\";s:7:\"columns\";a:1:{s:3:\"tid\";s:3:\"tid\";}}}s:7:\"indexes\";a:1:{s:3:\"tid\";a:1:{i:0;s:3:\"tid\";}}}',-1,0,0),(4,'field_image','image','image',1,'field_sql_storage','field_sql_storage',1,0,'a:6:{s:7:\"indexes\";a:1:{s:3:\"fid\";a:1:{i:0;s:3:\"fid\";}}s:8:\"settings\";a:2:{s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";b:0;}s:7:\"storage\";a:4:{s:4:\"type\";s:17:\"field_sql_storage\";s:8:\"settings\";a:0:{}s:6:\"module\";s:17:\"field_sql_storage\";s:6:\"active\";i:1;}s:12:\"entity_types\";a:0:{}s:12:\"translatable\";b:0;s:12:\"foreign keys\";a:1:{s:3:\"fid\";a:2:{s:5:\"table\";s:12:\"file_managed\";s:7:\"columns\";a:1:{s:3:\"fid\";s:3:\"fid\";}}}}',1,0,0);
/*!40000 ALTER TABLE `field_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_config_instance`
--

DROP TABLE IF EXISTS `field_config_instance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_config_instance` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a field instance',
  `field_id` int(11) NOT NULL COMMENT 'The identifier of the field attached by this instance',
  `field_name` varchar(32) NOT NULL DEFAULT '',
  `entity_type` varchar(32) NOT NULL DEFAULT '',
  `bundle` varchar(128) NOT NULL DEFAULT '',
  `data` longblob NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `field_name_bundle` (`field_name`,`entity_type`,`bundle`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_config_instance`
--

LOCK TABLES `field_config_instance` WRITE;
/*!40000 ALTER TABLE `field_config_instance` DISABLE KEYS */;
INSERT INTO `field_config_instance` VALUES (1,1,'comment_body','comment','comment_node_page','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(2,2,'body','node','page','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";i:31;s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(3,1,'comment_body','comment','comment_node_article','a:6:{s:5:\"label\";s:7:\"Comment\";s:8:\"settings\";a:2:{s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:8:\"required\";b:1;s:7:\"display\";a:1:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";}}s:6:\"widget\";a:4:{s:4:\"type\";s:13:\"text_textarea\";s:8:\"settings\";a:1:{s:4:\"rows\";i:5;}s:6:\"weight\";i:0;s:6:\"module\";s:4:\"text\";}s:11:\"description\";s:0:\"\";}',0),(4,2,'body','node','article','a:6:{s:5:\"label\";s:4:\"Body\";s:6:\"widget\";a:4:{s:4:\"type\";s:26:\"text_textarea_with_summary\";s:8:\"settings\";a:2:{s:4:\"rows\";i:20;s:12:\"summary_rows\";i:5;}s:6:\"weight\";i:31;s:6:\"module\";s:4:\"text\";}s:8:\"settings\";a:3:{s:15:\"display_summary\";b:1;s:15:\"text_processing\";i:1;s:18:\"user_register_form\";b:0;}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:6:\"module\";s:4:\"text\";s:6:\"weight\";i:0;}}s:8:\"required\";b:0;s:11:\"description\";s:0:\"\";}',0),(5,3,'field_tags','node','article','a:6:{s:5:\"label\";s:4:\"Tags\";s:11:\"description\";s:63:\"Enter a comma-separated list of words to describe your content.\";s:6:\"widget\";a:4:{s:4:\"type\";s:21:\"taxonomy_autocomplete\";s:6:\"weight\";i:-4;s:8:\"settings\";a:2:{s:4:\"size\";i:60;s:17:\"autocomplete_path\";s:21:\"taxonomy/autocomplete\";}s:6:\"module\";s:8:\"taxonomy\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:4:\"type\";s:28:\"taxonomy_term_reference_link\";s:6:\"weight\";i:10;s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}s:6:\"teaser\";a:5:{s:4:\"type\";s:28:\"taxonomy_term_reference_link\";s:6:\"weight\";i:10;s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:6:\"module\";s:8:\"taxonomy\";}}s:8:\"settings\";a:1:{s:18:\"user_register_form\";b:0;}s:8:\"required\";b:0;}',0),(6,4,'field_image','node','article','a:6:{s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:40:\"Upload an image to go with this article.\";s:8:\"required\";b:0;s:8:\"settings\";a:9:{s:14:\"file_directory\";s:11:\"field/image\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:11:\"title_field\";s:0:\"\";s:13:\"default_image\";i:0;s:18:\"user_register_form\";b:0;}s:6:\"widget\";a:4:{s:4:\"type\";s:11:\"image_image\";s:8:\"settings\";a:2:{s:18:\"progress_indicator\";s:8:\"throbber\";s:19:\"preview_image_style\";s:9:\"thumbnail\";}s:6:\"weight\";i:-1;s:6:\"module\";s:5:\"image\";}s:7:\"display\";a:2:{s:7:\"default\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:5:\"large\";s:10:\"image_link\";s:0:\"\";}s:6:\"weight\";i:-1;s:6:\"module\";s:5:\"image\";}s:6:\"teaser\";a:5:{s:5:\"label\";s:6:\"hidden\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:2:{s:11:\"image_style\";s:6:\"medium\";s:10:\"image_link\";s:7:\"content\";}s:6:\"weight\";i:-1;s:6:\"module\";s:5:\"image\";}}}',0);
/*!40000 ALTER TABLE `field_config_instance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_data_body`
--

DROP TABLE IF EXISTS `field_data_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 2 (body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_body`
--

LOCK TABLES `field_data_body` WRITE;
/*!40000 ALTER TABLE `field_data_body` DISABLE KEYS */;
INSERT INTO `field_data_body` VALUES ('node','page',0,1,1,'und',0,'<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>','<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>','full_html');
/*!40000 ALTER TABLE `field_data_body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_data_comment_body`
--

DROP TABLE IF EXISTS `field_data_comment_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 1 (comment_body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_comment_body`
--

LOCK TABLES `field_data_comment_body` WRITE;
/*!40000 ALTER TABLE `field_data_comment_body` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_data_comment_body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_data_field_image`
--

DROP TABLE IF EXISTS `field_data_field_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 4 (field_image)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_image`
--

LOCK TABLES `field_data_field_image` WRITE;
/*!40000 ALTER TABLE `field_data_field_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_data_field_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_data_field_tags`
--

DROP TABLE IF EXISTS `field_data_field_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_data_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned DEFAULT NULL COMMENT 'The entity revision id this data is attached to, or NULL if the entity type is not versioned',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Data storage for field 3 (field_tags)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_data_field_tags`
--

LOCK TABLES `field_data_field_tags` WRITE;
/*!40000 ALTER TABLE `field_data_field_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_data_field_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_revision_body`
--

DROP TABLE IF EXISTS `field_revision_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext,
  `body_summary` longtext,
  `body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 2 (body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_body`
--

LOCK TABLES `field_revision_body` WRITE;
/*!40000 ALTER TABLE `field_revision_body` DISABLE KEYS */;
INSERT INTO `field_revision_body` VALUES ('node','page',0,1,1,'und',0,'<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>','<div id=\"first-time\">\n\n\nIf you are new to Drupal, follow these steps to set up your web site in minutes:\n\n<strong>Step 1. Start at the beginning</strong>\n\nVisit the <a href=\"/RAPTOR/admin\">administration section</a> for a task-based or <a href=\"/RAPTOR/admin/index\">module-based</a> overview of the options available to configure your website.</li>\n\n<strong>Step 2. Connect to the Acquia Network</strong>\n\nAt any time you can activate an <a href=\"http://network.acquia.com/\">Acquia Network</a> subscription to gain access to Acquia\'s timely, professional support, automated services such as Mollom spam blocking, Acquia Library and documentation. Acquia offers subscription levels for every size web site - from individual blogs to enterprise-scale, multi-site deployments.  Once you have your Acquia Network subscription keys, enter them on the <a href=\"/RAPTOR/admin/config/system/acquia-agent\">settings page</a>. Get started with a <a href=\"http://network.acquia.com/\">free trial</a> today.\n\n<strong>Step 3. Activate functionality</strong>\n\nTurn on added functionality for your site - blogs, forums, polls, tags, comments, and more. Acquia Drupal comes with important <a href=\"/RAPTOR/admin/modules\">modules</a> to power social publishing capabilities on your site.\n\nHundreds of additional Drupal 7.x compatible modules are available on Drupal.org in the <a href=\"http://drupal.org/project/Modules\">Drupal modules download section</a>, which you can install <a href=\"/RAPTOR/admin/modules\">through your modules page</a>.\n\n<strong>Step 4. Start publishing content</strong>\n\nStart <a href=\"/RAPTOR/node/add\">creating content</a> for your site. Depending on which modules you have activated, you may see blogs, forums, polls and more as available content types.\n\n<hr />\n\n<p>Some optional configuration tasks are shown below. For more information, please refer to the built-in <a href=\"/RAPTOR/admin/help\">help section</a>, or the <a href=\"http://drupal.org/handbooks\">online Drupal handbooks</a>.</p>\n\n<strong>Choose a different design</strong>\n\nStart by <a href=\"/RAPTOR/admin/appearance/settings/bartik\">changing the colors</a> of the default theme.  To change the fundamental \"look and feel\" of your website, visit the <a href=\"/RAPTOR/admin/appearance\">appearance section</a> and choose a theme from one of the many themes available out-of-the-box.\n\nMany additional Drupal 7.x compatible themes are available on Drupal.org in the <a href=\"http://drupal.org/project/Themes\">Drupal themes download section</a>, which you can install <a href=\"/RAPTOR/admin/appearance\">through your themes page</a>.\n\n<strong>Configure the front page</strong>\n\nThe default front page is a listing of all content marked as <q>Promoted to front page</q>.  You can manage your content from the <a href=\"/RAPTOR/admin/content\">content administration page</a>. You can also designate, for example, an item of content you have created as the front page. See the <a href=\"/RAPTOR/admin/config/system/site-information\">site information settings page</a> to configure the default front page path.  You can also edit you site name and add a slogan to make the site your own.\n</div>','full_html');
/*!40000 ALTER TABLE `field_revision_body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_revision_comment_body`
--

DROP TABLE IF EXISTS `field_revision_comment_body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_comment_body` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `comment_body_value` longtext,
  `comment_body_format` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `comment_body_format` (`comment_body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 1 (comment_body)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_comment_body`
--

LOCK TABLES `field_revision_comment_body` WRITE;
/*!40000 ALTER TABLE `field_revision_comment_body` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_revision_comment_body` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_revision_field_image`
--

DROP TABLE IF EXISTS `field_revision_field_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_field_image` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_fid` int(10) unsigned DEFAULT NULL COMMENT 'The file_managed.fid being referenced in this field.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image’s ’alt’ attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image’s ’title’ attribute.',
  `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_image_fid` (`field_image_fid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 4 (field_image)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_field_image`
--

LOCK TABLES `field_revision_field_image` WRITE;
/*!40000 ALTER TABLE `field_revision_field_image` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_revision_field_image` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `field_revision_field_tags`
--

DROP TABLE IF EXISTS `field_revision_field_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `field_revision_field_tags` (
  `entity_type` varchar(128) NOT NULL DEFAULT '' COMMENT 'The entity type this data is attached to',
  `bundle` varchar(128) NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `language` varchar(32) NOT NULL DEFAULT '' COMMENT 'The language for this data item.',
  `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_tags_tid` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`entity_type`,`entity_id`,`revision_id`,`deleted`,`delta`,`language`),
  KEY `entity_type` (`entity_type`),
  KEY `bundle` (`bundle`),
  KEY `deleted` (`deleted`),
  KEY `entity_id` (`entity_id`),
  KEY `revision_id` (`revision_id`),
  KEY `language` (`language`),
  KEY `field_tags_tid` (`field_tags_tid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Revision archive storage for field 3 (field_tags)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `field_revision_field_tags`
--

LOCK TABLES `field_revision_field_tags` WRITE;
/*!40000 ALTER TABLE `field_revision_field_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `field_revision_field_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_managed`
--

DROP TABLE IF EXISTS `file_managed`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_managed` (
  `fid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'File ID.',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The users.uid of the user who is associated with the file.',
  `filename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the file with no path components. This may differ from the basename of the URI if the file is renamed to avoid overwriting an existing file.',
  `uri` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'The URI to access the file (either local or remote).',
  `filemime` varchar(255) NOT NULL DEFAULT '' COMMENT 'The file’s MIME type.',
  `filesize` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'The size of the file in bytes.',
  `status` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A field indicating the status of the file. Two status are defined in core: temporary (0) and permanent (1). Temporary files older than DRUPAL_MAXIMUM_TEMP_FILE_AGE will be removed during a cron run.',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'UNIX timestamp for when the file was added.',
  PRIMARY KEY (`fid`),
  UNIQUE KEY `uri` (`uri`),
  KEY `uid` (`uid`),
  KEY `status` (`status`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COMMENT='Stores information for uploaded files.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_managed`
--

LOCK TABLES `file_managed` WRITE;
/*!40000 ALTER TABLE `file_managed` DISABLE KEYS */;
INSERT INTO `file_managed` VALUES (3,42,'Thorax_PE.pdf','public://Thorax_PE.pdf','application/pdf',19694,1,1425764678),(4,5,'Brain Death Angiography Study.doc','public://Brain Death Angiography Study.doc','application/msword',38400,1,1418521599),(25,1,'Chrysanthemum.jpg','public://Chrysanthemum.jpg','image/jpeg',879394,1,1418777026),(28,1,'Koala.jpg','public://Koala.jpg','image/jpeg',780831,1,1418769958),(36,1,'FL-EXAMPLE-v2.pdf','public://FL-EXAMPLE-v2.pdf','application/pdf',19694,1,1420501012);
/*!40000 ALTER TABLE `file_managed` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `file_usage`
--

DROP TABLE IF EXISTS `file_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_usage` (
  `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',
  `module` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',
  `type` varchar(64) NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',
  PRIMARY KEY (`fid`,`type`,`id`,`module`),
  KEY `type_id` (`type`,`id`),
  KEY `fid_count` (`fid`,`count`),
  KEY `fid_module` (`fid`,`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Track where a file is used.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `file_usage`
--

LOCK TABLES `file_usage` WRITE;
/*!40000 ALTER TABLE `file_usage` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_usage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filter`
--

DROP TABLE IF EXISTS `filter`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter` (
  `format` varchar(255) NOT NULL COMMENT 'Foreign key: The filter_format.format to which this filter is assigned.',
  `module` varchar(64) NOT NULL DEFAULT '' COMMENT 'The origin module of the filter.',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Name of the filter being referenced.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of filter within format.',
  `status` int(11) NOT NULL DEFAULT '0' COMMENT 'Filter enabled status. (1 = enabled, 0 = disabled)',
  `settings` longblob COMMENT 'A serialized array of name value pairs that store the filter settings for the specific format.',
  PRIMARY KEY (`format`,`name`),
  KEY `list` (`weight`,`module`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table that maps filters (HTML corrector) to text formats ...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filter`
--

LOCK TABLES `filter` WRITE;
/*!40000 ALTER TABLE `filter` DISABLE KEYS */;
INSERT INTO `filter` VALUES ('filtered_html','filter','filter_autop',2,1,'a:0:{}'),('filtered_html','filter','filter_html',1,1,'a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}'),('filtered_html','filter','filter_htmlcorrector',10,1,'a:0:{}'),('filtered_html','filter','filter_html_escape',-10,0,'a:0:{}'),('filtered_html','filter','filter_url',0,1,'a:1:{s:17:\"filter_url_length\";i:72;}'),('full_html','filter','filter_autop',1,0,'a:0:{}'),('full_html','filter','filter_html',-10,0,'a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}'),('full_html','filter','filter_htmlcorrector',10,0,'a:0:{}'),('full_html','filter','filter_html_escape',-10,0,'a:0:{}'),('full_html','filter','filter_url',0,1,'a:1:{s:17:\"filter_url_length\";s:2:\"72\";}'),('full_html','forena','forena_report',0,1,'a:0:{}'),('plain_text','filter','filter_autop',2,1,'a:0:{}'),('plain_text','filter','filter_html',-10,0,'a:3:{s:12:\"allowed_html\";s:74:\"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>\";s:16:\"filter_html_help\";i:1;s:20:\"filter_html_nofollow\";i:0;}'),('plain_text','filter','filter_htmlcorrector',10,0,'a:0:{}'),('plain_text','filter','filter_html_escape',0,1,'a:0:{}'),('plain_text','filter','filter_url',1,1,'a:1:{s:17:\"filter_url_length\";i:72;}');
/*!40000 ALTER TABLE `filter` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `filter_format`
--

DROP TABLE IF EXISTS `filter_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `filter_format` (
  `format` varchar(255) NOT NULL COMMENT 'Primary Key: Unique machine name of the format.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'Name of the text format (Filtered HTML).',
  `cache` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate whether format is cacheable. (1 = cacheable, 0 = not cacheable)',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'The status of the text format. (1 = enabled, 0 = disabled)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of text format to use when listing.',
  PRIMARY KEY (`format`),
  UNIQUE KEY `name` (`name`),
  KEY `status_weight` (`status`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores text formats: custom groupings of filters, such as...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `filter_format`
--

LOCK TABLES `filter_format` WRITE;
/*!40000 ALTER TABLE `filter_format` DISABLE KEYS */;
INSERT INTO `filter_format` VALUES ('filtered_html','Filtered HTML',1,1,0),('full_html','Full HTML',0,1,1),('plain_text','Plain text',1,1,10);
/*!40000 ALTER TABLE `filter_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flood`
--

DROP TABLE IF EXISTS `flood`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flood` (
  `fid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Unique flood event ID.',
  `event` varchar(64) NOT NULL DEFAULT '' COMMENT 'Name of event (e.g. contact).',
  `identifier` varchar(128) NOT NULL DEFAULT '' COMMENT 'Identifier of the visitor, such as an IP address or hostname.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp of the event.',
  `expiration` int(11) NOT NULL DEFAULT '0' COMMENT 'Expiration timestamp. Expired events are purged on cron run.',
  PRIMARY KEY (`fid`),
  KEY `allow` (`event`,`identifier`,`timestamp`),
  KEY `purge` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='Flood controls the threshold of events, such as the...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flood`
--

LOCK TABLES `flood` WRITE;
/*!40000 ALTER TABLE `flood` DISABLE KEYS */;
INSERT INTO `flood` VALUES (18,'failed_login_attempt_ip','192.168.33.1',1454338278,1454341878),(20,'failed_login_attempt_ip','192.168.33.1',1454338314,1454341914),(22,'failed_login_attempt_ip','192.168.33.1',1454340339,1454343939),(24,'omega_raptor_omega_theme_settings_warning','192.168.33.1',1454341313,1454344913),(25,'omega_raptor_omega_theme_settings_warning','192.168.33.1',1454341314,1454344914),(26,'omega_raptor_omega_theme_settings_warning','192.168.33.1',1454341314,1454344914);
/*!40000 ALTER TABLE `flood` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `history`
--

DROP TABLE IF EXISTS `history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `history` (
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that read the node nid.',
  `nid` int(11) NOT NULL DEFAULT '0' COMMENT 'The node.nid that was read.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',
  PRIMARY KEY (`uid`,`nid`),
  KEY `nid` (`nid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A record of which users have read which nodes.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `history`
--

LOCK TABLES `history` WRITE;
/*!40000 ALTER TABLE `history` DISABLE KEYS */;
/*!40000 ALTER TABLE `history` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_effects`
--

DROP TABLE IF EXISTS `image_effects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `image_effects` (
  `ieid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image effect.',
  `isid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The image_styles.isid for an image style.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'The weight of the effect in the style.',
  `name` varchar(255) NOT NULL COMMENT 'The unique name of the effect to be executed.',
  `data` longblob NOT NULL COMMENT 'The configuration data for the effect.',
  PRIMARY KEY (`ieid`),
  KEY `isid` (`isid`),
  KEY `weight` (`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image effects.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_effects`
--

LOCK TABLES `image_effects` WRITE;
/*!40000 ALTER TABLE `image_effects` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_effects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `image_styles`
--

DROP TABLE IF EXISTS `image_styles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `image_styles` (
  `isid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for an image style.',
  `name` varchar(255) NOT NULL COMMENT 'The style machine name.',
  `label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The style administrative name.',
  PRIMARY KEY (`isid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores configuration options for image styles.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `image_styles`
--

LOCK TABLES `image_styles` WRITE;
/*!40000 ALTER TABLE `image_styles` DISABLE KEYS */;
/*!40000 ALTER TABLE `image_styles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_custom`
--

DROP TABLE IF EXISTS `menu_custom`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `menu_custom` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique key for menu. This is used as a block delta so length is 32.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Menu title; displayed at top of block.',
  `description` text COMMENT 'Menu description.',
  PRIMARY KEY (`menu_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Holds definitions for top-level custom menus (for example...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_custom`
--

LOCK TABLES `menu_custom` WRITE;
/*!40000 ALTER TABLE `menu_custom` DISABLE KEYS */;
INSERT INTO `menu_custom` VALUES ('main-menu','Main menu','The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.'),('management','Management','The <em>Management</em> menu contains links for administrative tasks.'),('navigation','Navigation','The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.'),('user-menu','User menu','The <em>User</em> menu contains links related to the user\'s account, as well as the \'Log out\' link.');
/*!40000 ALTER TABLE `menu_custom` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_links`
--

DROP TABLE IF EXISTS `menu_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `menu_links` (
  `menu_name` varchar(32) NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ’navigation’) are part of the same menu.',
  `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',
  `plid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The parent link ID (plid) is the mlid of the link above in the hierarchy, or zero if the link is at the top level in its menu.',
  `link_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The Drupal path or external path this link points to.',
  `router_path` varchar(255) NOT NULL DEFAULT '' COMMENT 'For links corresponding to a Drupal path (external = 0), this connects the link to a menu_router.path for joins.',
  `link_title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The text displayed for the link, which may be modified by a title callback stored in menu_router.',
  `options` blob COMMENT 'A serialized array of options to be passed to the url() or l() function, such as a query string or HTML attributes.',
  `module` varchar(255) NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',
  `hidden` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link should be rendered in menus. (1 = a disabled menu item that may be shown on admin screens, -1 = a menu callback, 0 = a normal, visible link)',
  `external` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).',
  `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any links have this link as a parent (1 = children exist, 0 = no children).',
  `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',
  `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with plid == 0 will have depth == 1.',
  `customized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate that the user has manually created or edited the link (1 = customized, 0 = not customized).',
  `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the plid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',
  `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',
  `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',
  `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',
  `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',
  `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',
  `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',
  `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',
  `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',
  `updated` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag that indicates that this link was generated during the update from Drupal 5.',
  PRIMARY KEY (`mlid`),
  KEY `path_menu` (`link_path`(128),`menu_name`),
  KEY `menu_plid_expand_child` (`menu_name`,`plid`,`expanded`,`has_children`),
  KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),
  KEY `router_path` (`router_path`(128))
) ENGINE=InnoDB AUTO_INCREMENT=1366 DEFAULT CHARSET=utf8 COMMENT='Contains the individual links within a menu.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_links`
--

LOCK TABLES `menu_links` WRITE;
/*!40000 ALTER TABLE `menu_links` DISABLE KEYS */;
INSERT INTO `menu_links` VALUES ('management',1,0,'admin','admin','Administration','a:0:{}','system',0,0,1,0,9,1,0,1,0,0,0,0,0,0,0,0,0),('user-menu',2,0,'user','user','User account','a:1:{s:5:\"alter\";b:1;}','system',0,0,0,0,-10,1,0,2,0,0,0,0,0,0,0,0,0),('navigation',3,0,'comment/%','comment/%','Comment permalink','a:0:{}','system',0,0,1,0,0,1,0,3,0,0,0,0,0,0,0,0,0),('navigation',4,0,'filter/tips','filter/tips','Compose tips','a:0:{}','system',1,0,0,0,0,1,0,4,0,0,0,0,0,0,0,0,0),('navigation',5,0,'node/%','node/%','','a:0:{}','system',0,0,0,0,0,1,0,5,0,0,0,0,0,0,0,0,0),('navigation',6,0,'node/add','node/add','Add content','a:0:{}','system',0,0,1,0,0,1,0,6,0,0,0,0,0,0,0,0,0),('management',7,1,'admin/appearance','admin/appearance','Appearance','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Select and configure your themes.\";}}','system',0,0,0,0,-6,2,0,1,7,0,0,0,0,0,0,0,0),('management',8,1,'admin/config','admin/config','Configuration','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:20:\"Administer settings.\";}}','system',0,0,1,0,0,2,0,1,8,0,0,0,0,0,0,0,0),('management',9,1,'admin/content','admin/content','Content','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:32:\"Administer content and comments.\";}}','system',0,0,1,0,-10,2,0,1,9,0,0,0,0,0,0,0,0),('user-menu',10,2,'user/register','user/register','Create new account','a:0:{}','system',-1,0,0,0,0,2,0,2,10,0,0,0,0,0,0,0,0),('management',11,1,'admin/dashboard','admin/dashboard','Dashboard','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View and customize your dashboard.\";}}','system',0,0,0,0,-15,2,0,1,11,0,0,0,0,0,0,0,0),('management',12,1,'admin/help','admin/help','Help','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:48:\"Reference for usage, configuration, and modules.\";}}','system',0,0,0,0,9,2,0,1,12,0,0,0,0,0,0,0,0),('management',13,1,'admin/index','admin/index','Index','a:0:{}','system',-1,0,0,0,-18,2,0,1,13,0,0,0,0,0,0,0,0),('user-menu',14,2,'user/login','user/login','Log in','a:0:{}','system',-1,0,0,0,0,2,0,2,14,0,0,0,0,0,0,0,0),('user-menu',15,0,'user/logout','user/logout','Log out','a:0:{}','system',0,0,0,0,10,1,0,15,0,0,0,0,0,0,0,0,0),('management',16,1,'admin/modules','admin/modules','Modules','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:26:\"Extend site functionality.\";}}','system',0,0,0,0,-2,2,0,1,16,0,0,0,0,0,0,0,0),('navigation',17,0,'user/%','user/%','My account','a:0:{}','system',0,0,1,0,0,1,0,17,0,0,0,0,0,0,0,0,0),('management',18,1,'admin/people','admin/people','People','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Manage user accounts, roles, and permissions.\";}}','system',0,0,0,0,-4,2,0,1,18,0,0,0,0,0,0,0,0),('management',19,1,'admin/reports','admin/reports','Reports','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:34:\"View reports, updates, and errors.\";}}','system',0,0,1,0,5,2,0,1,19,0,0,0,0,0,0,0,0),('user-menu',20,2,'user/password','user/password','Request new password','a:0:{}','system',-1,0,0,0,0,2,0,2,20,0,0,0,0,0,0,0,0),('management',21,1,'admin/structure','admin/structure','Structure','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Administer blocks, content types, menus, etc.\";}}','system',0,0,1,0,-8,2,0,1,21,0,0,0,0,0,0,0,0),('management',22,1,'admin/tasks','admin/tasks','Tasks','a:0:{}','system',-1,0,0,0,-20,2,0,1,22,0,0,0,0,0,0,0,0),('navigation',23,0,'comment/reply/%','comment/reply/%','Add new comment','a:0:{}','system',0,0,0,0,0,1,0,23,0,0,0,0,0,0,0,0,0),('navigation',24,3,'comment/%/approve','comment/%/approve','Approve','a:0:{}','system',0,0,0,0,1,2,0,3,24,0,0,0,0,0,0,0,0),('navigation',25,3,'comment/%/delete','comment/%/delete','Delete','a:0:{}','system',-1,0,0,0,2,2,0,3,25,0,0,0,0,0,0,0,0),('navigation',26,3,'comment/%/edit','comment/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,2,0,3,26,0,0,0,0,0,0,0,0),('navigation',27,3,'comment/%/view','comment/%/view','View comment','a:0:{}','system',-1,0,0,0,-10,2,0,3,27,0,0,0,0,0,0,0,0),('management',28,18,'admin/people/create','admin/people/create','Add user','a:0:{}','system',-1,0,0,0,0,3,0,1,18,28,0,0,0,0,0,0,0),('management',29,21,'admin/structure/block','admin/structure/block','Blocks','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site\'s sidebars and other regions.\";}}','system',0,0,1,0,0,3,0,1,21,29,0,0,0,0,0,0,0),('navigation',30,17,'user/%/cancel','user/%/cancel','Cancel account','a:0:{}','system',0,0,1,0,0,2,0,17,30,0,0,0,0,0,0,0,0),('management',31,9,'admin/content/comment','admin/content/comment','Comments','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:59:\"List and edit site comments and the comment approval queue.\";}}','system',0,0,0,0,0,3,0,1,9,31,0,0,0,0,0,0,0),('management',32,11,'admin/dashboard/configure','admin/dashboard/configure','Configure available dashboard blocks','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:53:\"Configure which blocks can be shown on the dashboard.\";}}','system',-1,0,0,0,0,3,0,1,11,32,0,0,0,0,0,0,0),('management',33,9,'admin/content/node','admin/content/node','Content','a:0:{}','system',-1,0,0,0,-10,3,0,1,9,33,0,0,0,0,0,0,0),('management',34,8,'admin/config/content','admin/config/content','Content authoring','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:53:\"Settings related to formatting and authoring content.\";}}','system',0,0,1,0,-15,3,0,1,8,34,0,0,0,0,0,0,0),('management',35,21,'admin/structure/types','admin/structure/types','Content types','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:92:\"Manage content types, including default status, front page promotion, comment settings, etc.\";}}','system',0,0,1,0,0,3,0,1,21,35,0,0,0,0,0,0,0),('management',36,11,'admin/dashboard/customize','admin/dashboard/customize','Customize dashboard','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:25:\"Customize your dashboard.\";}}','system',-1,0,0,0,0,3,0,1,11,36,0,0,0,0,0,0,0),('navigation',37,5,'node/%/delete','node/%/delete','Delete','a:0:{}','system',-1,0,0,0,1,2,0,5,37,0,0,0,0,0,0,0,0),('management',38,8,'admin/config/development','admin/config/development','Development','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:18:\"Development tools.\";}}','system',0,0,1,0,-10,3,0,1,8,38,0,0,0,0,0,0,0),('navigation',39,17,'user/%/edit','user/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,2,0,17,39,0,0,0,0,0,0,0,0),('navigation',40,5,'node/%/edit','node/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,2,0,5,40,0,0,0,0,0,0,0,0),('management',41,16,'admin/modules/list','admin/modules/list','List','a:0:{}','system',-1,0,0,0,0,3,0,1,16,41,0,0,0,0,0,0,0),('management',42,18,'admin/people/people','admin/people/people','List','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:50:\"Find and manage people interacting with your site.\";}}','system',-1,0,0,0,-10,3,0,1,18,42,0,0,0,0,0,0,0),('management',43,7,'admin/appearance/list','admin/appearance/list','List','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:31:\"Select and configure your theme\";}}','system',-1,0,0,0,-1,3,0,1,7,43,0,0,0,0,0,0,0),('management',44,8,'admin/config/media','admin/config/media','Media','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:12:\"Media tools.\";}}','system',0,0,1,0,-10,3,0,1,8,44,0,0,0,0,0,0,0),('management',45,21,'admin/structure/menu','admin/structure/menu','Menus','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:86:\"Add new menus to your site, edit existing menus, and rename and reorganize menu links.\";}}','system',0,0,1,0,0,3,0,1,21,45,0,0,0,0,0,0,0),('management',46,8,'admin/config/people','admin/config/people','People','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:24:\"Configure user accounts.\";}}','system',0,0,1,0,-20,3,0,1,8,46,0,0,0,0,0,0,0),('management',47,18,'admin/people/permissions','admin/people/permissions','Permissions','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:64:\"Determine access to features by selecting permissions for roles.\";}}','system',-1,0,0,0,0,3,0,1,18,47,0,0,0,0,0,0,0),('management',48,8,'admin/config/regional','admin/config/regional','Regional and language','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:48:\"Regional settings, localization and translation.\";}}','system',0,0,1,0,-5,3,0,1,8,48,0,0,0,0,0,0,0),('navigation',49,5,'node/%/revisions','node/%/revisions','Revisions','a:0:{}','system',-1,0,1,0,2,2,0,5,49,0,0,0,0,0,0,0,0),('management',50,8,'admin/config/search','admin/config/search','Search and metadata','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:36:\"Local site search, metadata and SEO.\";}}','system',0,0,1,0,-10,3,0,1,8,50,0,0,0,0,0,0,0),('management',51,7,'admin/appearance/settings','admin/appearance/settings','Settings','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Configure default and theme specific settings.\";}}','system',-1,0,0,0,20,3,0,1,7,51,0,0,0,0,0,0,0),('management',52,19,'admin/reports/status','admin/reports/status','Status report','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site\'s operation and any detected problems.\";}}','system',0,0,0,0,-60,3,0,1,19,52,0,0,0,0,0,0,0),('management',53,8,'admin/config/system','admin/config/system','System','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:37:\"General system related configuration.\";}}','system',0,0,1,0,-20,3,0,1,8,53,0,0,0,0,0,0,0),('management',54,16,'admin/modules/uninstall','admin/modules/uninstall','Uninstall','a:0:{}','system',-1,0,0,0,20,3,0,1,16,54,0,0,0,0,0,0,0),('management',55,8,'admin/config/user-interface','admin/config/user-interface','User interface','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:38:\"Tools that enhance the user interface.\";}}','system',0,0,1,0,-15,3,0,1,8,55,0,0,0,0,0,0,0),('navigation',56,5,'node/%/view','node/%/view','View','a:0:{}','system',-1,0,0,0,-10,2,0,5,56,0,0,0,0,0,0,0,0),('navigation',57,17,'user/%/view','user/%/view','View','a:0:{}','system',-1,0,0,0,-10,2,0,17,57,0,0,0,0,0,0,0,0),('management',58,8,'admin/config/services','admin/config/services','Web services','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:30:\"Tools related to web services.\";}}','system',0,0,1,0,0,3,0,1,8,58,0,0,0,0,0,0,0),('management',59,8,'admin/config/workflow','admin/config/workflow','Workflow','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"Content workflow, editorial workflow tools.\";}}','system',0,0,0,0,5,3,0,1,8,59,0,0,0,0,0,0,0),('management',60,12,'admin/help/block','admin/help/block','block','a:0:{}','system',-1,0,0,0,0,3,0,1,12,60,0,0,0,0,0,0,0),('management',61,12,'admin/help/color','admin/help/color','color','a:0:{}','system',-1,0,0,0,0,3,0,1,12,61,0,0,0,0,0,0,0),('management',62,12,'admin/help/comment','admin/help/comment','comment','a:0:{}','system',-1,0,0,0,0,3,0,1,12,62,0,0,0,0,0,0,0),('management',63,12,'admin/help/contextual','admin/help/contextual','contextual','a:0:{}','system',-1,0,0,0,0,3,0,1,12,63,0,0,0,0,0,0,0),('management',64,12,'admin/help/dashboard','admin/help/dashboard','dashboard','a:0:{}','system',-1,0,0,0,0,3,0,1,12,64,0,0,0,0,0,0,0),('management',65,12,'admin/help/field','admin/help/field','field','a:0:{}','system',-1,0,0,0,0,3,0,1,12,65,0,0,0,0,0,0,0),('management',66,12,'admin/help/field_sql_storage','admin/help/field_sql_storage','field_sql_storage','a:0:{}','system',-1,0,0,0,0,3,0,1,12,66,0,0,0,0,0,0,0),('management',67,12,'admin/help/file','admin/help/file','file','a:0:{}','system',-1,0,0,0,0,3,0,1,12,67,0,0,0,0,0,0,0),('management',68,12,'admin/help/filter','admin/help/filter','filter','a:0:{}','system',-1,0,0,0,0,3,0,1,12,68,0,0,0,0,0,0,0),('management',69,12,'admin/help/help','admin/help/help','help','a:0:{}','system',-1,0,0,0,0,3,0,1,12,69,0,0,0,0,0,0,0),('management',70,12,'admin/help/image','admin/help/image','image','a:0:{}','system',-1,0,0,0,0,3,0,1,12,70,0,0,0,0,0,0,0),('management',71,12,'admin/help/list','admin/help/list','list','a:0:{}','system',-1,0,0,0,0,3,0,1,12,71,0,0,0,0,0,0,0),('management',72,12,'admin/help/menu','admin/help/menu','menu','a:0:{}','system',-1,0,0,0,0,3,0,1,12,72,0,0,0,0,0,0,0),('management',73,12,'admin/help/node','admin/help/node','node','a:0:{}','system',-1,0,0,0,0,3,0,1,12,73,0,0,0,0,0,0,0),('management',74,12,'admin/help/options','admin/help/options','options','a:0:{}','system',-1,0,0,0,0,3,0,1,12,74,0,0,0,0,0,0,0),('management',75,12,'admin/help/system','admin/help/system','system','a:0:{}','system',-1,0,0,0,0,3,0,1,12,75,0,0,0,0,0,0,0),('management',76,12,'admin/help/text','admin/help/text','text','a:0:{}','system',-1,0,0,0,0,3,0,1,12,76,0,0,0,0,0,0,0),('management',77,12,'admin/help/user','admin/help/user','user','a:0:{}','system',-1,0,0,0,0,3,0,1,12,77,0,0,0,0,0,0,0),('management',78,46,'admin/config/people/accounts','admin/config/people/accounts','Account settings','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:109:\"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.\";}}','system',0,0,0,0,-10,4,0,1,8,46,78,0,0,0,0,0,0),('management',79,53,'admin/config/system/actions','admin/config/system/actions','Actions','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:41:\"Manage the actions defined for your site.\";}}','system',0,0,1,0,0,4,0,1,8,53,79,0,0,0,0,0,0),('management',80,29,'admin/structure/block/add','admin/structure/block/add','Add block','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,80,0,0,0,0,0,0),('management',81,35,'admin/structure/types/add','admin/structure/types/add','Add content type','a:0:{}','system',-1,0,0,0,0,4,0,1,21,35,81,0,0,0,0,0,0),('management',82,45,'admin/structure/menu/add','admin/structure/menu/add','Add menu','a:0:{}','system',-1,0,0,0,0,4,0,1,21,45,82,0,0,0,0,0,0),('management',83,51,'admin/appearance/settings/bartik','admin/appearance/settings/bartik','Bartik','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,83,0,0,0,0,0,0),('management',84,50,'admin/config/search/clean-urls','admin/config/search/clean-urls','Clean URLs','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"Enable or disable clean URLs for your site.\";}}','system',0,0,0,0,5,4,0,1,8,50,84,0,0,0,0,0,0),('management',85,53,'admin/config/system/cron','admin/config/system/cron','Cron','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:40:\"Manage automatic site maintenance tasks.\";}}','system',0,0,0,0,20,4,0,1,8,53,85,0,0,0,0,0,0),('management',86,48,'admin/config/regional/date-time','admin/config/regional/date-time','Date and time','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:44:\"Configure display formats for date and time.\";}}','system',0,0,0,0,-15,4,0,1,8,48,86,0,0,0,0,0,0),('management',87,44,'admin/config/media/file-system','admin/config/media/file-system','File system','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:68:\"Tell Drupal where to store uploaded files and how they are accessed.\";}}','system',0,0,0,0,-10,4,0,1,8,44,87,0,0,0,0,0,0),('management',88,51,'admin/appearance/settings/garland','admin/appearance/settings/garland','Garland','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,88,0,0,0,0,0,0),('management',89,51,'admin/appearance/settings/global','admin/appearance/settings/global','Global settings','a:0:{}','system',-1,0,0,0,-1,4,0,1,7,51,89,0,0,0,0,0,0),('management',90,46,'admin/config/people/ip-blocking','admin/config/people/ip-blocking','IP address blocking','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:28:\"Manage blocked IP addresses.\";}}','system',0,0,1,0,10,4,0,1,8,46,90,0,0,0,0,0,0),('management',91,44,'admin/config/media/image-styles','admin/config/media/image-styles','Image styles','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:78:\"Configure styles that can be used for resizing or adjusting images on display.\";}}','system',0,0,1,0,0,4,0,1,8,44,91,0,0,0,0,0,0),('management',92,44,'admin/config/media/image-toolkit','admin/config/media/image-toolkit','Image toolkit','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Choose which image toolkit to use if you have installed optional toolkits.\";}}','system',0,0,0,0,20,4,0,1,8,44,92,0,0,0,0,0,0),('management',93,35,'admin/structure/types/list','admin/structure/types/list','List','a:0:{}','system',-1,0,0,0,-10,4,0,1,21,35,93,0,0,0,0,0,0),('management',94,41,'admin/modules/list/confirm','admin/modules/list/confirm','List','a:0:{}','system',-1,0,0,0,0,4,0,1,16,41,94,0,0,0,0,0,0),('management',95,45,'admin/structure/menu/list','admin/structure/menu/list','List menus','a:0:{}','system',-1,0,0,0,-10,4,0,1,21,45,95,0,0,0,0,0,0),('management',96,38,'admin/config/development/logging','admin/config/development/logging','Logging and errors','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal\'s system events to different destinations, such as syslog, database, email, etc.\";}}','system',0,0,0,0,-15,4,0,1,8,38,96,0,0,0,0,0,0),('management',97,38,'admin/config/development/maintenance','admin/config/development/maintenance','Maintenance mode','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:62:\"Take the site offline for maintenance or bring it back online.\";}}','system',0,0,0,0,-10,4,0,1,8,38,97,0,0,0,0,0,0),('management',98,38,'admin/config/development/performance','admin/config/development/performance','Performance','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:101:\"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.\";}}','system',0,0,0,0,-20,4,0,1,8,38,98,0,0,0,0,0,0),('management',99,47,'admin/people/permissions/list','admin/people/permissions/list','Permissions','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:64:\"Determine access to features by selecting permissions for roles.\";}}','system',-1,0,0,0,-8,4,0,1,18,47,99,0,0,0,0,0,0),('management',100,31,'admin/content/comment/new','admin/content/comment/new','Published comments','a:0:{}','system',-1,0,0,0,-10,4,0,1,9,31,100,0,0,0,0,0,0),('management',101,58,'admin/config/services/rss-publishing','admin/config/services/rss-publishing','RSS publishing','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:114:\"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.\";}}','system',0,0,0,0,0,4,0,1,8,58,101,0,0,0,0,0,0),('management',102,48,'admin/config/regional/settings','admin/config/regional/settings','Regional settings','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site\'s default time zone and country.\";}}','system',0,0,0,0,-20,4,0,1,8,48,102,0,0,0,0,0,0),('management',103,47,'admin/people/permissions/roles','admin/people/permissions/roles','Roles','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:30:\"List, edit, or add user roles.\";}}','system',-1,0,1,0,-5,4,0,1,18,47,103,0,0,0,0,0,0),('management',104,45,'admin/structure/menu/settings','admin/structure/menu/settings','Settings','a:0:{}','system',-1,0,0,0,5,4,0,1,21,45,104,0,0,0,0,0,0),('management',105,51,'admin/appearance/settings/seven','admin/appearance/settings/seven','Seven','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,105,0,0,0,0,0,0),('management',106,53,'admin/config/system/site-information','admin/config/system/site-information','Site information','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:104:\"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.\";}}','system',0,0,0,0,-20,4,0,1,8,53,106,0,0,0,0,0,0),('management',107,51,'admin/appearance/settings/stark','admin/appearance/settings/stark','Stark','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,107,0,0,0,0,0,0),('management',108,34,'admin/config/content/formats','admin/config/content/formats','Text formats','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:127:\"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.\";}}','system',0,0,1,0,0,4,0,1,8,34,108,0,0,0,0,0,0),('management',109,31,'admin/content/comment/approval','admin/content/comment/approval','Unapproved comments','a:0:{}','system',-1,0,0,0,0,4,0,1,9,31,109,0,0,0,0,0,0),('management',110,54,'admin/modules/uninstall/confirm','admin/modules/uninstall/confirm','Uninstall','a:0:{}','system',-1,0,0,0,0,4,0,1,16,54,110,0,0,0,0,0,0),('navigation',111,39,'user/%/edit/account','user/%/edit/account','Account','a:0:{}','system',-1,0,0,0,0,3,0,17,39,111,0,0,0,0,0,0,0),('management',112,108,'admin/config/content/formats/%','admin/config/content/formats/%','','a:0:{}','system',0,0,1,0,0,5,0,1,8,34,108,112,0,0,0,0,0),('management',113,91,'admin/config/media/image-styles/add','admin/config/media/image-styles/add','Add style','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:22:\"Add a new image style.\";}}','system',-1,0,0,0,2,5,0,1,8,44,91,113,0,0,0,0,0),('management',114,108,'admin/config/content/formats/add','admin/config/content/formats/add','Add text format','a:0:{}','system',-1,0,0,0,1,5,0,1,8,34,108,114,0,0,0,0,0),('management',115,29,'admin/structure/block/list/bartik','admin/structure/block/list/bartik','Bartik','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,115,0,0,0,0,0,0),('management',116,79,'admin/config/system/actions/configure','admin/config/system/actions/configure','Configure an advanced action','a:0:{}','system',-1,0,0,0,0,5,0,1,8,53,79,116,0,0,0,0,0),('management',117,45,'admin/structure/menu/manage/%','admin/structure/menu/manage/%','Customize menu','a:0:{}','system',0,0,1,0,0,4,0,1,21,45,117,0,0,0,0,0,0),('management',118,35,'admin/structure/types/manage/%','admin/structure/types/manage/%','Edit content type','a:0:{}','system',0,0,1,0,0,4,0,1,21,35,118,0,0,0,0,0,0),('management',119,86,'admin/config/regional/date-time/formats','admin/config/regional/date-time/formats','Formats','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:51:\"Configure display format strings for date and time.\";}}','system',-1,0,1,0,-9,5,0,1,8,48,86,119,0,0,0,0,0),('management',120,29,'admin/structure/block/list/garland','admin/structure/block/list/garland','Garland','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,120,0,0,0,0,0,0),('management',121,108,'admin/config/content/formats/list','admin/config/content/formats/list','List','a:0:{}','system',-1,0,0,0,0,5,0,1,8,34,108,121,0,0,0,0,0),('management',122,91,'admin/config/media/image-styles/list','admin/config/media/image-styles/list','List','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:42:\"List the current image styles on the site.\";}}','system',-1,0,0,0,1,5,0,1,8,44,91,122,0,0,0,0,0),('management',123,79,'admin/config/system/actions/manage','admin/config/system/actions/manage','Manage actions','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:41:\"Manage the actions defined for your site.\";}}','system',-1,0,0,0,-2,5,0,1,8,53,79,123,0,0,0,0,0),('management',124,78,'admin/config/people/accounts/settings','admin/config/people/accounts/settings','Settings','a:0:{}','system',-1,0,0,0,-10,5,0,1,8,46,78,124,0,0,0,0,0),('management',125,29,'admin/structure/block/list/seven','admin/structure/block/list/seven','Seven','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,125,0,0,0,0,0,0),('management',126,29,'admin/structure/block/list/stark','admin/structure/block/list/stark','Stark','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,126,0,0,0,0,0,0),('management',127,86,'admin/config/regional/date-time/types','admin/config/regional/date-time/types','Types','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:44:\"Configure display formats for date and time.\";}}','system',-1,0,1,0,-10,5,0,1,8,48,86,127,0,0,0,0,0),('navigation',128,49,'node/%/revisions/%/delete','node/%/revisions/%/delete','Delete earlier revision','a:0:{}','system',0,0,0,0,0,3,0,5,49,128,0,0,0,0,0,0,0),('navigation',129,49,'node/%/revisions/%/revert','node/%/revisions/%/revert','Revert to earlier revision','a:0:{}','system',0,0,0,0,0,3,0,5,49,129,0,0,0,0,0,0,0),('navigation',130,49,'node/%/revisions/%/view','node/%/revisions/%/view','Revisions','a:0:{}','system',0,0,0,0,0,3,0,5,49,130,0,0,0,0,0,0,0),('management',131,120,'admin/structure/block/list/garland/add','admin/structure/block/list/garland/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,120,131,0,0,0,0,0),('management',132,125,'admin/structure/block/list/seven/add','admin/structure/block/list/seven/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,125,132,0,0,0,0,0),('management',133,126,'admin/structure/block/list/stark/add','admin/structure/block/list/stark/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,126,133,0,0,0,0,0),('management',134,127,'admin/config/regional/date-time/types/add','admin/config/regional/date-time/types/add','Add date type','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:18:\"Add new date type.\";}}','system',-1,0,0,0,-10,6,0,1,8,48,86,127,134,0,0,0,0),('management',135,119,'admin/config/regional/date-time/formats/add','admin/config/regional/date-time/formats/add','Add format','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"Allow users to add additional date formats.\";}}','system',-1,0,0,0,-10,6,0,1,8,48,86,119,135,0,0,0,0),('management',136,117,'admin/structure/menu/manage/%/add','admin/structure/menu/manage/%/add','Add link','a:0:{}','system',-1,0,0,0,0,5,0,1,21,45,117,136,0,0,0,0,0),('management',137,29,'admin/structure/block/manage/%/%','admin/structure/block/manage/%/%','Configure block','a:0:{}','system',0,0,0,0,0,4,0,1,21,29,137,0,0,0,0,0,0),('navigation',138,30,'user/%/cancel/confirm/%/%','user/%/cancel/confirm/%/%','Confirm account cancellation','a:0:{}','system',0,0,0,0,0,3,0,17,30,138,0,0,0,0,0,0,0),('management',139,118,'admin/structure/types/manage/%/delete','admin/structure/types/manage/%/delete','Delete','a:0:{}','system',0,0,0,0,0,5,0,1,21,35,118,139,0,0,0,0,0),('management',140,90,'admin/config/people/ip-blocking/delete/%','admin/config/people/ip-blocking/delete/%','Delete IP address','a:0:{}','system',0,0,0,0,0,5,0,1,8,46,90,140,0,0,0,0,0),('management',141,79,'admin/config/system/actions/delete/%','admin/config/system/actions/delete/%','Delete action','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:17:\"Delete an action.\";}}','system',0,0,0,0,0,5,0,1,8,53,79,141,0,0,0,0,0),('management',142,117,'admin/structure/menu/manage/%/delete','admin/structure/menu/manage/%/delete','Delete menu','a:0:{}','system',0,0,0,0,0,5,0,1,21,45,117,142,0,0,0,0,0),('management',143,45,'admin/structure/menu/item/%/delete','admin/structure/menu/item/%/delete','Delete menu link','a:0:{}','system',0,0,0,0,0,4,0,1,21,45,143,0,0,0,0,0,0),('management',144,103,'admin/people/permissions/roles/delete/%','admin/people/permissions/roles/delete/%','Delete role','a:0:{}','system',0,0,0,0,0,5,0,1,18,47,103,144,0,0,0,0,0),('management',145,112,'admin/config/content/formats/%/disable','admin/config/content/formats/%/disable','Disable text format','a:0:{}','system',0,0,0,0,0,6,0,1,8,34,108,112,145,0,0,0,0),('management',146,118,'admin/structure/types/manage/%/edit','admin/structure/types/manage/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,5,0,1,21,35,118,146,0,0,0,0,0),('management',147,117,'admin/structure/menu/manage/%/edit','admin/structure/menu/manage/%/edit','Edit menu','a:0:{}','system',-1,0,0,0,0,5,0,1,21,45,117,147,0,0,0,0,0),('management',148,45,'admin/structure/menu/item/%/edit','admin/structure/menu/item/%/edit','Edit menu link','a:0:{}','system',0,0,0,0,0,4,0,1,21,45,148,0,0,0,0,0,0),('management',149,103,'admin/people/permissions/roles/edit/%','admin/people/permissions/roles/edit/%','Edit role','a:0:{}','system',0,0,0,0,0,5,0,1,18,47,103,149,0,0,0,0,0),('management',150,91,'admin/config/media/image-styles/edit/%','admin/config/media/image-styles/edit/%','Edit style','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:25:\"Configure an image style.\";}}','system',0,0,1,0,0,5,0,1,8,44,91,150,0,0,0,0,0),('management',151,117,'admin/structure/menu/manage/%/list','admin/structure/menu/manage/%/list','List links','a:0:{}','system',-1,0,0,0,-10,5,0,1,21,45,117,151,0,0,0,0,0),('management',152,45,'admin/structure/menu/item/%/reset','admin/structure/menu/item/%/reset','Reset menu link','a:0:{}','system',0,0,0,0,0,4,0,1,21,45,152,0,0,0,0,0,0),('management',153,91,'admin/config/media/image-styles/delete/%','admin/config/media/image-styles/delete/%','Delete style','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:22:\"Delete an image style.\";}}','system',0,0,0,0,0,5,0,1,8,44,91,153,0,0,0,0,0),('management',154,91,'admin/config/media/image-styles/revert/%','admin/config/media/image-styles/revert/%','Revert style','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:22:\"Revert an image style.\";}}','system',0,0,0,0,0,5,0,1,8,44,91,154,0,0,0,0,0),('management',155,118,'admin/structure/types/manage/%/comment/display','admin/structure/types/manage/%/comment/display','Comment display','a:0:{}','system',-1,0,0,0,4,5,0,1,21,35,118,155,0,0,0,0,0),('management',156,118,'admin/structure/types/manage/%/comment/fields','admin/structure/types/manage/%/comment/fields','Comment fields','a:0:{}','system',-1,0,1,0,3,5,0,1,21,35,118,156,0,0,0,0,0),('management',157,137,'admin/structure/block/manage/%/%/configure','admin/structure/block/manage/%/%/configure','Configure block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,137,157,0,0,0,0,0),('management',158,137,'admin/structure/block/manage/%/%/delete','admin/structure/block/manage/%/%/delete','Delete block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,137,158,0,0,0,0,0),('management',159,119,'admin/config/regional/date-time/formats/%/delete','admin/config/regional/date-time/formats/%/delete','Delete date format','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:47:\"Allow users to delete a configured date format.\";}}','system',0,0,0,0,0,6,0,1,8,48,86,119,159,0,0,0,0),('management',160,127,'admin/config/regional/date-time/types/%/delete','admin/config/regional/date-time/types/%/delete','Delete date type','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Allow users to delete a configured date type.\";}}','system',0,0,0,0,0,6,0,1,8,48,86,127,160,0,0,0,0),('management',161,119,'admin/config/regional/date-time/formats/%/edit','admin/config/regional/date-time/formats/%/edit','Edit date format','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:45:\"Allow users to edit a configured date format.\";}}','system',0,0,0,0,0,6,0,1,8,48,86,119,161,0,0,0,0),('management',162,150,'admin/config/media/image-styles/edit/%/add/%','admin/config/media/image-styles/edit/%/add/%','Add image effect','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:28:\"Add a new effect to a style.\";}}','system',0,0,0,0,0,6,0,1,8,44,91,150,162,0,0,0,0),('management',163,150,'admin/config/media/image-styles/edit/%/effects/%','admin/config/media/image-styles/edit/%/effects/%','Edit image effect','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:39:\"Edit an existing effect within a style.\";}}','system',0,0,1,0,0,6,0,1,8,44,91,150,163,0,0,0,0),('management',164,163,'admin/config/media/image-styles/edit/%/effects/%/delete','admin/config/media/image-styles/edit/%/effects/%/delete','Delete image effect','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:39:\"Delete an existing effect from a style.\";}}','system',0,0,0,0,0,7,0,1,8,44,91,150,163,164,0,0,0),('management',165,45,'admin/structure/menu/manage/main-menu','admin/structure/menu/manage/%','Main menu','a:0:{}','menu',0,0,0,0,0,4,0,1,21,45,165,0,0,0,0,0,0),('management',166,45,'admin/structure/menu/manage/management','admin/structure/menu/manage/%','Management','a:0:{}','menu',0,0,0,0,0,4,0,1,21,45,166,0,0,0,0,0,0),('management',167,45,'admin/structure/menu/manage/navigation','admin/structure/menu/manage/%','Navigation','a:0:{}','menu',0,0,0,0,0,4,0,1,21,45,167,0,0,0,0,0,0),('management',168,45,'admin/structure/menu/manage/user-menu','admin/structure/menu/manage/%','User menu','a:0:{}','menu',0,0,0,0,0,4,0,1,21,45,168,0,0,0,0,0,0),('navigation',169,0,'search','search','Search','a:0:{}','system',1,0,0,0,0,1,0,169,0,0,0,0,0,0,0,0,0),('navigation',170,169,'search/node','search/node','Content','a:0:{}','system',-1,0,0,0,-10,2,0,169,170,0,0,0,0,0,0,0,0),('navigation',171,169,'search/user','search/user','Users','a:0:{}','system',-1,0,0,0,0,2,0,169,171,0,0,0,0,0,0,0,0),('navigation',172,0,'taxonomy/term/%','taxonomy/term/%','Taxonomy term','a:0:{}','system',0,0,0,0,0,1,0,172,0,0,0,0,0,0,0,0,0),('navigation',173,170,'search/node/%','search/node/%','Content','a:0:{}','system',-1,0,0,0,0,3,0,169,170,173,0,0,0,0,0,0,0),('management',174,19,'admin/reports/dblog','admin/reports/dblog','Recent log messages','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View events that have recently been logged.\";}}','system',0,0,0,0,-1,3,0,1,19,174,0,0,0,0,0,0,0),('navigation',175,17,'user/%/shortcuts','user/%/shortcuts','Shortcuts','a:0:{}','system',-1,0,0,0,0,2,0,17,175,0,0,0,0,0,0,0,0),('management',176,21,'admin/structure/taxonomy','admin/structure/taxonomy','Taxonomy','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:67:\"Manage tagging, categorization, and classification of your content.\";}}','system',0,0,1,0,0,3,0,1,21,176,0,0,0,0,0,0,0),('management',177,19,'admin/reports/access-denied','admin/reports/access-denied','Top \'access denied\' errors','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:35:\"View \'access denied\' errors (403s).\";}}','system',0,0,0,0,0,3,0,1,19,177,0,0,0,0,0,0,0),('management',178,19,'admin/reports/page-not-found','admin/reports/page-not-found','Top \'page not found\' errors','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:36:\"View \'page not found\' errors (404s).\";}}','system',0,0,0,0,0,3,0,1,19,178,0,0,0,0,0,0,0),('management',179,19,'admin/reports/search','admin/reports/search','Top search phrases','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"View most popular search phrases.\";}}','system',0,0,0,0,0,3,0,1,19,179,0,0,0,0,0,0,0),('navigation',180,171,'search/user/%','search/user/%','Users','a:0:{}','system',-1,0,0,0,0,3,0,169,171,180,0,0,0,0,0,0,0),('management',181,12,'admin/help/dblog','admin/help/dblog','dblog','a:0:{}','system',-1,0,0,0,0,3,0,1,12,181,0,0,0,0,0,0,0),('management',182,12,'admin/help/number','admin/help/number','number','a:0:{}','system',-1,0,0,0,0,3,0,1,12,182,0,0,0,0,0,0,0),('management',183,12,'admin/help/path','admin/help/path','path','a:0:{}','system',-1,0,0,0,0,3,0,1,12,183,0,0,0,0,0,0,0),('management',184,12,'admin/help/search','admin/help/search','search','a:0:{}','system',-1,0,0,0,0,3,0,1,12,184,0,0,0,0,0,0,0),('management',185,12,'admin/help/shortcut','admin/help/shortcut','shortcut','a:0:{}','system',-1,0,0,0,0,3,0,1,12,185,0,0,0,0,0,0,0),('management',186,12,'admin/help/taxonomy','admin/help/taxonomy','taxonomy','a:0:{}','system',-1,0,0,0,0,3,0,1,12,186,0,0,0,0,0,0,0),('navigation',187,172,'taxonomy/term/%/edit','taxonomy/term/%/edit','Edit','a:0:{}','system',-1,0,0,0,10,2,0,172,187,0,0,0,0,0,0,0,0),('navigation',188,172,'taxonomy/term/%/view','taxonomy/term/%/view','View','a:0:{}','system',-1,0,0,0,0,2,0,172,188,0,0,0,0,0,0,0,0),('management',189,176,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','','a:0:{}','system',0,0,0,0,0,4,0,1,21,176,189,0,0,0,0,0,0),('management',190,176,'admin/structure/taxonomy/add','admin/structure/taxonomy/add','Add vocabulary','a:0:{}','system',-1,0,0,0,0,4,0,1,21,176,190,0,0,0,0,0,0),('management',191,19,'admin/reports/event/%','admin/reports/event/%','Details','a:0:{}','system',0,0,0,0,0,3,0,1,19,191,0,0,0,0,0,0,0),('management',192,176,'admin/structure/taxonomy/list','admin/structure/taxonomy/list','List','a:0:{}','system',-1,0,0,0,-10,4,0,1,21,176,192,0,0,0,0,0,0),('management',193,50,'admin/config/search/settings','admin/config/search/settings','Search settings','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:67:\"Configure relevance settings for search and other indexing options.\";}}','system',0,0,0,0,-10,4,0,1,8,50,193,0,0,0,0,0,0),('management',194,55,'admin/config/user-interface/shortcut','admin/config/user-interface/shortcut','Shortcuts','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:29:\"Add and modify shortcut sets.\";}}','system',0,0,1,0,0,4,0,1,8,55,194,0,0,0,0,0,0),('management',195,50,'admin/config/search/path','admin/config/search/path','URL aliases','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site\'s URL paths by aliasing them.\";}}','system',0,0,1,0,-5,4,0,1,8,50,195,0,0,0,0,0,0),('management',196,195,'admin/config/search/path/add','admin/config/search/path/add','Add alias','a:0:{}','system',-1,0,0,0,0,5,0,1,8,50,195,196,0,0,0,0,0),('management',197,194,'admin/config/user-interface/shortcut/add-set','admin/config/user-interface/shortcut/add-set','Add shortcut set','a:0:{}','system',-1,0,0,0,0,5,0,1,8,55,194,197,0,0,0,0,0),('management',198,189,'admin/structure/taxonomy/%/add','admin/structure/taxonomy/%/add','Add term','a:0:{}','system',-1,0,0,0,0,5,0,1,21,176,189,198,0,0,0,0,0),('management',199,193,'admin/config/search/settings/reindex','admin/config/search/settings/reindex','Clear index','a:0:{}','system',-1,0,0,0,0,5,0,1,8,50,193,199,0,0,0,0,0),('management',200,189,'admin/structure/taxonomy/%/edit','admin/structure/taxonomy/%/edit','Edit','a:0:{}','system',-1,0,0,0,-10,5,0,1,21,176,189,200,0,0,0,0,0),('management',201,194,'admin/config/user-interface/shortcut/%','admin/config/user-interface/shortcut/%','Edit shortcuts','a:0:{}','system',0,0,1,0,0,5,0,1,8,55,194,201,0,0,0,0,0),('management',202,189,'admin/structure/taxonomy/%/list','admin/structure/taxonomy/%/list','List','a:0:{}','system',-1,0,0,0,-20,5,0,1,21,176,189,202,0,0,0,0,0),('management',203,195,'admin/config/search/path/list','admin/config/search/path/list','List','a:0:{}','system',-1,0,0,0,-10,5,0,1,8,50,195,203,0,0,0,0,0),('management',204,201,'admin/config/user-interface/shortcut/%/add-link','admin/config/user-interface/shortcut/%/add-link','Add shortcut','a:0:{}','system',-1,0,0,0,0,6,0,1,8,55,194,201,204,0,0,0,0),('management',205,195,'admin/config/search/path/delete/%','admin/config/search/path/delete/%','Delete alias','a:0:{}','system',0,0,0,0,0,5,0,1,8,50,195,205,0,0,0,0,0),('management',206,201,'admin/config/user-interface/shortcut/%/delete','admin/config/user-interface/shortcut/%/delete','Delete shortcut set','a:0:{}','system',0,0,0,0,0,6,0,1,8,55,194,201,206,0,0,0,0),('management',207,195,'admin/config/search/path/edit/%','admin/config/search/path/edit/%','Edit alias','a:0:{}','system',0,0,0,0,0,5,0,1,8,50,195,207,0,0,0,0,0),('management',208,201,'admin/config/user-interface/shortcut/%/edit','admin/config/user-interface/shortcut/%/edit','Edit set name','a:0:{}','system',-1,0,0,0,10,6,0,1,8,55,194,201,208,0,0,0,0),('management',209,194,'admin/config/user-interface/shortcut/link/%','admin/config/user-interface/shortcut/link/%','Edit shortcut','a:0:{}','system',0,0,1,0,0,5,0,1,8,55,194,209,0,0,0,0,0),('management',210,201,'admin/config/user-interface/shortcut/%/links','admin/config/user-interface/shortcut/%/links','List links','a:0:{}','system',-1,0,0,0,0,6,0,1,8,55,194,201,210,0,0,0,0),('management',211,209,'admin/config/user-interface/shortcut/link/%/delete','admin/config/user-interface/shortcut/link/%/delete','Delete shortcut','a:0:{}','system',0,0,0,0,0,6,0,1,8,55,194,209,211,0,0,0,0),('shortcut-set-1',212,0,'node/add','node/add','Add content','a:0:{}','menu',0,0,0,0,-20,1,0,212,0,0,0,0,0,0,0,0,0),('shortcut-set-1',213,0,'admin/content','admin/content','Find content','a:0:{}','menu',0,0,0,0,-19,1,0,213,0,0,0,0,0,0,0,0,0),('main-menu',214,0,'<front>','','Home','a:0:{}','menu',0,1,0,0,0,1,0,214,0,0,0,0,0,0,0,0,0),('navigation',217,6,'node/add/article','node/add/article','Article','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.\";}}','system',0,0,0,0,0,2,0,6,217,0,0,0,0,0,0,0,0),('navigation',218,6,'node/add/page','node/add/page','Basic page','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an \'About us\' page.\";}}','system',0,0,0,0,0,2,0,6,218,0,0,0,0,0,0,0,0),('management',219,19,'admin/reports/fields','admin/reports/fields','Field list','a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:39:\"Overview of fields on all entity types.\";}}','system',0,0,0,0,0,3,0,1,19,219,0,0,0,0,0,0,0),('management',222,12,'admin/help/field_ui','admin/help/field_ui','field_ui','a:0:{}','system',-1,0,0,0,0,3,0,1,12,222,0,0,0,0,0,0,0),('management',225,12,'admin/help/rdf','admin/help/rdf','rdf','a:0:{}','system',-1,0,0,0,0,3,0,1,12,225,0,0,0,0,0,0,0),('management',227,12,'admin/help/toolbar','admin/help/toolbar','toolbar','a:0:{}','system',-1,0,0,0,0,3,0,1,12,227,0,0,0,0,0,0,0),('management',317,51,'admin/appearance/settings/ohm','admin/appearance/settings/ohm','Ohm','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,317,0,0,0,0,0,0),('management',318,51,'admin/appearance/settings/omega','admin/appearance/settings/omega','Omega','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,318,0,0,0,0,0,0),('management',319,51,'admin/appearance/settings/raptor_omega','admin/appearance/settings/raptor_omega','RAPTOR Omega','a:0:{}','system',-1,0,0,0,0,4,0,1,7,51,319,0,0,0,0,0,0),('management',320,29,'admin/structure/block/list/ohm','admin/structure/block/list/ohm','Ohm','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,320,0,0,0,0,0,0),('management',321,29,'admin/structure/block/list/omega','admin/structure/block/list/omega','Omega','a:0:{}','system',-1,0,0,0,0,4,0,1,21,29,321,0,0,0,0,0,0),('management',322,29,'admin/structure/block/list/raptor_omega','admin/structure/block/list/raptor_omega','RAPTOR Omega','a:0:{}','system',-1,0,0,0,-10,4,0,1,21,29,322,0,0,0,0,0,0),('management',323,320,'admin/structure/block/list/ohm/add','admin/structure/block/list/ohm/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,320,323,0,0,0,0,0),('management',324,321,'admin/structure/block/list/omega/add','admin/structure/block/list/omega/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,321,324,0,0,0,0,0),('management',329,115,'admin/structure/block/list/bartik/add','admin/structure/block/list/bartik/add','Add block','a:0:{}','system',-1,0,0,0,0,5,0,1,21,29,115,329,0,0,0,0,0),('management',932,189,'admin/structure/taxonomy/%/display','admin/structure/taxonomy/%/display','Manage display','a:0:{}','system',-1,0,0,0,2,5,0,1,21,176,189,932,0,0,0,0,0),('management',933,78,'admin/config/people/accounts/display','admin/config/people/accounts/display','Manage display','a:0:{}','system',-1,0,0,0,2,5,0,1,8,46,78,933,0,0,0,0,0),('management',934,189,'admin/structure/taxonomy/%/fields','admin/structure/taxonomy/%/fields','Manage fields','a:0:{}','system',-1,0,1,0,1,5,0,1,21,176,189,934,0,0,0,0,0),('management',935,78,'admin/config/people/accounts/fields','admin/config/people/accounts/fields','Manage fields','a:0:{}','system',-1,0,1,0,1,5,0,1,8,46,78,935,0,0,0,0,0),('management',936,932,'admin/structure/taxonomy/%/display/default','admin/structure/taxonomy/%/display/default','Default','a:0:{}','system',-1,0,0,0,-10,6,0,1,21,176,189,932,936,0,0,0,0),('management',937,933,'admin/config/people/accounts/display/default','admin/config/people/accounts/display/default','Default','a:0:{}','system',-1,0,0,0,-10,6,0,1,8,46,78,933,937,0,0,0,0),('management',938,118,'admin/structure/types/manage/%/display','admin/structure/types/manage/%/display','Manage display','a:0:{}','system',-1,0,0,0,2,5,0,1,21,35,118,938,0,0,0,0,0),('management',939,118,'admin/structure/types/manage/%/fields','admin/structure/types/manage/%/fields','Manage fields','a:0:{}','system',-1,0,1,0,1,5,0,1,21,35,118,939,0,0,0,0,0),('management',940,932,'admin/structure/taxonomy/%/display/full','admin/structure/taxonomy/%/display/full','Taxonomy term page','a:0:{}','system',-1,0,0,0,0,6,0,1,21,176,189,932,940,0,0,0,0),('management',941,933,'admin/config/people/accounts/display/full','admin/config/people/accounts/display/full','User account','a:0:{}','system',-1,0,0,0,0,6,0,1,8,46,78,933,941,0,0,0,0),('management',942,934,'admin/structure/taxonomy/%/fields/%','admin/structure/taxonomy/%/fields/%','','a:0:{}','system',0,0,0,0,0,6,0,1,21,176,189,934,942,0,0,0,0),('management',943,935,'admin/config/people/accounts/fields/%','admin/config/people/accounts/fields/%','','a:0:{}','system',0,0,0,0,0,6,0,1,8,46,78,935,943,0,0,0,0),('management',944,938,'admin/structure/types/manage/%/display/default','admin/structure/types/manage/%/display/default','Default','a:0:{}','system',-1,0,0,0,-10,6,0,1,21,35,118,938,944,0,0,0,0),('management',945,938,'admin/structure/types/manage/%/display/full','admin/structure/types/manage/%/display/full','Full content','a:0:{}','system',-1,0,0,0,0,6,0,1,21,35,118,938,945,0,0,0,0),('management',946,938,'admin/structure/types/manage/%/display/rss','admin/structure/types/manage/%/display/rss','RSS','a:0:{}','system',-1,0,0,0,2,6,0,1,21,35,118,938,946,0,0,0,0),('management',947,938,'admin/structure/types/manage/%/display/search_index','admin/structure/types/manage/%/display/search_index','Search index','a:0:{}','system',-1,0,0,0,3,6,0,1,21,35,118,938,947,0,0,0,0),('management',948,938,'admin/structure/types/manage/%/display/search_result','admin/structure/types/manage/%/display/search_result','Search result highlighting input','a:0:{}','system',-1,0,0,0,4,6,0,1,21,35,118,938,948,0,0,0,0),('management',949,938,'admin/structure/types/manage/%/display/teaser','admin/structure/types/manage/%/display/teaser','Teaser','a:0:{}','system',-1,0,0,0,1,6,0,1,21,35,118,938,949,0,0,0,0),('management',950,939,'admin/structure/types/manage/%/fields/%','admin/structure/types/manage/%/fields/%','','a:0:{}','system',0,0,0,0,0,6,0,1,21,35,118,939,950,0,0,0,0),('management',951,942,'admin/structure/taxonomy/%/fields/%/delete','admin/structure/taxonomy/%/fields/%/delete','Delete','a:0:{}','system',-1,0,0,0,10,7,0,1,21,176,189,934,942,951,0,0,0),('management',952,942,'admin/structure/taxonomy/%/fields/%/edit','admin/structure/taxonomy/%/fields/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,7,0,1,21,176,189,934,942,952,0,0,0),('management',953,942,'admin/structure/taxonomy/%/fields/%/field-settings','admin/structure/taxonomy/%/fields/%/field-settings','Field settings','a:0:{}','system',-1,0,0,0,0,7,0,1,21,176,189,934,942,953,0,0,0),('management',954,942,'admin/structure/taxonomy/%/fields/%/widget-type','admin/structure/taxonomy/%/fields/%/widget-type','Widget type','a:0:{}','system',-1,0,0,0,0,7,0,1,21,176,189,934,942,954,0,0,0),('management',955,943,'admin/config/people/accounts/fields/%/delete','admin/config/people/accounts/fields/%/delete','Delete','a:0:{}','system',-1,0,0,0,10,7,0,1,8,46,78,935,943,955,0,0,0),('management',956,943,'admin/config/people/accounts/fields/%/edit','admin/config/people/accounts/fields/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,7,0,1,8,46,78,935,943,956,0,0,0),('management',957,943,'admin/config/people/accounts/fields/%/field-settings','admin/config/people/accounts/fields/%/field-settings','Field settings','a:0:{}','system',-1,0,0,0,0,7,0,1,8,46,78,935,943,957,0,0,0),('management',958,943,'admin/config/people/accounts/fields/%/widget-type','admin/config/people/accounts/fields/%/widget-type','Widget type','a:0:{}','system',-1,0,0,0,0,7,0,1,8,46,78,935,943,958,0,0,0),('management',959,155,'admin/structure/types/manage/%/comment/display/default','admin/structure/types/manage/%/comment/display/default','Default','a:0:{}','system',-1,0,0,0,-10,6,0,1,21,35,118,155,959,0,0,0,0),('management',960,155,'admin/structure/types/manage/%/comment/display/full','admin/structure/types/manage/%/comment/display/full','Full comment','a:0:{}','system',-1,0,0,0,0,6,0,1,21,35,118,155,960,0,0,0,0),('management',961,156,'admin/structure/types/manage/%/comment/fields/%','admin/structure/types/manage/%/comment/fields/%','','a:0:{}','system',0,0,0,0,0,6,0,1,21,35,118,156,961,0,0,0,0),('management',962,950,'admin/structure/types/manage/%/fields/%/delete','admin/structure/types/manage/%/fields/%/delete','Delete','a:0:{}','system',-1,0,0,0,10,7,0,1,21,35,118,939,950,962,0,0,0),('management',963,950,'admin/structure/types/manage/%/fields/%/edit','admin/structure/types/manage/%/fields/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,939,950,963,0,0,0),('management',964,950,'admin/structure/types/manage/%/fields/%/field-settings','admin/structure/types/manage/%/fields/%/field-settings','Field settings','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,939,950,964,0,0,0),('management',965,950,'admin/structure/types/manage/%/fields/%/widget-type','admin/structure/types/manage/%/fields/%/widget-type','Widget type','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,939,950,965,0,0,0),('management',966,961,'admin/structure/types/manage/%/comment/fields/%/delete','admin/structure/types/manage/%/comment/fields/%/delete','Delete','a:0:{}','system',-1,0,0,0,10,7,0,1,21,35,118,156,961,966,0,0,0),('management',967,961,'admin/structure/types/manage/%/comment/fields/%/edit','admin/structure/types/manage/%/comment/fields/%/edit','Edit','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,156,961,967,0,0,0),('management',968,961,'admin/structure/types/manage/%/comment/fields/%/field-settings','admin/structure/types/manage/%/comment/fields/%/field-settings','Field settings','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,156,961,968,0,0,0),('management',969,961,'admin/structure/types/manage/%/comment/fields/%/widget-type','admin/structure/types/manage/%/comment/fields/%/widget-type','Widget type','a:0:{}','system',-1,0,0,0,0,7,0,1,21,35,118,156,961,969,0,0,0),('management',1258,12,'admin/help/simplerulesengine_core','admin/help/simplerulesengine_core','simplerulesengine_core','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1258,0,0,0,0,0,0,0),('management',1260,12,'admin/help/simplerulesengine_ui','admin/help/simplerulesengine_ui','simplerulesengine_ui','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1260,0,0,0,0,0,0,0),('management',1352,12,'admin/help/raptor_contraindications','admin/help/raptor_contraindications','raptor_contraindications','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1352,0,0,0,0,0,0,0),('management',1353,12,'admin/help/raptor_datalayer','admin/help/raptor_datalayer','raptor_datalayer','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1353,0,0,0,0,0,0,0),('management',1354,12,'admin/help/raptor_ewdvista','admin/help/raptor_ewdvista','raptor_ewdvista','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1354,0,0,0,0,0,0,0),('management',1355,12,'admin/help/raptor_floatingdialog','admin/help/raptor_floatingdialog','raptor_floatingdialog','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1355,0,0,0,0,0,0,0),('management',1356,12,'admin/help/raptor_formulas','admin/help/raptor_formulas','raptor_formulas','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1356,0,0,0,0,0,0,0),('management',1357,12,'admin/help/raptor_glue','admin/help/raptor_glue','raptor_glue','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1357,0,0,0,0,0,0,0),('management',1358,12,'admin/help/raptor_graph','admin/help/raptor_graph','raptor_graph','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1358,0,0,0,0,0,0,0),('management',1359,12,'admin/help/raptor_imageviewing','admin/help/raptor_imageviewing','raptor_imageviewing','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1359,0,0,0,0,0,0,0),('management',1360,12,'admin/help/raptor_mdwsvista','admin/help/raptor_mdwsvista','raptor_mdwsvista','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1360,0,0,0,0,0,0,0),('management',1361,12,'admin/help/raptor_protocollib','admin/help/raptor_protocollib','raptor_protocollib','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1361,0,0,0,0,0,0,0),('management',1362,12,'admin/help/raptor_reports','admin/help/raptor_reports','raptor_reports','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1362,0,0,0,0,0,0,0),('management',1363,12,'admin/help/raptor_scheduling','admin/help/raptor_scheduling','raptor_scheduling','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1363,0,0,0,0,0,0,0),('management',1364,12,'admin/help/raptor_workflow','admin/help/raptor_workflow','raptor_workflow','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1364,0,0,0,0,0,0,0),('management',1365,12,'admin/help/simplerulesengine_demo','admin/help/simplerulesengine_demo','simplerulesengine_demo','a:0:{}','system',-1,0,0,0,0,3,0,1,12,1365,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `menu_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_router`
--

DROP TABLE IF EXISTS `menu_router`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `menu_router` (
  `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary Key: the Drupal path this entry describes',
  `load_functions` blob NOT NULL COMMENT 'A serialized array of function names (like node_load) to be called to load an object corresponding to a part of the current path.',
  `to_arg_functions` blob NOT NULL COMMENT 'A serialized array of function names (like user_uid_optional_to_arg) to be called to replace a part of the router path with another string.',
  `access_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The callback which determines the access to this router path. Defaults to user_access.',
  `access_arguments` blob COMMENT 'A serialized array of arguments for the access callback.',
  `page_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that renders the page.',
  `page_arguments` blob COMMENT 'A serialized array of arguments for the page callback.',
  `delivery_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'The name of the function that sends the result of the page_callback function to the browser.',
  `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',
  `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',
  `context` int(11) NOT NULL DEFAULT '0' COMMENT 'Only for local tasks (tabs) - the context of a local task to control its placement.',
  `tab_parent` varchar(255) NOT NULL DEFAULT '' COMMENT 'Only for local tasks (tabs) - the router path of the parent page (which may also be a local task).',
  `tab_root` varchar(255) NOT NULL DEFAULT '' COMMENT 'Router path of the closest non-tab parent page. For pages that are not local tasks, this will be the same as the path.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title for the current page, or the title for the tab if this is a local task.',
  `title_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which will alter the title. Defaults to t()',
  `title_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the title callback. If empty, the title will be used as the sole argument for the title callback.',
  `theme_callback` varchar(255) NOT NULL DEFAULT '' COMMENT 'A function which returns the name of the theme that will be used to render this page. If left empty, the default theme will be used.',
  `theme_arguments` varchar(255) NOT NULL DEFAULT '' COMMENT 'A serialized array of arguments for the theme callback.',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT 'Numeric representation of the type of the menu item, like MENU_LOCAL_TASK.',
  `description` text NOT NULL COMMENT 'A description of this item.',
  `position` varchar(255) NOT NULL DEFAULT '' COMMENT 'The position of the block (left or right) on the system administration page for this item.',
  `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Weight of the element. Lighter weights are higher up, heavier weights go down.',
  `include_file` mediumtext COMMENT 'The file to include for this element, usually the page callback function lives in this file.',
  PRIMARY KEY (`path`),
  KEY `fit` (`fit`),
  KEY `tab_parent` (`tab_parent`(64),`weight`,`title`),
  KEY `tab_root_weight_title` (`tab_root`(64),`weight`,`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps paths to various callbacks (access, page and title)';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_router`
--

LOCK TABLES `menu_router` WRITE;
/*!40000 ALTER TABLE `menu_router` DISABLE KEYS */;
INSERT INTO `menu_router` VALUES ('admin','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',1,1,0,'','admin','Administration','t','','','a:0:{}',6,'','',9,'modules/system/system.admin.inc'),('admin/appearance','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','system_themes_page','a:0:{}','',3,2,0,'','admin/appearance','Appearance','t','','','a:0:{}',6,'Select and configure your themes.','left',-6,'modules/system/system.admin.inc'),('admin/appearance/default','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','system_theme_default','a:0:{}','',7,3,0,'','admin/appearance/default','Set default theme','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/appearance/disable','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','system_theme_disable','a:0:{}','',7,3,0,'','admin/appearance/disable','Disable theme','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/appearance/enable','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','system_theme_enable','a:0:{}','',7,3,0,'','admin/appearance/enable','Enable theme','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/appearance/list','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','system_themes_page','a:0:{}','',7,3,1,'admin/appearance','admin/appearance','List','t','','','a:0:{}',140,'Select and configure your theme','',-1,'modules/system/system.admin.inc'),('admin/appearance/settings','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','drupal_get_form','a:1:{i:0;s:21:\"system_theme_settings\";}','',7,3,1,'admin/appearance','admin/appearance','Settings','t','','','a:0:{}',132,'Configure default and theme specific settings.','',20,'modules/system/system.admin.inc'),('admin/appearance/settings/bartik','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:25:\"themes/bartik/bartik.info\";s:4:\"name\";s:6:\"bartik\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:6:\"Bartik\";s:11:\"description\";s:48:\"A flexible, recolorable theme with many regions.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:7:\"regions\";a:20:{s:6:\"header\";s:6:\"Header\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:11:\"highlighted\";s:11:\"Highlighted\";s:8:\"featured\";s:8:\"Featured\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"Sidebar first\";s:14:\"sidebar_second\";s:14:\"Sidebar second\";s:14:\"triptych_first\";s:14:\"Triptych first\";s:15:\"triptych_middle\";s:15:\"Triptych middle\";s:13:\"triptych_last\";s:13:\"Triptych last\";s:18:\"footer_firstcolumn\";s:19:\"Footer first column\";s:19:\"footer_secondcolumn\";s:20:\"Footer second column\";s:18:\"footer_thirdcolumn\";s:19:\"Footer third column\";s:19:\"footer_fourthcolumn\";s:20:\"Footer fourth column\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"0\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:28:\"themes/bartik/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418441;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:6:\"bartik\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Bartik','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/garland','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:27:\"themes/garland/garland.info\";s:4:\"name\";s:7:\"garland\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:7:\"Garland\";s:11:\"description\";s:111:\"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:8:\"settings\";a:1:{s:13:\"garland_width\";s:5:\"fluid\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:29:\"themes/garland/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418436;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:7:\"garland\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Garland','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/global','','','user_access','a:1:{i:0;s:17:\"administer themes\";}','drupal_get_form','a:1:{i:0;s:21:\"system_theme_settings\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Global settings','t','','','a:0:{}',140,'','',-1,'modules/system/system.admin.inc'),('admin/appearance/settings/ohm','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":14:{s:8:\"filename\";s:35:\"sites/all/themes/omega/ohm/ohm.info\";s:4:\"name\";s:3:\"ohm\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:20:{s:4:\"name\";s:3:\"Ohm\";s:11:\"description\";s:189:\"Omega based demonstration theme. Serves as a best-practice reference for the Omega documentation. Ohm will be constantly updated as best practice evolves so shouldn\'t be used in production.\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:41:\"sites/all/themes/omega/ohm/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:7:\"regions\";a:13:{s:8:\"branding\";s:8:\"Branding\";s:10:\"navigation\";s:14:\"Navigation bar\";s:6:\"header\";s:6:\"Header\";s:4:\"hero\";s:4:\"Hero\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:6:\"layout\";a:1:{s:4:\"hero\";a:1:{s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:36:\"css/layouts/hero/ohm-hero.layout.css\";}}}}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"1\";s:27:\"toggle_comment_user_picture\";s:1:\"1\";s:32:\"toggle_comment_user_verification\";s:1:\"1\";s:14:\"toggle_favicon\";s:1:\"1\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"1\";s:31:\"omega_toggle_front_page_content\";s:1:\"1\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:5:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"0\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"0\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"0\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}s:8:\"messages\";a:1:{s:6:\"status\";s:1:\"1\";}}s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:8:\"ohm-hero\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"1\";s:23:\"omega_livereload_script\";s:36:\"http://localhost:35729/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"1\";s:23:\"omega_demo_regions_list\";a:9:{s:10:\"navigation\";s:10:\"navigation\";s:6:\"header\";s:6:\"header\";s:4:\"hero\";s:4:\"hero\";s:11:\"highlighted\";s:11:\"highlighted\";s:4:\"help\";s:4:\"help\";s:7:\"content\";s:7:\"content\";s:13:\"sidebar_first\";s:13:\"sidebar_first\";s:14:\"sidebar_second\";s:14:\"sidebar_second\";s:6:\"footer\";s:6:\"footer\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862216;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:3:\"ohm\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Ohm','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/omega','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:39:\"sites/all/themes/omega/omega/omega.info\";s:4:\"name\";s:5:\"omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Omega\";s:11:\"description\";s:432:\"A powerful HTML5 base theme framework utilizing tools like <a href=\"http://sass-lang.com/\" title=\"Sass\">Sass</a>, <a href=\"http://compass-style.org/\" title=\"Compass\">Compass</a>, <a href=\"http://gruntjs.com/\" title=\"Grunt\">Grunt</a>, <a href=\"http://bower.io/\" title=\"Bower\">Bower</a>, <a href=\"http://rvm.io/\" title=\"Ruby Version Manager\">Ruby Version Manager</a>, <a href=\"http://bundler.io/\" title=\"Bundler\">Bundler</a> and more.\";s:10:\"screenshot\";s:43:\"sites/all/themes/omega/omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:7:\"regions\";a:12:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First Sidebar\";s:14:\"sidebar_second\";s:14:\"Second Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:7:\"plugins\";a:1:{s:6:\"panels\";a:2:{s:7:\"layouts\";s:14:\"panels/layouts\";s:6:\"styles\";s:13:\"panels/styles\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:11:\"stylesheets\";a:0:{}s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862218;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:10:\"sub_themes\";a:2:{s:3:\"ohm\";s:3:\"Ohm\";s:12:\"raptor_omega\";s:12:\"RAPTOR Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:6:\"engine\";s:11:\"phptemplate\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:5:\"omega\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Omega','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/raptor_omega','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":15:{s:8:\"filename\";s:47:\"sites/all/themes/raptor_omega/raptor_omega.info\";s:4:\"name\";s:12:\"raptor_omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:12:\"RAPTOR Omega\";s:11:\"description\";s:32:\"Theme for the RAPTOR application\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:44:\"sites/all/themes/raptor_omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"0\";s:27:\"toggle_comment_user_picture\";s:1:\"0\";s:32:\"toggle_comment_user_verification\";s:1:\"0\";s:14:\"toggle_favicon\";s:1:\"0\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"0\";s:31:\"omega_toggle_front_page_content\";s:1:\"0\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:20:\"omega_enable_warning\";s:1:\"1\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:5:\"admin\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"0\";s:23:\"omega_livereload_script\";s:16:\"js/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"0\";s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:4:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"1\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"1\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"1\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}}}s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:5:\"mtime\";i:1440241381;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:12:\"raptor_omega\";}','',15,4,1,'admin/appearance/settings','admin/appearance','RAPTOR Omega','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/seven','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/seven/seven.info\";s:4:\"name\";s:5:\"seven\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:5:\"Seven\";s:11:\"description\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"1\";}s:7:\"regions\";a:8:{s:7:\"content\";s:7:\"Content\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/seven/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418439;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:5:\"seven\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Seven','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/appearance/settings/stark','','','_system_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal\'s default HTML markup and CSS styles. To learn how to build your own theme and override Drupal\'s default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418435;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','drupal_get_form','a:2:{i:0;s:21:\"system_theme_settings\";i:1;s:5:\"stark\";}','',15,4,1,'admin/appearance/settings','admin/appearance','Stark','t','','','a:0:{}',132,'','',0,'modules/system/system.admin.inc'),('admin/compact','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_compact_page','a:0:{}','',3,2,0,'','admin/compact','Compact mode','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/config','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_config_page','a:0:{}','',3,2,0,'','admin/config','Configuration','t','','','a:0:{}',6,'Administer settings.','',0,'modules/system/system.admin.inc'),('admin/config/content','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/content','Content authoring','t','','','a:0:{}',6,'Settings related to formatting and authoring content.','left',-15,'modules/system/system.admin.inc'),('admin/config/content/formats','','','user_access','a:1:{i:0;s:18:\"administer filters\";}','drupal_get_form','a:1:{i:0;s:21:\"filter_admin_overview\";}','',15,4,0,'','admin/config/content/formats','Text formats','t','','','a:0:{}',6,'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.','',0,'modules/filter/filter.admin.inc'),('admin/config/content/formats/%','a:1:{i:4;s:18:\"filter_format_load\";}','','user_access','a:1:{i:0;s:18:\"administer filters\";}','filter_admin_format_page','a:1:{i:0;i:4;}','',30,5,0,'','admin/config/content/formats/%','','filter_admin_format_title','a:1:{i:0;i:4;}','','a:0:{}',6,'','',0,'modules/filter/filter.admin.inc'),('admin/config/content/formats/%/disable','a:1:{i:4;s:18:\"filter_format_load\";}','','_filter_disable_format_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:20:\"filter_admin_disable\";i:1;i:4;}','',61,6,0,'','admin/config/content/formats/%/disable','Disable text format','t','','','a:0:{}',6,'','',0,'modules/filter/filter.admin.inc'),('admin/config/content/formats/add','','','user_access','a:1:{i:0;s:18:\"administer filters\";}','filter_admin_format_page','a:0:{}','',31,5,1,'admin/config/content/formats','admin/config/content/formats','Add text format','t','','','a:0:{}',388,'','',1,'modules/filter/filter.admin.inc'),('admin/config/content/formats/list','','','user_access','a:1:{i:0;s:18:\"administer filters\";}','drupal_get_form','a:1:{i:0;s:21:\"filter_admin_overview\";}','',31,5,1,'admin/config/content/formats','admin/config/content/formats','List','t','','','a:0:{}',140,'','',0,'modules/filter/filter.admin.inc'),('admin/config/development','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/development','Development','t','','','a:0:{}',6,'Development tools.','right',-10,'modules/system/system.admin.inc'),('admin/config/development/logging','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:23:\"system_logging_settings\";}','',15,4,0,'','admin/config/development/logging','Logging and errors','t','','','a:0:{}',6,'Settings for logging and alerts modules. Various modules can route Drupal\'s system events to different destinations, such as syslog, database, email, etc.','',-15,'modules/system/system.admin.inc'),('admin/config/development/maintenance','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:28:\"system_site_maintenance_mode\";}','',15,4,0,'','admin/config/development/maintenance','Maintenance mode','t','','','a:0:{}',6,'Take the site offline for maintenance or bring it back online.','',-10,'modules/system/system.admin.inc'),('admin/config/development/performance','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:27:\"system_performance_settings\";}','',15,4,0,'','admin/config/development/performance','Performance','t','','','a:0:{}',6,'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.','',-20,'modules/system/system.admin.inc'),('admin/config/media','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/media','Media','t','','','a:0:{}',6,'Media tools.','left',-10,'modules/system/system.admin.inc'),('admin/config/media/file-system','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:27:\"system_file_system_settings\";}','',15,4,0,'','admin/config/media/file-system','File system','t','','','a:0:{}',6,'Tell Drupal where to store uploaded files and how they are accessed.','',-10,'modules/system/system.admin.inc'),('admin/config/media/image-styles','','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','image_style_list','a:0:{}','',15,4,0,'','admin/config/media/image-styles','Image styles','t','','','a:0:{}',6,'Configure styles that can be used for resizing or adjusting images on display.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/add','','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:1:{i:0;s:20:\"image_style_add_form\";}','',31,5,1,'admin/config/media/image-styles','admin/config/media/image-styles','Add style','t','','','a:0:{}',388,'Add a new image style.','',2,'modules/image/image.admin.inc'),('admin/config/media/image-styles/delete/%','a:1:{i:5;a:1:{s:16:\"image_style_load\";a:2:{i:0;N;i:1;s:1:\"1\";}}}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:2:{i:0;s:23:\"image_style_delete_form\";i:1;i:5;}','',62,6,0,'','admin/config/media/image-styles/delete/%','Delete style','t','','','a:0:{}',6,'Delete an image style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/edit/%','a:1:{i:5;s:16:\"image_style_load\";}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:2:{i:0;s:16:\"image_style_form\";i:1;i:5;}','',62,6,0,'','admin/config/media/image-styles/edit/%','Edit style','t','','','a:0:{}',6,'Configure an image style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/edit/%/add/%','a:2:{i:5;a:1:{s:16:\"image_style_load\";a:1:{i:0;i:5;}}i:7;a:1:{s:28:\"image_effect_definition_load\";a:1:{i:0;i:5;}}}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:3:{i:0;s:17:\"image_effect_form\";i:1;i:5;i:2;i:7;}','',250,8,0,'','admin/config/media/image-styles/edit/%/add/%','Add image effect','t','','','a:0:{}',6,'Add a new effect to a style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/edit/%/effects/%','a:2:{i:5;a:1:{s:16:\"image_style_load\";a:2:{i:0;i:5;i:1;s:1:\"3\";}}i:7;a:1:{s:17:\"image_effect_load\";a:2:{i:0;i:5;i:1;s:1:\"3\";}}}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:3:{i:0;s:17:\"image_effect_form\";i:1;i:5;i:2;i:7;}','',250,8,0,'','admin/config/media/image-styles/edit/%/effects/%','Edit image effect','t','','','a:0:{}',6,'Edit an existing effect within a style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/edit/%/effects/%/delete','a:2:{i:5;a:1:{s:16:\"image_style_load\";a:2:{i:0;i:5;i:1;s:1:\"3\";}}i:7;a:1:{s:17:\"image_effect_load\";a:2:{i:0;i:5;i:1;s:1:\"3\";}}}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:3:{i:0;s:24:\"image_effect_delete_form\";i:1;i:5;i:2;i:7;}','',501,9,0,'','admin/config/media/image-styles/edit/%/effects/%/delete','Delete image effect','t','','','a:0:{}',6,'Delete an existing effect from a style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-styles/list','','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','image_style_list','a:0:{}','',31,5,1,'admin/config/media/image-styles','admin/config/media/image-styles','List','t','','','a:0:{}',140,'List the current image styles on the site.','',1,'modules/image/image.admin.inc'),('admin/config/media/image-styles/revert/%','a:1:{i:5;a:1:{s:16:\"image_style_load\";a:2:{i:0;N;i:1;s:1:\"2\";}}}','','user_access','a:1:{i:0;s:23:\"administer image styles\";}','drupal_get_form','a:2:{i:0;s:23:\"image_style_revert_form\";i:1;i:5;}','',62,6,0,'','admin/config/media/image-styles/revert/%','Revert style','t','','','a:0:{}',6,'Revert an image style.','',0,'modules/image/image.admin.inc'),('admin/config/media/image-toolkit','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:29:\"system_image_toolkit_settings\";}','',15,4,0,'','admin/config/media/image-toolkit','Image toolkit','t','','','a:0:{}',6,'Choose which image toolkit to use if you have installed optional toolkits.','',20,'modules/system/system.admin.inc'),('admin/config/people','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/people','People','t','','','a:0:{}',6,'Configure user accounts.','left',-20,'modules/system/system.admin.inc'),('admin/config/people/accounts','','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:1:{i:0;s:19:\"user_admin_settings\";}','',15,4,0,'','admin/config/people/accounts','Account settings','t','','','a:0:{}',6,'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.','',-10,'modules/user/user.admin.inc'),('admin/config/people/accounts/display','','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"user\";i:2;s:4:\"user\";i:3;s:7:\"default\";}','',31,5,1,'admin/config/people/accounts','admin/config/people/accounts','Manage display','t','','','a:0:{}',132,'','',2,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/display/default','','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:7:\"default\";i:3;s:11:\"user_access\";i:4;s:16:\"administer users\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"user\";i:2;s:4:\"user\";i:3;s:7:\"default\";}','',63,6,1,'admin/config/people/accounts/display','admin/config/people/accounts','Default','t','','','a:0:{}',140,'','',-10,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/display/full','','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:4:\"full\";i:3;s:11:\"user_access\";i:4;s:16:\"administer users\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"user\";i:2;s:4:\"user\";i:3;s:4:\"full\";}','',63,6,1,'admin/config/people/accounts/display','admin/config/people/accounts','User account','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields','','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:3:{i:0;s:28:\"field_ui_field_overview_form\";i:1;s:4:\"user\";i:2;s:4:\"user\";}','',31,5,1,'admin/config/people/accounts','admin/config/people/accounts','Manage fields','t','','','a:0:{}',132,'','',1,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields/%','a:1:{i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:1:\"0\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:5;}','',62,6,0,'','admin/config/people/accounts/fields/%','','field_ui_menu_title','a:1:{i:0;i:5;}','','a:0:{}',6,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields/%/delete','a:1:{i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:1:\"0\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:2:{i:0;s:26:\"field_ui_field_delete_form\";i:1;i:5;}','',125,7,1,'admin/config/people/accounts/fields/%','admin/config/people/accounts/fields/%','Delete','t','','','a:0:{}',132,'','',10,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields/%/edit','a:1:{i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:1:\"0\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:5;}','',125,7,1,'admin/config/people/accounts/fields/%','admin/config/people/accounts/fields/%','Edit','t','','','a:0:{}',140,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields/%/field-settings','a:1:{i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:1:\"0\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:2:{i:0;s:28:\"field_ui_field_settings_form\";i:1;i:5;}','',125,7,1,'admin/config/people/accounts/fields/%','admin/config/people/accounts/fields/%','Field settings','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/fields/%/widget-type','a:1:{i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"user\";i:1;s:4:\"user\";i:2;s:1:\"0\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:2:{i:0;s:25:\"field_ui_widget_type_form\";i:1;i:5;}','',125,7,1,'admin/config/people/accounts/fields/%','admin/config/people/accounts/fields/%','Widget type','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/config/people/accounts/settings','','','user_access','a:1:{i:0;s:16:\"administer users\";}','drupal_get_form','a:1:{i:0;s:19:\"user_admin_settings\";}','',31,5,1,'admin/config/people/accounts','admin/config/people/accounts','Settings','t','','','a:0:{}',140,'','',-10,'modules/user/user.admin.inc'),('admin/config/people/ip-blocking','','','user_access','a:1:{i:0;s:18:\"block IP addresses\";}','system_ip_blocking','a:0:{}','',15,4,0,'','admin/config/people/ip-blocking','IP address blocking','t','','','a:0:{}',6,'Manage blocked IP addresses.','',10,'modules/system/system.admin.inc'),('admin/config/people/ip-blocking/delete/%','a:1:{i:5;s:15:\"blocked_ip_load\";}','','user_access','a:1:{i:0;s:18:\"block IP addresses\";}','drupal_get_form','a:2:{i:0;s:25:\"system_ip_blocking_delete\";i:1;i:5;}','',62,6,0,'','admin/config/people/ip-blocking/delete/%','Delete IP address','t','','','a:0:{}',6,'','',0,'modules/system/system.admin.inc'),('admin/config/raptor_contraindications','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_edit_ci_config_form','a:0:{}','',7,3,0,'','admin/config/raptor_contraindications','Edit Contraindications Configuration','t','','','a:0:{}',0,'Edit Contraindications Configuration Form','',0,'/sites/all/modules/raptor_contraindications/form//EditContraIndicationsConfigPage.php'),('admin/config/raptor_datalayer','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_datalayer_edit_config_form','a:0:{}','',7,3,0,'','admin/config/raptor_datalayer','Edit Datalayer Configuration','t','','','a:0:{}',0,'Edit Datalayer Configuration Form','',0,'/sites/all/modules/raptor_datalayer/form//EditDatalayerConfigPage.php'),('admin/config/raptor_glue','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_edit_config_form','a:0:{}','',7,3,0,'','admin/config/raptor_glue','Edit Glue Configuration','t','','','a:0:{}',0,'Edit Glue Configuration Form','',0,'/sites/all/modules/raptor_glue/form//EditGlueConfigPage.php'),('admin/config/raptor_protocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_protocollib_edit_config_form','a:0:{}','',7,3,0,'','admin/config/raptor_protocollib','Edit Protocol Library Configuration','t','','','a:0:{}',0,'Edit Protocol Library Configuration Form','',0,'/sites/all/modules/raptor_protocollib/form//EditProtocolLibraryConfigPage.php'),('admin/config/regional','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/regional','Regional and language','t','','','a:0:{}',6,'Regional settings, localization and translation.','left',-5,'modules/system/system.admin.inc'),('admin/config/regional/date-time','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:25:\"system_date_time_settings\";}','',15,4,0,'','admin/config/regional/date-time','Date and time','t','','','a:0:{}',6,'Configure display formats for date and time.','',-15,'modules/system/system.admin.inc'),('admin/config/regional/date-time/formats','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','system_date_time_formats','a:0:{}','',31,5,1,'admin/config/regional/date-time','admin/config/regional/date-time','Formats','t','','','a:0:{}',132,'Configure display format strings for date and time.','',-9,'modules/system/system.admin.inc'),('admin/config/regional/date-time/formats/%/delete','a:1:{i:5;N;}','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:2:{i:0;s:30:\"system_date_delete_format_form\";i:1;i:5;}','',125,7,0,'','admin/config/regional/date-time/formats/%/delete','Delete date format','t','','','a:0:{}',6,'Allow users to delete a configured date format.','',0,'modules/system/system.admin.inc'),('admin/config/regional/date-time/formats/%/edit','a:1:{i:5;N;}','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:2:{i:0;s:34:\"system_configure_date_formats_form\";i:1;i:5;}','',125,7,0,'','admin/config/regional/date-time/formats/%/edit','Edit date format','t','','','a:0:{}',6,'Allow users to edit a configured date format.','',0,'modules/system/system.admin.inc'),('admin/config/regional/date-time/formats/add','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:34:\"system_configure_date_formats_form\";}','',63,6,1,'admin/config/regional/date-time/formats','admin/config/regional/date-time','Add format','t','','','a:0:{}',388,'Allow users to add additional date formats.','',-10,'modules/system/system.admin.inc'),('admin/config/regional/date-time/formats/lookup','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','system_date_time_lookup','a:0:{}','',63,6,0,'','admin/config/regional/date-time/formats/lookup','Date and time lookup','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/config/regional/date-time/types','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:25:\"system_date_time_settings\";}','',31,5,1,'admin/config/regional/date-time','admin/config/regional/date-time','Types','t','','','a:0:{}',140,'Configure display formats for date and time.','',-10,'modules/system/system.admin.inc'),('admin/config/regional/date-time/types/%/delete','a:1:{i:5;N;}','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:2:{i:0;s:35:\"system_delete_date_format_type_form\";i:1;i:5;}','',125,7,0,'','admin/config/regional/date-time/types/%/delete','Delete date type','t','','','a:0:{}',6,'Allow users to delete a configured date type.','',0,'modules/system/system.admin.inc'),('admin/config/regional/date-time/types/add','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:32:\"system_add_date_format_type_form\";}','',63,6,1,'admin/config/regional/date-time/types','admin/config/regional/date-time','Add date type','t','','','a:0:{}',388,'Add new date type.','',-10,'modules/system/system.admin.inc'),('admin/config/regional/settings','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:24:\"system_regional_settings\";}','',15,4,0,'','admin/config/regional/settings','Regional settings','t','','','a:0:{}',6,'Settings for the site\'s default time zone and country.','',-20,'modules/system/system.admin.inc'),('admin/config/search','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/search','Search and metadata','t','','','a:0:{}',6,'Local site search, metadata and SEO.','left',-10,'modules/system/system.admin.inc'),('admin/config/search/clean-urls','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:25:\"system_clean_url_settings\";}','',15,4,0,'','admin/config/search/clean-urls','Clean URLs','t','','','a:0:{}',6,'Enable or disable clean URLs for your site.','',5,'modules/system/system.admin.inc'),('admin/config/search/clean-urls/check','','','1','a:0:{}','drupal_json_output','a:1:{i:0;a:1:{s:6:\"status\";b:1;}}','',31,5,0,'','admin/config/search/clean-urls/check','Clean URL check','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/config/search/path','','','user_access','a:1:{i:0;s:22:\"administer url aliases\";}','path_admin_overview','a:0:{}','',15,4,0,'','admin/config/search/path','URL aliases','t','','','a:0:{}',6,'Change your site\'s URL paths by aliasing them.','',-5,'modules/path/path.admin.inc'),('admin/config/search/path/add','','','user_access','a:1:{i:0;s:22:\"administer url aliases\";}','path_admin_edit','a:0:{}','',31,5,1,'admin/config/search/path','admin/config/search/path','Add alias','t','','','a:0:{}',388,'','',0,'modules/path/path.admin.inc'),('admin/config/search/path/delete/%','a:1:{i:5;s:9:\"path_load\";}','','user_access','a:1:{i:0;s:22:\"administer url aliases\";}','drupal_get_form','a:2:{i:0;s:25:\"path_admin_delete_confirm\";i:1;i:5;}','',62,6,0,'','admin/config/search/path/delete/%','Delete alias','t','','','a:0:{}',6,'','',0,'modules/path/path.admin.inc'),('admin/config/search/path/edit/%','a:1:{i:5;s:9:\"path_load\";}','','user_access','a:1:{i:0;s:22:\"administer url aliases\";}','path_admin_edit','a:1:{i:0;i:5;}','',62,6,0,'','admin/config/search/path/edit/%','Edit alias','t','','','a:0:{}',6,'','',0,'modules/path/path.admin.inc'),('admin/config/search/path/list','','','user_access','a:1:{i:0;s:22:\"administer url aliases\";}','path_admin_overview','a:0:{}','',31,5,1,'admin/config/search/path','admin/config/search/path','List','t','','','a:0:{}',140,'','',-10,'modules/path/path.admin.inc'),('admin/config/search/settings','','','user_access','a:1:{i:0;s:17:\"administer search\";}','drupal_get_form','a:1:{i:0;s:21:\"search_admin_settings\";}','',15,4,0,'','admin/config/search/settings','Search settings','t','','','a:0:{}',6,'Configure relevance settings for search and other indexing options.','',-10,'modules/search/search.admin.inc'),('admin/config/search/settings/reindex','','','user_access','a:1:{i:0;s:17:\"administer search\";}','drupal_get_form','a:1:{i:0;s:22:\"search_reindex_confirm\";}','',31,5,0,'','admin/config/search/settings/reindex','Clear index','t','','','a:0:{}',4,'','',0,'modules/search/search.admin.inc'),('admin/config/services','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/services','Web services','t','','','a:0:{}',6,'Tools related to web services.','right',0,'modules/system/system.admin.inc'),('admin/config/services/rss-publishing','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:25:\"system_rss_feeds_settings\";}','',15,4,0,'','admin/config/services/rss-publishing','RSS publishing','t','','','a:0:{}',6,'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.','',0,'modules/system/system.admin.inc'),('admin/config/system','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/system','System','t','','','a:0:{}',6,'General system related configuration.','right',-20,'modules/system/system.admin.inc'),('admin/config/system/actions','','','user_access','a:1:{i:0;s:18:\"administer actions\";}','system_actions_manage','a:0:{}','',15,4,0,'','admin/config/system/actions','Actions','t','','','a:0:{}',6,'Manage the actions defined for your site.','',0,'modules/system/system.admin.inc'),('admin/config/system/actions/configure','','','user_access','a:1:{i:0;s:18:\"administer actions\";}','drupal_get_form','a:1:{i:0;s:24:\"system_actions_configure\";}','',31,5,0,'','admin/config/system/actions/configure','Configure an advanced action','t','','','a:0:{}',4,'','',0,'modules/system/system.admin.inc'),('admin/config/system/actions/delete/%','a:1:{i:5;s:12:\"actions_load\";}','','user_access','a:1:{i:0;s:18:\"administer actions\";}','drupal_get_form','a:2:{i:0;s:26:\"system_actions_delete_form\";i:1;i:5;}','',62,6,0,'','admin/config/system/actions/delete/%','Delete action','t','','','a:0:{}',6,'Delete an action.','',0,'modules/system/system.admin.inc'),('admin/config/system/actions/manage','','','user_access','a:1:{i:0;s:18:\"administer actions\";}','system_actions_manage','a:0:{}','',31,5,1,'admin/config/system/actions','admin/config/system/actions','Manage actions','t','','','a:0:{}',140,'Manage the actions defined for your site.','',-2,'modules/system/system.admin.inc'),('admin/config/system/actions/orphan','','','user_access','a:1:{i:0;s:18:\"administer actions\";}','system_actions_remove_orphans','a:0:{}','',31,5,0,'','admin/config/system/actions/orphan','Remove orphans','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/config/system/cron','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:20:\"system_cron_settings\";}','',15,4,0,'','admin/config/system/cron','Cron','t','','','a:0:{}',6,'Manage automatic site maintenance tasks.','',20,'modules/system/system.admin.inc'),('admin/config/system/site-information','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','drupal_get_form','a:1:{i:0;s:32:\"system_site_information_settings\";}','',15,4,0,'','admin/config/system/site-information','Site information','t','','','a:0:{}',6,'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.','',-20,'modules/system/system.admin.inc'),('admin/config/user-interface','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/user-interface','User interface','t','','','a:0:{}',6,'Tools that enhance the user interface.','right',-15,'modules/system/system.admin.inc'),('admin/config/user-interface/shortcut','','','user_access','a:1:{i:0;s:20:\"administer shortcuts\";}','shortcut_set_admin','a:0:{}','',15,4,0,'','admin/config/user-interface/shortcut','Shortcuts','t','','','a:0:{}',6,'Add and modify shortcut sets.','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_edit_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:22:\"shortcut_set_customize\";i:1;i:4;}','',30,5,0,'','admin/config/user-interface/shortcut/%','Edit shortcuts','shortcut_set_title_callback','a:1:{i:0;i:4;}','','a:0:{}',6,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%/add-link','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_edit_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:17:\"shortcut_link_add\";i:1;i:4;}','',61,6,1,'admin/config/user-interface/shortcut/%','admin/config/user-interface/shortcut/%','Add shortcut','t','','','a:0:{}',388,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%/add-link-inline','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_edit_access','a:1:{i:0;i:4;}','shortcut_link_add_inline','a:1:{i:0;i:4;}','',61,6,0,'','admin/config/user-interface/shortcut/%/add-link-inline','Add shortcut','t','','','a:0:{}',0,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%/delete','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_delete_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:24:\"shortcut_set_delete_form\";i:1;i:4;}','',61,6,0,'','admin/config/user-interface/shortcut/%/delete','Delete shortcut set','t','','','a:0:{}',6,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%/edit','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_edit_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:22:\"shortcut_set_edit_form\";i:1;i:4;}','',61,6,1,'admin/config/user-interface/shortcut/%','admin/config/user-interface/shortcut/%','Edit set name','t','','','a:0:{}',132,'','',10,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/%/links','a:1:{i:4;s:17:\"shortcut_set_load\";}','','shortcut_set_edit_access','a:1:{i:0;i:4;}','drupal_get_form','a:2:{i:0;s:22:\"shortcut_set_customize\";i:1;i:4;}','',61,6,1,'admin/config/user-interface/shortcut/%','admin/config/user-interface/shortcut/%','List links','t','','','a:0:{}',140,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/add-set','','','user_access','a:1:{i:0;s:20:\"administer shortcuts\";}','drupal_get_form','a:1:{i:0;s:21:\"shortcut_set_add_form\";}','',31,5,1,'admin/config/user-interface/shortcut','admin/config/user-interface/shortcut','Add shortcut set','t','','','a:0:{}',388,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/link/%','a:1:{i:5;s:14:\"menu_link_load\";}','','shortcut_link_access','a:1:{i:0;i:5;}','drupal_get_form','a:2:{i:0;s:18:\"shortcut_link_edit\";i:1;i:5;}','',62,6,0,'','admin/config/user-interface/shortcut/link/%','Edit shortcut','t','','','a:0:{}',6,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/user-interface/shortcut/link/%/delete','a:1:{i:5;s:14:\"menu_link_load\";}','','shortcut_link_access','a:1:{i:0;i:5;}','drupal_get_form','a:2:{i:0;s:20:\"shortcut_link_delete\";i:1;i:5;}','',125,7,0,'','admin/config/user-interface/shortcut/link/%/delete','Delete shortcut','t','','','a:0:{}',6,'','',0,'modules/shortcut/shortcut.admin.inc'),('admin/config/workflow','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',7,3,0,'','admin/config/workflow','Workflow','t','','','a:0:{}',6,'Content workflow, editorial workflow tools.','right',5,'modules/system/system.admin.inc'),('admin/content','','','user_access','a:1:{i:0;s:23:\"access content overview\";}','drupal_get_form','a:1:{i:0;s:18:\"node_admin_content\";}','',3,2,0,'','admin/content','Content','t','','','a:0:{}',6,'Administer content and comments.','',-10,'modules/node/node.admin.inc'),('admin/content/comment','','','user_access','a:1:{i:0;s:19:\"administer comments\";}','comment_admin','a:0:{}','',7,3,1,'admin/content','admin/content','Comments','t','','','a:0:{}',134,'List and edit site comments and the comment approval queue.','',0,'modules/comment/comment.admin.inc'),('admin/content/comment/approval','','','user_access','a:1:{i:0;s:19:\"administer comments\";}','comment_admin','a:1:{i:0;s:8:\"approval\";}','',15,4,1,'admin/content/comment','admin/content','Unapproved comments','comment_count_unpublished','','','a:0:{}',132,'','',0,'modules/comment/comment.admin.inc'),('admin/content/comment/new','','','user_access','a:1:{i:0;s:19:\"administer comments\";}','comment_admin','a:0:{}','',15,4,1,'admin/content/comment','admin/content','Published comments','t','','','a:0:{}',140,'','',-10,'modules/comment/comment.admin.inc'),('admin/content/node','','','user_access','a:1:{i:0;s:23:\"access content overview\";}','drupal_get_form','a:1:{i:0;s:18:\"node_admin_content\";}','',7,3,1,'admin/content','admin/content','Content','t','','','a:0:{}',140,'','',-10,'modules/node/node.admin.inc'),('admin/dashboard','','','user_access','a:1:{i:0;s:16:\"access dashboard\";}','dashboard_admin','a:0:{}','',3,2,0,'','admin/dashboard','Dashboard','t','','','a:0:{}',6,'View and customize your dashboard.','',-15,''),('admin/dashboard/block-content/%/%','a:2:{i:3;N;i:4;N;}','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','dashboard_show_block_content','a:2:{i:0;i:3;i:1;i:4;}','',28,5,0,'','admin/dashboard/block-content/%/%','','t','','','a:0:{}',0,'','',0,''),('admin/dashboard/configure','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','dashboard_admin_blocks','a:0:{}','',7,3,0,'','admin/dashboard/configure','Configure available dashboard blocks','t','','','a:0:{}',4,'Configure which blocks can be shown on the dashboard.','',0,''),('admin/dashboard/customize','','','user_access','a:1:{i:0;s:16:\"access dashboard\";}','dashboard_admin','a:1:{i:0;b:1;}','',7,3,0,'','admin/dashboard/customize','Customize dashboard','t','','','a:0:{}',4,'Customize your dashboard.','',0,''),('admin/dashboard/drawer','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','dashboard_show_disabled','a:0:{}','',7,3,0,'','admin/dashboard/drawer','','t','','','a:0:{}',0,'','',0,''),('admin/dashboard/update','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','dashboard_update','a:0:{}','',7,3,0,'','admin/dashboard/update','','t','','','a:0:{}',0,'','',0,''),('admin/help','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_main','a:0:{}','',3,2,0,'','admin/help','Help','t','','','a:0:{}',6,'Reference for usage, configuration, and modules.','',9,'modules/help/help.admin.inc'),('admin/help/block','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/block','block','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/color','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/color','color','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/comment','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/comment','comment','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/contextual','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/contextual','contextual','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/dashboard','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/dashboard','dashboard','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/dblog','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/dblog','dblog','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/field','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/field','field','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/field_sql_storage','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/field_sql_storage','field_sql_storage','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/field_ui','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/field_ui','field_ui','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/file','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/file','file','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/filter','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/filter','filter','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/help','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/help','help','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/image','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/image','image','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/list','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/list','list','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/menu','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/menu','menu','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/node','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/node','node','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/number','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/number','number','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/options','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/options','options','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/path','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/path','path','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_contraindications','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_contraindications','raptor_contraindications','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_datalayer','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_datalayer','raptor_datalayer','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_ewdvista','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_ewdvista','raptor_ewdvista','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_floatingdialog','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_floatingdialog','raptor_floatingdialog','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_formulas','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_formulas','raptor_formulas','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_glue','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_glue','raptor_glue','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_graph','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_graph','raptor_graph','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_imageviewing','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_imageviewing','raptor_imageviewing','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_mdwsvista','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_mdwsvista','raptor_mdwsvista','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_protocollib','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_protocollib','raptor_protocollib','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_reports','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_reports','raptor_reports','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_scheduling','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_scheduling','raptor_scheduling','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/raptor_workflow','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/raptor_workflow','raptor_workflow','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/rdf','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/rdf','rdf','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/search','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/search','search','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/shortcut','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/shortcut','shortcut','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/simplerulesengine_core','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/simplerulesengine_core','simplerulesengine_core','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/simplerulesengine_demo','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/simplerulesengine_demo','simplerulesengine_demo','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/simplerulesengine_ui','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/simplerulesengine_ui','simplerulesengine_ui','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/system','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/system','system','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/taxonomy','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/taxonomy','taxonomy','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/text','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/text','text','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/toolbar','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/toolbar','toolbar','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/help/user','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','help_page','a:1:{i:0;i:2;}','',7,3,0,'','admin/help/user','user','t','','','a:0:{}',4,'','',0,'modules/help/help.admin.inc'),('admin/index','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_index','a:0:{}','',3,2,1,'admin','admin','Index','t','','','a:0:{}',132,'','',-18,'modules/system/system.admin.inc'),('admin/modules','','','user_access','a:1:{i:0;s:18:\"administer modules\";}','drupal_get_form','a:1:{i:0;s:14:\"system_modules\";}','',3,2,0,'','admin/modules','Modules','t','','','a:0:{}',6,'Extend site functionality.','',-2,'modules/system/system.admin.inc'),('admin/modules/list','','','user_access','a:1:{i:0;s:18:\"administer modules\";}','drupal_get_form','a:1:{i:0;s:14:\"system_modules\";}','',7,3,1,'admin/modules','admin/modules','List','t','','','a:0:{}',140,'','',0,'modules/system/system.admin.inc'),('admin/modules/list/confirm','','','user_access','a:1:{i:0;s:18:\"administer modules\";}','drupal_get_form','a:1:{i:0;s:14:\"system_modules\";}','',15,4,0,'','admin/modules/list/confirm','List','t','','','a:0:{}',4,'','',0,'modules/system/system.admin.inc'),('admin/modules/uninstall','','','user_access','a:1:{i:0;s:18:\"administer modules\";}','drupal_get_form','a:1:{i:0;s:24:\"system_modules_uninstall\";}','',7,3,1,'admin/modules','admin/modules','Uninstall','t','','','a:0:{}',132,'','',20,'modules/system/system.admin.inc'),('admin/modules/uninstall/confirm','','','user_access','a:1:{i:0;s:18:\"administer modules\";}','drupal_get_form','a:1:{i:0;s:24:\"system_modules_uninstall\";}','',15,4,0,'','admin/modules/uninstall/confirm','Uninstall','t','','','a:0:{}',4,'','',0,'modules/system/system.admin.inc'),('admin/people','','','user_access','a:1:{i:0;s:16:\"administer users\";}','user_admin','a:1:{i:0;s:4:\"list\";}','',3,2,0,'','admin/people','People','t','','','a:0:{}',6,'Manage user accounts, roles, and permissions.','left',-4,'modules/user/user.admin.inc'),('admin/people/create','','','user_access','a:1:{i:0;s:16:\"administer users\";}','user_admin','a:1:{i:0;s:6:\"create\";}','',7,3,1,'admin/people','admin/people','Add user','t','','','a:0:{}',388,'','',0,'modules/user/user.admin.inc'),('admin/people/people','','','user_access','a:1:{i:0;s:16:\"administer users\";}','user_admin','a:1:{i:0;s:4:\"list\";}','',7,3,1,'admin/people','admin/people','List','t','','','a:0:{}',140,'Find and manage people interacting with your site.','',-10,'modules/user/user.admin.inc'),('admin/people/permissions','','','user_access','a:1:{i:0;s:22:\"administer permissions\";}','drupal_get_form','a:1:{i:0;s:22:\"user_admin_permissions\";}','',7,3,1,'admin/people','admin/people','Permissions','t','','','a:0:{}',132,'Determine access to features by selecting permissions for roles.','',0,'modules/user/user.admin.inc'),('admin/people/permissions/list','','','user_access','a:1:{i:0;s:22:\"administer permissions\";}','drupal_get_form','a:1:{i:0;s:22:\"user_admin_permissions\";}','',15,4,1,'admin/people/permissions','admin/people','Permissions','t','','','a:0:{}',140,'Determine access to features by selecting permissions for roles.','',-8,'modules/user/user.admin.inc'),('admin/people/permissions/roles','','','user_access','a:1:{i:0;s:22:\"administer permissions\";}','drupal_get_form','a:1:{i:0;s:16:\"user_admin_roles\";}','',15,4,1,'admin/people/permissions','admin/people','Roles','t','','','a:0:{}',132,'List, edit, or add user roles.','',-5,'modules/user/user.admin.inc'),('admin/people/permissions/roles/delete/%','a:1:{i:5;s:14:\"user_role_load\";}','','user_role_edit_access','a:1:{i:0;i:5;}','drupal_get_form','a:2:{i:0;s:30:\"user_admin_role_delete_confirm\";i:1;i:5;}','',62,6,0,'','admin/people/permissions/roles/delete/%','Delete role','t','','','a:0:{}',6,'','',0,'modules/user/user.admin.inc'),('admin/people/permissions/roles/edit/%','a:1:{i:5;s:14:\"user_role_load\";}','','user_role_edit_access','a:1:{i:0;i:5;}','drupal_get_form','a:2:{i:0;s:15:\"user_admin_role\";i:1;i:5;}','',62,6,0,'','admin/people/permissions/roles/edit/%','Edit role','t','','','a:0:{}',6,'','',0,'modules/user/user.admin.inc'),('admin/reports','','','user_access','a:1:{i:0;s:19:\"access site reports\";}','system_admin_menu_block_page','a:0:{}','',3,2,0,'','admin/reports','Reports','t','','','a:0:{}',6,'View reports, updates, and errors.','left',5,'modules/system/system.admin.inc'),('admin/reports/access-denied','','','user_access','a:1:{i:0;s:19:\"access site reports\";}','dblog_top','a:1:{i:0;s:13:\"access denied\";}','',7,3,0,'','admin/reports/access-denied','Top \'access denied\' errors','t','','','a:0:{}',6,'View \'access denied\' errors (403s).','',0,'modules/dblog/dblog.admin.inc'),('admin/reports/dblog','','','user_access','a:1:{i:0;s:19:\"access site reports\";}','dblog_overview','a:0:{}','',7,3,0,'','admin/reports/dblog','Recent log messages','t','','','a:0:{}',6,'View events that have recently been logged.','',-1,'modules/dblog/dblog.admin.inc'),('admin/reports/event/%','a:1:{i:3;N;}','','user_access','a:1:{i:0;s:19:\"access site reports\";}','dblog_event','a:1:{i:0;i:3;}','',14,4,0,'','admin/reports/event/%','Details','t','','','a:0:{}',6,'','',0,'modules/dblog/dblog.admin.inc'),('admin/reports/fields','','','user_access','a:1:{i:0;s:24:\"administer content types\";}','field_ui_fields_list','a:0:{}','',7,3,0,'','admin/reports/fields','Field list','t','','','a:0:{}',6,'Overview of fields on all entity types.','',0,'modules/field_ui/field_ui.admin.inc'),('admin/reports/page-not-found','','','user_access','a:1:{i:0;s:19:\"access site reports\";}','dblog_top','a:1:{i:0;s:14:\"page not found\";}','',7,3,0,'','admin/reports/page-not-found','Top \'page not found\' errors','t','','','a:0:{}',6,'View \'page not found\' errors (404s).','',0,'modules/dblog/dblog.admin.inc'),('admin/reports/search','','','user_access','a:1:{i:0;s:19:\"access site reports\";}','dblog_top','a:1:{i:0;s:6:\"search\";}','',7,3,0,'','admin/reports/search','Top search phrases','t','','','a:0:{}',6,'View most popular search phrases.','',0,'modules/dblog/dblog.admin.inc'),('admin/reports/status','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','system_status','a:0:{}','',7,3,0,'','admin/reports/status','Status report','t','','','a:0:{}',6,'Get a status report about your site\'s operation and any detected problems.','',-60,'modules/system/system.admin.inc'),('admin/reports/status/php','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','system_php','a:0:{}','',15,4,0,'','admin/reports/status/php','PHP','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/reports/status/rebuild','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','drupal_get_form','a:1:{i:0;s:30:\"node_configure_rebuild_confirm\";}','',15,4,0,'','admin/reports/status/rebuild','Rebuild permissions','t','','','a:0:{}',0,'','',0,'modules/node/node.admin.inc'),('admin/reports/status/run-cron','','','user_access','a:1:{i:0;s:29:\"administer site configuration\";}','system_run_cron','a:0:{}','',15,4,0,'','admin/reports/status/run-cron','Run cron','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('admin/structure','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',3,2,0,'','admin/structure','Structure','t','','','a:0:{}',6,'Administer blocks, content types, menus, etc.','right',-8,'modules/system/system.admin.inc'),('admin/structure/block','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','block_admin_display','a:1:{i:0;s:12:\"raptor_omega\";}','',7,3,0,'','admin/structure/block','Blocks','t','','','a:0:{}',6,'Configure what block content appears in your site\'s sidebars and other regions.','',0,'modules/block/block.admin.inc'),('admin/structure/block/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',15,4,1,'admin/structure/block','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/bartik','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:25:\"themes/bartik/bartik.info\";s:4:\"name\";s:6:\"bartik\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:6:\"Bartik\";s:11:\"description\";s:48:\"A flexible, recolorable theme with many regions.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:7:\"regions\";a:20:{s:6:\"header\";s:6:\"Header\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:11:\"highlighted\";s:11:\"Highlighted\";s:8:\"featured\";s:8:\"Featured\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"Sidebar first\";s:14:\"sidebar_second\";s:14:\"Sidebar second\";s:14:\"triptych_first\";s:14:\"Triptych first\";s:15:\"triptych_middle\";s:15:\"Triptych middle\";s:13:\"triptych_last\";s:13:\"Triptych last\";s:18:\"footer_firstcolumn\";s:19:\"Footer first column\";s:19:\"footer_secondcolumn\";s:20:\"Footer second column\";s:18:\"footer_thirdcolumn\";s:19:\"Footer third column\";s:19:\"footer_fourthcolumn\";s:20:\"Footer fourth column\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"0\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:28:\"themes/bartik/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418441;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_demo','a:1:{i:0;s:6:\"bartik\";}','',31,5,0,'','admin/structure/block/demo/bartik','Bartik','t','','_block_custom_theme','a:1:{i:0;s:6:\"bartik\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/garland','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:27:\"themes/garland/garland.info\";s:4:\"name\";s:7:\"garland\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:7:\"Garland\";s:11:\"description\";s:111:\"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:8:\"settings\";a:1:{s:13:\"garland_width\";s:5:\"fluid\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:29:\"themes/garland/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418436;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_demo','a:1:{i:0;s:7:\"garland\";}','',31,5,0,'','admin/structure/block/demo/garland','Garland','t','','_block_custom_theme','a:1:{i:0;s:7:\"garland\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/ohm','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":14:{s:8:\"filename\";s:35:\"sites/all/themes/omega/ohm/ohm.info\";s:4:\"name\";s:3:\"ohm\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:20:{s:4:\"name\";s:3:\"Ohm\";s:11:\"description\";s:189:\"Omega based demonstration theme. Serves as a best-practice reference for the Omega documentation. Ohm will be constantly updated as best practice evolves so shouldn\'t be used in production.\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:41:\"sites/all/themes/omega/ohm/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:7:\"regions\";a:13:{s:8:\"branding\";s:8:\"Branding\";s:10:\"navigation\";s:14:\"Navigation bar\";s:6:\"header\";s:6:\"Header\";s:4:\"hero\";s:4:\"Hero\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:6:\"layout\";a:1:{s:4:\"hero\";a:1:{s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:36:\"css/layouts/hero/ohm-hero.layout.css\";}}}}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"1\";s:27:\"toggle_comment_user_picture\";s:1:\"1\";s:32:\"toggle_comment_user_verification\";s:1:\"1\";s:14:\"toggle_favicon\";s:1:\"1\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"1\";s:31:\"omega_toggle_front_page_content\";s:1:\"1\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:5:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"0\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"0\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"0\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}s:8:\"messages\";a:1:{s:6:\"status\";s:1:\"1\";}}s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:8:\"ohm-hero\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"1\";s:23:\"omega_livereload_script\";s:36:\"http://localhost:35729/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"1\";s:23:\"omega_demo_regions_list\";a:9:{s:10:\"navigation\";s:10:\"navigation\";s:6:\"header\";s:6:\"header\";s:4:\"hero\";s:4:\"hero\";s:11:\"highlighted\";s:11:\"highlighted\";s:4:\"help\";s:4:\"help\";s:7:\"content\";s:7:\"content\";s:13:\"sidebar_first\";s:13:\"sidebar_first\";s:14:\"sidebar_second\";s:14:\"sidebar_second\";s:6:\"footer\";s:6:\"footer\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862216;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','block_admin_demo','a:1:{i:0;s:3:\"ohm\";}','',31,5,0,'','admin/structure/block/demo/ohm','Ohm','t','','_block_custom_theme','a:1:{i:0;s:3:\"ohm\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/omega','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:39:\"sites/all/themes/omega/omega/omega.info\";s:4:\"name\";s:5:\"omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Omega\";s:11:\"description\";s:432:\"A powerful HTML5 base theme framework utilizing tools like <a href=\"http://sass-lang.com/\" title=\"Sass\">Sass</a>, <a href=\"http://compass-style.org/\" title=\"Compass\">Compass</a>, <a href=\"http://gruntjs.com/\" title=\"Grunt\">Grunt</a>, <a href=\"http://bower.io/\" title=\"Bower\">Bower</a>, <a href=\"http://rvm.io/\" title=\"Ruby Version Manager\">Ruby Version Manager</a>, <a href=\"http://bundler.io/\" title=\"Bundler\">Bundler</a> and more.\";s:10:\"screenshot\";s:43:\"sites/all/themes/omega/omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:7:\"regions\";a:12:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First Sidebar\";s:14:\"sidebar_second\";s:14:\"Second Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:7:\"plugins\";a:1:{s:6:\"panels\";a:2:{s:7:\"layouts\";s:14:\"panels/layouts\";s:6:\"styles\";s:13:\"panels/styles\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:11:\"stylesheets\";a:0:{}s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862218;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:10:\"sub_themes\";a:2:{s:3:\"ohm\";s:3:\"Ohm\";s:12:\"raptor_omega\";s:12:\"RAPTOR Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_demo','a:1:{i:0;s:5:\"omega\";}','',31,5,0,'','admin/structure/block/demo/omega','Omega','t','','_block_custom_theme','a:1:{i:0;s:5:\"omega\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/raptor_omega','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":15:{s:8:\"filename\";s:47:\"sites/all/themes/raptor_omega/raptor_omega.info\";s:4:\"name\";s:12:\"raptor_omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:12:\"RAPTOR Omega\";s:11:\"description\";s:32:\"Theme for the RAPTOR application\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:44:\"sites/all/themes/raptor_omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"0\";s:27:\"toggle_comment_user_picture\";s:1:\"0\";s:32:\"toggle_comment_user_verification\";s:1:\"0\";s:14:\"toggle_favicon\";s:1:\"0\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"0\";s:31:\"omega_toggle_front_page_content\";s:1:\"0\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:20:\"omega_enable_warning\";s:1:\"1\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:5:\"admin\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"0\";s:23:\"omega_livereload_script\";s:16:\"js/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"0\";s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:4:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"1\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"1\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"1\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}}}s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:5:\"mtime\";i:1440241381;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','block_admin_demo','a:1:{i:0;s:12:\"raptor_omega\";}','',31,5,0,'','admin/structure/block/demo/raptor_omega','RAPTOR Omega','t','','_block_custom_theme','a:1:{i:0;s:12:\"raptor_omega\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/seven','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/seven/seven.info\";s:4:\"name\";s:5:\"seven\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:5:\"Seven\";s:11:\"description\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"1\";}s:7:\"regions\";a:8:{s:7:\"content\";s:7:\"Content\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/seven/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418439;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_demo','a:1:{i:0;s:5:\"seven\";}','',31,5,0,'','admin/structure/block/demo/seven','Seven','t','','_block_custom_theme','a:1:{i:0;s:5:\"seven\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/demo/stark','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal\'s default HTML markup and CSS styles. To learn how to build your own theme and override Drupal\'s default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418435;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_demo','a:1:{i:0;s:5:\"stark\";}','',31,5,0,'','admin/structure/block/demo/stark','Stark','t','','_block_custom_theme','a:1:{i:0;s:5:\"stark\";}',0,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/bartik','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:25:\"themes/bartik/bartik.info\";s:4:\"name\";s:6:\"bartik\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:6:\"Bartik\";s:11:\"description\";s:48:\"A flexible, recolorable theme with many regions.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:7:\"regions\";a:20:{s:6:\"header\";s:6:\"Header\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:11:\"highlighted\";s:11:\"Highlighted\";s:8:\"featured\";s:8:\"Featured\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"Sidebar first\";s:14:\"sidebar_second\";s:14:\"Sidebar second\";s:14:\"triptych_first\";s:14:\"Triptych first\";s:15:\"triptych_middle\";s:15:\"Triptych middle\";s:13:\"triptych_last\";s:13:\"Triptych last\";s:18:\"footer_firstcolumn\";s:19:\"Footer first column\";s:19:\"footer_secondcolumn\";s:20:\"Footer second column\";s:18:\"footer_thirdcolumn\";s:19:\"Footer third column\";s:19:\"footer_fourthcolumn\";s:20:\"Footer fourth column\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"0\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:28:\"themes/bartik/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418441;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:3:{s:14:\"css/layout.css\";s:28:\"themes/bartik/css/layout.css\";s:13:\"css/style.css\";s:27:\"themes/bartik/css/style.css\";s:14:\"css/colors.css\";s:28:\"themes/bartik/css/colors.css\";}s:5:\"print\";a:1:{s:13:\"css/print.css\";s:27:\"themes/bartik/css/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_display','a:1:{i:0;s:6:\"bartik\";}','',31,5,1,'admin/structure/block','admin/structure/block','Bartik','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/bartik/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/bartik','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/garland','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:27:\"themes/garland/garland.info\";s:4:\"name\";s:7:\"garland\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:7:\"Garland\";s:11:\"description\";s:111:\"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:8:\"settings\";a:1:{s:13:\"garland_width\";s:5:\"fluid\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:29:\"themes/garland/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418436;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:2:{s:3:\"all\";a:1:{s:9:\"style.css\";s:24:\"themes/garland/style.css\";}s:5:\"print\";a:1:{s:9:\"print.css\";s:24:\"themes/garland/print.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_display','a:1:{i:0;s:7:\"garland\";}','',31,5,1,'admin/structure/block','admin/structure/block','Garland','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/garland/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/garland','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/ohm','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":14:{s:8:\"filename\";s:35:\"sites/all/themes/omega/ohm/ohm.info\";s:4:\"name\";s:3:\"ohm\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:20:{s:4:\"name\";s:3:\"Ohm\";s:11:\"description\";s:189:\"Omega based demonstration theme. Serves as a best-practice reference for the Omega documentation. Ohm will be constantly updated as best practice evolves so shouldn\'t be used in production.\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:41:\"sites/all/themes/omega/ohm/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:7:\"regions\";a:13:{s:8:\"branding\";s:8:\"Branding\";s:10:\"navigation\";s:14:\"Navigation bar\";s:6:\"header\";s:6:\"Header\";s:4:\"hero\";s:4:\"Hero\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"sidebar_second\";s:14:\"Second sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:6:\"layout\";a:1:{s:4:\"hero\";a:1:{s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{i:0;s:36:\"css/layouts/hero/ohm-hero.layout.css\";}}}}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"1\";s:27:\"toggle_comment_user_picture\";s:1:\"1\";s:32:\"toggle_comment_user_verification\";s:1:\"1\";s:14:\"toggle_favicon\";s:1:\"1\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"1\";s:31:\"omega_toggle_front_page_content\";s:1:\"1\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:5:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"0\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"0\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"0\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}s:8:\"messages\";a:1:{s:6:\"status\";s:1:\"1\";}}s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:8:\"ohm-hero\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"1\";s:23:\"omega_livereload_script\";s:36:\"http://localhost:35729/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"1\";s:23:\"omega_demo_regions_list\";a:9:{s:10:\"navigation\";s:10:\"navigation\";s:6:\"header\";s:6:\"header\";s:4:\"hero\";s:4:\"hero\";s:11:\"highlighted\";s:11:\"highlighted\";s:4:\"help\";s:4:\"help\";s:7:\"content\";s:7:\"content\";s:13:\"sidebar_first\";s:13:\"sidebar_first\";s:14:\"sidebar_second\";s:14:\"sidebar_second\";s:6:\"footer\";s:6:\"footer\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862216;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:4:{s:21:\"css/ohm.normalize.css\";s:48:\"sites/all/themes/omega/ohm/css/ohm.normalize.css\";s:17:\"css/ohm.hacks.css\";s:44:\"sites/all/themes/omega/ohm/css/ohm.hacks.css\";s:18:\"css/ohm.styles.css\";s:45:\"sites/all/themes/omega/ohm/css/ohm.styles.css\";s:20:\"css/ohm.no-query.css\";s:47:\"sites/all/themes/omega/ohm/css/ohm.no-query.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','block_admin_display','a:1:{i:0;s:3:\"ohm\";}','',31,5,1,'admin/structure/block','admin/structure/block','Ohm','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/ohm/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/ohm','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/omega','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:39:\"sites/all/themes/omega/omega/omega.info\";s:4:\"name\";s:5:\"omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Omega\";s:11:\"description\";s:432:\"A powerful HTML5 base theme framework utilizing tools like <a href=\"http://sass-lang.com/\" title=\"Sass\">Sass</a>, <a href=\"http://compass-style.org/\" title=\"Compass\">Compass</a>, <a href=\"http://gruntjs.com/\" title=\"Grunt\">Grunt</a>, <a href=\"http://bower.io/\" title=\"Bower\">Bower</a>, <a href=\"http://rvm.io/\" title=\"Ruby Version Manager\">Ruby Version Manager</a>, <a href=\"http://bundler.io/\" title=\"Bundler\">Bundler</a> and more.\";s:10:\"screenshot\";s:43:\"sites/all/themes/omega/omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:7:\"regions\";a:12:{s:8:\"branding\";s:8:\"Branding\";s:6:\"header\";s:6:\"Header\";s:10:\"navigation\";s:10:\"Navigation\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:13:\"sidebar_first\";s:13:\"First Sidebar\";s:14:\"sidebar_second\";s:14:\"Second Sidebar\";s:6:\"footer\";s:6:\"Footer\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:7:\"plugins\";a:1:{s:6:\"panels\";a:2:{s:7:\"layouts\";s:14:\"panels/layouts\";s:6:\"styles\";s:13:\"panels/styles\";}}s:7:\"version\";s:7:\"7.x-4.2\";s:7:\"project\";s:5:\"omega\";s:9:\"datestamp\";s:10:\"1390302888\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:11:\"stylesheets\";a:0:{}s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1438862218;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:10:\"sub_themes\";a:2:{s:3:\"ohm\";s:3:\"Ohm\";s:12:\"raptor_omega\";s:12:\"RAPTOR Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_display','a:1:{i:0;s:5:\"omega\";}','',31,5,1,'admin/structure/block','admin/structure/block','Omega','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/omega/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/omega','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/raptor_omega','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":15:{s:8:\"filename\";s:47:\"sites/all/themes/raptor_omega/raptor_omega.info\";s:4:\"name\";s:12:\"raptor_omega\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:16:{s:4:\"name\";s:12:\"RAPTOR Omega\";s:11:\"description\";s:32:\"Theme for the RAPTOR application\";s:10:\"base theme\";s:5:\"omega\";s:10:\"screenshot\";s:44:\"sites/all/themes/raptor_omega/screenshot.png\";s:6:\"engine\";s:11:\"phptemplate\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:8:\"settings\";a:41:{s:11:\"toggle_logo\";s:1:\"1\";s:11:\"toggle_name\";s:1:\"1\";s:13:\"toggle_slogan\";s:1:\"1\";s:24:\"toggle_node_user_picture\";s:1:\"0\";s:27:\"toggle_comment_user_picture\";s:1:\"0\";s:32:\"toggle_comment_user_verification\";s:1:\"0\";s:14:\"toggle_favicon\";s:1:\"0\";s:16:\"toggle_main_menu\";s:1:\"1\";s:21:\"toggle_secondary_menu\";s:1:\"0\";s:31:\"omega_toggle_front_page_content\";s:1:\"0\";s:12:\"default_logo\";s:1:\"1\";s:9:\"logo_path\";s:0:\"\";s:11:\"logo_upload\";s:0:\"\";s:15:\"default_favicon\";s:1:\"1\";s:12:\"favicon_path\";s:0:\"\";s:14:\"favicon_upload\";s:0:\"\";s:20:\"omega_enable_warning\";s:1:\"1\";s:30:\"omega_toggle_extension_layouts\";s:1:\"1\";s:12:\"omega_layout\";s:5:\"admin\";s:34:\"omega_toggle_extension_development\";s:1:\"1\";s:28:\"omega_rebuild_theme_registry\";s:1:\"0\";s:24:\"omega_rebuild_aggregates\";s:1:\"0\";s:29:\"omega_browser_width_indicator\";s:1:\"0\";s:16:\"omega_livereload\";s:1:\"0\";s:23:\"omega_livereload_script\";s:16:\"js/livereload.js\";s:21:\"omega_livereload_host\";s:9:\"localhost\";s:21:\"omega_livereload_port\";s:5:\"35729\";s:18:\"omega_demo_regions\";s:1:\"0\";s:36:\"omega_toggle_extension_compatibility\";s:1:\"1\";s:30:\"omega_conditional_classes_html\";s:1:\"1\";s:17:\"omega_apple_touch\";s:1:\"1\";s:15:\"omega_cleartype\";s:1:\"1\";s:23:\"omega_handheld_friendly\";s:1:\"1\";s:22:\"omega_mobile_optimized\";s:1:\"1\";s:14:\"omega_viewport\";s:1:\"1\";s:29:\"omega_viewport_user_scaleable\";s:1:\"1\";s:17:\"omega_chrome_edge\";s:1:\"1\";s:18:\"omega_chrome_popup\";s:1:\"0\";s:19:\"omega_chrome_notice\";s:1:\"0\";s:29:\"omega_toggle_extension_assets\";s:1:\"1\";s:15:\"omega_libraries\";a:4:{s:11:\"selectivizr\";a:1:{s:6:\"status\";s:1:\"1\";}s:7:\"respond\";a:1:{s:6:\"status\";s:1:\"1\";}s:3:\"pie\";a:1:{s:6:\"status\";s:1:\"1\";}s:9:\"html5shiv\";a:1:{s:6:\"status\";s:1:\"1\";}}}s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:3:\"php\";s:5:\"5.2.4\";s:5:\"mtime\";i:1440241381;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"base_themes\";a:1:{s:5:\"omega\";s:5:\"Omega\";}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:9:{s:21:\"css/raptor-global.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-global.css\";s:30:\"css/raptor-omega.normalize.css\";s:60:\"sites/all/themes/raptor_omega/css/raptor-omega.normalize.css\";s:26:\"css/raptor-omega.hacks.css\";s:56:\"sites/all/themes/raptor_omega/css/raptor-omega.hacks.css\";s:27:\"css/raptor-omega.styles.css\";s:57:\"sites/all/themes/raptor_omega/css/raptor-omega.styles.css\";s:29:\"css/raptor-omega.no-query.css\";s:59:\"sites/all/themes/raptor_omega/css/raptor-omega.no-query.css\";s:28:\"css/jquery-ui-1.10.3.min.css\";s:58:\"sites/all/themes/raptor_omega/css/jquery-ui-1.10.3.min.css\";s:21:\"css/raptor-charts.css\";s:51:\"sites/all/themes/raptor_omega/css/raptor-charts.css\";s:25:\"css/jquery.dataTables.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.dataTables.css\";s:25:\"css/jquery.timepicker.css\";s:55:\"sites/all/themes/raptor_omega/css/jquery.timepicker.css\";}}s:7:\"scripts\";a:7:{s:23:\"js/jquery.noconflict.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.noconflict.js\";s:23:\"js/jquery-1.11.1.min.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery-1.11.1.min.js\";s:19:\"js/jquery.cookie.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.cookie.js\";s:28:\"js/raptor-omega.behaviors.js\";s:58:\"sites/all/themes/raptor_omega/js/raptor-omega.behaviors.js\";s:27:\"js/jquery.dataTables.min.js\";s:57:\"sites/all/themes/raptor_omega/js/jquery.dataTables.min.js\";s:23:\"js/jquery.timepicker.js\";s:53:\"sites/all/themes/raptor_omega/js/jquery.timepicker.js\";s:19:\"js/jquery.sticky.js\";s:49:\"sites/all/themes/raptor_omega/js/jquery.sticky.js\";}s:6:\"engine\";s:11:\"phptemplate\";s:10:\"base_theme\";s:5:\"omega\";}}','block_admin_display','a:1:{i:0;s:12:\"raptor_omega\";}','',31,5,1,'admin/structure/block','admin/structure/block','RAPTOR Omega','t','','','a:0:{}',140,'','',-10,'modules/block/block.admin.inc'),('admin/structure/block/list/seven','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/seven/seven.info\";s:4:\"name\";s:5:\"seven\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"1\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:19:{s:4:\"name\";s:5:\"Seven\";s:11:\"description\";s:65:\"A simple one-column, tableless, fluid width administration theme.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:8:\"settings\";a:1:{s:20:\"shortcut_module_link\";s:1:\"1\";}s:7:\"regions\";a:8:{s:7:\"content\";s:7:\"Content\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/seven/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418439;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:6:\"screen\";a:2:{s:9:\"reset.css\";s:22:\"themes/seven/reset.css\";s:9:\"style.css\";s:22:\"themes/seven/style.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_display','a:1:{i:0;s:5:\"seven\";}','',31,5,1,'admin/structure/block','admin/structure/block','Seven','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/seven/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/seven','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/stark','','','_block_themes_access','a:1:{i:0;O:8:\"stdClass\":12:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:18:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal\'s default HTML markup and CSS styles. To learn how to build your own theme and override Drupal\'s default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:4:\"7.38\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:7:\"project\";s:6:\"drupal\";s:9:\"datestamp\";s:10:\"1434567286\";s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:5:\"mtime\";i:1435418435;s:15:\"overlay_regions\";a:3:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:6:\"prefix\";s:11:\"phptemplate\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}','block_admin_display','a:1:{i:0;s:5:\"stark\";}','',31,5,1,'admin/structure/block','admin/structure/block','Stark','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/list/stark/add','','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:1:{i:0;s:20:\"block_add_block_form\";}','',63,6,1,'admin/structure/block/list/stark','admin/structure/block','Add block','t','','','a:0:{}',388,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/manage/%/%','a:2:{i:4;N;i:5;N;}','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:3:{i:0;s:21:\"block_admin_configure\";i:1;i:4;i:2;i:5;}','',60,6,0,'','admin/structure/block/manage/%/%','Configure block','t','','','a:0:{}',6,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/manage/%/%/configure','a:2:{i:4;N;i:5;N;}','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:3:{i:0;s:21:\"block_admin_configure\";i:1;i:4;i:2;i:5;}','',121,7,2,'admin/structure/block/manage/%/%','admin/structure/block/manage/%/%','Configure block','t','','','a:0:{}',140,'','',0,'modules/block/block.admin.inc'),('admin/structure/block/manage/%/%/delete','a:2:{i:4;N;i:5;N;}','','user_access','a:1:{i:0;s:17:\"administer blocks\";}','drupal_get_form','a:3:{i:0;s:25:\"block_custom_block_delete\";i:1;i:4;i:2;i:5;}','',121,7,0,'admin/structure/block/manage/%/%','admin/structure/block/manage/%/%','Delete block','t','','','a:0:{}',132,'','',0,'modules/block/block.admin.inc'),('admin/structure/menu','','','user_access','a:1:{i:0;s:15:\"administer menu\";}','menu_overview_page','a:0:{}','',7,3,0,'','admin/structure/menu','Menus','t','','','a:0:{}',6,'Add new menus to your site, edit existing menus, and rename and reorganize menu links.','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/add','','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:2:{i:0;s:14:\"menu_edit_menu\";i:1;s:3:\"add\";}','',15,4,1,'admin/structure/menu','admin/structure/menu','Add menu','t','','','a:0:{}',388,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/item/%/delete','a:1:{i:4;s:14:\"menu_link_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','menu_item_delete_page','a:1:{i:0;i:4;}','',61,6,0,'','admin/structure/menu/item/%/delete','Delete menu link','t','','','a:0:{}',6,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/item/%/edit','a:1:{i:4;s:14:\"menu_link_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:4:{i:0;s:14:\"menu_edit_item\";i:1;s:4:\"edit\";i:2;i:4;i:3;N;}','',61,6,0,'','admin/structure/menu/item/%/edit','Edit menu link','t','','','a:0:{}',6,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/item/%/reset','a:1:{i:4;s:14:\"menu_link_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:2:{i:0;s:23:\"menu_reset_item_confirm\";i:1;i:4;}','',61,6,0,'','admin/structure/menu/item/%/reset','Reset menu link','t','','','a:0:{}',6,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/list','','','user_access','a:1:{i:0;s:15:\"administer menu\";}','menu_overview_page','a:0:{}','',15,4,1,'admin/structure/menu','admin/structure/menu','List menus','t','','','a:0:{}',140,'','',-10,'modules/menu/menu.admin.inc'),('admin/structure/menu/manage/%','a:1:{i:4;s:9:\"menu_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:2:{i:0;s:18:\"menu_overview_form\";i:1;i:4;}','',30,5,0,'','admin/structure/menu/manage/%','Customize menu','menu_overview_title','a:1:{i:0;i:4;}','','a:0:{}',6,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/manage/%/add','a:1:{i:4;s:9:\"menu_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:4:{i:0;s:14:\"menu_edit_item\";i:1;s:3:\"add\";i:2;N;i:3;i:4;}','',61,6,1,'admin/structure/menu/manage/%','admin/structure/menu/manage/%','Add link','t','','','a:0:{}',388,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/manage/%/delete','a:1:{i:4;s:9:\"menu_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','menu_delete_menu_page','a:1:{i:0;i:4;}','',61,6,0,'','admin/structure/menu/manage/%/delete','Delete menu','t','','','a:0:{}',6,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/manage/%/edit','a:1:{i:4;s:9:\"menu_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:3:{i:0;s:14:\"menu_edit_menu\";i:1;s:4:\"edit\";i:2;i:4;}','',61,6,3,'admin/structure/menu/manage/%','admin/structure/menu/manage/%','Edit menu','t','','','a:0:{}',132,'','',0,'modules/menu/menu.admin.inc'),('admin/structure/menu/manage/%/list','a:1:{i:4;s:9:\"menu_load\";}','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:2:{i:0;s:18:\"menu_overview_form\";i:1;i:4;}','',61,6,3,'admin/structure/menu/manage/%','admin/structure/menu/manage/%','List links','t','','','a:0:{}',140,'','',-10,'modules/menu/menu.admin.inc'),('admin/structure/menu/parents','','','user_access','a:1:{i:0;s:15:\"administer menu\";}','menu_parent_options_js','a:0:{}','',15,4,0,'','admin/structure/menu/parents','Parent menu items','t','','','a:0:{}',0,'','',0,''),('admin/structure/menu/settings','','','user_access','a:1:{i:0;s:15:\"administer menu\";}','drupal_get_form','a:1:{i:0;s:14:\"menu_configure\";}','',15,4,1,'admin/structure/menu','admin/structure/menu','Settings','t','','','a:0:{}',132,'','',5,'modules/menu/menu.admin.inc'),('admin/structure/taxonomy','','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:1:{i:0;s:30:\"taxonomy_overview_vocabularies\";}','',7,3,0,'','admin/structure/taxonomy','Taxonomy','t','','','a:0:{}',6,'Manage tagging, categorization, and classification of your content.','',0,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/%','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:23:\"taxonomy_overview_terms\";i:1;i:3;}','',14,4,0,'','admin/structure/taxonomy/%','','entity_label','a:2:{i:0;s:19:\"taxonomy_vocabulary\";i:1;i:3;}','','a:0:{}',6,'','',0,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/%/add','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:3:{i:0;s:18:\"taxonomy_form_term\";i:1;a:0:{}i:2;i:3;}','',29,5,1,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','Add term','t','','','a:0:{}',388,'','',0,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/%/display','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:13:\"taxonomy_term\";i:2;i:3;i:3;s:7:\"default\";}','',29,5,1,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','Manage display','t','','','a:0:{}',132,'','',2,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/display/default','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:7:\"default\";i:3;s:11:\"user_access\";i:4;s:19:\"administer taxonomy\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:13:\"taxonomy_term\";i:2;i:3;i:3;s:7:\"default\";}','',59,6,1,'admin/structure/taxonomy/%/display','admin/structure/taxonomy/%','Default','t','','','a:0:{}',140,'','',-10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/display/full','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:4:\"full\";i:3;s:11:\"user_access\";i:4;s:19:\"administer taxonomy\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:13:\"taxonomy_term\";i:2;i:3;i:3;s:4:\"full\";}','',59,6,1,'admin/structure/taxonomy/%/display','admin/structure/taxonomy/%','Taxonomy term page','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/edit','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:24:\"taxonomy_form_vocabulary\";i:1;i:3;}','',29,5,1,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','Edit','t','','','a:0:{}',132,'','',-10,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/%/fields','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:3:{i:0;s:28:\"field_ui_field_overview_form\";i:1;s:13:\"taxonomy_term\";i:2;i:3;}','',29,5,1,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','Manage fields','t','','','a:0:{}',132,'','',1,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/fields/%','a:2:{i:3;a:1:{s:37:\"taxonomy_vocabulary_machine_name_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:5;}','',58,6,0,'','admin/structure/taxonomy/%/fields/%','','field_ui_menu_title','a:1:{i:0;i:5;}','','a:0:{}',6,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/fields/%/delete','a:2:{i:3;a:1:{s:37:\"taxonomy_vocabulary_machine_name_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:26:\"field_ui_field_delete_form\";i:1;i:5;}','',117,7,1,'admin/structure/taxonomy/%/fields/%','admin/structure/taxonomy/%/fields/%','Delete','t','','','a:0:{}',132,'','',10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/fields/%/edit','a:2:{i:3;a:1:{s:37:\"taxonomy_vocabulary_machine_name_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:5;}','',117,7,1,'admin/structure/taxonomy/%/fields/%','admin/structure/taxonomy/%/fields/%','Edit','t','','','a:0:{}',140,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/fields/%/field-settings','a:2:{i:3;a:1:{s:37:\"taxonomy_vocabulary_machine_name_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:28:\"field_ui_field_settings_form\";i:1;i:5;}','',117,7,1,'admin/structure/taxonomy/%/fields/%','admin/structure/taxonomy/%/fields/%','Field settings','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/fields/%/widget-type','a:2:{i:3;a:1:{s:37:\"taxonomy_vocabulary_machine_name_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}i:5;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:13:\"taxonomy_term\";i:1;i:3;i:2;s:1:\"3\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:25:\"field_ui_widget_type_form\";i:1;i:5;}','',117,7,1,'admin/structure/taxonomy/%/fields/%','admin/structure/taxonomy/%/fields/%','Widget type','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/taxonomy/%/list','a:1:{i:3;s:37:\"taxonomy_vocabulary_machine_name_load\";}','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:2:{i:0;s:23:\"taxonomy_overview_terms\";i:1;i:3;}','',29,5,1,'admin/structure/taxonomy/%','admin/structure/taxonomy/%','List','t','','','a:0:{}',140,'','',-20,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/add','','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:1:{i:0;s:24:\"taxonomy_form_vocabulary\";}','',15,4,1,'admin/structure/taxonomy','admin/structure/taxonomy','Add vocabulary','t','','','a:0:{}',388,'','',0,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/taxonomy/list','','','user_access','a:1:{i:0;s:19:\"administer taxonomy\";}','drupal_get_form','a:1:{i:0;s:30:\"taxonomy_overview_vocabularies\";}','',15,4,1,'admin/structure/taxonomy','admin/structure/taxonomy','List','t','','','a:0:{}',140,'','',-10,'modules/taxonomy/taxonomy.admin.inc'),('admin/structure/types','','','user_access','a:1:{i:0;s:24:\"administer content types\";}','node_overview_types','a:0:{}','',7,3,0,'','admin/structure/types','Content types','t','','','a:0:{}',6,'Manage content types, including default status, front page promotion, comment settings, etc.','',0,'modules/node/content_types.inc'),('admin/structure/types/add','','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:1:{i:0;s:14:\"node_type_form\";}','',15,4,1,'admin/structure/types','admin/structure/types','Add content type','t','','','a:0:{}',388,'','',0,'modules/node/content_types.inc'),('admin/structure/types/list','','','user_access','a:1:{i:0;s:24:\"administer content types\";}','node_overview_types','a:0:{}','',15,4,1,'admin/structure/types','admin/structure/types','List','t','','','a:0:{}',140,'','',-10,'modules/node/content_types.inc'),('admin/structure/types/manage/%','a:1:{i:4;s:14:\"node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:14:\"node_type_form\";i:1;i:4;}','',30,5,0,'','admin/structure/types/manage/%','Edit content type','node_type_page_title','a:1:{i:0;i:4;}','','a:0:{}',6,'','',0,'modules/node/content_types.inc'),('admin/structure/types/manage/%/comment/display','a:1:{i:4;s:22:\"comment_node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:7:\"comment\";i:2;i:4;i:3;s:7:\"default\";}','',123,7,1,'admin/structure/types/manage/%','admin/structure/types/manage/%','Comment display','t','','','a:0:{}',132,'','',4,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/display/default','a:1:{i:4;s:22:\"comment_node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:7:\"default\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:7:\"comment\";i:2;i:4;i:3;s:7:\"default\";}','',247,8,1,'admin/structure/types/manage/%/comment/display','admin/structure/types/manage/%','Default','t','','','a:0:{}',140,'','',-10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/display/full','a:1:{i:4;s:22:\"comment_node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:4:\"full\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:7:\"comment\";i:2;i:4;i:3;s:4:\"full\";}','',247,8,1,'admin/structure/types/manage/%/comment/display','admin/structure/types/manage/%','Full comment','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields','a:1:{i:4;s:22:\"comment_node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:3:{i:0;s:28:\"field_ui_field_overview_form\";i:1;s:7:\"comment\";i:2;i:4;}','',123,7,1,'admin/structure/types/manage/%','admin/structure/types/manage/%','Comment fields','t','','','a:0:{}',132,'','',3,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields/%','a:2:{i:4;a:1:{s:22:\"comment_node_type_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:7;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:7;}','',246,8,0,'','admin/structure/types/manage/%/comment/fields/%','','field_ui_menu_title','a:1:{i:0;i:7;}','','a:0:{}',6,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields/%/delete','a:2:{i:4;a:1:{s:22:\"comment_node_type_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:7;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:26:\"field_ui_field_delete_form\";i:1;i:7;}','',493,9,1,'admin/structure/types/manage/%/comment/fields/%','admin/structure/types/manage/%/comment/fields/%','Delete','t','','','a:0:{}',132,'','',10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields/%/edit','a:2:{i:4;a:1:{s:22:\"comment_node_type_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:7;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:7;}','',493,9,1,'admin/structure/types/manage/%/comment/fields/%','admin/structure/types/manage/%/comment/fields/%','Edit','t','','','a:0:{}',140,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields/%/field-settings','a:2:{i:4;a:1:{s:22:\"comment_node_type_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:7;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:28:\"field_ui_field_settings_form\";i:1;i:7;}','',493,9,1,'admin/structure/types/manage/%/comment/fields/%','admin/structure/types/manage/%/comment/fields/%','Field settings','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/comment/fields/%/widget-type','a:2:{i:4;a:1:{s:22:\"comment_node_type_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:7;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:7:\"comment\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:25:\"field_ui_widget_type_form\";i:1;i:7;}','',493,9,1,'admin/structure/types/manage/%/comment/fields/%','admin/structure/types/manage/%/comment/fields/%','Widget type','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/delete','a:1:{i:4;s:14:\"node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;i:4;}','',61,6,0,'','admin/structure/types/manage/%/delete','Delete','t','','','a:0:{}',6,'','',0,'modules/node/content_types.inc'),('admin/structure/types/manage/%/display','a:1:{i:4;s:14:\"node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:7:\"default\";}','',61,6,1,'admin/structure/types/manage/%','admin/structure/types/manage/%','Manage display','t','','','a:0:{}',132,'','',2,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/default','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:7:\"default\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:7:\"default\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','Default','t','','','a:0:{}',140,'','',-10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/full','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:4:\"full\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:4:\"full\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','Full content','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/rss','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:3:\"rss\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:3:\"rss\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','RSS','t','','','a:0:{}',132,'','',2,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/search_index','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:12:\"search_index\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:12:\"search_index\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','Search index','t','','','a:0:{}',132,'','',3,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/search_result','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:13:\"search_result\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:13:\"search_result\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','Search result highlighting input','t','','','a:0:{}',132,'','',4,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/display/teaser','a:1:{i:4;s:14:\"node_type_load\";}','','_field_ui_view_mode_menu_access','a:5:{i:0;s:4:\"node\";i:1;i:4;i:2;s:6:\"teaser\";i:3;s:11:\"user_access\";i:4;s:24:\"administer content types\";}','drupal_get_form','a:4:{i:0;s:30:\"field_ui_display_overview_form\";i:1;s:4:\"node\";i:2;i:4;i:3;s:6:\"teaser\";}','',123,7,1,'admin/structure/types/manage/%/display','admin/structure/types/manage/%','Teaser','t','','','a:0:{}',132,'','',1,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/edit','a:1:{i:4;s:14:\"node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:14:\"node_type_form\";i:1;i:4;}','',61,6,1,'admin/structure/types/manage/%','admin/structure/types/manage/%','Edit','t','','','a:0:{}',140,'','',0,'modules/node/content_types.inc'),('admin/structure/types/manage/%/fields','a:1:{i:4;s:14:\"node_type_load\";}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:3:{i:0;s:28:\"field_ui_field_overview_form\";i:1;s:4:\"node\";i:2;i:4;}','',61,6,1,'admin/structure/types/manage/%','admin/structure/types/manage/%','Manage fields','t','','','a:0:{}',132,'','',1,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/fields/%','a:2:{i:4;a:1:{s:14:\"node_type_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:6;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:6;}','',122,7,0,'','admin/structure/types/manage/%/fields/%','','field_ui_menu_title','a:1:{i:0;i:6;}','','a:0:{}',6,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/fields/%/delete','a:2:{i:4;a:1:{s:14:\"node_type_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:6;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:26:\"field_ui_field_delete_form\";i:1;i:6;}','',245,8,1,'admin/structure/types/manage/%/fields/%','admin/structure/types/manage/%/fields/%','Delete','t','','','a:0:{}',132,'','',10,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/fields/%/edit','a:2:{i:4;a:1:{s:14:\"node_type_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:6;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:24:\"field_ui_field_edit_form\";i:1;i:6;}','',245,8,1,'admin/structure/types/manage/%/fields/%','admin/structure/types/manage/%/fields/%','Edit','t','','','a:0:{}',140,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/fields/%/field-settings','a:2:{i:4;a:1:{s:14:\"node_type_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:6;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:28:\"field_ui_field_settings_form\";i:1;i:6;}','',245,8,1,'admin/structure/types/manage/%/fields/%','admin/structure/types/manage/%/fields/%','Field settings','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/structure/types/manage/%/fields/%/widget-type','a:2:{i:4;a:1:{s:14:\"node_type_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}i:6;a:1:{s:18:\"field_ui_menu_load\";a:4:{i:0;s:4:\"node\";i:1;i:4;i:2;s:1:\"4\";i:3;s:4:\"%map\";}}}','','user_access','a:1:{i:0;s:24:\"administer content types\";}','drupal_get_form','a:2:{i:0;s:25:\"field_ui_widget_type_form\";i:1;i:6;}','',245,8,1,'admin/structure/types/manage/%/fields/%','admin/structure/types/manage/%/fields/%','Widget type','t','','','a:0:{}',132,'','',0,'modules/field_ui/field_ui.admin.inc'),('admin/tasks','','','user_access','a:1:{i:0;s:27:\"access administration pages\";}','system_admin_menu_block_page','a:0:{}','',3,2,1,'admin','admin','Tasks','t','','','a:0:{}',140,'','',-20,'modules/system/system.admin.inc'),('batch','','','1','a:0:{}','system_batch_page','a:0:{}','',1,1,0,'','batch','','t','','_system_batch_theme','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('comment/%','a:1:{i:1;N;}','','user_access','a:1:{i:0;s:15:\"access comments\";}','comment_permalink','a:1:{i:0;i:1;}','',2,2,0,'','comment/%','Comment permalink','t','','','a:0:{}',6,'','',0,''),('comment/%/approve','a:1:{i:1;N;}','','user_access','a:1:{i:0;s:19:\"administer comments\";}','comment_approve','a:1:{i:0;i:1;}','',5,3,0,'','comment/%/approve','Approve','t','','','a:0:{}',6,'','',1,'modules/comment/comment.pages.inc'),('comment/%/delete','a:1:{i:1;N;}','','user_access','a:1:{i:0;s:19:\"administer comments\";}','comment_confirm_delete_page','a:1:{i:0;i:1;}','',5,3,1,'comment/%','comment/%','Delete','t','','','a:0:{}',132,'','',2,'modules/comment/comment.admin.inc'),('comment/%/edit','a:1:{i:1;s:12:\"comment_load\";}','','comment_access','a:2:{i:0;s:4:\"edit\";i:1;i:1;}','comment_edit_page','a:1:{i:0;i:1;}','',5,3,1,'comment/%','comment/%','Edit','t','','','a:0:{}',132,'','',0,''),('comment/%/view','a:1:{i:1;N;}','','user_access','a:1:{i:0;s:15:\"access comments\";}','comment_permalink','a:1:{i:0;i:1;}','',5,3,1,'comment/%','comment/%','View comment','t','','','a:0:{}',140,'','',-10,''),('comment/reply/%','a:1:{i:2;s:9:\"node_load\";}','','node_access','a:2:{i:0;s:4:\"view\";i:1;i:2;}','comment_reply','a:1:{i:0;i:2;}','',6,3,0,'','comment/reply/%','Add new comment','t','','','a:0:{}',6,'','',0,'modules/comment/comment.pages.inc'),('ewdvista/diagnostic1','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_ewdvista_diagnostic1_form','a:0:{}','',3,2,0,'','ewdvista/diagnostic1','Developer Diagnostic Page1','t','','','a:0:{}',0,'Developer Diagnostic1 Page','',0,'/sites/all/modules/raptor_ewdvista/form//DiagnosticPage1.php'),('ewdvista/diagnostic2','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_ewdvista_diagnostic2_form','a:0:{}','',3,2,0,'','ewdvista/diagnostic2','Developer Diagnostic Page2','t','','','a:0:{}',0,'Developer Diagnostic Page2','',0,'/sites/all/modules/raptor_ewdvista/form//DiagnosticPage2.php'),('file/ajax','','','user_access','a:1:{i:0;s:14:\"access content\";}','file_ajax_upload','a:0:{}','ajax_deliver',3,2,0,'','file/ajax','','t','','ajax_base_page_theme','a:0:{}',0,'','',0,''),('file/progress','','','user_access','a:1:{i:0;s:14:\"access content\";}','file_ajax_progress','a:0:{}','',3,2,0,'','file/progress','','t','','ajax_base_page_theme','a:0:{}',0,'','',0,''),('filter/tips','','','1','a:0:{}','filter_tips_long','a:0:{}','',3,2,0,'','filter/tips','Compose tips','t','','','a:0:{}',20,'','',0,'modules/filter/filter.pages.inc'),('getdaoruntimemetrics','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_datalayer_getdaoruntimemetrics_form','a:0:{}','',1,1,0,'','getdaoruntimemetrics','Get DAO Runtime Metrics','t','','','a:0:{}',0,'Get DAO Runtime Metrics','',0,'/sites/all/modules/raptor_datalayer/core//EhrDaoRuntimeMetrics.php'),('node','','','user_access','a:1:{i:0;s:14:\"access content\";}','node_page_default','a:0:{}','',1,1,0,'','node','','t','','','a:0:{}',0,'','',0,''),('node/%','a:1:{i:1;s:9:\"node_load\";}','','node_access','a:2:{i:0;s:4:\"view\";i:1;i:1;}','node_page_view','a:1:{i:0;i:1;}','',2,2,0,'','node/%','','node_page_title','a:1:{i:0;i:1;}','','a:0:{}',6,'','',0,''),('node/%/delete','a:1:{i:1;s:9:\"node_load\";}','','node_access','a:2:{i:0;s:6:\"delete\";i:1;i:1;}','drupal_get_form','a:2:{i:0;s:19:\"node_delete_confirm\";i:1;i:1;}','',5,3,2,'node/%','node/%','Delete','t','','','a:0:{}',132,'','',1,'modules/node/node.pages.inc'),('node/%/edit','a:1:{i:1;s:9:\"node_load\";}','','node_access','a:2:{i:0;s:6:\"update\";i:1;i:1;}','node_page_edit','a:1:{i:0;i:1;}','',5,3,3,'node/%','node/%','Edit','t','','','a:0:{}',132,'','',0,'modules/node/node.pages.inc'),('node/%/revisions','a:1:{i:1;s:9:\"node_load\";}','','_node_revision_access','a:1:{i:0;i:1;}','node_revision_overview','a:1:{i:0;i:1;}','',5,3,1,'node/%','node/%','Revisions','t','','','a:0:{}',132,'','',2,'modules/node/node.pages.inc'),('node/%/revisions/%/delete','a:2:{i:1;a:1:{s:9:\"node_load\";a:1:{i:0;i:3;}}i:3;N;}','','_node_revision_access','a:2:{i:0;i:1;i:1;s:6:\"delete\";}','drupal_get_form','a:2:{i:0;s:28:\"node_revision_delete_confirm\";i:1;i:1;}','',21,5,0,'','node/%/revisions/%/delete','Delete earlier revision','t','','','a:0:{}',6,'','',0,'modules/node/node.pages.inc'),('node/%/revisions/%/revert','a:2:{i:1;a:1:{s:9:\"node_load\";a:1:{i:0;i:3;}}i:3;N;}','','_node_revision_access','a:2:{i:0;i:1;i:1;s:6:\"update\";}','drupal_get_form','a:2:{i:0;s:28:\"node_revision_revert_confirm\";i:1;i:1;}','',21,5,0,'','node/%/revisions/%/revert','Revert to earlier revision','t','','','a:0:{}',6,'','',0,'modules/node/node.pages.inc'),('node/%/revisions/%/view','a:2:{i:1;a:1:{s:9:\"node_load\";a:1:{i:0;i:3;}}i:3;N;}','','_node_revision_access','a:1:{i:0;i:1;}','node_show','a:2:{i:0;i:1;i:1;b:1;}','',21,5,0,'','node/%/revisions/%/view','Revisions','t','','','a:0:{}',6,'','',0,''),('node/%/view','a:1:{i:1;s:9:\"node_load\";}','','node_access','a:2:{i:0;s:4:\"view\";i:1;i:1;}','node_page_view','a:1:{i:0;i:1;}','',5,3,1,'node/%','node/%','View','t','','','a:0:{}',140,'','',-10,''),('node/add','','','_node_add_access','a:0:{}','node_add_page','a:0:{}','',3,2,0,'','node/add','Add content','t','','','a:0:{}',6,'','',0,'modules/node/node.pages.inc'),('node/add/article','','','node_access','a:2:{i:0;s:6:\"create\";i:1;s:7:\"article\";}','node_add','a:1:{i:0;s:7:\"article\";}','',7,3,0,'','node/add/article','Article','check_plain','','','a:0:{}',6,'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.','',0,'modules/node/node.pages.inc'),('node/add/page','','','node_access','a:2:{i:0;s:6:\"create\";i:1;s:4:\"page\";}','node_add','a:1:{i:0;s:4:\"page\";}','',7,3,0,'','node/add/page','Basic page','check_plain','','','a:0:{}',6,'Use <em>basic pages</em> for your static content, such as an \'About us\' page.','',0,'modules/node/node.pages.inc'),('protocol','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_protocolinfo_form_inputarea','a:0:{}','',1,1,0,'','protocol','Protocol','t','','','a:0:{}',0,'The RAPTOR Protocol Page','',0,'/sites/all/modules/raptor_glue/form//ProtocolInfoPage.php'),('raptor/about','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_about_form','a:0:{}','',3,2,0,'','raptor/about','About Page','t','','','a:0:{}',0,'See information about RAPTOR installation','',0,'/sites/all/modules/raptor_glue/functions//misc.inc'),('raptor/addadminuser','','','1','a:1:{i:0;s:14:\"access content\";}','drupal_get_form','a:1:{i:0;s:37:\"raptor_glue_addadminuser_form_builder\";}','',3,2,0,'','raptor/addadminuser','Add Admin User','t','','','a:0:{}',0,'Add Admin User Form','',0,'/sites/all/modules/raptor_glue/form//AddUserPage.php'),('raptor/addcontraindication','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_addci_form','a:0:{}','',3,2,0,'','raptor/addcontraindication','Add Contraindication','t','','','a:0:{}',0,'Add Contraindications Detail','',0,'/sites/all/modules/raptor_contraindications/form//AddContraIndicationPage.php'),('raptor/addprotocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_addprotocollib_form','a:0:{}','',3,2,0,'','raptor/addprotocollib','Add Protocol to Library','t','','','a:0:{}',0,'Add Protocol Lib Form','',0,'/sites/all/modules/raptor_glue/form//AddProtocolLibPage.php'),('raptor/addradiationdosehxentry','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_addradiationdosehxentry_form','a:0:{}','',3,2,0,'','raptor/addradiationdosehxentry','Add Radiation Dose History Entry','t','','','a:0:{}',0,'Add radiation dose history content','',0,'/sites/all/modules/raptor_glue/form//AddRadiationDoseHxEntryPage.php'),('raptor/addstandarduser','','','1','a:1:{i:0;s:14:\"access content\";}','drupal_get_form','a:1:{i:0;s:40:\"raptor_glue_addstandarduser_form_builder\";}','',3,2,0,'','raptor/addstandarduser','Add Standard User','t','','','a:0:{}',0,'Add Standard User Form','',0,'/sites/all/modules/raptor_glue/form//AddUserPage.php'),('raptor/cancelorder','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_cancelorder_form','a:0:{}','',3,2,0,'','raptor/cancelorder','Cancel Order','t','','','a:0:{}',0,'Cancel Order Form','',0,'/sites/all/modules/raptor_glue/form//CancelOrderPage.php'),('raptor/changepassword','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_chgpwd_form','a:0:{}','',3,2,0,'','raptor/changepassword','RAPTOR Password Change','t','','','a:0:{}',0,'Change Password Form','',0,'/sites/all/modules/raptor_glue/form//ChangePasswordPage.php'),('raptor/choosevisit','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_choosevisit_form','a:0:{}','',3,2,0,'','raptor/choosevisit','Choose Visit','t','','','a:0:{}',0,'Choose Visit Form','',0,'/sites/all/modules/raptor_glue/form//ChooseVisitPage.php'),('raptor/completionsuccess','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_completion_form','a:0:{}','',3,2,0,'','raptor/completionsuccess','Completion Success','t','','','a:0:{}',0,'Completion Notice','',0,'/sites/all/modules/raptor_glue/functions//misc.inc'),('raptor/contraindications/exportdata','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_admincontraindicationdatadump_form','a:0:{}','',7,3,0,'','raptor/contraindications/exportdata','Contraindications Data Dump','t','','','a:0:{}',0,'Extract to a file all contraindication rules data','',0,''),('raptor/contraindications/exportxml','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_exportxml_form','a:0:{}','',7,3,0,'','raptor/contraindications/exportxml','XML Rulebase Dump','t','','','a:0:{}',0,'Export all the rulebase info in a shareable XML format','',0,''),('raptor/dataexports','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_dataexports_form','a:0:{}','',3,2,0,'','raptor/dataexports','Export RAPTOR data','t','','','a:0:{}',0,'Data exports','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/declarehiddenworklistcols','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_declarehiddenworklistcols_form','a:0:{}','',3,2,0,'','raptor/declarehiddenworklistcols','Declare Hidden Worklist Cols','t','','','a:0:{}',0,'Declare Hidden Worklist Cols','',0,''),('raptor/deletecontraindication','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_deleteci_form','a:0:{}','',3,2,0,'','raptor/deletecontraindication','Delete Contraindication','t','','','a:0:{}',0,'Delete Contraindications Detail','',0,'/sites/all/modules/raptor_contraindications/form//DeleteContraIndicationPage.php'),('raptor/deleteprotocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_deleteprotocollib_form','a:0:{}','',3,2,0,'','raptor/deleteprotocollib','Delete Protocol from Library','t','','','a:0:{}',0,'Delete Protocol Lib Form','',0,'/sites/all/modules/raptor_glue/form//DeleteProtocolLibPage.php'),('raptor/deleteuser','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_deleteuser_form','a:0:{}','',3,2,0,'','raptor/deleteuser','Delete User','t','','','a:0:{}',0,'Delete User Form','',0,'/sites/all/modules/raptor_glue/form//DeleteUserPage.php'),('raptor/downloadconfig','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_admincoredatadump_form','a:0:{}','',3,2,0,'','raptor/downloadconfig','Download Configuration Settings','t','','','a:0:{}',0,'Download all the site configuration settings','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/editatriskallergycontrast','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editatriskallergycontrast_form','a:0:{}','',3,2,0,'','raptor/editatriskallergycontrast','Edit At Risk Allergy Contrast List','t','','','a:0:{}',0,'Edit At Risk Allergy Contrast List Form','',0,'/sites/all/modules/raptor_glue/form//EditListAtRiskAllergyContrastPage.php'),('raptor/editatriskbloodthinner','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editatriskbloodthinner_form','a:0:{}','',3,2,0,'','raptor/editatriskbloodthinner','Edit Blood Thinner Keyword List','t','','','a:0:{}',0,'Edit Blood Thinner Keyword List Form','',0,'/sites/all/modules/raptor_glue/form//EditListAtRiskBloodThinnerPage.php'),('raptor/editatriskmeds','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editatriskmeds_form','a:0:{}','',3,2,0,'','raptor/editatriskmeds','Edit At Risk Medications List','t','','','a:0:{}',0,'Edit At Risk Medications List Form','',0,'/sites/all/modules/raptor_glue/form//EditListAtRiskMedsPage.php'),('raptor/editatriskrarecontrast','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editatriskrarecontrast_form','a:0:{}','',3,2,0,'','raptor/editatriskrarecontrast','Edit Rare Contrast Keyword List','t','','','a:0:{}',0,'Edit Rare Contrast Keyword List Form','',0,'/sites/all/modules/raptor_glue/form//EditListAtRiskRareContrastPage.php'),('raptor/editatriskrareradioisotope','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editatriskrareradioisotope_form','a:0:{}','',3,2,0,'','raptor/editatriskrareradioisotope','Edit Rare Radionuclide Keyword List','t','','','a:0:{}',0,'Edit Rare Radionuclide Keyword List Form','',0,'/sites/all/modules/raptor_glue/form//EditListAtRiskRareRadioisotopePage.php'),('raptor/editboilerplateexamoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editboilerplateexamoptions_form','a:0:{}','',3,2,0,'','raptor/editboilerplateexamoptions','Edit Exam Boilerplate Text Options','t','','','a:0:{}',0,'Edit Exam Boilerplate Text Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListBoilerplateExamPage.php'),('raptor/editboilerplateprotocoloptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editboilerplateprotocoloptions_form','a:0:{}','',3,2,0,'','raptor/editboilerplateprotocoloptions','Edit Protocol Boilerplate Text Options','t','','','a:0:{}',0,'Edit Protocol Boilerplate Text Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListBoilerplateProtocolPage.php'),('raptor/editcontraindication','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_editci_form','a:0:{}','',3,2,0,'','raptor/editcontraindication','Edit Contraindication','t','','','a:0:{}',0,'Edit Contraindications Detail','',0,'/sites/all/modules/raptor_contraindications/form//EditContraIndicationPage.php'),('raptor/editcontrastoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editcontrastoptions_form','a:0:{}','',3,2,0,'','raptor/editcontrastoptions','Edit Contrast Options','t','','','a:0:{}',0,'Edit Contrast Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListContrastPage.php'),('raptor/editexamroomoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editexamroomoptions_form','a:0:{}','',3,2,0,'','raptor/editexamroomoptions','Edit Exam Room Options','t','','','a:0:{}',0,'Edit Exam Room Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListExamRoomPage.php'),('raptor/edithydrationoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_edithydrationoptions_form','a:0:{}','',3,2,0,'','raptor/edithydrationoptions','Edit Hydration Options','t','','','a:0:{}',0,'Edit Hydration Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListHydrationPage.php'),('raptor/editprotocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editprotocollib_form','a:0:{}','',3,2,0,'','raptor/editprotocollib','Edit Protocol in Library','t','','','a:0:{}',0,'Edit Protocol Lib Form','',0,'/sites/all/modules/raptor_glue/form//EditProtocolLibPage.php'),('raptor/editqaquestions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editqaquestions_form','a:0:{}','',3,2,0,'','raptor/editqaquestions','Edit QA Questions','t','','','a:0:{}',0,'Edit QA Questions Form','',0,'/sites/all/modules/raptor_glue/form//EditQAQuestionsPage.php'),('raptor/editradiationdosehxentry','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editradiationdosehxentry_form','a:0:{}','',3,2,0,'','raptor/editradiationdosehxentry','Edit Radiation Dose History Entry','t','','','a:0:{}',0,'Edit radiation dose history content','',0,'/sites/all/modules/raptor_glue/form//EditRadiationDoseHxEntryPage.php'),('raptor/editradioisotopeoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editradioisotopeoptions_form','a:0:{}','',3,2,0,'','raptor/editradioisotopeoptions','Edit Radionuclide Options','t','','','a:0:{}',0,'Edit Radionuclide Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListRadioisotopePage.php'),('raptor/editsedationoptions','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editsedationoptions_form','a:0:{}','',3,2,0,'','raptor/editsedationoptions','Edit Sedation Options','t','','','a:0:{}',0,'Edit Sedation Options Form','',0,'/sites/all/modules/raptor_glue/form//EditListSedationPage.php'),('raptor/editselfprofile','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editselfprofile_form','a:0:{}','',3,2,0,'','raptor/editselfprofile','Edit Profile','t','','','a:0:{}',0,'Edit Profile','',0,'/sites/all/modules/raptor_glue/form//EditUserPage.php'),('raptor/edituser','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_edituser_form','a:0:{}','',3,2,0,'','raptor/edituser','Edit User','t','','','a:0:{}',0,'Edit User Form','',0,'/sites/all/modules/raptor_glue/form//EditUserPage.php'),('raptor/editworklistranking','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_editworklistranking_form','a:0:{}','',3,2,0,'','raptor/editworklistranking','Edit Worklist Ranking','t','','','a:0:{}',0,'Edit Worklist Ranking Form','',0,'/sites/all/modules/raptor_glue/form//EditWorklistRankingPage.php'),('raptor/floatingdialog/testform','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_floatingdialog_runtests_form','a:0:{}','',7,3,0,'','raptor/floatingdialog/testform','Test Form','t','','','a:0:{}',0,'Test floatingdialog integration','',0,''),('raptor/getnotestab','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_getnotestab_form','a:0:{}','',3,2,0,'','raptor/getnotestab','VistA Notes','t','','','a:0:{}',0,'VistA Notes tab content','',0,'/sites/all/modules/raptor_glue/form//GetNotesTab.php'),('raptor/getprotocollibtab','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_getprotocollibtab_form','a:0:{}','',3,2,0,'','raptor/getprotocollibtab','Protocol Library','t','','','a:0:{}',0,'Protocol library tab content','',0,'/sites/all/modules/raptor_glue/form//GetProtocolLibTab.php'),('raptor/getradiationdosehxtab','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_getradiationdosehxtab_form','a:0:{}','',3,2,0,'','raptor/getradiationdosehxtab','Radiation Dose History','t','','','a:0:{}',0,'Radiation dose history tab content','',0,'/sites/all/modules/raptor_glue/form//GetRadiationDoseHxTab.php'),('raptor/getradrptstab','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_getradrptstab_form','a:0:{}','',3,2,0,'','raptor/getradrptstab','Radiology Reports','t','','','a:0:{}',0,'Radiology Reports tab content','',0,'/sites/all/modules/raptor_glue/form//GetRadiologyReportsTab.php'),('raptor/imageviewing/runtests','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_imageviewing_runtests_form','a:0:{}','',7,3,0,'','raptor/imageviewing/runtests','Image Viewing Test','t','','','a:0:{}',0,'Test image viewing integration','',0,''),('raptor/kickout_accountconflict','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_kickout_accountconflict_form','a:0:{}','',3,2,0,'','raptor/kickout_accountconflict','User Session Account Kickout Account Conflict','t','','','a:0:{}',0,'User account session kickout because of account conflict','',0,'/sites/all/modules/raptor_glue/functions//misc.inc'),('raptor/kickout_timeout','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_kickout_timeout_form','a:0:{}','',3,2,0,'','raptor/kickout_timeout','User Session Account Kickout Session Timeout','t','','','a:0:{}',0,'User account session kickout because of timeout','',0,''),('raptor/loadcache','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_loadcache_form','a:0:{}','',3,2,0,'','raptor/loadcache','Load Cache','t','','','a:0:{}',0,'Load cache','',0,'/sites/all/modules/raptor_glue/functions//misc.inc'),('raptor/managecontraindications','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_mng_ci_form','a:0:{}','',3,2,0,'','raptor/managecontraindications','Manage Contraindications','t','','','a:0:{}',0,'Manage Contraindications Form','',0,'/sites/all/modules/raptor_contraindications/form//ManageContraIndicationsPage.php'),('raptor/managelists','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_mng_lists_form','a:0:{}','',3,2,0,'','raptor/managelists','Manage Lists','t','','','a:0:{}',0,'Manage Lists Form','',0,'/sites/all/modules/raptor_glue/form//ManageListsPage.php'),('raptor/manageprotocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_mng_protocols_form','a:0:{}','',3,2,0,'','raptor/manageprotocollib','Manage Protocols','t','','','a:0:{}',0,'Manage Protocols Form','',0,'/sites/all/modules/raptor_glue/form//ManageProtocolLibPage.php'),('raptor/manageusers','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_mngusers_form','a:0:{}','',3,2,0,'','raptor/manageusers','Manage User Accounts','t','','','a:0:{}',0,'Manage Users Form','',0,'/sites/all/modules/raptor_glue/form//ManageUsersPage.php'),('raptor/protocollib/exportdata','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_adminprotocollibdatadump_form','a:0:{}','',7,3,0,'','raptor/protocollib/exportdata','ProtocolLib Data Export','t','','','a:0:{}',0,'Extract to a file all protocol lib data','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/protocollib/exportxml','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_adminprotocollib_xmldatadump_form','a:0:{}','',7,3,0,'','raptor/protocollib/exportxml','ProtocolLib XML Data Export','t','','','a:0:{}',0,'Extract to an XML file all protocol lib data','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/replaceorder','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_replaceorder_form','a:0:{}','',3,2,0,'','raptor/replaceorder','Replace Order','t','','','a:0:{}',0,'Replace Order Form','',0,'/sites/all/modules/raptor_glue/form//ReplaceOrderPage.php'),('raptor/requestcollaborate','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_requestcollaborate_form','a:0:{}','',3,2,0,'','raptor/requestcollaborate','Request Collaboration','t','','','a:0:{}',0,'Request Collaboration Form','',0,'/sites/all/modules/raptor_glue/form//RequestCollaboratePage.php'),('raptor/resetdatafordemo','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_resetdatafordemo_form','a:0:{}','',3,2,0,'','raptor/resetdatafordemo','Reset data for demo','t','','','a:0:{}',0,'Reset data for demo','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/resetsecondssincelastaction','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_resetsecondssincelastaction_form','a:0:{}','',3,2,0,'','raptor/resetsecondssincelastaction','Reset seconds since last user action','t','','','a:0:{}',0,'Reset number of seconds to zero','',0,''),('raptor/resetworkflow','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_resetworkflow_form','a:0:{}','',3,2,0,'','raptor/resetworkflow','Reset Workflow','t','','','a:0:{}',0,'Reset Workflow Form','',0,'/sites/all/modules/raptor_glue/form//ResetWorkflowPage.php'),('raptor/scheduleticket','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_scheduling_scheduleticket_form','a:0:{}','',3,2,0,'','raptor/scheduleticket','Schedule Ticket','t','','','a:0:{}',0,'Schedule Ticket Form','',0,'sites/all/modules/raptor_scheduling/form//ScheduleTicketPage.php'),('raptor/scheduling/exportdata','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_adminschedulingdatadump_form','a:0:{}','',7,3,0,'','raptor/scheduling/exportdata','Scheduling Data Dump','t','','','a:0:{}',0,'Extract to a file all scheduling data','',0,''),('raptor/scheduling/runtests','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_scheduling_runtests_form','a:0:{}','',7,3,0,'','raptor/scheduling/runtests','Scheduling Test','t','','','a:0:{}',0,'Test scheduling integration','',0,''),('raptor/secondssincelastaction','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_secondssincelastaction_form','a:0:{}','',3,2,0,'','raptor/secondssincelastaction','Seconds since last user action','t','','','a:0:{}',0,'Return the number of seconds since last user action','',0,''),('raptor/seeallurls','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_seeallurls_form','a:0:{}','',3,2,0,'','raptor/seeallurls','See all RAPTOR URLs','t','','','a:0:{}',0,'See all the URLs in RAPTOR application','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/selftest','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_runtests_form','a:0:{}','',3,2,0,'','raptor/selftest','Self Test','t','','','a:0:{}',0,'Run a self test','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/showconversionformulas','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showconversionformulas','Conversion Formulas','t','','','a:0:{}',0,'Shows supported conversion formulas','',0,'/sites/all/modules/raptor_reports/report//ViewReportConversionFormulas.php'),('raptor/showehrdaoperformance','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showehrdaoperformance','Show EHR DAO Performance Details','t','','','a:0:{}',0,'Shows detailed EHR DAO performance results by making calls at runtime as the logged in user.','',0,'/sites/all/modules/raptor_reports/report//ViewEhrDaoPerformance.php'),('raptor/showradiationdosewatch','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showradiationdosewatch','Facility Radiation Dose Watch','t','','','a:0:{}',0,'Shows available facility radiation dose tracking information','',0,'/sites/all/modules/raptor_reports/report//ViewReportRadiationDoseWatch.php'),('raptor/showroomreservations','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showroomreservations','Room Reservations','t','','','a:0:{}',0,'Shows room reservations','',0,'/sites/all/modules/raptor_reports/report//ViewReportRoomReservations.php'),('raptor/showtechsupportconfigdetails','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showtechsupportconfigdetails','Technical Support Configuration Details','t','','','a:0:{}',0,'Shows detailed configuration settings of the installation','',0,'/sites/all/modules/raptor_reports/report//ViewTechSupportConfigDetails.php'),('raptor/showuseractivity','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/showuseractivity','User Activity','t','','','a:0:{}',0,'Shows user login and logout activity times in the system.','',0,'/sites/all/modules/raptor_reports/report//ViewReportUserActivity.php'),('raptor/show_ci_rules','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/show_ci_rules','Contraindication Rules','t','','','a:0:{}',0,'Shows contraindication rules','',0,'/sites/all/modules/raptor_reports/report//ViewReportContraindicationRules.php'),('raptor/start','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_start_form','a:0:{}','',3,2,0,'','raptor/start','Start Landing Page','t','','','a:0:{}',0,'Start using RAPTOR','',0,'/sites/all/modules/raptor_glue/functions//misc.inc'),('raptor/suspendticket','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_suspendticket_form','a:0:{}','',3,2,0,'','raptor/suspendticket','Suspend Ticket','t','','','a:0:{}',0,'Suspend Ticket Form','',0,'/sites/all/modules/raptor_glue/form//SuspendTicketPage.php'),('raptor/ticketlockrefresh','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_ticketlockrefresh_form','a:0:{}','',3,2,0,'','raptor/ticketlockrefresh','Refresh one user ticket lock information','t','','','a:0:{}',0,'Update one user ticket lock information in the database','',0,''),('raptor/ticketlockrelease','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_ticketlockrelease_form','a:0:{}','',3,2,0,'','raptor/ticketlockrelease','Release one user ticket lock','t','','','a:0:{}',0,'Release user ticket lock','',0,''),('raptor/ticketlocksgetinfo','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_ticketlocksgetinfo_form','a:0:{}','',3,2,0,'','raptor/ticketlocksgetinfo','Get ticket lock information','t','','','a:0:{}',0,'Get the ticket lock information','',0,''),('raptor/userinteractionping','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_userinteractionping_form','a:0:{}','',3,2,0,'','raptor/userinteractionping','Get/Set User Alive Info and Ticket Lock Info or Refresh Locks','t','','','a:0:{}',0,'Use parameters as follows<ol><li>No parameters: Get JSON object with user idle time info and ticket lock listing<li>Pass \"refreshlocks\" param to refresh locks instead of getting lock info<li>Pass \"resetsecondssincelastaction\" param to reset the user idle recording</ol>','',0,''),('raptor/users/exportdata','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_adminuserdatadump_form','a:0:{}','',7,3,0,'','raptor/users/exportdata','User Account Data Dump','t','','','a:0:{}',0,'Exract to a file all the non-admin RAPTOR user accounts','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/users/exportxml','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_adminuser_xmldatadump_form','a:0:{}','',7,3,0,'','raptor/users/exportxml','User Account XML Data Dump','t','','','a:0:{}',0,'Exract to a file all the non-admin RAPTOR user accounts as XML','',0,'/sites/all/modules/raptor_glue/functions//admin.inc'),('raptor/viewcontraindication','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_contraindications_viewci_form','a:0:{}','',3,2,0,'','raptor/viewcontraindication','View Contraindication','t','','','a:0:{}',0,'View Contraindications Detail','',0,'/sites/all/modules/raptor_contraindications/form//ViewContraIndicationPage.php'),('raptor/viewprotocollib','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_viewprotocollib_form','a:0:{}','',3,2,0,'','raptor/viewprotocollib','View Protocol Lib','t','','','a:0:{}',0,'View Protocol Lib Form','',0,'/sites/all/modules/raptor_glue/form//ViewProtocolLibPage.php'),('raptor/viewReports','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_viewreports_form','a:0:{}','',3,2,0,'','raptor/viewReports','View Reports','t','','','a:0:{}',0,'View Reports Form','',0,'/sites/all/modules/raptor_reports/form//ManageReportsPage.php'),('raptor/viewrepqascores','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/viewrepqascores','Ticket QA Scores','t','','','a:0:{}',0,'Shows available ticket QA scores in the system','',0,'/sites/all/modules/raptor_reports/report//ViewReportQAScores.php'),('raptor/viewrepusract1','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/viewrepusract1','Department Ticket Processing Activity Analysis','t','','','a:0:{}',0,'Shows analysis of user ticket processing activity in the system','',0,'/sites/all/modules/raptor_reports/report//ViewReportDeptTicketProcessing.php'),('raptor/viewrepusract2','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_reports_runner_form','a:0:{}','',3,2,0,'','raptor/viewrepusract2','User Ticket Processing Activity Analysis','t','','','a:0:{}',0,'Shows analysis of user ticket processing activity in the system','',0,'/sites/all/modules/raptor_reports/report//ViewReportUserTicketProcessing.php'),('raptor/viewscannedprotocol','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_viewscannedprotocol_form','a:0:{}','',3,2,0,'','raptor/viewscannedprotocol','View Scanned Protocol','t','','','a:0:{}',0,'View Scanned Protocol Lib Document','',0,'/sites/all/modules/raptor_glue/form//ViewScannedProtocolLibFile.php'),('raptor/viewuser','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_viewuser_form','a:0:{}','',3,2,0,'','raptor/viewuser','View User Profile','t','','','a:0:{}',0,'View User Profile','',0,'/sites/all/modules/raptor_glue/form//ViewUserPage.php'),('rss.xml','','','user_access','a:1:{i:0;s:14:\"access content\";}','node_feed','a:2:{i:0;b:0;i:1;a:0:{}}','',1,1,0,'','rss.xml','RSS feed','t','','','a:0:{}',0,'','',0,''),('search','','','search_is_active','a:0:{}','search_view','a:0:{}','',1,1,0,'','search','Search','t','','','a:0:{}',20,'','',0,'modules/search/search.pages.inc'),('search/node','','','_search_menu_access','a:1:{i:0;s:4:\"node\";}','search_view','a:2:{i:0;s:4:\"node\";i:1;s:0:\"\";}','',3,2,1,'search','search','Content','t','','','a:0:{}',132,'','',-10,'modules/search/search.pages.inc'),('search/node/%','a:1:{i:2;a:1:{s:14:\"menu_tail_load\";a:2:{i:0;s:4:\"%map\";i:1;s:6:\"%index\";}}}','a:1:{i:2;s:16:\"menu_tail_to_arg\";}','_search_menu_access','a:1:{i:0;s:4:\"node\";}','search_view','a:2:{i:0;s:4:\"node\";i:1;i:2;}','',6,3,1,'search/node','search/node/%','Content','t','','','a:0:{}',132,'','',0,'modules/search/search.pages.inc'),('search/user','','','_search_menu_access','a:1:{i:0;s:4:\"user\";}','search_view','a:2:{i:0;s:4:\"user\";i:1;s:0:\"\";}','',3,2,1,'search','search','Users','t','','','a:0:{}',132,'','',0,'modules/search/search.pages.inc'),('search/user/%','a:1:{i:2;a:1:{s:14:\"menu_tail_load\";a:2:{i:0;s:4:\"%map\";i:1;s:6:\"%index\";}}}','a:1:{i:2;s:16:\"menu_tail_to_arg\";}','_search_menu_access','a:1:{i:0;s:4:\"user\";}','search_view','a:2:{i:0;s:4:\"user\";i:1;i:2;}','',6,3,1,'search/node','search/node/%','Users','t','','','a:0:{}',132,'','',0,'modules/search/search.pages.inc'),('simplerulesengine/runtests','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_core_runtests_form','a:0:{}','',3,2,0,'','simplerulesengine/runtests','Simple Rules Engine Test','t','','','a:0:{}',0,'Test simple rules engine','',0,''),('simplerulesengine_demo/addmeasure','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_addmeasure_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/addmeasure','Add Measure','t','','','a:0:{}',0,'Add Measure Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoAddMeasurePage.php'),('simplerulesengine_demo/addrule','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_addrule_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/addrule','Add Rule','t','','','a:0:{}',0,'Add Rule Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoAddRulePage.php'),('simplerulesengine_demo/deletemeasure','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_deletemeasure_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/deletemeasure','Delete Measure','t','','','a:0:{}',0,'Delete Measure Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoDeleteMeasurePage.php'),('simplerulesengine_demo/deleterule','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_deleterule_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/deleterule','Delete Rule','t','','','a:0:{}',0,'Delete Rule Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoDeleteRulePage.php'),('simplerulesengine_demo/editmeasure','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_editmeasure_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/editmeasure','Edit Measure','t','','','a:0:{}',0,'Edit Measure Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoEditMeasurePage.php'),('simplerulesengine_demo/editrule','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_editrule_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/editrule','Edit Rule','t','','','a:0:{}',0,'Edit Rule Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoEditRulePage.php'),('simplerulesengine_demo/evaluate','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_evaluate_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/evaluate','Demo Evaluate Page','t','','','a:0:{}',0,'Evaluate Rules on Data','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoEvaluatePage.php'),('simplerulesengine_demo/exportxml','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_exportxml_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/exportxml','XML Rulebase Dump','t','','','a:0:{}',0,'Export all the rulebase info in a shareable XML format','',0,''),('simplerulesengine_demo/managemeasures','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_managemeasures_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/managemeasures','Manage Measures','t','','','a:0:{}',0,'Manage Measures Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoManageMeasuresPage.php'),('simplerulesengine_demo/managerules','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_managerules_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/managerules','Manage Rules','t','','','a:0:{}',0,'Manage Rules Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoManageRulesPage.php'),('simplerulesengine_demo/reportrules','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_reportrules_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/reportrules','View Rules','t','','','a:0:{}',0,'View Rules Report','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoReportRules.php'),('simplerulesengine_demo/viewinputs','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_viewinputs_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/viewinputs','View Inputs','t','','','a:0:{}',0,'View Inputs Report','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoReportInputs.php'),('simplerulesengine_demo/viewmeasure','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_viewmeasure_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/viewmeasure','View Measure','t','','','a:0:{}',0,'View Measure Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoViewMeasurePage.php'),('simplerulesengine_demo/viewrule','','','1','a:1:{i:0;s:14:\"access content\";}','simplerulesengine_demo_viewrule_form','a:0:{}','',3,2,0,'','simplerulesengine_demo/viewrule','View Rule','t','','','a:0:{}',0,'View Rule Form','',0,'/sites/all/modules/simplerulesengine_demo/form//DemoViewRulePage.php'),('sites/default/files/styles/%','a:1:{i:4;s:16:\"image_style_load\";}','','1','a:0:{}','image_style_deliver','a:1:{i:0;i:4;}','',30,5,0,'','sites/default/files/styles/%','Generate image style','t','','','a:0:{}',0,'','',0,''),('system/ajax','','','1','a:0:{}','ajax_form_callback','a:0:{}','ajax_deliver',3,2,0,'','system/ajax','AHAH callback','t','','ajax_base_page_theme','a:0:{}',0,'','',0,'includes/form.inc'),('system/files','','','1','a:0:{}','file_download','a:1:{i:0;s:7:\"private\";}','',3,2,0,'','system/files','File download','t','','','a:0:{}',0,'','',0,''),('system/files/styles/%','a:1:{i:3;s:16:\"image_style_load\";}','','1','a:0:{}','image_style_deliver','a:1:{i:0;i:3;}','',14,4,0,'','system/files/styles/%','Generate image style','t','','','a:0:{}',0,'','',0,''),('system/temporary','','','1','a:0:{}','file_download','a:1:{i:0;s:9:\"temporary\";}','',3,2,0,'','system/temporary','Temporary files','t','','','a:0:{}',0,'','',0,''),('system/timezone','','','1','a:0:{}','system_timezone','a:0:{}','',3,2,0,'','system/timezone','Time zone','t','','','a:0:{}',0,'','',0,'modules/system/system.admin.inc'),('taxonomy/autocomplete','','','user_access','a:1:{i:0;s:14:\"access content\";}','taxonomy_autocomplete','a:0:{}','',3,2,0,'','taxonomy/autocomplete','Autocomplete taxonomy','t','','','a:0:{}',0,'','',0,'modules/taxonomy/taxonomy.pages.inc'),('taxonomy/term/%','a:1:{i:2;s:18:\"taxonomy_term_load\";}','','user_access','a:1:{i:0;s:14:\"access content\";}','taxonomy_term_page','a:1:{i:0;i:2;}','',6,3,0,'','taxonomy/term/%','Taxonomy term','taxonomy_term_title','a:1:{i:0;i:2;}','','a:0:{}',6,'','',0,'modules/taxonomy/taxonomy.pages.inc'),('taxonomy/term/%/edit','a:1:{i:2;s:18:\"taxonomy_term_load\";}','','taxonomy_term_edit_access','a:1:{i:0;i:2;}','drupal_get_form','a:3:{i:0;s:18:\"taxonomy_form_term\";i:1;i:2;i:2;N;}','',13,4,1,'taxonomy/term/%','taxonomy/term/%','Edit','t','','','a:0:{}',132,'','',10,'modules/taxonomy/taxonomy.admin.inc'),('taxonomy/term/%/feed','a:1:{i:2;s:18:\"taxonomy_term_load\";}','','user_access','a:1:{i:0;s:14:\"access content\";}','taxonomy_term_feed','a:1:{i:0;i:2;}','',13,4,0,'','taxonomy/term/%/feed','Taxonomy term','taxonomy_term_title','a:1:{i:0;i:2;}','','a:0:{}',0,'','',0,'modules/taxonomy/taxonomy.pages.inc'),('taxonomy/term/%/view','a:1:{i:2;s:18:\"taxonomy_term_load\";}','','user_access','a:1:{i:0;s:14:\"access content\";}','taxonomy_term_page','a:1:{i:0;i:2;}','',13,4,1,'taxonomy/term/%','taxonomy/term/%','View','t','','','a:0:{}',140,'','',0,'modules/taxonomy/taxonomy.pages.inc'),('toolbar/toggle','','','user_access','a:1:{i:0;s:14:\"access toolbar\";}','toolbar_toggle_page','a:0:{}','',3,2,0,'','toolbar/toggle','Toggle drawer visibility','t','','','a:0:{}',0,'','',0,''),('user','','','1','a:0:{}','user_page','a:0:{}','',1,1,0,'','user','User account','user_menu_title','','','a:0:{}',6,'','',-10,'modules/user/user.pages.inc'),('user/%','a:1:{i:1;s:9:\"user_load\";}','','user_view_access','a:1:{i:0;i:1;}','user_view_page','a:1:{i:0;i:1;}','',2,2,0,'','user/%','My account','user_page_title','a:1:{i:0;i:1;}','','a:0:{}',6,'','',0,''),('user/%/cancel','a:1:{i:1;s:9:\"user_load\";}','','user_cancel_access','a:1:{i:0;i:1;}','drupal_get_form','a:2:{i:0;s:24:\"user_cancel_confirm_form\";i:1;i:1;}','',5,3,0,'','user/%/cancel','Cancel account','t','','','a:0:{}',6,'','',0,'modules/user/user.pages.inc'),('user/%/cancel/confirm/%/%','a:3:{i:1;s:9:\"user_load\";i:4;N;i:5;N;}','','user_cancel_access','a:1:{i:0;i:1;}','user_cancel_confirm','a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}','',44,6,0,'','user/%/cancel/confirm/%/%','Confirm account cancellation','t','','','a:0:{}',6,'','',0,'modules/user/user.pages.inc'),('user/%/edit','a:1:{i:1;s:9:\"user_load\";}','','user_edit_access','a:1:{i:0;i:1;}','drupal_get_form','a:2:{i:0;s:17:\"user_profile_form\";i:1;i:1;}','',5,3,1,'user/%','user/%','Edit','t','','','a:0:{}',132,'','',0,'modules/user/user.pages.inc'),('user/%/edit/account','a:1:{i:1;a:1:{s:18:\"user_category_load\";a:2:{i:0;s:4:\"%map\";i:1;s:6:\"%index\";}}}','','user_edit_access','a:1:{i:0;i:1;}','drupal_get_form','a:2:{i:0;s:17:\"user_profile_form\";i:1;i:1;}','',11,4,1,'user/%/edit','user/%','Account','t','','','a:0:{}',140,'','',0,'modules/user/user.pages.inc'),('user/%/shortcuts','a:1:{i:1;s:9:\"user_load\";}','','shortcut_set_switch_access','a:1:{i:0;i:1;}','drupal_get_form','a:2:{i:0;s:19:\"shortcut_set_switch\";i:1;i:1;}','',5,3,1,'user/%','user/%','Shortcuts','t','','','a:0:{}',132,'','',0,'modules/shortcut/shortcut.admin.inc'),('user/%/view','a:1:{i:1;s:9:\"user_load\";}','','user_view_access','a:1:{i:0;i:1;}','user_view_page','a:1:{i:0;i:1;}','',5,3,1,'user/%','user/%','View','t','','','a:0:{}',140,'','',-10,''),('user/autocomplete','','','user_access','a:1:{i:0;s:20:\"access user profiles\";}','user_autocomplete','a:0:{}','',3,2,0,'','user/autocomplete','User autocomplete','t','','','a:0:{}',0,'','',0,'modules/user/user.pages.inc'),('user/login','','','user_is_anonymous','a:0:{}','user_page','a:0:{}','',3,2,1,'user','user','Log in','t','','','a:0:{}',140,'','',0,'modules/user/user.pages.inc'),('user/logout','','','user_is_logged_in','a:0:{}','user_logout','a:0:{}','',3,2,0,'','user/logout','Log out','t','','','a:0:{}',6,'','',10,'modules/user/user.pages.inc'),('user/password','','','0','a:0:{}','drupal_get_form','a:1:{i:0;s:9:\"user_pass\";}','',3,2,1,'user','user','Request new password','t','','','a:0:{}',132,'','',0,'modules/user/user.pages.inc'),('user/register','','','0','a:0:{}','drupal_get_form','a:1:{i:0;s:18:\"user_register_form\";}','',3,2,1,'user','user','Create new account','t','','','a:0:{}',132,'','',0,''),('user/reset/%/%/%','a:3:{i:2;N;i:3;N;i:4;N;}','','1','a:0:{}','drupal_get_form','a:4:{i:0;s:15:\"user_pass_reset\";i:1;i:2;i:2;i:3;i:3;i:4;}','',24,5,0,'','user/reset/%/%/%','Reset password','t','','','a:0:{}',0,'','',0,'modules/user/user.pages.inc'),('worklist','','','1','a:1:{i:0;s:14:\"access content\";}','raptor_glue_worklist_form','a:0:{}','',1,1,0,'','worklist','Worklist','t','','','a:0:{}',0,'The RAPTOR Worklist Page','',0,'/sites/all/modules/raptor_glue/form//WorklistPage.php');
/*!40000 ALTER TABLE `menu_router` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `node`
--

DROP TABLE IF EXISTS `node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for a node.',
  `vid` int(10) unsigned DEFAULT NULL COMMENT 'The current node_revision.vid version identifier.',
  `type` varchar(32) NOT NULL DEFAULT '' COMMENT 'The node_type.type of this node.',
  `language` varchar(12) NOT NULL DEFAULT '' COMMENT 'The languages.language of this node.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this node, always treated as non-markup plain text.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that owns this node; initially, this is the user that created it.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node is published (visible to non-administrators).',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was created.',
  `changed` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp when the node was most recently saved.',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node: 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed on the front page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node should be displayed at the top of lists in which it appears.',
  `tnid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The translation set id for this node, which equals the node id of the source post in each set.',
  `translate` int(11) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this translation page needs to be updated.',
  PRIMARY KEY (`nid`),
  UNIQUE KEY `vid` (`vid`),
  KEY `node_changed` (`changed`),
  KEY `node_created` (`created`),
  KEY `node_frontpage` (`promote`,`status`,`sticky`,`created`),
  KEY `node_status_type` (`status`,`type`,`nid`),
  KEY `node_title_type` (`title`,`type`(4)),
  KEY `node_type` (`type`(4)),
  KEY `uid` (`uid`),
  KEY `tnid` (`tnid`),
  KEY `translate` (`translate`),
  KEY `language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='The base table for nodes.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `node`
--

LOCK TABLES `node` WRITE;
/*!40000 ALTER TABLE `node` DISABLE KEYS */;
INSERT INTO `node` VALUES (1,1,'page','','Welcome to your new Acquia Drupal website!',1,1,1417212358,1417212358,0,1,0,0,0);
/*!40000 ALTER TABLE `node` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `node_access`
--

DROP TABLE IF EXISTS `node_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node_access` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid this record affects.',
  `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row’s privileges on the node.',
  `realm` varchar(255) NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Each node access node can define one or more realms.',
  `grant_view` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this node.',
  `grant_update` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this node.',
  `grant_delete` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this node.',
  PRIMARY KEY (`nid`,`gid`,`realm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Identifies which realm/grant pairs a user must possess in...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `node_access`
--

LOCK TABLES `node_access` WRITE;
/*!40000 ALTER TABLE `node_access` DISABLE KEYS */;
INSERT INTO `node_access` VALUES (0,0,'all',1,0,0);
/*!40000 ALTER TABLE `node_access` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `node_comment_statistics`
--

DROP TABLE IF EXISTS `node_comment_statistics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node_comment_statistics` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid for which the statistics are compiled.',
  `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid of the last comment.',
  `last_comment_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from comment.changed.',
  `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from comment.name.',
  `last_comment_uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from comment.uid.',
  `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this node.',
  PRIMARY KEY (`nid`),
  KEY `node_comment_timestamp` (`last_comment_timestamp`),
  KEY `comment_count` (`comment_count`),
  KEY `last_comment_uid` (`last_comment_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maintains statistics of node and comments posts to show ...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `node_comment_statistics`
--

LOCK TABLES `node_comment_statistics` WRITE;
/*!40000 ALTER TABLE `node_comment_statistics` DISABLE KEYS */;
INSERT INTO `node_comment_statistics` VALUES (1,0,1417212358,NULL,1,0);
/*!40000 ALTER TABLE `node_comment_statistics` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `node_revision`
--

DROP TABLE IF EXISTS `node_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node_revision` (
  `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node this version belongs to.',
  `vid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The primary identifier for this version.',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that created this version.',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'The title of this version.',
  `log` longtext NOT NULL COMMENT 'The log entry explaining the changes in this version.',
  `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when this version was created.',
  `status` int(11) NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether the node (at the time of this revision) is published (visible to non-administrators).',
  `comment` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this node (at the time of this revision): 0 = no, 1 = closed (read only), 2 = open (read/write).',
  `promote` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed on the front page.',
  `sticky` int(11) NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether the node (at the time of this revision) should be displayed at the top of lists in which it appears.',
  PRIMARY KEY (`vid`),
  KEY `nid` (`nid`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='Stores information about each saved version of a node.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `node_revision`
--

LOCK TABLES `node_revision` WRITE;
/*!40000 ALTER TABLE `node_revision` DISABLE KEYS */;
INSERT INTO `node_revision` VALUES (1,1,1,'Welcome to your new Acquia Drupal website!','',1417212358,1,0,1,0);
/*!40000 ALTER TABLE `node_revision` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `node_type`
--

DROP TABLE IF EXISTS `node_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node_type` (
  `type` varchar(32) NOT NULL COMMENT 'The machine-readable name of this type.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The human-readable name of this type.',
  `base` varchar(255) NOT NULL COMMENT 'The base string used to construct callbacks corresponding to this node type.',
  `module` varchar(255) NOT NULL COMMENT 'The module defining this node type.',
  `description` mediumtext NOT NULL COMMENT 'A brief description of this type.',
  `help` mediumtext NOT NULL COMMENT 'Help information shown to the user when creating a node of this type.',
  `has_title` tinyint(3) unsigned NOT NULL COMMENT 'Boolean indicating whether this type uses the node.title field.',
  `title_label` varchar(255) NOT NULL DEFAULT '' COMMENT 'The label displayed for the title field on the edit form.',
  `custom` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this type is defined by a module (FALSE) or by a user via Add content type (TRUE).',
  `modified` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this type has been modified by an administrator; currently not used in any way.',
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether the administrator can change the machine name of this type.',
  `disabled` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether the node type is disabled.',
  `orig_type` varchar(255) NOT NULL DEFAULT '' COMMENT 'The original machine-readable name of this node type. This may be different from the current type name if the locked field is 0.',
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores information about all defined node types.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `node_type`
--

LOCK TABLES `node_type` WRITE;
/*!40000 ALTER TABLE `node_type` DISABLE KEYS */;
INSERT INTO `node_type` VALUES ('article','Article','node_content','node','Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.','',1,'Title',1,1,0,0,'article'),('page','Basic page','node_content','node','Use <em>basic pages</em> for your static content, such as an \'About us\' page.','',1,'Title',1,1,0,0,'page');
/*!40000 ALTER TABLE `node_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue` (
  `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique item ID.',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT 'The queue name.',
  `data` longblob COMMENT 'The arbitrary data for the item.',
  `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the claim lease expires on the item.',
  `created` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the item was created.',
  PRIMARY KEY (`item_id`),
  KEY `name_created` (`name`,`created`),
  KEY `expire` (`expire`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Stores items in queues.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `queue`
--

LOCK TABLES `queue` WRITE;
/*!40000 ALTER TABLE `queue` DISABLE KEYS */;
/*!40000 ALTER TABLE `queue` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_about`
--

DROP TABLE IF EXISTS `raptor_about`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_about` (
  `category_nm` varchar(20) NOT NULL COMMENT 'Information category',
  `info_tx` varchar(100) DEFAULT NULL COMMENT 'The information text to show',
  `major_ct` int(10) unsigned DEFAULT '1' COMMENT 'Major info number, sometimes useful for versioning',
  `minor_ct` int(10) unsigned DEFAULT '1' COMMENT 'Minor info number, sometimes useful for versioning',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Information about this RAPTOR installation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_about`
--

LOCK TABLES `raptor_about` WRITE;
/*!40000 ALTER TABLE `raptor_about` DISABLE KEYS */;
INSERT INTO `raptor_about` VALUES ('DBSchemaVersion','Initial installation',2015,8,'2015-10-02 14:52:16');
/*!40000 ALTER TABLE `raptor_about` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_atrisk_allergy_contrast`
--

DROP TABLE IF EXISTS `raptor_atrisk_allergy_contrast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_atrisk_allergy_contrast` (
  `keyword` varchar(50) NOT NULL COMMENT 'Keyword for text matching',
  PRIMARY KEY (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keywords to match with known patient allergies considered...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_atrisk_allergy_contrast`
--

LOCK TABLES `raptor_atrisk_allergy_contrast` WRITE;
/*!40000 ALTER TABLE `raptor_atrisk_allergy_contrast` DISABLE KEYS */;
INSERT INTO `raptor_atrisk_allergy_contrast` VALUES ('Contrast'),('Gadolinium'),('interavascular'),('Iodinated'),('Iodine');
/*!40000 ALTER TABLE `raptor_atrisk_allergy_contrast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_atrisk_bloodthinner`
--

DROP TABLE IF EXISTS `raptor_atrisk_bloodthinner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_atrisk_bloodthinner` (
  `keyword` varchar(50) NOT NULL COMMENT 'Keyword for text matching',
  PRIMARY KEY (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keywords to match with known blood thinning medications';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_atrisk_bloodthinner`
--

LOCK TABLES `raptor_atrisk_bloodthinner` WRITE;
/*!40000 ALTER TABLE `raptor_atrisk_bloodthinner` DISABLE KEYS */;
INSERT INTO `raptor_atrisk_bloodthinner` VALUES ('Lovenox'),('Metaglys'),('Metformin'),('Plavix'),('Proleukin'),('Warfarin');
/*!40000 ALTER TABLE `raptor_atrisk_bloodthinner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_atrisk_meds`
--

DROP TABLE IF EXISTS `raptor_atrisk_meds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_atrisk_meds` (
  `keyword` varchar(50) NOT NULL COMMENT 'Keyword for text matching',
  PRIMARY KEY (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keywords to match with medications considered to be at...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_atrisk_meds`
--

LOCK TABLES `raptor_atrisk_meds` WRITE;
/*!40000 ALTER TABLE `raptor_atrisk_meds` DISABLE KEYS */;
INSERT INTO `raptor_atrisk_meds` VALUES ('Aldesleukin'),('Aspirin'),('Avandamet'),('Clopidogrel'),('Coumadin'),('Dalteparin'),('Enoxaparin'),('Fragmin'),('Glucophage'),('Glucovance'),('Heparin'),('Lovenox'),('Metaglys'),('Metformin'),('Plavix'),('Proleukin'),('Sample'),('Warfarin');
/*!40000 ALTER TABLE `raptor_atrisk_meds` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_atrisk_rare_contrast`
--

DROP TABLE IF EXISTS `raptor_atrisk_rare_contrast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_atrisk_rare_contrast` (
  `keyword` varchar(50) NOT NULL COMMENT 'Keyword for text matching',
  PRIMARY KEY (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keywords to match with known controlled or rare contrast';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_atrisk_rare_contrast`
--

LOCK TABLES `raptor_atrisk_rare_contrast` WRITE;
/*!40000 ALTER TABLE `raptor_atrisk_rare_contrast` DISABLE KEYS */;
INSERT INTO `raptor_atrisk_rare_contrast` VALUES ('Ablavar');
/*!40000 ALTER TABLE `raptor_atrisk_rare_contrast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_atrisk_rare_radioisotope`
--

DROP TABLE IF EXISTS `raptor_atrisk_rare_radioisotope`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_atrisk_rare_radioisotope` (
  `keyword` varchar(50) NOT NULL COMMENT 'Keyword for text matching',
  PRIMARY KEY (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Keywords to match with known controlled or rare radioisotope';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_atrisk_rare_radioisotope`
--

LOCK TABLES `raptor_atrisk_rare_radioisotope` WRITE;
/*!40000 ALTER TABLE `raptor_atrisk_rare_radioisotope` DISABLE KEYS */;
INSERT INTO `raptor_atrisk_rare_radioisotope` VALUES ('MAG3');
/*!40000 ALTER TABLE `raptor_atrisk_rare_radioisotope` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_boilerplate_exam`
--

DROP TABLE IF EXISTS `raptor_boilerplate_exam`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_boilerplate_exam` (
  `category_tx` varchar(50) NOT NULL DEFAULT '' COMMENT 'Category of the text',
  `title_tx` varchar(40) NOT NULL DEFAULT '' COMMENT 'Short title for the text',
  `content_tx` varchar(250) NOT NULL DEFAULT '' COMMENT 'Description of the location',
  PRIMARY KEY (`category_tx`,`title_tx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Boilerplate text options for exam step';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_boilerplate_exam`
--

LOCK TABLES `raptor_boilerplate_exam` WRITE;
/*!40000 ALTER TABLE `raptor_boilerplate_exam` DISABLE KEYS */;
INSERT INTO `raptor_boilerplate_exam` VALUES ('General','Difficult Patient','Image quality is reduced by [<artifact>] because patient [<reason>].'),('General','Extravasation','Extravasation of IV contrast occurred. [<>] cc of [<type>] at [<anatomy>].');
/*!40000 ALTER TABLE `raptor_boilerplate_exam` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_boilerplate_protocol`
--

DROP TABLE IF EXISTS `raptor_boilerplate_protocol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_boilerplate_protocol` (
  `category_tx` varchar(50) NOT NULL DEFAULT '' COMMENT 'Category of the text',
  `title_tx` varchar(40) NOT NULL DEFAULT '' COMMENT 'Short title for the text',
  `content_tx` varchar(250) NOT NULL DEFAULT '' COMMENT 'Description of the location',
  PRIMARY KEY (`category_tx`,`title_tx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Boilerplate text options for protocol step';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_boilerplate_protocol`
--

LOCK TABLES `raptor_boilerplate_protocol` WRITE;
/*!40000 ALTER TABLE `raptor_boilerplate_protocol` DISABLE KEYS */;
INSERT INTO `raptor_boilerplate_protocol` VALUES ('General','Labs Needed','Scheduler, please assure patient gets renal function laboratory blood draw prior to exam.'),('General','Mass Markers','Technologist, please bracket mass with skin surface markers prior to scanning.'),('General','On Table Check','Technologist, please have Radiologist check images while patient is still on table.'),('General','Unauthorized Provider','Unauthorized ordering provider for this joint MRI examination. Please contact provider and recommend referral to Orthopedics, Rehabilitation Medicine, or Rheumatology.'),('Hydration','IV Inpatient','Normal saline 1-2 mL/kg/hour for 12 hours before and after scan'),('Hydration','IV Outpatient','Normal saline 1-2 mL/kg/hour for 3-6 hours before and after scan'),('Hydration','Oral','500 cc water during 2 hr before scan + 500 cc water during 2 hrs after scan'),('Premedication','Diphenhydramine ',' Diphenhydramine 25 mg PO 1 hr before scan for either protocol above'),('Premedication','Emergency',' Emergency protocol – Hydrocortisone 200 mg IV 6 hr before scan, 0 hr before scan, and 4-6 hr after scan + diphenhydramine 50 mg PO or IM or IV 1 hr before scan'),('Premedication','Methylprednisolone','Methylprednisolone 32 mg PO @ 12 hr and 2 hr before scan'),('Premedication','Prednisone','Prednisone 50 mg PO @ 13 hr, 7 hr and 1 hr before scan');
/*!40000 ALTER TABLE `raptor_boilerplate_protocol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_cache_data`
--

DROP TABLE IF EXISTS `raptor_cache_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_cache_data` (
  `uid` int(10) unsigned NOT NULL COMMENT 'Who owns this data',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created',
  `retry_delay` int(10) unsigned NOT NULL COMMENT 'Seconds to wait before retry a cache read',
  `max_age` int(10) unsigned NOT NULL COMMENT 'This data expires after this many seconds',
  `group_name` varchar(50) NOT NULL COMMENT 'Group to which this data belongs',
  `item_name` varchar(50) NOT NULL COMMENT 'Specific name of data in the group',
  `item_data` mediumblob NOT NULL COMMENT 'The cached data',
  PRIMARY KEY (`uid`,`group_name`,`item_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Runtime cached data';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_cache_data`
--

LOCK TABLES `raptor_cache_data` WRITE;
/*!40000 ALTER TABLE `raptor_cache_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_cache_data` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_cache_flag`
--

DROP TABLE IF EXISTS `raptor_cache_flag`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_cache_flag` (
  `uid` int(10) unsigned NOT NULL COMMENT 'Who owns this data',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created',
  `retry_delay` int(10) unsigned NOT NULL COMMENT 'Seconds to wait before retry a flag read',
  `max_age` int(10) unsigned NOT NULL COMMENT 'This flag expires after this many seconds',
  `group_name` varchar(50) NOT NULL COMMENT 'Group to which this flag belongs',
  `item_name` varchar(50) NOT NULL COMMENT 'Specific name of item in the group',
  `flag_name` varchar(20) NOT NULL COMMENT 'Specific name of flag in the group',
  `flag_value` int(10) unsigned NOT NULL COMMENT 'Value of the flag',
  PRIMARY KEY (`uid`,`group_name`,`item_name`,`flag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Runtime cache flags';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_cache_flag`
--

LOCK TABLES `raptor_cache_flag` WRITE;
/*!40000 ALTER TABLE `raptor_cache_flag` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_cache_flag` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_checklist_question`
--

DROP TABLE IF EXISTS `raptor_checklist_question`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_checklist_question` (
  `type_cd` varchar(2) NOT NULL COMMENT 'Safety Checklist = SC',
  `relative_position` int(10) unsigned NOT NULL DEFAULT '500' COMMENT 'Lower numbers are asked before higher numbered questions',
  `modality_abbr` varchar(2) NOT NULL DEFAULT '' COMMENT 'Modality abbreviation or empty if question applies to all modalities',
  `protocol_shortname` varchar(20) NOT NULL DEFAULT '' COMMENT 'A specific protocol for this question or empty if question applies to all protocols',
  `question_shortname` varchar(20) NOT NULL COMMENT 'Uniquely identify the current version of a question',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The version number of this question must be incremented if the text is ever updated',
  `question_tx` varchar(512) NOT NULL COMMENT 'Question to ask the user',
  `ask_yes_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer Yes',
  `ask_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer No',
  `ask_notsure_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer Not Sure',
  `ask_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User will be prompted to answer Not Applicable',
  `always_require_comment_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then comment is always required for this question.',
  `trigger_comment_on_yes_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then comment is requird when user answers Yes',
  `trigger_comment_on_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers No',
  `trigger_comment_on_notsure_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers Not Sure',
  `trigger_comment_on_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers Not Applicable',
  `comment_prompt_tx` varchar(128) DEFAULT 'Explanation' COMMENT 'Prompt to show the user when asking for a comment',
  `failed_on_yes_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Yes',
  `failed_on_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then question is considered failed when user answers No',
  `failed_on_notsure_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Not Sure',
  `failed_on_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Not Applicable',
  `the_okay_answer_tx` varchar(16) DEFAULT 'yes' COMMENT 'Identify the answer that indicates the good scenario.  Possible values are yes,no,notsure,notapplicable.  Leave as NULL if no answer is considered special.',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created',
  PRIMARY KEY (`question_shortname`),
  KEY `raptor_checklist_question_sorted_idx` (`type_cd`,`modality_abbr`,`protocol_shortname`,`relative_position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Checklist questions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_checklist_question`
--

LOCK TABLES `raptor_checklist_question` WRITE;
/*!40000 ALTER TABLE `raptor_checklist_question` DISABLE KEYS */;
INSERT INTO `raptor_checklist_question` VALUES ('SC',16,'CT','','GOT_IMG_PROTOCOL',1,'Correct imaging protocol?',1,1,1,1,0,0,1,1,1,'Explain why the imaging protocol does not appear to be correct and what action you will take.',0,1,0,0,'yes','2015-10-02 14:52:16'),('SC',12,'','','GOT_IMG_SITE',1,'Confirmed imaging site?',1,1,1,0,0,0,1,1,1,'Explain why the imaging site cannot be confirmed.',0,1,0,0,'yes','2015-10-02 14:52:16'),('SC',10,'','','GOT_PATIENT',1,'Correct patient?',1,1,1,0,0,0,1,1,1,'Explain why the patient identity cannot be confirmed as appropriate for the procedure.',0,1,0,0,'yes','2015-10-02 14:52:16'),('SC',14,'','','SET_PAT_POSITION',1,'Correct patient positioning?',1,1,1,0,0,0,1,1,1,'Explain why the correct positioning cannot be answered as Yes.',0,1,0,0,'yes','2015-10-02 14:52:16'),('SC',18,'CT','','SET_SCNR_PARAMS',1,'Correct scanner parameters?',1,1,1,1,0,0,1,1,1,'Explain why you cannot confirm the scanner parameters are correct for this procedure.',0,1,0,0,'yes','2015-10-02 14:52:16');
/*!40000 ALTER TABLE `raptor_checklist_question` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_checklist_question_replaced`
--

DROP TABLE IF EXISTS `raptor_checklist_question_replaced`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_checklist_question_replaced` (
  `type_cd` varchar(2) NOT NULL COMMENT 'Safety Checklist = SC',
  `relative_position` int(10) unsigned NOT NULL DEFAULT '500' COMMENT 'Lower numbers are asked before higher numbered questions',
  `modality_abbr` varchar(2) NOT NULL DEFAULT '' COMMENT 'Modality abbreviation or empty if question applies to all modalities',
  `protocol_shortname` varchar(20) NOT NULL DEFAULT '' COMMENT 'A specific protocol for this question or empty if question applies to all protocols',
  `question_shortname` varchar(20) NOT NULL COMMENT 'Uniquely identify the current version of a question',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The version number of this question must be incremented if the text is ever updated',
  `question_tx` varchar(512) NOT NULL COMMENT 'Question to ask the user',
  `ask_yes_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer Yes',
  `ask_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer No',
  `ask_notsure_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'User will be prompted to answer Not Sure',
  `ask_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User will be prompted to answer Not Applicable',
  `always_require_comment_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then comment is always required for this question.',
  `trigger_comment_on_yes_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then comment is requird when user answers Yes',
  `trigger_comment_on_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers No',
  `trigger_comment_on_notsure_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers Not Sure',
  `trigger_comment_on_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then comment is requird when user answers Not Applicable',
  `comment_prompt_tx` varchar(128) DEFAULT 'Explanation' COMMENT 'Prompt to show the user when asking for a comment',
  `failed_on_yes_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Yes',
  `failed_on_no_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 1 then question is considered failed when user answers No',
  `failed_on_notsure_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Not Sure',
  `failed_on_notapplicable_yn` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'If 1 then question is considered failed when user answers Not Applicable',
  `the_okay_answer_tx` varchar(16) DEFAULT 'yes' COMMENT 'Identify the answer that indicates the good scenario.  Possible values are yes,no,notsure,notapplicable.  Leave as NULL if no answer is considered special.',
  `created_dt` datetime NOT NULL COMMENT 'When this record was originally created',
  `replaced_dt` datetime NOT NULL COMMENT 'When this record was replaced'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Replaced checklist questions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_checklist_question_replaced`
--

LOCK TABLES `raptor_checklist_question_replaced` WRITE;
/*!40000 ALTER TABLE `raptor_checklist_question_replaced` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_checklist_question_replaced` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_contraindication_measure`
--

DROP TABLE IF EXISTS `raptor_contraindication_measure`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_contraindication_measure` (
  `category_nm` varchar(20) NOT NULL COMMENT 'Simply for grouping in a logical way',
  `measure_nm` varchar(40) NOT NULL COMMENT 'The measure name',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The version number of this measure',
  `return_type` varchar(20) NOT NULL COMMENT 'The returned data type',
  `purpose_tx` varchar(1024) NOT NULL COMMENT 'Static text describing purpose of this measure',
  `criteria_tx` varchar(4000) DEFAULT NULL COMMENT 'The measure formula or INPUT if no formula',
  `readonly_yn` int(11) NOT NULL DEFAULT '0' COMMENT 'If 1 then this measure record should not be edited',
  `active_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 0 then this measure is not available for use in new expressions',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was updated',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created',
  PRIMARY KEY (`measure_nm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A measure used by the simple rules engine';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_contraindication_measure`
--

LOCK TABLES `raptor_contraindication_measure` WRITE;
/*!40000 ALTER TABLE `raptor_contraindication_measure` DISABLE KEYS */;
INSERT INTO `raptor_contraindication_measure` VALUES ('Renal','HAS_ACUTE_LOW_EGFR',1,'boolean','Does the patient have sudden low EGFR?','(LATEST_EGFR < 60) and (MIN_EGFR_60DAYS > 89) ',0,1,'2015-08-20 15:00:00','2014-08-01 00:00:00'),('Contrast','HAS_ANY_CONTRAST',1,'boolean','Has any contrast been selected for this patient?','GIVE_CONTRAST_ENTERIC or GIVE_CONTRAST_IV',0,1,'2014-07-29 00:00:00','2014-07-29 00:00:00'),('Radioisotope','HAS_ANY_RADIOISOTOPE',1,'boolean','Will this patient require any radioisotopes?','GIVE_RADIOISOTOPE_ENTERIC or GIVE_RADIOISOTOPE_IV',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Sedation','HAS_ANY_SEDATION',1,'boolean','Will this patient receive any sedation?','GIVE_SEDATION_ORAL or GIVE_SEDATION_IV',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Renal','HAS_ATRISK_MEDS',1,'boolean','Is this patient taking any medications from at-risk list?','CURRENT_MEDS somematch KWL_ATRISK_MEDS',0,1,'2015-09-14 00:00:00','2015-09-14 00:00:00'),('Blood','HAS_BLOODTHINNER',1,'boolean','Is this patient taking any medications from the blood thinner list?','CURRENT_MEDS somematch KWL_BLOOD_THINNER',0,1,'2014-08-14 00:00:00','2014-08-14 00:00:00'),('Renal','HAS_CHRONIC_LOW_EGFR',1,'boolean','Does the patient have low EGFR and show a trend down?','(LATEST_EGFR < 60) and (MIN_EGFR_90DAYS >= MIN_EGFR_30DAYS) ',0,1,'2015-08-20 15:00:00','2014-08-01 00:00:00'),('Allergy','HAS_CONTRAST_ALLERGY',1,'boolean','Does the patient\'s allergy list match any contrast allergen keywords?','CURRENT_ALLERGIES somematch KWL_CONTRAST_ALLERGY_INDICATOR',0,1,'2014-08-02 00:00:00','2014-08-02 00:00:00'),('Renal','HAS_EGFR_OVER_89',1,'boolean','Does the patient have a good eGFR reading?','LATEST_EGFR > 90',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Renal','HAS_EGFR_UNDER_30',1,'boolean','Does the patient have a critically low eGFR reading?','LATEST_EGFR < 30',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Renal','HAS_EGFR_UNDER_60',1,'boolean','Does the patient have a borderline low eGFR reading?','LATEST_EGFR < 60',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Renal','HAS_KIDNEY_FAILURE',1,'boolean','Does the patient have kidney failure?','LATEST_EGFR < 15',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Availability','HAS_RARE_CONTRAST',1,'boolean','Does the patient\'s contrast dose list match any of the rare or specially controlled contrast keywords?','CURRENT_CONTRASTS somematch KWL_RARE_CONTRAST',0,1,'2015-08-20 18:00:00','2014-08-30 00:00:00'),('Availability','HAS_RARE_RADIOISOTOPE',1,'boolean','Does the patient\'s radioisotope dose list match any of the rare or specially controlled radioisotope keywords?','CURRENT_RADIOISOTOPES somematch KWL_RARE_RADIOISOTOPE',0,1,'2015-08-20 18:00:00','2014-08-30 00:00:00'),('Gender','IS_FEMALE',1,'boolean','Is this patient a woman?','GENDER = \"F\"',0,1,'2014-07-31 00:00:00','2014-07-31 00:00:00'),('Size','IS_HEAVY',1,'boolean','Is this a large patient that may need special considerations for equipment?','WEIGHT_KG > 140',0,1,'2014-08-01 00:00:00','2014-08-01 00:00:00'),('Gender','IS_MALE',1,'boolean','Is this patient a man?','GENDER = \"M\"',0,1,'2014-07-31 00:00:00','2014-07-31 00:00:00'),('Modality','IS_MODALITY_CT',1,'boolean','Is the selected modality Computed Tomography?','MODALITY = \"CT\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Modality','IS_MODALITY_FL',1,'boolean','Is the selected modality Fluoroscopy?','MODALITY = \"FL\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Modality','IS_MODALITY_IR',1,'boolean','Is the selected modality Interventional Radiology?','MODALITY = \"IR\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Modality','IS_MODALITY_MR',1,'boolean','Is the selected modality Magnetic Resonance Imaging ?','MODALITY = \"MR\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Modality','IS_MODALITY_NM',1,'boolean','Is the selected modality Nuclear Medicine?','MODALITY = \"NM\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Modality','IS_MODALITY_US',1,'boolean','Is the selected modality Ultrasound?','MODALITY = \"US\"',0,1,'2014-10-01 00:00:00','2014-10-01 00:00:00'),('Age','IS_OVER_AGE_60',1,'boolean','Is this patient over age 60?','AGE > 60',0,1,'2014-07-29 00:00:00','2014-07-29 00:00:00'),('Age','IS_UNDER_AGE_18',1,'boolean','Is this patient under age 18?','AGE < 18',0,1,'2015-08-20 15:00:00','2015-08-20 15:00:00'),('Age','IS_UNDER_AGE_50',1,'boolean','Is this patient under age 50?','AGE < 50',0,1,'2014-07-31 00:00:00','2014-07-31 00:00:00'),('Age','IS_UNDER_AGE_60',1,'boolean','Is this patient under age 60?','AGE < 60',0,1,'2015-08-20 15:00:00','2015-08-20 15:00:00'),('Medication','KWL_ATRISK_MEDS',1,'array of text','If patient has medication that matches any of these keywords then this indicates they are taking an at-risk medication','TEXT FROM MANAGED LIST',0,1,'2015-09-14 00:00:00','2015-09-14 00:00:00'),('Medication','KWL_BLOOD_THINNER',1,'array of text','If patient has medication that matches any of these keywords then this indicates they are on a blood thinner.','TEXT FROM MANAGED LIST',0,1,'2014-09-24 00:00:00','2014-09-24 00:00:00'),('Contrast','KWL_CONTRAST_ALLERGY_INDICATOR',1,'array of text','If patient has allergy that matches any of these keywords then there is a possible contrast allergy.','TEXT FROM MANAGED LIST',0,1,'2014-09-24 00:00:00','2014-09-24 00:00:00'),('Policy','KWL_RARE_CONTRAST',1,'array of text','If order has contrast that matches any of these keywords then this indicates that a rare or special procurement contrast has been selected.','TEXT FROM MANAGED LIST',0,1,'2014-09-24 00:00:00','2014-09-24 00:00:00'),('Policy','KWL_RARE_RADIOISOTOPE',1,'array of keywords','If order has radioisotope that matches any of these keywords then this indicates that a rare or special procurement radioisotope has been selected.','TEXT FROM MANAGED LIST',0,1,'2014-09-24 00:00:00','2014-09-24 00:00:00');
/*!40000 ALTER TABLE `raptor_contraindication_measure` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_contraindication_measure_replaced`
--

DROP TABLE IF EXISTS `raptor_contraindication_measure_replaced`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_contraindication_measure_replaced` (
  `category_nm` varchar(20) NOT NULL COMMENT 'Simply for grouping in a logical way',
  `measure_nm` varchar(40) NOT NULL COMMENT 'The measure name',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The version number of this measure',
  `return_type` varchar(20) NOT NULL COMMENT 'The returned data type',
  `purpose_tx` varchar(1024) NOT NULL COMMENT 'Static text describing purpose of this measure',
  `criteria_tx` varchar(4000) DEFAULT NULL COMMENT 'The measure formula or INPUT if no formula',
  `readonly_yn` int(11) NOT NULL DEFAULT '0' COMMENT 'If 1 then this measure record should not be edited',
  `active_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'If 0 then this measure is not available for use in new expressions',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was updated',
  `created_dt` datetime NOT NULL COMMENT 'When this record was created',
  PRIMARY KEY (`measure_nm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A measure used by the simple rules engine';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_contraindication_measure_replaced`
--

LOCK TABLES `raptor_contraindication_measure_replaced` WRITE;
/*!40000 ALTER TABLE `raptor_contraindication_measure_replaced` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_contraindication_measure_replaced` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_contraindication_rule`
--

DROP TABLE IF EXISTS `raptor_contraindication_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_contraindication_rule` (
  `category_nm` varchar(20) NOT NULL COMMENT 'Simply for grouping rules in a logical way',
  `rule_nm` varchar(40) NOT NULL COMMENT 'Must be unique',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Increases each time change is saved',
  `summary_msg_tx` varchar(80) NOT NULL COMMENT 'Static summary text to show the user when rule is triggered',
  `msg_tx` varchar(512) NOT NULL COMMENT 'Text to show the user when rule is triggered',
  `explanation` varchar(2048) NOT NULL COMMENT 'Explanation of the rule purpose',
  `req_ack_yn` int(11) NOT NULL DEFAULT '1' COMMENT 'If 1 then an acknowledgement is required',
  `trigger_crit` varchar(4000) NOT NULL COMMENT 'The criteria that triggers the rule',
  `readonly_yn` int(11) NOT NULL DEFAULT '0' COMMENT 'If 1 then this rule record cannot be edited',
  `active_yn` int(11) NOT NULL DEFAULT '1' COMMENT 'If 0 then this rule is not active',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  `created_dt` datetime DEFAULT NULL COMMENT 'When this record was created',
  PRIMARY KEY (`rule_nm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A simple rules engine rule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_contraindication_rule`
--

LOCK TABLES `raptor_contraindication_rule` WRITE;
/*!40000 ALTER TABLE `raptor_contraindication_rule` DISABLE KEYS */;
INSERT INTO `raptor_contraindication_rule` VALUES ('Scheduling','ATRISK_OUTPATIENT_RENAL_LABS',1,'Renal risk','Laboratory renal function required within 14 days for at risk outpatients. Please assure blood draw is ordered','Laboratory renal function required within 14 days for at risk outpatients. Please assure blood draw is ordered',1,'',0,1,'2014-07-28 00:40:48',NULL),('Allergy','CONSENT_ALLERGY_CONTRAINDICATION',4,'Allergy to IV Contrast risk','Consent for IV contrast required, potential history of imaging contrast dye allergy','Consent for IV contrast required, potential history of imaging contrast dye allergy',1,'AnyFlagTrue(GIVE_CONTRAST_IV) and AllFlagsTrue(HAS_CONTRAST_ALLERGY)',0,1,'2015-06-15 19:45:00',NULL),('Allergy','CONTRAST_ALLERGY_CONTRAINDICATION',4,'Allergy risk','Contrast allergy risk','CONSENT FOR IV CONTRAST REQUIRED, POTENTIAL HISTORY OF IMAGING CONTRAST DYE ALLERGY',1,'AnyFlagTrue(GIVE_CONTRAST_IV , GIVE_CONTRAST_ENTERIC) and AllFlagsTrue(HAS_CONTRAST_ALLERGY)',0,1,'2014-09-24 12:29:00',NULL),('Renal','CONTRAST_RENAL_IMPAIRMENT_ACUTE_III',4,'Renal risk','At risk for contrast. Acute Stage 3 Renal Impairment.','At risk for contrast. Acute Stage 3 Renal Impairment.',1,'AllFlagsTrue(HAS_ACUTE_LOW_EGFR , HAS_EGFR_UNDER_60, GIVE_CONTRAST_IV) and AllFlagsFalse(HAS_EGFR_UNDER_30)',0,1,'2015-06-15 20:08:00',NULL),('Renal','CONTRAST_RENAL_IMPAIRMENT_CHRONIC_III',3,'Renal risk','At risk for contrast. Chronic Stage 3 Renal Impairment.','At risk for contrast. Chronic Stage 3 Renal Impairment.',1,'AllFlagsTrue(HAS_CHRONIC_LOW_EGFR, HAS_EGFR_UNDER_60, GIVE_CONTRAST_IV) and AllFlagsFalse(HAS_EGFR_UNDER_30)',0,1,'2015-06-15 20:06:00',NULL),('Renal','CONTRAST_RENAL_IMPAIRMENT_IV_V',5,'Renal risk','At risk for contrast. Stage IV or Stage V Renal Impairment.','At risk for contrast. Stage IV or Stage V Renal Impairment.',1,'AnyFlagTrue(HAS_KIDNEY_FAILURE, ) and AllFlagsTrue(HAS_EGFR_UNDER_30, GIVE_CONTRAST_IV)',0,1,'2015-06-15 20:15:00',NULL),('Age','CONTRAST_RISK_AGE',7,'Age risk','Patient age of 60 years or older carries increased risk for IV contrast complications. Consider noncontrast exam or alternate imaging modality.','Studies of serum creatinine suggest age, hypertension, and diabetes are important predictors of creatinine elevation. In addition, many VA centers use age (with variable thresholds) to determine the need for creatinine testing and this practice is also ingrained in the department culture at VA.',0,'AllFlagsTrue(IS_OVER_AGE_60, GIVE_CONTRAST_IV)',0,1,'2015-06-15 20:20:00',NULL),('Renal','DIAGNOSTIC_EXAM_RISK_MED',6,'Renal risk','Patient medication use increases risk for IV contrast complications.','Patient medication use increases risk for IV contrast complications.',1,'AllFlagsTrue(GIVE_CONTRAST_IV , IS_DIAGNOSTIC_EXAM)',0,1,'2015-06-26 14:54:00',NULL),('Bleeding','IMGGUIDE_RISK_MED',7,'Bleeding risk','At-Risk Medications for Image-Guided Procedures. Increased risk of bleeding complications.','At-Risk Medications for Image-Guided Procedures. Increased risk of bleeding complications.',1,'AllFlagsTrue(IS_IMG_GUIDED_EXAM, HAS_ATRISK_MEDS)',0,1,'2015-09-14 16:17:00',NULL),('Renal','IMPAIRED_RENAL_ALTERNATE_STUDY',3,'Renal risk','Impaired renal function, consider non-contrast study or alternative imaging modality','Impaired renal function, consider non-contrast study or alternative imaging modality',1,'AllFlagsTrue(HAS_EGFR_UNDER_60, GIVE_CONTRAST_IV)',0,1,'2015-06-15 21:01:00',NULL),('Renal','IMPAIRED_RENAL_PRE_POST_HYDRATION',2,'Renal risk','Impaired renal function, consider pre and post-exam hydration for renal protection if IV contrast will be administered.','Impaired renal function, consider pre and post-exam hydration for renal protection if IV contrast will be administered',1,'AllFlagsTrue(HAS_EGFR_UNDER_60, GIVE_CONTRAST_IV)',0,1,'2015-06-15 21:05:00',NULL),('Renal','IMPAIRED_RENAL_REDUCED_CONTRAST',2,'Renal risk','Impaired renal function, consider reduced dose of IV contrast if IV contrast will be administered','Impaired renal function, consider reduced dose of IV contrast if IV contrast will be administered',1,'AllFlagsTrue(HAS_EGFR_UNDER_60, GIVE_CONTRAST_IV)',0,1,'2015-06-15 21:06:00',NULL),('Scheduling','INPATIENT_RENAL_LABS',2,'Renal risk','Laboratory renal function required within 48 hours for inpatients. Please assure blood draw is ordered','Laboratory renal function required within 48 hours for inpatients. Please assure blood draw is ordered',1,'AllFlagsTrue(GIVE_CONTRAST_IV)',0,0,'2015-06-15 21:11:00',NULL),('Scheduling','NONRISK_OUTPATIENT_RENAL_LABS',2,'Renal risk','Laboratory renal function required within 30 days for routine outpatients. Please assure blood draw is ordered','Laboratory renal function required within 30 days for routine outpatients. Please assure blood draw is ordered',1,'AllFlagsTrue(GIVE_CONTRAST_IV)',0,0,'2015-06-15 21:13:00',NULL),('General','POTENTIAL_DUPLICATE_STUDY',4,'Duplicate order risk','Please review potential duplicate studies in the worklist.','Click the #P column in the worklist for this order to group together all other active orders for this patient.',1,'AnyFlagTrue(IS_POSSIBLE_DUP_PROC)',0,1,'2014-10-03 14:19:00',NULL),('Allergy','PROPHYLACTIC_ALLERGY_PREMEDICATION',3,'Allergy risk','Potential history of imaging contrast dye allergy, consider prophylactic premedication protocol','Potential history of imaging contrast dye allergy, consider prophylactic premedication protocol',0,'AllFlagsTrue( HAS_ANY_CONTRAST , HAS_CONTRAST_ALLERGY )',0,1,'2014-09-21 21:56:00',NULL),('Rare','RARE_DOSE',6,'Rare or special procurement dose','One or more rare or special process related doses have been selected.','This exam has rare or difficult to procure doses. Please use caution as to not waste valuable resources and allow enough time for procurement when scheduling the exam.',1,'AnyFlagTrue(HAS_RARE_CONTRAST , HAS_RARE_RADIOISOTOPE)',0,1,'2015-04-20 17:30:00',NULL),('Renal','RENAL_IMPAIRMENT',2,'Renal risk','This patient may have Renal Impairment and require consent prior to contrast enhanced advanced medical imaging.','This patient may have Renal Impairment and require consent prior to contrast enhanced advanced medical imaging.',1,'AllFlagsTrue(HAS_EGFR_UNDER_30)',0,1,'2014-08-02 03:43:00',NULL),('Age','RISK_AGE',5,'Age risk','Patient is over age 60','Routine creatinine testing prior to contrast administration is not necessary in all patients.  The major indications are age over 60, history of renal insufficiency, diabetes mellitus, or hypertension. ',1,'AllFlagsTrue(IS_OVER_AGE_60)',0,1,'2014-08-30 16:43:00',NULL),('Vascular','RISK_DEHYDRATION',1,'Vascular risk','Myeloma or Sickle Cell disease (risks for dehydration)','Myeloma or Sickle Cell disease (risks for dehydration)',1,'',0,1,'2014-07-28 00:40:48',NULL),('Renal','RISK_FAMILY_HX_KIDNEY_DISEASE',2,'Family history of kidney failure','Family history of kidney failure','Family history of kidney failure',1,'',0,1,'2014-07-30 20:35:00',NULL),('General','RISK_GOUT',2,'GOUT','GOUT','GOUT',1,'',0,1,'2014-07-31 17:23:00',NULL),('Renal','RISK_HX_KIDNEY_DISEASE',1,'Diabetes risk','A history of kidney disease (including kidney tumors, solitary kidney, renal transplantation, recurrent UTI, etc.)','A history of kidney disease (including kidney tumors, solitary kidney, renal transplantation, recurrent UTI, etc.)',1,'',0,1,'2014-07-28 00:40:48',NULL),('Vascular','RISK_HX_VASCULAR_SURGERY',1,'Vascular risk','A history of vascular surgery for atherosclerosis','A history of vascular surgery for atherosclerosis',1,'',0,1,'2014-07-28 00:40:48',NULL),('Diabetes','RISK_INSULIN_DEPENDENT_DIABETES',1,'Diabetes risk','Insulin-dependent diabetes >2 yrs','Insulin-dependent diabetes >2 yrs',1,'',0,1,'2014-07-28 00:40:48',NULL),('General','RISK_LIVER_WORKUP',3,'Liver txp work-up','Liver txp work-up','Liver txp work-up',1,'',0,1,'2014-07-30 20:45:00',NULL),('General','RISK_LUPUS',1,'General risk','Systemic Lupus Erythematosis','Systemic Lupus Erythematosis',1,'',0,1,'2014-07-28 00:40:48',NULL),('General','RISK_NEPHROTOXIC',1,'General risk','On nephrotoxic drugs','On nephrotoxic drugs',1,'',0,1,'2014-07-28 00:40:48',NULL),('Diabetes','RISK_NONINSULIN_DEPENDENT_DIABETES',1,'Diabetes risk','Non-insulin-dependent diabetes >5 yrs','Non-insulin-dependent diabetes >5 yrs',1,'',0,1,'2014-07-28 00:40:48',NULL);
/*!40000 ALTER TABLE `raptor_contraindication_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_contraindication_rule_replaced`
--

DROP TABLE IF EXISTS `raptor_contraindication_rule_replaced`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_contraindication_rule_replaced` (
  `category_nm` varchar(20) NOT NULL COMMENT 'Simply for grouping rules in a logical way',
  `rule_nm` varchar(40) NOT NULL COMMENT 'Must be unique',
  `version` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Increases each time change is saved',
  `summary_msg_tx` varchar(80) NOT NULL COMMENT 'Static summary text to show the user when rule is triggered',
  `msg_tx` varchar(512) NOT NULL COMMENT 'Text to show the user when rule is triggered',
  `explanation` varchar(2048) NOT NULL COMMENT 'Explanation of the rule purpose',
  `req_ack_yn` int(11) NOT NULL DEFAULT '1' COMMENT 'If 1 then an acknowledgement is required',
  `trigger_crit` varchar(4000) NOT NULL COMMENT 'The criteria that triggers the rule',
  `readonly_yn` int(11) NOT NULL DEFAULT '0' COMMENT 'If 1 then this rule record cannot be edited',
  `active_yn` int(11) NOT NULL DEFAULT '1' COMMENT 'If 0 then this rule is not active',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  `created_dt` datetime DEFAULT NULL COMMENT 'When this record was created',
  PRIMARY KEY (`rule_nm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='A simple rules engine rule';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_contraindication_rule_replaced`
--

LOCK TABLES `raptor_contraindication_rule_replaced` WRITE;
/*!40000 ALTER TABLE `raptor_contraindication_rule_replaced` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_contraindication_rule_replaced` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_cprs_codes`
--

DROP TABLE IF EXISTS `raptor_cprs_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_cprs_codes` (
  `cprs_cd` varchar(6) NOT NULL COMMENT 'The CPRS code',
  `exclude_from_worklist_yn` int(10) unsigned NOT NULL COMMENT 'If 1 then orders of this type are ignored by RAPTOR',
  `contrast_yn` int(10) unsigned DEFAULT NULL COMMENT 'If 1, then contrast, else no contrast.',
  `modality_abbr` varchar(2) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the modality associated with this order',
  `service_nm` varchar(10) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the service associated with this order',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relevant information about codes used in CPRS.  In...';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_cprs_codes`
--

LOCK TABLES `raptor_cprs_codes` WRITE;
/*!40000 ALTER TABLE `raptor_cprs_codes` DISABLE KEYS */;
INSERT INTO `raptor_cprs_codes` VALUES ('74000',1,NULL,'','','2015-10-02 14:52:16'),('74010',1,NULL,'','','2015-10-02 14:52:16'),('73050',1,NULL,'','','2015-10-02 14:52:16'),('75710',0,NULL,'CT','','2015-10-02 14:52:16'),('73600',1,NULL,'','','2015-10-02 14:52:16'),('73610',1,NULL,'','','2015-10-02 14:52:16'),('73650',1,NULL,'','','2015-10-02 14:52:16'),('71020',1,NULL,'','','2015-10-02 14:52:16'),('71035',1,NULL,'','','2015-10-02 14:52:16'),('71022',1,NULL,'','','2015-10-02 14:52:16'),('75716',0,NULL,'CT','','2015-10-02 14:52:16'),('74300',0,NULL,'CT','','2015-10-02 14:52:16'),('74290',0,NULL,'CT','','2015-10-02 14:52:16');
/*!40000 ALTER TABLE `raptor_cprs_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_cpt_codes`
--

DROP TABLE IF EXISTS `raptor_cpt_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_cpt_codes` (
  `cpt_cd` varchar(5) NOT NULL COMMENT 'The CPT code',
  `exclude_from_worklist_yn` int(10) unsigned NOT NULL COMMENT 'If 1 then orders of this type are ignored by RAPTOR',
  `contrast_yn` int(10) unsigned DEFAULT NULL COMMENT 'If 1, then contrast, else no contrast.',
  `modality_abbr` varchar(2) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the modality associated with this order',
  `service_nm` varchar(10) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the service associated with this order',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relevant information about CPT codes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_cpt_codes`
--

LOCK TABLES `raptor_cpt_codes` WRITE;
/*!40000 ALTER TABLE `raptor_cpt_codes` DISABLE KEYS */;
INSERT INTO `raptor_cpt_codes` VALUES ('74000',1,NULL,'','','2015-10-02 14:52:16'),('74010',1,NULL,'','','2015-10-02 14:52:16'),('73050',1,NULL,'','','2015-10-02 14:52:16'),('75710',0,NULL,'CT','','2015-10-02 14:52:16'),('73600',1,NULL,'','','2015-10-02 14:52:16'),('73610',1,NULL,'','','2015-10-02 14:52:16'),('73650',1,NULL,'','','2015-10-02 14:52:16'),('71020',1,NULL,'','','2015-10-02 14:52:16'),('71035',1,NULL,'','','2015-10-02 14:52:16'),('71022',1,NULL,'','','2015-10-02 14:52:16'),('75716',0,NULL,'CT','','2015-10-02 14:52:16'),('74300',0,NULL,'CT','','2015-10-02 14:52:16'),('74290',0,NULL,'CT','','2015-10-02 14:52:16');
/*!40000 ALTER TABLE `raptor_cpt_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_group`
--

DROP TABLE IF EXISTS `raptor_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_group` (
  `name_tx` varchar(10) NOT NULL DEFAULT '' COMMENT 'Group name',
  `desc_tx` varchar(128) NOT NULL DEFAULT '' COMMENT 'Group name',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  PRIMARY KEY (`name_tx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Lookup table of groups to which users can belong';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_group`
--

LOCK TABLES `raptor_group` WRITE;
/*!40000 ALTER TABLE `raptor_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_group_anatomy_keyword`
--

DROP TABLE IF EXISTS `raptor_group_anatomy_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_group_anatomy_keyword` (
  `name_tx` varchar(10) NOT NULL DEFAULT '' COMMENT 'Group name',
  `weightgroup` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Group 1 has the most weight, 2 less, 3 least',
  `keyword` varchar(32) NOT NULL DEFAULT '' COMMENT 'Anatomy keyword',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  PRIMARY KEY (`name_tx`,`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Default anatomy keywords for a group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_group_anatomy_keyword`
--

LOCK TABLES `raptor_group_anatomy_keyword` WRITE;
/*!40000 ALTER TABLE `raptor_group_anatomy_keyword` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_group_anatomy_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_group_modality`
--

DROP TABLE IF EXISTS `raptor_group_modality`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_group_modality` (
  `group_nm` varchar(10) NOT NULL DEFAULT '' COMMENT 'Group name',
  `modality_abbr` varchar(2) NOT NULL COMMENT 'Modality abbreviation',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  PRIMARY KEY (`group_nm`,`modality_abbr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Default modalities associated with a group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_group_modality`
--

LOCK TABLES `raptor_group_modality` WRITE;
/*!40000 ALTER TABLE `raptor_group_modality` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_group_modality` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_group_service`
--

DROP TABLE IF EXISTS `raptor_group_service`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_group_service` (
  `group_nm` varchar(10) NOT NULL DEFAULT '' COMMENT 'Group name',
  `service_nm` varchar(10) NOT NULL COMMENT 'Service name',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated',
  PRIMARY KEY (`group_nm`,`service_nm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Default services associated with a group';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_group_service`
--

LOCK TABLES `raptor_group_service` WRITE;
/*!40000 ALTER TABLE `raptor_group_service` DISABLE KEYS */;
/*!40000 ALTER TABLE `raptor_group_service` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_icd_codes`
--

DROP TABLE IF EXISTS `raptor_icd_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_icd_codes` (
  `icd_cd` varchar(10) NOT NULL COMMENT 'The ICD code',
  `exclude_from_worklist_yn` int(10) unsigned NOT NULL COMMENT 'If 1 then orders of this type are ignored by RAPTOR',
  `contrast_yn` int(10) unsigned DEFAULT NULL COMMENT 'If 1, then contrast, else no contrast.',
  `modality_abbr` varchar(2) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the modality associated with this order',
  `service_nm` varchar(10) DEFAULT NULL COMMENT 'If not excluded, then this field tells us the service associated with this order',
  `updated_dt` datetime NOT NULL COMMENT 'When this record was last updated'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Relevant information about ICD codes';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_icd_codes`
--

LOCK TABLES `raptor_icd_codes` WRITE;
/*!40000 ALTER TABLE `raptor_icd_codes` DISABLE KEYS */;
INSERT INTO `raptor_icd_codes` VALUES ('74000',1,NULL,'','','2015-10-02 14:52:16'),('74010',1,NULL,'','','2015-10-02 14:52:16'),('73050',1,NULL,'','','2015-10-02 14:52:16'),('75710',0,NULL,'CT','','2015-10-02 14:52:16'),('73600',1,NULL,'','','2015-10-02 14:52:16'),('73610',1,NULL,'','','2015-10-02 14:52:16'),('73650',1,NULL,'','','2015-10-02 14:52:16'),('71020',1,NULL,'','','2015-10-02 14:52:16'),('71035',1,NULL,'','','2015-10-02 14:52:16'),('71022',1,NULL,'','','2015-10-02 14:52:16'),('75716',0,NULL,'CT','','2015-10-02 14:52:16'),('74300',0,NULL,'CT','','2015-10-02 14:52:16'),('74290',0,NULL,'CT','','2015-10-02 14:52:16');
/*!40000 ALTER TABLE `raptor_icd_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_list_contrast`
--

DROP TABLE IF EXISTS `raptor_list_contrast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_list_contrast` (
  `type_nm` varchar(8) NOT NULL COMMENT 'Oral/IV/Enteric',
  `option_tx` varchar(100) NOT NULL COMMENT 'The text to show',
  `ct_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to CT?',
  `mr_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to MRI?',
  `nm_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Nuclear Medicine?',
  `fl_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Fluoroscopy?',
  `us_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Ultrasound?'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for contrast panel';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_list_contrast`
--

LOCK TABLES `raptor_list_contrast` WRITE;
/*!40000 ALTER TABLE `raptor_list_contrast` DISABLE KEYS */;
INSERT INTO `raptor_list_contrast` VALUES ('ENTERIC','GastroView 450cc during 1-2 hrs before scan',1,0,1,1,1),('ENTERIC','H2O 450cc over 20min prescan + 150cc on table',1,0,1,1,1),('ENTERIC','Other (see protocol notes)',1,1,1,1,1),('ENTERIC','Rectal',1,0,1,1,1),('ENTERIC','RediCat 450cc during 1-2 hrs before scan',1,0,1,1,1),('ENTERIC','Volumen 1350cc protocol',1,0,1,1,1),('ENTERIC','Volumen 450cc protocol',1,0,1,1,1),('ENTERIC','Volumen 900cc protocol',1,0,1,1,1),('IV','Ablavar 0.03 mmol/kg',0,1,0,1,1),('IV','Eovist 0.025 mmol/kg',0,1,0,1,1),('IV','Isovue 370',1,0,1,1,1),('IV','MultiHance 0.05 mmol/kg (\"1/2 Dose\")',0,1,0,1,1),('IV','MultiHance 0.1 mmol/kg',0,1,0,1,1),('IV','Other (see protocol notes)',1,1,1,1,1),('IV','ProHance 0.1 mmol/kg',0,1,0,1,1),('IV','Ultravist 300',1,0,1,1,1),('IV','Visipaque 320',1,0,1,1,1);
/*!40000 ALTER TABLE `raptor_list_contrast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_list_hydration`
--

DROP TABLE IF EXISTS `raptor_list_hydration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_list_hydration` (
  `type_nm` varchar(8) NOT NULL COMMENT 'Oral/IV/Enteric',
  `option_tx` varchar(100) NOT NULL COMMENT 'The text to show',
  `ct_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to CT?',
  `mr_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to MRI?',
  `nm_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Nuclear Medicine?',
  `fl_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Fluoroscopy?',
  `us_yn` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'Applies to Ultrasound?'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Options for hydration panel';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_list_hydration`
--

LOCK TABLES `raptor_list_hydration` WRITE;
/*!40000 ALTER TABLE `raptor_list_hydration` DISABLE KEYS */;
INSERT INTO `raptor_list_hydration` VALUES ('ORAL','500cc H2O over 2hr pre-scan + post-scan',1,1,1,1,1),('ORAL','Other (See protocol notes)',1,1,1,1,1),('IV','OutPt- NS 1-2mL/kg/hr 3-6hr pre & postscan',1,1,1,1,1),('IV','InPt- NS 1-2 mL/kg/hr 12 hr pre & postscan',1,1,1,1,1),('IV','Other (See protocol notes)',1,1,1,1,1);
/*!40000 ALTER TABLE `raptor_list_hydration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_list_kw_with_contrast`
--

DROP TABLE IF EXISTS `raptor_list_kw_with_contrast`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `raptor_list_kw_with_contrast` (
  `phrase_tx` varchar(50) NOT NULL COMMENT 'The exact text to look for'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Phrases that indicate an order includes contrast';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `raptor_list_kw_with_contrast`
--

LOCK TABLES `raptor_list_kw_with_contrast` WRITE;
/*!40000 ALTER TABLE `raptor_list_kw_with_contrast` DISABLE KEYS */;
INSERT INTO `raptor_list_kw_with_contrast` VALUES ('W CONT'),('WITH CONT'),('W/IV CONT'),('INCLUDE CONT'),('INC CONT');
/*!40000 ALTER TABLE `raptor_list_kw_with_contrast` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `raptor_list_kw_withandwithout_contrast`
--

DROP TABLE IF EXISTS `raptor_list_kw_withandwithout_contrast`;
/*