var crypto = require("crypto");

var password = {
  matches: function(fromUser, credentials) {
    var iterations = 10000;
    var keyLength = 64;
    var salt = new Buffer(credentials.salt, 'base64');
    var encrypted = crypto.pbkdf2Sync(fromUser, salt, iterations, keyLength);
    encrypted = encrypted.toString('base64');
    if (credentials.hash === encrypted) return true;
    return false;
  }
};


module.exports = {
 onMessage: {
    getLoginType: function(params, ewd) {
      var loginGlo = new ewd.mumps.GlobalNode('zewdMonitor', ['login']);
      if (loginGlo._exists) {
        return {login: 'ewdMonitor'};
      }
      else {
        return {login: 'mgrPassword'};
      }
    },
    login: function(params, ewd) {
      var loginGlo = new ewd.mumps.GlobalNode('zewdMonitor', ['login']);
      if (loginGlo._exists) {
        if (params.username === '') return {error: 'You must enter your ewdMonitor username'};
        if (params.password === '') return {error: 'You must enter your ewdMonitor password'};
        var userGlo = loginGlo.$(params.username);
        if (!userGlo._exists) return {error: 'Invalid login attempt'};
        var credentials = userGlo._getDocument();
        console.log('credentials: ' + JSON.stringify(credentials));
        if (!password.matches(params.password, credentials)) return {error: 'Invalid login attempt'};
      }
      else {
        if (params.password === '') return {error: 'You must enter the EWD.js Management password'};
        if (params.password !== params.managementPassword) return {error: 'Invalid password'};
      }
      ewd.session.setAuthenticated();
      return {ok: true};
    },
    'EWD.ping1': function(params, ewd) {
      //console.log('EWD.ping1 received by benchmark backend module');
      return {ok: 'ping1'};
    }
 }
};
