# Submitted to OSEHRA 02/05/2016 by OSEHRA Developer Open Source Project
# Original routine authored by Mitre Corp and members of popHealth open source contributors
# See https://github.com/OSEHRA/popHealth/graphs/contributors
class Race
  include Mongoid::Document
  
  field :name, type: String
  field :order, type: Integer
  field :codes, type: Array
  
  scope :from_code, ->(code) {where("codes" => code)}
  scope :ordered, -> { asc(:username) }
  scope :selected, ->(race_ids) { any_in(:_id => race_ids)}
  scope :selected_or_all, ->(race_ids) { race_ids.nil? || race_ids.empty? ? Race.all : Race.selected(race_ids) }
  
end