# Submitted to OSEHRA 02/05/2016 by OSEHRA Developer Open Source Project
# Original routine authored by Mitre Corp and members of popHealth open source contributors
# See https://github.com/OSEHRA/popHealth/graphs/contributors
class Practice
  include Mongoid::Document

  field :name, type: String
  field :organization, type: String
  field :address, type: String
  field :provider_id, type: BSON::ObjectId
  
  validates_presence_of :name, :organization
  validates :name, uniqueness: true
  belongs_to :provider, dependent: :destroy
  has_many :users
  has_many :records
  
end
