# Submitted to OSEHRA 02/05/2016 by OSEHRA Developer Open Source Project
# Original routine authored by Mitre Corp and members of popHealth open source contributors
# See https://github.com/OSEHRA/popHealth/graphs/contributors
class Language
  include Mongoid::Document
  
  field :name, type: String
  field :order, type: Integer
  field :codes, type: Array
  
  scope :ordered, -> { asc(:order) }
  scope :selected, ->(language_ids) { any_in(:_id => language_ids)}
  scope :selected_or_all, ->(language_ids) { language_ids.nil? || language_ids.empty? ? Language.all : Language.selected(language_ids) }
  scope :by_code, ->(codes) { any_in(codes: codes)}
  
end