package gov.va.med.authentication.kernel.ccow;

import java.security.Principal;

import gov.va.med.authentication.kernel.LoginUserInfoVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class LoginResult {
	
	private static Logger logger = Logger.getLogger(LoginResult.class);

	private CcowEnv ccowEnv;
	private LoginUserInfoVO userInfo;
	private Principal principal;
	

	public LoginResult(CcowEnv ccowEnv, HttpServletRequest req) {
		this.ccowEnv = ccowEnv;
		HttpSession session = ccowEnv.getHttpSession();
		this.userInfo = (LoginUserInfoVO) session.getAttribute(LoginUserInfoVO.SESSION_KEY);
		this.principal = req.getUserPrincipal();
	}

	public boolean UsingToken() {
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("user logged in using ccow/sso token? " + ccowEnv.isLoginUsingToken());
		}
		return ccowEnv.isLoginUsingToken();
	}

	public boolean UsingLoginPage() {
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("user logged in using login page? LoginUserInfoVO: " + userInfo);
		}
		return (userInfo != null);
	}

	public boolean isSuccessful() {
		return (principal != null && userInfo != null);
	}
}
