package gov.va.med.authentication.kernel.ccow;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

import com.sentillion.sdkweb.webcontextor.WebContextor;
import com.sentillion.sdkweb.webcontextor.WebContextorException;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public abstract class ContextManager {
	
	private static Logger logger = Logger.getLogger(ContextManager.class);

	public static CommonContextSession joinReadContext(CcowEnv ccowEnv) {
		return joinContext("", ccowEnv);
	}
	
	public static CommonContextSession joinWriteContext(String passcode, CcowEnv ccowEnv) {
		CommonContextSession contextSession = null;
		if (passcode == null) {
			if (logger.isEnabledFor(Level.WARN)) {
				logger.debug("attempted to obtain a Write Context session with a null passcode");
			}
			// instead a Read Context Session will be returned
			contextSession = joinReadContext(ccowEnv);
		} else {
			contextSession = joinContext(passcode, ccowEnv);
		}
		return contextSession;
	}

	public static CommonContextSession joinContext(String passcode, CcowEnv ccowEnv) {
    	
		Map sessions = ccowEnv.getContextSessions();
		CommonContextSession ctxSession = null;
		String applName = null;
		String contextManagerUrl = ccowEnv.getContextManagerURL();
    	String contextParticipantURL = ccowEnv.getContextParticipantURL();
    	String appName = ccowEnv.getApplicationName();
     	WebContextor contextor = new WebContextor();
     	String [] contextorBlob = new String[1];
    	// start the contextor			
     	try
     	{
     		contextor.run( contextorBlob,
     				contextManagerUrl,
     				contextParticipantURL,
     				appName + "#",      // # allows multiple instances to co-exist
     				passcode,
     				true);
     		
     		applName = contextor.getName(contextorBlob);
     		ctxSession = new CommonContextSession(contextorBlob[0]);
     		sessions.put(applName, ctxSession);
     	} catch (WebContextorException e) {
     		if (logger.isEnabledFor(Level.ERROR)) {
     			logger.debug("run contextor error: " + e);
     		}
     	} finally {
     		ccowEnv.setContextSessions(sessions);
     	}

    	return ctxSession;
	}

	public static void suspendContext(CcowEnv ccowEnv) {
		// suspend current active context session
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("in suspendContext for ccowEnv: " + ccowEnv);
		}
		if (ccowEnv != null) {			
//			Map sessions = ccowEnv.getContextSessions();
//			if (sessions != null){				
//				Set keys = sessions.keySet();
//				Iterator it = keys.iterator();
//				while (it.hasNext()){
//					Object next = it.next();
//					CommonContextSession ctxSession = (CommonContextSession)sessions.get(next);
//					if (logger.isEnabledFor(Level.DEBUG)) {
//						logger.debug("suspending context for : " + ctxSession);
//					}
//					ctxSession.suspend();
//				}
//			}
			
			CommonContextSession ctxSession = ccowEnv.getActiveContextSession();
			if (ctxSession != null){
				ctxSession.suspend();
				ccowEnv.setActiveContextSession(null);
			}
		}
	}

	public static void abandonContext(CcowEnv ccowEnv) {
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("in abandonContext for CcowEnv: " + ccowEnv);
		}
 		if (ccowEnv != null) {
			Map sessions = ccowEnv.getContextSessions();
			if (sessions != null) {				
				Set keys = sessions.keySet();
				Iterator it = keys.iterator();
				while (it.hasNext()){
					Object next = it.next();
					CommonContextSession ctxSession = (CommonContextSession)sessions.get(next);
					if (logger.isEnabledFor(Level.DEBUG)) {
						logger.debug("abandoning context for : " + ctxSession);
					}
					ctxSession.stop();
				}
			}
		}
	}	
}
