package gov.va.med.authentication.kernel.ccow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class ContextChangesMessage {
	
	private static Logger logger = Logger.getLogger(ContextChangesMessage.class);
	private static final String INTERFACE = "interface";
	private static final String METHOD = "method";
	private static final String CONTEXT_COUPON = "contextCoupon";

	private HttpServletRequest req;
	private HttpServletResponse res;
	
	String interfaceValue = "";
	String methodValue = "";
	String contextCouponValue = "";

	public ContextChangesMessage(HttpServletRequest req, HttpServletResponse res) {
		this.req = req;
		this.res = res;
		parseRequest();
	}

	private void parseRequest() {
		// Get message from HttpRequest
		String messageString = req.getQueryString();
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("query string: " + messageString);
		}
		interfaceValue = req.getParameter(INTERFACE);
		methodValue = req.getParameter(METHOD);
		contextCouponValue = req.getParameter(CONTEXT_COUPON);
	}
	
	public String getContextCouponValue() {
		return contextCouponValue;
	}

	public String getInterfaceValue() {
		return interfaceValue;
	}

	public String getMethodValue() {
		return methodValue;
	}

	public HttpServletResponse getResponse() {
		return res;
	}
	
	public CcowEnv getCcowEnv() {
		return CcowEnv.getInstance(req);
	}

}
