package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.ccow.CcowEnv;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class CcowHttpSessionListener implements HttpSessionListener {

	private static final Logger LOGGER = Logger.getLogger(CcowHttpSessionListener.class);

	/**
	 * No actions implemented at session creation.
	 * @see javax.servlet.http.HttpSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionCreated(HttpSessionEvent event) {
	}

	/**
	 * When session ends, call logout actions, if we can get the LoginUserInfoVO object (signifying a logout
	 * of a user that was logged in.) Appears to be container-specific whether this action is called;
	 * we double-cover this with KaajeeSessionAttributeListener looking for this attribute to be removed, as well.
	 * @see javax.servlet.http.HttpSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionDestroyed(HttpSessionEvent event) {
		if (LOGGER.isEnabledFor(Level.DEBUG)) {
			LOGGER.debug("Session will be destroyed: " + event.getSession().getId());
		}
		CcowEnv ccowEnv = CcowEnv.getInstance(event.getSession());
		if (ccowEnv != null) {
			ccowEnv.terminateContextSession();
		}
	}

}
