package gov.va.med.authentication.kernel.ccow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import gov.va.med.authentication.kernel.LoginUserInfoVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class CcowEnv implements Serializable {
	
	private static Logger logger = Logger.getLogger(CcowEnv.class);
	
	public static final String LOCATOR_SENT = "locatorAppletSent";
	public static final String CONTEXT_MANAGER_URL = "contextManagerUrl";
	public static final String CONTEXT_SESSIONS = "contextSessions";
	public static final String COMMON_CONTEXT = "currentCommonContext";
	public static final String THIS_CCOWENV = "authentication.kernel.ccow.ccowEnv";
	public static final String CONTEXT_PARTICIPANT_URL = "contextParticipantUrl";
	public static final String APPLICATION_NAME = "applicationName";
	public static final String APPLET_CODEBASE_URL = "appletCodebaseURL";
	public static final String LOGIN_USING_TOKEN = "loginUsingToken";
	public static final String ACTIVE_CONTEXT_SESSION = "activeContextSession";
	public static final String CLIENT_IP_ADDRESS = "clientIPAddr";


	private HttpSession httpSession;
	private Map env;
	
	private CcowEnv (HttpSession currentSession){
		httpSession = currentSession;
		env = new HashMap();
		httpSession.setAttribute(THIS_CCOWENV,this);
	}
	
	public static CcowEnv getInstance(HttpServletRequest req) {
		CcowEnv instance = null;
		HttpSession session = req.getSession(false);
		if (session != null){
			instance = getInstance(session);
		}
		return instance;
	}
	
	public static CcowEnv getInstance(HttpSession session) {
		CcowEnv instance = null;
		if (session != null){
			instance = (CcowEnv) session.getAttribute(THIS_CCOWENV);
			if (instance == null) {
				instance = new CcowEnv(session);
			}
		}
		return instance;
	}
	
	public void terminateContextSession(){
		
		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("terminating context sessions in CcowEnv: " + this);
		}
		
		ContextManager.abandonContext(this);
		httpSession.removeAttribute(THIS_CCOWENV);
	}
		
	public void setContextManagerURL(String url) {
		//httpSession.setAttribute(CONTEXT_MANAGER_URL, url);
		env.put(CONTEXT_MANAGER_URL,url);
	}

	public String getContextManagerURL(){
		//return (String) httpSession.getAttribute(CONTEXT_MANAGER_URL);
		return (String) env.get(CONTEXT_MANAGER_URL);
	}
	
	public void setContextParticipantURL( String url){
		//httpSession.setAttribute("contextParticipantURL", url);
		env.put(CONTEXT_PARTICIPANT_URL,url);
	}
	
	public String getContextParticipantURL(){
		//return (String) httpSession.getAttribute("contextParticipantURL");
		return (String) env.get(CONTEXT_PARTICIPANT_URL);
	}

	public void setApplicationName(String app_name) {
		//httpSession.setAttribute("applicationName", app_name);
		env.put(APPLICATION_NAME, app_name);
	}
	
	public String getApplicationName() {
		//return (String) httpSession.getAttribute("applicationName");
		return (String) env.get(APPLICATION_NAME);
	}
	
	public boolean locatorSent() {
		//String locatorSent = (String) httpSession.getAttribute(LOCATOR_SENT);
		String locatorSent = (String) env.get(LOCATOR_SENT);
		return locatorSent != null;
	}

	public void setLocatorSent() {
		env.put(LOCATOR_SENT, "");		
	}

	public HttpSession getHttpSession() {
		return httpSession;		
	}

	public void setLoginUserInfo(LoginUserInfoVO userInfo) {
		// use the HttpSession object instead of the local instance env (Map) object
		// as this is the interface to and from the KAAJEE LoginController
		httpSession.setAttribute(LoginUserInfoVO.SESSION_KEY, userInfo);
	}
	
	public LoginUserInfoVO getLoginUserInfo() {
		return (LoginUserInfoVO) httpSession.getAttribute(LoginUserInfoVO.SESSION_KEY);		
	}

	public void setAppletCodebaseURL(String url) {
		env.put(APPLET_CODEBASE_URL, url);
	}

	public String getAppletCodebaseURL() {
		return (String) env.get(APPLET_CODEBASE_URL);
	}

	public void setLoginUsingToken() {
		env.put(LOGIN_USING_TOKEN, "");
	}

	public boolean isLoginUsingToken() {
		String loginUsingToken = (String) env.get(LOGIN_USING_TOKEN);
		return loginUsingToken != null;
	}

	public void setNotLoginUsingToken() {
		//httpSession.removeAttribute("ccow.loginUsingToken");
		env.remove(LOGIN_USING_TOKEN);
	}

	public void setActiveContextSession(CommonContextSession ctxSession) {
		env.put(ACTIVE_CONTEXT_SESSION, ctxSession);
	}

	public CommonContextSession getActiveContextSession() {
		return (CommonContextSession) env.get(ACTIVE_CONTEXT_SESSION);
	}

	public void setContextSessions(Map sessions) {
		env.put(CONTEXT_SESSIONS, sessions);
	}
	
	public Map getContextSessions() {
		Map sessions = (Map) env.get(CONTEXT_SESSIONS);
		if (sessions == null){
			sessions = new HashMap();
		}
		return sessions;
	}

	public void setCurrentCommonContext(CommonContextMap vaContext) {
		env.put(COMMON_CONTEXT, vaContext);
	}
	
	public CommonContextMap getCurrentCommonContext() {
		return (CommonContextMap) env.get(COMMON_CONTEXT);
	}

	public void setClientIPAddr(String clientIPAddr) {
		env.put(CLIENT_IP_ADDRESS, clientIPAddr);
	}

	public String getClientIPAddr() {
		return (String) env.get(CLIENT_IP_ADDRESS);
	}
}
