package gov.va.med.authentication.kernel;

import javax.resource.ResourceException;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import gov.va.med.exception.FoundationsException;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * Performs actions at user logout. Called from KAAJEE code that detects a user logout has occurred.
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class LogoutController {

	private static Logger logger = Logger.getLogger(LogoutController.class);
	private static final String LOGOUT_RPC_NAME = "XUS KAAJEE LOGOUT";

	/**
	 * perform logout actions. Called from both HttpSessionListener and SessionAttributeListener; hopefully
	 * one of these two places detects the session ending or the removal of the LoginUserInfoVO attribute from
	 * session, and can provide that value so that user-specific logout actions can be performed.
	 * @param userInfo
	 */
	static void performLogoutActions(String signonLogIen, String duz, String loginDivisionStationNumber) {

		VistaLinkConnection myConnection = null;

		if ((signonLogIen.length() < 1) | (duz.length() < 1) | (loginDivisionStationNumber.length() < 1)) {

			if (logger.isEnabledFor(Level.ERROR)) {
				StringBuffer sb =
					new StringBuffer("Signon IEN, DUZ or Login station # missing. Not able to mark signon log as signed off, for Duz '");
				sb.append(duz);
				sb.append("', login station # '");
				sb.append(loginDivisionStationNumber);
				sb.append("', and signon log IEN '");
				sb.append(signonLogIen);
				sb.append("'.");
				
				logger.error(sb.toString());
			}

		} else {

			VistaLinkDuzConnectionSpec duzConnSpec = new VistaLinkDuzConnectionSpec(loginDivisionStationNumber, duz);
			try {

				myConnection = LoginControllerUtils.getVistaLinkConnection(loginDivisionStationNumber, duzConnSpec);
				RpcRequest vReq = RpcRequestFactory.getRpcRequest();
				vReq.setRpcContext(LoginController.LOGIN_RPC_CONTEXT);
				vReq.setRpcClientTimeOut(600);
				vReq.setUseProprietaryMessageFormat(true);
				vReq.setRpcName(LOGOUT_RPC_NAME);
				vReq.getParams().setParam(1, "string", signonLogIen);
				RpcResponse vResp = myConnection.executeRPC(vReq);
				// don't need the results, just need to execute the RPC
				vResp.getResults();
				if (logger.isEnabledFor(Level.DEBUG)) {
					StringBuffer sb = new StringBuffer("Executed RPC to mark signon log at station #'");
					sb.append(loginDivisionStationNumber);
					sb.append("' for user DUZ '");
					sb.append(duz);
					sb.append("' logged off for signon log IEN '");
					sb.append(signonLogIen);
					sb.append("'.");
					logger.debug(sb.toString());
				}

			} catch (VistaLinkFaultException e) {

				if (logger.isEnabledFor(Level.ERROR)) {
					logger.error("Error marking VistA-side signon log as signed off", e);
				}

			} catch (KaajeeException e) {

				if (logger.isEnabledFor(Level.ERROR)) {
					logger.error("Error marking VistA-side signon log as signed off", e);
				}

			} catch (FoundationsException e) {

				if (logger.isEnabledFor(Level.ERROR)) {
					logger.error("Error marking VistA-side signon log as signed off", e);
				}

			} finally {
				try {
					myConnection.close();
				} catch (ResourceException e1) {
					if (logger.isEnabledFor(Level.ERROR)) {
						logger.error("Could not close VistaLink Connection.");
					}
				}
			}
			
		}
	}

}
