package gov.va.med.authentication.kernel;

/**
 * Provides a value object to hold j_username and j_password login credentials.
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class CactusFormsAuthCredentialVO {

	private String jUsername;
	private String jPassword;

	/**
	 * Creates a new CactusFormsAuthCredentialVO based on scraping values from the string written
	 * by CactusFormsAuthCredentialVO.toString(). Useful during Cactus testing when creating a credential
	 * on the server side. The server side of a cactus test can return the credential to the client as 
	 * response output using this object's toString method. Then the client can scrape the return
	 * values out of the response string using this method.
	 * @param cactusFormsAuthCredentialToStringOutput a string containing the toString output generated by
	 * this classes' toString method.
	 */
	public CactusFormsAuthCredentialVO(String cactusFormsAuthCredentialToStringOutput) {
		
		int uStartPos = cactusFormsAuthCredentialToStringOutput.indexOf('\'') + 1;
		int uEndPos = cactusFormsAuthCredentialToStringOutput.indexOf('\'', uStartPos);
		int pStartPos = cactusFormsAuthCredentialToStringOutput.indexOf('\'', uEndPos + 1) + 1;
		int pEndPos = cactusFormsAuthCredentialToStringOutput.indexOf('\'', pStartPos);
		this.jUsername = cactusFormsAuthCredentialToStringOutput.substring(uStartPos, uEndPos);
		this.jPassword = cactusFormsAuthCredentialToStringOutput.substring(pStartPos, pEndPos);

	}

	/**
	 * Creates a new credential.
	 * @param jUsername username
	 * @param jPassword password
	 */
	public CactusFormsAuthCredentialVO(String jUsername, String jPassword) {

		this.jUsername = jUsername;
		this.jPassword = jPassword;
	}

	/**
	 * 
	 * @return the username
	 */	
	public String getJUsername() {
		return this.jUsername;
	}

	/**
	 * 
	 * @return the password
	 */
	public String getJPassword() {
		return this.jPassword;
	}

	/**
	 * @return a string representation of this object.
	 */
	public String toString() {

		StringBuffer sb = new StringBuffer("JUsername: '");
		sb.append(this.jUsername);
		sb.append("' JPassword: '");
		sb.append(this.jPassword);
		sb.append("'.");
		return sb.toString();
	}
}
