package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class LoginDispatcher {
	
	private static Logger logger = Logger.getLogger(LoginDispatcher.class);
	private HttpServletRequest req;
	private HttpServletResponse res;
	public LoginDispatcher(CcowEnv ccowEnv, HttpServletRequest req, HttpServletResponse res) {
		this.req = req;
		this.res = res;
	}

	public void forwardToLoginController(LoginUserInfoVO userInfo) throws KaajeeException {

		if (logger.isEnabledFor(Level.DEBUG)) {
			logger.debug("forwarding to Logincontroller Servlet");
		}
		
		try {
			RequestDispatcher disp = req.getRequestDispatcher("/LoginController");
			disp.forward(req, res);
		}
		catch (ServletException e){
			String msg = "Could not forward to Logincontroller Servlet: " + e;
			if (logger.isEnabledFor(Level.ERROR)) {
				logger.debug(msg);
			}
			throw new KaajeeException(msg);
		}
		catch (IOException e){
			String msg = "Could not forward to Logincontroller Servlet: " + e;
			if (logger.isEnabledFor(Level.ERROR)) {
				logger.debug(msg);
			}
			throw new KaajeeException(msg);
		}        

	}

	public void continueChain(ServletRequest servletReq, ServletResponse servletResp, FilterChain chain) 
	throws IOException, ServletException {
		chain.doFilter(servletReq, servletResp);
	}

}
