package gov.va.med.authentication.kernel.ccow;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

import com.sentillion.sdkweb.webcontextor.ContextItem;
import com.sentillion.sdkweb.webcontextor.ContextItemCollection;
import com.sentillion.sdkweb.webcontextor.WebContextorException;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class CommonContextMap {
	
	private static Logger logger = Logger.getLogger(CommonContextMap.class);
	
	private Map context;
	private ContextItemCollection contextItemCollection;
	
	/**
	 * The user context location under which the     el token is stored.
	 */
	public static final String VHA_CCOW_LOGON_TOKEN = "user.id.logon.vistatoken";

	/**
	 * The user context location under which the user name is stored.
	 */
	public static final String VHA_CCOW_LOGON_NAME = "user.id.logon.vistaname";

	/**
	 * The non-VA-specific generic user context location under which the user name is stored.
	 */
	public static final String VHA_CCOW_LOGON_NAME_GENERIC = "user.co.name";

	/**
	 * The user context location under which the VPID is stored.
	 */
	public static final String VHA_CCOW_LOGON_VPID = "user.id.logon.vpid";

	/**
	 * The VistA Domain.
	 */
	public static final String VHA_CCOW_LOGON_DOMAIN = "user.id.logon.vistalogon"; 

	
	public CommonContextMap(ContextItemCollection collection) {
		this.contextItemCollection = collection;
		transform();
	}

	private void transform() {
		context = new HashMap();
      			
        if (contextItemCollection != null)
        {
            int count = contextItemCollection.count();
        	for (int j = 1; j <= count; j++)
            {
                ContextItem contextItem = null;
                try
                {
                    contextItem = contextItemCollection.item(j);  // Note: range is 1 to count
                    context.put(contextItem.getName(), contextItem.getValue());
                }
                catch (WebContextorException e)
                {
        			if (logger.isEnabledFor(Level.ERROR)) {
        				logger.debug("error retrieving context item: " + j
        						+ " error: " + e);
        			}
                }
                catch (Exception e)
                {
        			if (logger.isEnabledFor(Level.ERROR)) {
        				logger.debug("error retrieving context item: " + j
        						+ " error: " + e);
        			}
                }
            }

        }
	}

	public String getContextItem(String name) {
		
		return (String) context.get(name);
	}

}
