package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.VergenceAppletsHtml;

/**
 * @author VHIT Security and Other Common Services (S&OCS)
 * @version 1.1.0.007
 */
public class AppletTag {

    private final String APP_ARCHIVE_J2 = ContextInitializerFilter.APP_ARCHIVE_J2;
    private final String APP_ARCHIVE_IE = ContextInitializerFilter.APP_ARCHIVE_IE;
    private final String APP_DEBUG =  ContextInitializerFilter.APP_DEBUG;
    private final String APP_LOCATE_TIMEOUT = ContextInitializerFilter.APP_LOCATE_TIMEOUT;
	private final boolean UseIETag = ContextInitializerFilter.UseIETag;
	
	private String contextParticipantURL;
	private String codebaseURL;
	private String refreshURL;
	
	public AppletTag (String contextParticipantURL,
					   String codebaseURL, 
					   String refreshURL){
		this.contextParticipantURL = contextParticipantURL;
		this.codebaseURL = codebaseURL;
		this.refreshURL = refreshURL;
	}
		
    public String getLocatorAppletTag() {
    	   	
    	int appletType = VergenceAppletsHtml.JAVA2;
    	String archiveName = APP_ARCHIVE_J2;
    	
    	if (UseIETag)
    	{
    		appletType = VergenceAppletsHtml.INTERNET_EXPLORER;
    		archiveName = APP_ARCHIVE_IE;
    	} 	
    	
    	VergenceAppletsHtml vergenceAppletsHtml
    	= new VergenceAppletsHtml ( appletType,
    			this.codebaseURL,
    			archiveName,
    			APP_DEBUG); 
    	
    	String appletTag 
    	= vergenceAppletsHtml.locatorTag ( this.refreshURL,
    										"",  // refreshTarget
    										"",  // descriptiveData
    										this.contextParticipantURL,
    										APP_LOCATE_TIMEOUT);
    	
    	return appletTag;     	    	
    }
}
