jQuery(document).ready(function() {

	$.ajaxSetup({
		cache : false
	})
	// Refresh the values in filters on page refresh
	clearFilterValues();

	// populate the status drop down
	loadStatusDropDown();

	loadUpdatesHistoryTable();

	// connect to the buttons.
	connectToStatusButton();

	connectApplyButton();

	connectClearButton();

});

function connectToStatusButton() {
	jQuery(".dropdown-menu").on('click','li a',
					function() {
						$("#dropdownMenu1:first-child").html(
										$(this).text()
												+ ' <span class="caret"></span><input type="hidden" value="'
												+ $(this).attr('data-value')
												+ '" name="statusId" />');
						$("#dropdownMenu1:first-child").attr('value',
								$(this).attr('data-value'));
						
						$("#dropdownMenu1:first-child").attr('aria-label',
								'Status Dropdown: ' + $(this).text() + ' selected');

						

					});
}

function connectApplyButton() {
	jQuery('#applyButton').bind('click', function(e) {
		// StartRow should be set back to zero when applying a filter
		$("#startRow").val(0);

		loadUpdatesHistoryTable();
		$("#updateFileTable").focus();		
	});
}

function connectClearButton() {
	jQuery('#clearButton').bind('click', function(e) {
		clearFilterValues();
	});
}

function loadStatusDropDown() {

	$.ajax({
		type : 'GET',
		cache : false,
		dataType : "json",
		url : '/PRE/fileStatusDropDownList.rest',
		success : parseStatusResponse,
		error : errorMessage
	});
}

function parseStatusResponse(data) {

	jQuery.each(data, function(i, entry) {

		$('#status').append(
				'<li data-value=' + entry.statusId
						+ '> <a tabindex="-1" href="#" data-value="'
						+ entry.statusId + '">' + entry.statusName
						+ '</a></li>');
	});
}

// Function to clear filter values
// User will need to click apply button to refresh the table.
function clearFilterValues() {

	$('#beginningDateRange').val('');
	$('#endingDateRange').val('');

	// TODO: Test for selected drop down value once we can select a value
	$("#dropdownMenu1:first-child").html('Status <span class="caret"></span>');
	$("#dropdownMenu1:first-child").attr('value', '');
	$("#dropdownMenu1:first-child").attr('aria-label', 'Status Dropdown');

}

function loadUpdatesHistoryTable() {

	var form = $('#updateFileForm');

	$('#progressDiv').removeClass('hidden');

	var beginDate = $("#beginningDateRange").val();
	if (jQuery.trim(beginDate).length > 0) {
		if (!isValidDate(beginDate)) {
			$('#progressDiv').addClass('hidden');
			alert("Please enter dates in a valid mm/dd/yyyy format.");		
			return;
		}
	}
	
	var endingDate = $("#endingDateRange").val();
	if (jQuery.trim(endingDate).length > 0) {
		if (!isValidDate(endingDate)) {
			$('#progressDiv').addClass('hidden');
			alert("Please enter dates in a valid mm/dd/yyyy format.");
			return;
		}
	}
	$.ajax({
		type : 'POST',
		cache : false,
		dataType : "json",
		url : '/PRE/historyUpdateFiles.rest',
		data : form.serialize(),
		success : parseResponse,
		error : errorMessage
	});
}

function parseResponse(data) {

	$('#progressDiv').addClass('hidden');
	loadPaginationControls(data.pageSize, data.fullSize, data.startingIndex);

	$("#updateFilePagedTable").empty();
	if (data === null || data == "") {
		$("#updateFilePagedTable").append(
				"<tr><td>No NDF History Files To Display</td><td>");
	} else {
		jQuery.each(data.values, function(i, entry) {

			if (entry.comments === null || entry.comments == null) {
				entry.comments = "";
			}
			$("#updateFilePagedTable").append(
					"<tr>" + "<td tabindex='0'>" + entry.fileName + "</td >" 
					+ "<td tabindex='0'>" + entry.status.statusName + "</td>" 
					+ "<td tabindex='0'>" + entry.statusModifiedDtm + "</td>" 
					+ "<td tabindex='0'>" + entry.comments + "</td>" + "</tr>");
		});
	}	
}

function errorMessage(data) {
	console.log("Error: " + data)
	$('#progressDiv').addClass('hidden');
}

function isValidDate(dateString) {
	// First check for the pattern
	if (!/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(dateString))
		return false;

	// Parse the date parts to integers
	var parts = dateString.split("/");
	var day = parseInt(parts[1], 10);
	var month = parseInt(parts[0], 10);
	var year = parseInt(parts[2], 10);

	// Check the ranges of month and year
	if (year < 1000 || year > 3000 || month == 0 || month > 12)
		return false;

	var monthLength = [ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 ];

	// Adjust for leap years
	if (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0))
		monthLength[1] = 29;

	// Check the range of the day
	return day > 0 && day <= monthLength[month - 1];
};

function clickedPageLink(num, e) {

	$("#startRow").val(num);
	loadUpdatesHistoryTable();
}

function loadPaginationControls(pageSize, fullSize, startIndex) {

	// Empty controls
	$('#page-control').empty();

	// Get total number of result pages
	pages = Math.floor(fullSize / pageSize);
	if (fullSize % pageSize > 0)
		pages++;

	// Identify our page
	currentPage = 0;
	if (startIndex != 0) {
		// Add 1 to startIndex to identify current page
		currentPage = Math.floor((startIndex + 1) / pageSize);
		if ((startIndex + 1) % pageSize > 0)
			currentPage++;
	} else {
		currentPage = 1;
	}

	if (pages > 1 && currentPage != 1) {
		// Show Previous link
		$('#page-control')
				.append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ (startIndex - pageSize)
								+ ');" aria-label="Previous"> <span aria-hidden="true">Previous</span></a></li>');
	}

	// Draw page numbers
	if (pages < 10) {

		for (b = 1; b <= pages; b++) {
			if (b != currentPage) {
				$('#page-control').append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ ((b * pageSize) - pageSize) + ');">' + b
								+ '</a></li>');
			} else {
				$('#page-control').append(
						'<li  class="disabled"><a href="#">' + currentPage
								+ '</a></li>');
			}
		}

	} else if (pages >= 10) {

		// Determine page numbers to show before current
		startPageNumber = currentPage - 5;
		if((pages - startPageNumber) < 10)
			startPageNumber = pages - 9;
		
		if (startPageNumber > 0) {
			for (b = startPageNumber; b < currentPage; b++) {
				$('#page-control').append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ ((b * pageSize) - pageSize) + ');">' + b
								+ '</a></li>');
			}
		} else {
			// Current page is less than 5
			for (b = 1; b < currentPage; b++) {
				$('#page-control').append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ ((b * pageSize) - pageSize) + ');">' + b
								+ '</a></li>');
			}
		}

		// Current page is not clickable
		$('#page-control').append(
				'<li  class="disabled"><a href="#">' + currentPage
						+ '</a></li>');

		// Determine page numbers to show after current
		if (currentPage < 5) {
			pagesToLink = 10;
			for (b = currentPage + 1; b <= pagesToLink && b <= pages; b++) {
				$('#page-control').append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ ((b * pageSize) - pageSize) + ');">' + b
								+ '</a></li>');
			}
		} else {
			for (b = currentPage + 1; b <= currentPage + 4 && b <= pages; b++) {
				$('#page-control').append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ ((b * pageSize) - pageSize) + ');">' + b
								+ '</a></li>');
			}
		}

	}

	if (pages > 1 && currentPage != pages) {
		// Show Next link
		$('#page-control')
				.append(
						'<li><a href="#pc" onclick="clickedPageLink('
								+ (startIndex + pageSize)
								+ ');" aria-label="Next"> <span aria-hidden="true">Next</span></a></li>');
	}

	// Mirror controls from header to footer
	$('#page-control-footer').empty();
	$('#page-control-footer').append($('#page-control').html());

}