
<%@tag import="gov.va.med.pharmacy.peps.common.vo.FieldKey"%>
<%@tag import="gov.va.med.pharmacy.peps.common.vo.EntityType"%>
<%@tag import="gov.va.med.pharmacy.peps.common.vo.ManagedItemVo"%>
<%@tag import="gov.va.med.pharmacy.peps.presentation.common.controller.ControllerConstants"%>
<%@tag import="gov.va.med.pharmacy.peps.presentation.common.utility.UrlUtility"%>
<%@tag import="gov.va.med.pharmacy.peps.presentation.common.utility.JspTagUtility"%>
<%@tag import="gov.va.med.pharmacy.peps.common.vo.printtemplate.DefaultPrintTemplateFactory"%>
<%@tag import="org.apache.commons.lang3.StringUtils"%>
<%@tag import="org.apache.log4j.Logger"%>
<%@tag import="org.displaytag.tags.TableTagParameters" %>

<%@tag import="gov.va.med.pharmacy.peps.presentation.common.spring.interceptor.PepsSpringInterceptor"%>
<%@ tag
    language="java"
    body-content="empty"%>
<%@ taglib
    uri="http://displaytag.sf.net"
    prefix="display"%>
<%@ taglib
    prefix="peps"
    tagdir="/WEB-INF/tags"%>
<%@taglib 
    prefix="spring" 
    uri="http://www.springframework.org/tags"%>
<%@taglib 
    prefix="c" 
    uri="http://java.sun.com/jsp/jstl/core"%>
<%@ attribute
    name="dataModel"
    required="true"
    type="java.util.Collection"
    rtexprvalue="true"
    description="EL value of the collection containing the data to display."%>
<%@ attribute
    name="printTemplate"
    required="true"
    type="gov.va.med.pharmacy.peps.common.vo.printtemplate.PrintTemplateVo"
    rtexprvalue="true"
    description="EL value of the PrintTemplateVo place on the model containing the fields to use as columns."%>
<%@ attribute
    name="tableId"
    required="true"
    type="java.lang.String"
    description="ID to give the generated HTML table"%>
<%@ attribute
    name="export"
    required="false"
    type="java.lang.Boolean"
    description="Turn on and off the export functionality. Defaults to false."%>
<%@ attribute
    name="paged"
    required="false"
    type="java.lang.Boolean"
    description="Set whether or not the table will be paged. Default is true."%>
<%@ attribute
    name="sortExportLinkParameters"
    required="false"
    type="java.util.Map"
    description="Request parameters to add to sort and export links generated by the Display Tag Library. Used especially when clicking one of these links should return the user back to a particular tab."%>
<%@ attribute
    name="multiselectButtonKey"
    required="false"
    type="java.lang.String"
    description="Key to localize as the button label if this table is multi-select."%>
<%@ attribute
    name="disableMultiselectButton"
    required="false"
    type="java.lang.String"
    description="Key to show/hide multiselect edit button."%>    
<%@ attribute
    name="multiselectButtonAction"
    required="false"
    type="java.lang.String"
    description="Spring event to trigger when the button is clicked if this table is multi-select."%>
<%@ attribute
    name="multiselectButtonMethod"
    required="false"
    type="java.lang.String"
    description="HTTP Method to execute when the button is clicked"%>
<%@ attribute
    name="multiselectButtonKeys"
    required="false"
    type="java.lang.String[]"
    description="A string array of keys to localize as the button label if this table is multi-select. The number of multiselectButtonActions and multiselectButtonKeys must be equal."%>
<%@ attribute
    name="multiselectButtonActions"
    required="false"
    type="java.lang.String[]"
    description="A string array of Springs event to trigger when the button is clicked if this table is multi-select. The number of multiselectButtonActions and multiselectButtonMethods must be equal."%>
<%@ attribute
    name="multiselectButtonMethods"
    required="false"
    type="java.lang.String[]"
    description="A String array of HTTP Methods to execute when the button is clicked. The number of multiselectButtonActions and multiselectButtonMethods must be equal."%>
<%@ attribute
    name="nonMultiselectButtonKeys"
    required="false"
    type="java.lang.String[]"
    description="A string array of keys to localize as the button label if this table has buttons. The number of nonMultiselectButtonKeys and nonMultiselectButtonActions must be equal."%>
<%@ attribute
    name="nonMultiselectButtonActions"
    required="false"
    type="java.lang.String[]"
    description="A string array of Springs event to trigger when the button is clicked if this table has buttons. The number of nonMultiselectButtonActions and nonMultiselectButtonMethods must be equal."%>
<%@ attribute
    name="nonMultiselectButtonMethods"
    required="false"
    type="java.lang.String[]"
    description="A String array of HTTP Methods to execute when the button is clicked. The number of nonMultiselectButtonActions and nonMultiselectButtonMethods must be equal."%>
<%@ attribute
    name="numRows"
    required="false"
    type="java.lang.Integer"
    description="Number of rows in the collection."%>
<%@ attribute
    name="multiselectButtonKey2"
    required="false"
    type="java.lang.String"
    description="Key to localize as the button label if this table is multi-select."%>
<%@ attribute
    name="multiselectButtonAction2"
    required="false"
    type="java.lang.String"
    description="Spring event to trigger when the button is clicked if this table is multi-select."%>
    
    <c:set value="${dataModel}" var="dataModel" scope="page"></c:set>
   
<%
            String model = (String) request.getAttribute("model");

            if (export == null) {
                jspContext.setAttribute("export", Boolean.FALSE);   
            }

            if (sortExportLinkParameters == null) {
                sortExportLinkParameters = new java.util.HashMap();
            }
            
            java.util.Collection collection = dataModel;
            java.util.List columns = printTemplate.getFields();

            if (collection == null) {
                collection = java.util.Collections.EMPTY_LIST;
            }
            
            int totalCount = 0;

            if (paged == null || paged) {
                gov.va.med.pharmacy.peps.common.vo.UserVo user = PepsSpringInterceptor.getUserContext(request.getSession()).getUser();
                jspContext.setAttribute("pagesize", user.getTableSizePreference());
                
                if ((collection instanceof gov.va.med.pharmacy.peps.common.vo.PaginatedList) && 
                		(request.getParameter(TableTagParameters.PARAMETER_EXPORTING) == null)) {
                    gov.va.med.pharmacy.peps.common.vo.PaginatedList paged = (gov.va.med.pharmacy.peps.common.vo.PaginatedList) collection;
                    sortExportLinkParameters.put(
                        gov.va.med.pharmacy.peps.presentation.common.controller.ControllerConstants.TABLE_ID_PARAMETER, tableId);                    
                  
                    jspContext.setAttribute("sort", "external");
                    jspContext.setAttribute("partialList", Boolean.TRUE);
                    jspContext.setAttribute("fullSize", paged.getFullSize());
                    totalCount = paged.getFullSize();

                    if (paged.isAscendingOrder()) {
                        jspContext.setAttribute("defaultOrder", "ascending");
                    }
                    else {
                        jspContext.setAttribute("defaultOrder", "descending");
                    }

                    for (int i = 0; i < columns.size(); i++) {
                        gov.va.med.pharmacy.peps.common.vo.printtemplate.Column column = (gov.va.med.pharmacy.peps.common.vo.printtemplate.Column) columns
                            .get(i);

                        if (column.getFieldKey() != null && column.getFieldKey().equals(paged.getSortedFieldKey())) {
                            jspContext.setAttribute("defaultSort", i + 1);
                        }
                    }
                }

                else {
                    jspContext.setAttribute("sort", "list");
                    jspContext.setAttribute("partialList", Boolean.FALSE);
                    jspContext.setAttribute("fullSize", collection.size());
                    jspContext.setAttribute("defaultOrder", "ascending");
                    jspContext.setAttribute("defaultSort", null);
                }
            }
            else {
                jspContext.setAttribute("pagesize", 0);
                jspContext.setAttribute("sort", "list");
                jspContext.setAttribute("partialList", Boolean.FALSE);
                jspContext.setAttribute("fullSize", collection.size());
                jspContext.setAttribute("defaultOrder", "ascending");
                jspContext.setAttribute("defaultSort", null);
            }

            int numRows = collection.size();

            // dislay tag library requires the data collection to be in request scope
            request.setAttribute(tableId + "_data", collection);

            // if there is no PrintTemplateVo, set an empty one to try and prevent NullPointerExceptions
            if (printTemplate == null) {
                printTemplate = new gov.va.med.pharmacy.peps.common.vo.printtemplate.PrintTemplateVo();
                jspContext.setAttribute("printTemplate", printTemplate);
            }

            
            String flowUrl =  UrlUtility.createMvcExecutionUrl(request, sortExportLinkParameters);
            
            flowUrl = StringUtils.remove(flowUrl, "resetSearch=true");
 
            jspContext.setAttribute("flowUrl", flowUrl);

            if (multiselectButtonKey == null || multiselectButtonKey.trim().length() <= 0) {
                multiselectButtonKey = "button.edit";
                jspContext.setAttribute("multiselectButtonKey", multiselectButtonKey);
            }

            if (multiselectButtonAction == null || multiselectButtonAction.trim().length() <= 0) {
                multiselectButtonAction = "retrieve";
                jspContext.setAttribute("multiselectButtonAction", multiselectButtonAction);
            }

            gov.va.med.pharmacy.peps.common.vo.FieldKey firstFieldKey = printTemplate.getFields().get(0).getFieldKey();

            boolean multiselect = gov.va.med.pharmacy.peps.common.vo.FieldKey.SELECT.equals(firstFieldKey);

            if (numRows > 0 && totalCount > numRows) {
            	jspContext.setAttribute("pagingBannerPlacement", "both");
            }
            else {
            	jspContext.setAttribute("pagingBannerPlacement", "top");
            }
            
            if (multiselect && numRows > 0) {
%>
<form
    id="editMultiple" 
    name="editMultiple"
    method="post"
    action="<%=gov.va.med.pharmacy.peps.presentation.common.utility.UrlUtility.createMvcExecutionUrl(request)%>"
    onsubmit="return disableSubmit(this.id);">

<%
}
%>
<display:table
    name="${tableId}_data"
    export="${export}"
    pagesize="${pagesize}"
    uid="${tableId}"
    requestURI="${flowUrl}"
    excludedParams="*"
    sort="${sort}"
    partialList="${partialList}"
    size="${fullSize}"
    defaultorder="${defaultOrder}"
    defaultsort="${defaultSort}"
    frame="box"
    rules="cols" 
    decorator="gov.va.med.pharmacy.peps.presentation.common.displaytag.SortTitleTableDecorator">
    <display:setProperty 
    	name="paging.banner.placement"
    	value="${pagingBannerPlacement}" />
    <display:setProperty
        name="export.csv.filename"
        value="${tableId}.csv" />
    <display:setProperty
        name="export.excel.filename"
        value="${tableId}.xls" />
    <display:setProperty
        name="export.xml.filename"
        value="${tableId}.xml" />
    <display:setProperty
        name="export.pdf.filename"
        value="${tableId}.pdf" />
    <display:setProperty
        name="export.rtf.filename"
        value="${tableId}.rtf" />
    <%
                    for (int i = 0; i < columns.size(); i++) {
                    gov.va.med.pharmacy.peps.common.vo.printtemplate.Column column = (gov.va.med.pharmacy.peps.common.vo.printtemplate.Column) columns
                        .get(i);
                    
                    jspContext.setAttribute("fieldIndex", i);
                    java.lang.Integer rowNum = (Integer) jspContext.getAttribute(tableId + "_rowNum");

                    if (rowNum == null) {
                        rowNum = new Integer(0);
                    }

                    int dataIndex = rowNum - 1;
                    jspContext.setAttribute("dataIndex", dataIndex);                    

                    Boolean fieldSortable = column.isSortable();
                    gov.va.med.pharmacy.peps.common.vo.FieldKey currentFieldKey = column.getFieldKey();

                    String pepsFieldKey = null;

                    if (currentFieldKey != null) { // localizable columns won't have FieldKeys
                        pepsFieldKey = currentFieldKey.getKey();
                    }

                    jspContext.setAttribute("pepsFieldKey", pepsFieldKey);
                    
                    String columnTitle = null;

                    if (currentFieldKey != null)                        
                        columnTitle = currentFieldKey.getLocalizedAbbreviation(request.getLocale());                    
                    else if (columnTitle == null) {
                        columnTitle = JspTagUtility.getText(request, "column."+(String) printTemplate.getFields().get(i).getFieldKey().getKey());
                    }

                    jspContext.setAttribute("columnTitle", columnTitle);

                    if (collection instanceof gov.va.med.pharmacy.peps.common.vo.PaginatedList) {
                        jspContext.setAttribute("sortProperty", pepsFieldKey);
                    }
                    else {
                        jspContext.setAttribute("sortProperty", "");
                    }
                    
                    // ability to define specific column widths in search results tables 
                    // only need a few, and values will be different than those that could be pulled from fieldKey.properties
                    String newkey; 
                    String thwidth = "";
                    newkey = currentFieldKey.getKey();
                    
                    if (newkey != null && newkey.equals("ndc")) {                    	
                        thwidth = "width: 100px";
                    }
                   
                    %>
    <display:column
        title="<%=columnTitle%>"
        sortable="<%=fieldSortable%>"
        scope="col"
        headerScope="col"
        style="<%=thwidth%>"
        comparator="gov.va.med.pharmacy.peps.presentation.common.displaytag.NumericComparator"
        sortName="<%=pepsFieldKey%>">
        <%
        if (column.isTextColumn()) {
            
            // center the content for these data fields
            if (pepsFieldKey.equals("displayable.ingredient.unit") || 
                            pepsFieldKey.equals("cmop.id") ||
                            pepsFieldKey.equals("primary.drug.class2") ||
                            pepsFieldKey.equals("transmit.to.cmop") ||
                            pepsFieldKey.equals("local.use") ||
                            pepsFieldKey.equals("item.status") ||
                            pepsFieldKey.equals("request.item.status") ||
                            pepsFieldKey.equals("ndc.count") ||
                            pepsFieldKey.equals("product.count") ||
                            pepsFieldKey.equals("cmop.dispense") ||
                            pepsFieldKey.equals("formulary")) {
                 
        %><center>
        
        <peps:text
            key="<%=pepsFieldKey%>"
            item="<%=dataModel.toArray()[dataIndex]%>" /></center>
            
        <%
            }
            else {
                %>
                <peps:text
                    key="<%=pepsFieldKey%>"
                    item="<%=dataModel.toArray()[dataIndex]%>" />
                    
                    
                <% 

            }
                        }
                        else if (column.isInputColumn()) {
                            if (gov.va.med.pharmacy.peps.common.vo.FieldKey.SELECT.equals(column.getFieldKey())) {
        %>
        <peps:input
            key="<%=pepsFieldKey%>"
            item="${dataModel[dataIndex]}"
            cssClass="columnCheckbox"
            labelPosition="none" />
            <input type="hidden" name="rowIdx" value="<%=dataIndex%>"/>

        <%
                            }
                            else {
        %>
        <peps:input
            key="<%=pepsFieldKey%>"            
            item="${dataModel}[${dataIndex}]"
            labelPosition="none" />
        <%
        
                        }
                        }
                        else if (column.isLinkColumn()) {
        %>
        <%
                            gov.va.med.pharmacy.peps.common.vo.printtemplate.LinkColumn linkColumn = (gov.va.med.pharmacy.peps.common.vo.printtemplate.LinkColumn) column;

                            java.util.Map<String, String> linkParameters = new java.util.LinkedHashMap<String, String>(
                                    linkColumn.getParameters().size());                            

                            // Display tag library sorts by table cell contents, including href attribute of anchor tag, so force
                            // href to have the displayed value in it to sort by, using dummy "_sort" parameter.
                            // Except for localizable flow links, whose text are all the same.
                            if (!column.isLocalizableLinkColumn()) {
                                
                                Object displayObject = gov.va.med.pharmacy.peps.presentation.common.utility.JspTagUtility
                                .getFieldValue(dataModel.toArray()[dataIndex], currentFieldKey);                                
                                
                                String displayString = "";

                                if (displayObject != null) {
                                    if (displayObject instanceof gov.va.med.pharmacy.peps.common.vo.datafield.DataFields) {
                                        gov.va.med.pharmacy.peps.common.vo.datafield.DataFields dfs = 
                                            (gov.va.med.pharmacy.peps.common.vo.datafield.DataFields) displayObject;
                                        
                                        gov.va.med.pharmacy.peps.common.vo.datafield.DataField df = 
                                            (gov.va.med.pharmacy.peps.common.vo.datafield.DataField) dfs.getDataField(currentFieldKey);
                                        
                                        if (df == null) {
                                            throw new UnsupportedOperationException("No support for displaying field key: " + currentFieldKey);
                                        }
                                        displayString = (df.getValue() != null ? df.getValue().toString() : "");                                        
                                    }
                                    else if (displayObject instanceof gov.va.med.pharmacy.peps.common.vo.ValueObject) {
                                        displayString = ((gov.va.med.pharmacy.peps.common.vo.ValueObject) displayObject)
                                            .toShortString();
                                    }
                                    else {
                                        displayString = displayObject.toString();
                                    }                                    
                                }

                                linkParameters.put("_sort", java.net.URLEncoder.encode(displayString, "UTF-8"));
                            }

                            // Add remaining link parameters
                            for (java.util.Map.Entry<String, Object> entry : linkColumn.getParameters().entrySet()) {

                                String parameterValue;

                                if (entry.getValue() instanceof gov.va.med.pharmacy.peps.common.vo.FieldKey) {
                                    gov.va.med.pharmacy.peps.common.vo.FieldKey tempKey = (gov.va.med.pharmacy.peps.common.vo.FieldKey) entry
                                    .getValue();
                                    parameterValue = String.valueOf(gov.va.med.pharmacy.peps.presentation.common.utility.JspTagUtility
                                            .getFieldValue(dataModel.toArray()[dataIndex], tempKey));                                   
                                    
                                }
                                else {
                                    parameterValue = String.valueOf(entry.getValue());
                                }
                                
                                linkParameters.put(entry.getKey(), parameterValue);
                                jspContext.setAttribute("parameterValue", parameterValue);
                                jspContext.setAttribute("linkParameters", linkParameters);
                            }

                            if(column.isLinkColumn() && column.getFieldKey().equals(FieldKey.CREATE_NEW)) {
                            	Object dataValue=FieldKey.getLocalizedAbbreviation(FieldKey.CREATE_NEW, request.getLocale());
                            	%>
                            	
                                <peps:link
                                id="${pepsFieldKey}${dataIndex}"
                                key="<%=pepsFieldKey%>"
                                item="<%=dataValue%>"
                                event="<%=linkColumn.getEvent()%>"        
                                input="<%=linkParameters%>"
                                cssClass="addLink"
                                />
                                
                                <%
                            }
                            else if (column.isLinkColumn()) {
                                Object dataValue = dataModel.toArray()[dataIndex];
                                jspContext.setAttribute("dataValue", dataValue);

                            	String event = linkColumn.getEvent();

	                            if (event == "fdbDetails") {
	                            	%>
	                                <peps:link
	                                id="${pepsFieldKey}"
	                                key="<%=pepsFieldKey%>"
	                                item="<%=dataValue%>"
	                                event="<%=linkColumn.getEvent()%>"        
	                                input="<%=linkParameters%>"
	                                onclick="return popup('fdbAddPrint.go?type=POPUP&ndc=${parameterValue}', this.id,600,900,100,300);"
	                                />
	                                
	                                <%
	                            	
	                            }
	                            else {
	                            
							        %>
							        <peps:link
							        id="${pepsFieldKey}"
							        key="<%=pepsFieldKey%>"
							        item="<%=dataValue%>"
							        event="<%=linkColumn.getEvent()%>"        
							        input="<%=linkParameters%>"
							        />
							        
							        <%
	                            }
                            }
                            else if (column.isLocalizableLinkColumn()) {
                                Object dataValue = dataModel.toArray()[dataIndex];
                               
                                
                                
        %>
        <peps:link
            id="${columnTitle}${dataIndex}"
            text="<%=columnTitle%>"
            item="<%=dataValue%>"
            event="<%=linkColumn.getEvent()%>"
            input="<%=linkParameters%>" />
        <%
                            }
                            else if (column.isLinkColumn()) {
                                Object dataValue = dataModel.toArray()[dataIndex];
                                
                                /* removed ${dataIndex} from below so that _sort would work correctly */
                                // center the content for these data fields
                                if (pepsFieldKey.equals("ndc.count") ||
                                    pepsFieldKey.equals("product.count")) {
        %><center>
        <peps:link
            id="${pepsFieldKey}"
            key="<%=pepsFieldKey%>"
            item="<%=dataValue%>"
            event="<%=linkColumn.getEvent()%>"
            input="<%=linkParameters%>" /></center>
        <%
                            }
  
                            else {
                                
        %>
        <peps:link
            id="${pepsFieldKey}"
            key="<%=pepsFieldKey%>"
            item="<%=dataValue%>"
            event="<%=linkColumn.getEvent()%>"
            input="<%=linkParameters%>" />
        <%                                      
                                }
                            }
  
                            else {  
                                Object dataValue = dataModel.toArray()[dataIndex];
                                
        %>
        <peps:link
            id="${pepsFieldKey}${dataIndex}"
            key="<%=pepsFieldKey%>"
            item="<%=dataValue%>"
            event="<%=linkColumn.getEvent()%>"
            input="<%=linkParameters%>" />
        <%
                        }
                        }  
                        
                        else if (column.isPopupLinkColumn()) {
                            Object dataValue = dataModel.toArray()[dataIndex];
                            
                            gov.va.med.pharmacy.peps.common.vo.printtemplate.PopupLinkColumn popup = (gov.va.med.pharmacy.peps.common.vo.printtemplate.PopupLinkColumn) column;
                            
                            jspContext.setAttribute("text", gov.va.med.pharmacy.peps.presentation.common.utility.JspTagUtility
                                .getFieldValue(dataValue, popup.getFieldKey()));
                            jspContext.setAttribute("viewedBy", gov.va.med.pharmacy.peps.presentation.common.utility.JspTagUtility
                                .getFieldValue(dataValue, popup.getOtherKey()));

                            
    %>
    <peps:link
        id="viewed.by.count"
        event="popupField"
        text="${text}"
        item="<%=dataValue%>"
        onclick="return popupField(this.href, this.id);"
        tooltip="${fieldLinkAltText} ${text}"
        viewedBy="${viewedBy}"
        disabled="true" />
    <%
                        }
        %>
    </display:column>
    <%
    }
    %>

</display:table>
<%
	String tabToDisplay = (String) request.getAttribute(ControllerConstants.TAB_KEY);
%>
<%
//do not display select all/edit buttons if table is empty or a parent search
if (multiselect && numRows > 0 && !DefaultPrintTemplateFactory.selectParentOrderableItemSearch().equals(printTemplate)
		&& !DefaultPrintTemplateFactory.selectParentProductSearch().equals(printTemplate)) { 
%>
<br />
<div
    id="buttons"
    class="panel">
<span class="floatLeft">
<spring:message code="select.all" var="selectText"/>
<spring:message code="unselect.all" var="unselectText"/>
<input type="button" name="select.all.button" id="select.all.button" class="button" value="${selectText}" onclick="checkall('itemIds'); return false;"/>  
<input type="button" name="unselect.all.button" id="unselect.all.button" class="button" value="${unselectText}" onclick="checkall('itemIds'); return false;" style="display:none;"/>
<c:choose>
    <c:when test="${!empty disableMultiselectButton}">
    </c:when>
    <c:otherwise>
        <peps:submit
            key="${multiselectButtonKey}"
            onclick="return verifySelection('itemIds'); return false;" 
            action="${multiselectButtonAction}"
            method="${multiselectButtonMethod }"/>
	</c:otherwise>
</c:choose>
<c:choose>
    <c:when test="${!empty disableMultiselectButton2}">
    </c:when>
    <c:otherwise>
    	<c:if test="<%=ControllerConstants.CHILDREN_TAB.equals(tabToDisplay) && 
    	DefaultPrintTemplateFactory.defaultNdcList().equals(printTemplate)%>">
	        <peps:submit
	            key="${multiselectButtonKey2}"
	            onclick="return verifySelection('itemIds'); return false;" 
	            action="${multiselectButtonAction2}"
	            method="${multiselectButtonMethod2 }"/>
         </c:if>
	</c:otherwise>
</c:choose>
<c:forEach var="key" items="${multiselectButtonKeys}" varStatus="status">
	<peps:submit
     key="${key}"
     onclick="return verifySelection('itemIds'); return false;" 
     action="${multiselectButtonActions[status.index]}"
     method="${multiselectButtonMethods[status.index]}"/>
</c:forEach>
<c:forEach var="key" items="${nonMultiselectButtonKeys}" varStatus="status">
	<peps:submit
     key="${key}" 
     action="${nonMultiselectButtonActions[status.index]}"
     method="${nonMultiselectButtonMethods[status.index]}"/>
</c:forEach>
    

</span>
</div>
</form>
<%
}
%>