<%@page import="java.util.Collection"%>
<%@page import="gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo"%>
<%@taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@taglib prefix="peps" tagdir="/WEB-INF/tags"%>
<%@taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%
	Collection<NdfUpdateFileVo> updateFiles = (Collection<NdfUpdateFileVo>) request
			.getAttribute("updateFiles");
%>

<c:choose>
	<c:when test="<%=updateFiles != null && !updateFiles.isEmpty()%>">
		<div class="horizontalspacer"></div>
		<fieldset>
			<legend class="boldText" >History</legend>
			<table id="updateFileTable" frame="box" rules="cols"
				class="pepsTable">
				<thead>
					<tr>
						<th><peps:label key="file.name" abbreviation="true" /></th>
						<th><peps:label key="status.name" abbreviation="true" /></th>
						<th><peps:label key="status.modified.dtm" abbreviation="true" /></th>
						<th><peps:label key="directory.path" abbreviation="true" /></th>
						<th><peps:label key="comments" abbreviation="true" /></th>
					</tr>
				</thead>
				<tbody>
					<c:forEach var="ndfUpdateFile" items="${updateFiles}" begin="0" varStatus="status">
	                    <tr class="${status.index % 2 == 0 ? 'even' : 'odd'}"> 					
						<%
							NdfUpdateFileVo ndfUpdateFile = (NdfUpdateFileVo) pageContext
												.getAttribute("ndfUpdateFile");
						%>						
							<c:choose>
								<c:when test="${row mod 2 == 0}">
									<tr class="odd">
								</c:when>
								<c:otherwise>
									<tr class="even">
								</c:otherwise>
							</c:choose>

							<c:set var="row" scope="page" value="${row + 1}" />
							
							<c:choose>
								<c:when test="<%=ndfUpdateFile.getFileName()== null%>">
									<td><peps:text item="${ndfUpdateFile}" key="file.name"
									value="" /></td>
								</c:when>
								<c:otherwise>
									<td><peps:text item="${ndfUpdateFile}" key="file.name"
										value="<%=ndfUpdateFile.getFileName()%>" /></td>
								</c:otherwise>
							</c:choose>
							<c:choose>
								<c:when test="<%=ndfUpdateFile.getStatusName()== null%>">
									<td><peps:text item="${ndfUpdateFile}" key="status.name"
										value="" /></td>
								</c:when>
								<c:otherwise>
									<td><peps:text item="${ndfUpdateFile}" key="status.name"
										value="<%=ndfUpdateFile.getStatusName()%>" /></td>
								</c:otherwise>
							</c:choose>
							<c:choose>
								<c:when test="<%=ndfUpdateFile.getStatusModifiedDtm()== null%>">
									<td><peps:text item="${ndfUpdateFile}" key="status.modified.dtm"
										value="" /></td>
								</c:when>
								<c:otherwise>
									<td><peps:text item="${ndfUpdateFile}" key="status.modified.dtm"
										value="<%=ndfUpdateFile.getStatusModifiedDtm().toString()%>" /></td>
								</c:otherwise>
							</c:choose>
							<c:choose>
								<c:when test="<%=ndfUpdateFile.getDirectoryPath()== null%>">
									<td><peps:text item="${ndfUpdateFile}" key="directory.path"
										value="" /></td>
								</c:when>
								<c:otherwise>
									<td><peps:text item="${ndfUpdateFile}" key="directory.path"
										value="<%=ndfUpdateFile.getDirectoryPath()%>" /></td>
								</c:otherwise>
							</c:choose>
							<c:choose>
								<c:when test="<%=ndfUpdateFile.getComments()== null%>">
									<td><peps:text item="${ndfUpdateFile}" key="comments"
										value="" /></td>
								</c:when>
								<c:otherwise>
									<td><peps:text item="${ndfUpdateFile}" key="comments"
										value="<%=ndfUpdateFile.getComments()%>" /></td>
								</c:otherwise>
							</c:choose>
						</tr>
					</c:forEach>
				</tbody>
			</table>
		</fieldset>
	</c:when>

	<c:otherwise>
		<div class="noDataText">No NDF History Files To Display</div>
	</c:otherwise>

</c:choose>
