<%@page import="gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo"%>
<%@page import="gov.va.med.pharmacy.peps.common.vo.Role"%>
<%@page import="gov.va.med.pharmacy.peps.presentation.common.context.UserContext"%>
<%@page import="gov.va.med.pharmacy.peps.presentation.common.controller.ControllerConstants"%>
<%@ taglib prefix="peps" tagdir="/WEB-INF/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>

<%
	NdfUpdateFileVo pendingFile = (NdfUpdateFileVo) request
			.getAttribute("pendingFile");	
	
	NdfUpdateFileVo initiatedFile = (NdfUpdateFileVo) request
			.getAttribute("initiatedFile");	
	
    UserContext userContext = (UserContext) session.getAttribute(ControllerConstants.USER_CONTEXT_KEY);
    
	boolean canCreate = userContext != null && !userContext.getUser().hasOnlyRole(Role.PSS_PPSN_VIEWER);	
%>
<script type="text/javascript">

	function setFocusOnResults()
	{
		var searchFocus = document.getElementById("fieldErrors");
		if(searchFocus != null || searchFocus != undefined) {
			searchFocus.focus();
		}
	}
	
</script>

<div class="filehorizontalspacer"></div>
<div class="pendingcriteria">
<c:url value="/updateStatus.go" var="updateAction" />
<c:url value="/createFile.go" var="createAction" />	
<%
if (canCreate){
%>
	<c:choose>		
		<c:when test="<%=pendingFile != null%>">
			<form:form id="pendingUpdate" name="pendingUpdate"
				modelAttribute="ndfPendingAction" action="${updateAction}"
				method="GET"
				onsubmit="return disableSubmit(this.id);">
				<input type="hidden" id="pendingFileId" name="pendingFileId"
					value="<%=pendingFile.getFileId()%>" />				
				<span class="addfiletitle"><spring:message
						code="ndfUpdate.file.title.description" /></span>
				<div class="panel">
					<div class="columnFile">
						<div>
							<div class="dataFirst">
								<span class="boldText"><spring:message
										code="file.name.description" /></span>
								<span class="boldText">:</span>
							</div>
							<div class="labelColon">
								&nbsp;
							</div>
							<div class="dataLast">
								<span class="columnFile2"><%=pendingFile.getFileName()%></span>
							</div>
						</div>
						<div>
							<div class="dataFirst">
								<span class="boldText"><spring:message
										code="status.modified.dtm.name" /></span>
								<span class="boldText">:</span>
							</div>
							<div class="labelColon">
								&nbsp;
							</div>
							
							<c:choose>
								<c:when test="<%=pendingFile.getStatusModifiedDtm()== null%>">
									<div class="dataLast">
										<span class="columnFile2">&nbsp;</span>
									</div>
								</c:when>
								<c:otherwise>
									<div class="dataLast">
										<span class="columnFile2"><%=pendingFile.getStatusModifiedDtm().toString()%></span>
									</div>
								</c:otherwise>
							</c:choose>
						</div>
						<div>
							<div class="dataFirst">
								<span class="boldText"><spring:message
										code="directory.path.name" /></span>
								<span class="boldText">:</span>
							</div>
							<div class="labelColon">
								&nbsp;
							</div>
							<div class="dataEnd">
								<span class="columnFile2"><%=pendingFile.getDirectoryPath()%></span>
							</div>
						</div>
					</div>

					<div id="strengthField" class="columnFile">
						<div>
							<div class="actionText">
								<span class="boldText"><spring:message code="action.name" /></span>
								<span class="boldText">:</span>
							</div>
							<div class="labelColon">
								&nbsp;
							</div>
							<spring:message code="action.name" var="action" />
							<div class="selectFileDrop">
								<form:select id="itemAction" title="${action}" path="actionSelected"
									tabindex="2" >									
									<form:options items="${StatusMap}" itemLabel="displayValue" itemValue="value"/>
								</form:select>
							</div>
						</div>
						<div>
							<div class="actionText">
								<span class="boldText"><spring:message
										code="comments.name" /></span>
								<span class="boldText">:</span>
							</div>
							<div class="labelColon">
								&nbsp;
							</div>
							<spring:message code="comments.name" var="comments" />
							<div class="textAreaData">
								<form:textarea id="comments" path="comments" rows="2" cols="30"
									required="false" />
							</div>
						</div>
						<div class="fileButton">
							<peps:submit key="button.submit" onclick="setFocusOnResults();"/>
						</div>
					</div>

				</div>
			</form:form>
		</c:when>

		<c:otherwise>						
			<form:form id="createUpdate" name="createUpdate"
				modelAttribute="ndfPendingUpdateFile" action="${createAction}"
				method="GET"
				onsubmit="return disableSubmit(this.id);">
				<div class="panel">
					<div class="createSubmitSpace">
						<div>
							<c:choose>
								<c:when test="<%=initiatedFile != null%>">
									<c:choose>
										<c:when test="<%=initiatedFile.getFileName() != null%>">
											<div class="textMessage">
												<span><spring:message
														code="ndfUpdate.file.initiated.message.name" />&nbsp;<%=initiatedFile.getFileName()%>
												</span>
											</div>
										</c:when>
										<c:otherwise>
											<div class="textMessage">
												<span><spring:message
														code="ndfUpdate.file.initiated.message.name" />
												</span>
											</div>
										</c:otherwise>
									</c:choose>
									<div>
										&nbsp;
									</div>
									<div>
										<input class="ignoreEnable" id="disabledBtn"  disabled="disabled" style="height:50px; width:200px;" type="button" value="Create Update File"  />
									</div>
								</c:when>
								<c:otherwise>
									<div>
										<peps:submit id="createBtn" cssClass="createFileButton" key="button.create" onclick="setFocusOnResults();"/>
									</div>							
								</c:otherwise>
							</c:choose>
						</div>				
					</div>
				</div>
			</form:form>
		</c:otherwise>

	</c:choose>
	<%
}
	%>
</div>