<%@ page contentType="text/html; charset=UTF-8" buffer="256kb"%>
<%@ taglib prefix="tiles" uri="http://tiles.apache.org/tags-tiles"%>
<%@ taglib prefix="peps" tagdir="/WEB-INF/tags"%>
<%@taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=10">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="css/peps.css" rel="stylesheet" type="text/css">
<link href="bootstrap-3.3.5/css/bootstrap.min.css" rel="stylesheet">
<link href="bootstrap-3.3.5/css/override.css" rel="stylesheet">
<link href="css/ppsn-bootstrap.css" rel="stylesheet">

</head>
<body>

	<div class="container-fluid">
		<header class="row header">
			<div class="banner">
				<!-- -->
				<tiles:insertAttribute name="banner" />
			</div>
			<spring:message scope="page" var="skipLinkTitle"
				code="link.nav.skip.title" />

			<div class="skip-links">
				<a name="skipnav" id="skipnav" class="HeaderLinks"
					title="${skipLinkTitle}" tabindex="1" href="#startcontent"><spring:message
						code="link.nav.skip" /></a>
			</div>
			<div class="user-info">
				<!-- -->
				<tiles:insertAttribute name="user-info" />
			</div>
		</header>

		<nav class="row navbar-top navbar navbar-default">
			<!-- -->
			<tiles:insertAttribute name="primary-nav" />
		</nav>
		<nav class="row navbar navbar-inverse">
			<ul class="nav navbar-nav">
				<li><spring:message code="nav.search" var="search" /> <a
					tabIndex="1" title="${search}" id="m2.1"
					href="<c:url value="/searchItems.go?&menuItemSelected=m2.1"/>" >${search}</a>
				<li><spring:message code="nav.reviewRequests" var="requests" />
					<a tabIndex="1" title="${requests}"
					id="m2.2" href="<c:url value="/searchRequests.go?&menuItemSelected=m2.2"/>" >${requests}</a>
				<li><spring:message code="nav.partialSaveItems"
						var="partialSave" /> <a tabIndex="1" title="${partialSave}"
					id="m2.3" href="<c:url value="/managePartialItem.go?&menuItemSelected=m2.3"/>" >${partialSave}</a>
				<li><spring:message code="nav.manageDomains" var="domains" /> <a
					tabIndex="1" title="${domains}"
					id="m2.4" href="<c:url value="/searchDataElements.go?&menuItemSelected=m2.4"/>" >${domains}</a>
				<li><spring:message code="nav.reviewDomainRequests"
						var="domainRequests" /> <a tabIndex="1" title="${domainRequests}"
					id="m2.5" href="<c:url value="/searchDomainRequests.go?&menuItemSelected=m2.5"/>" >${domainRequests}</a>
				<li class="active"><spring:message code="nav.manageUpdateFile"
						var="updateFile" /> <a tabIndex="1" title="${updateFile}"
					id="m2.6" href="<c:url value="/manageUpdateFiles.go?&menuItemSelected=m2.6"/>" >${updateFile}</a>
				<li><spring:message code="nav.suggestedRematches"
						var="suggestedRematches" /> <a tabIndex="1"
					title="${suggestedRematches}"
					id="m2.7" href="<c:url value="/unmatchedproductscriteria.go?&menuItemSelected=m2.7"/>" >${suggestedRematches}</a>
				</li>
			</ul>
		</nav>
		<section class="content">
			<div class="body-header">
				<!-- -->
				<peps:pageTrail />
				<a name="startcontent"></a>
				<tiles:insertAttribute name="body-header" />
			</div>
			<div class="body-content">
				<!-- -->
				<peps:error id="fieldErrors" errors="${errors}" />
			</div>
			<div class="body-content">
				<tiles:insertAttribute name="body-content" />
			</div>
			<div class="body-footer">
				<!-- -->
				<tiles:insertAttribute name="body-footer" />
			</div>
		</section>
		<footer class="row">
			<!-- -->
			<tiles:insertAttribute name="footer" />
		</footer>
		<peps:javascriptLocalization />
	</div>
	<script src="javascript/jquery-2.1.4.min.js"></script>
	<script src="bootstrap-3.3.5/js/bootstrap.min.js"></script>
    <script src="javascript/updateFile.js"></script>
    <script src="javascript/RoboHelp_CSH.js"></script>
    <script src="javascript/session.js"></script>

</body>
</html>